/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.analyzer.ResolverForModule;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.storage.NotNullLazyValue;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0016J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analyzer/DelegatingPackageFragmentProvider;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "moduleContent", "Lorg/jetbrains/kotlin/analyzer/ModuleContent;", "packageOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "resolverForModule", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "(Lorg/jetbrains/kotlin/analyzer/ModuleContent;Lorg/jetbrains/kotlin/analyzer/PackageOracle;Lorg/jetbrains/kotlin/storage/NotNullLazyValue;)V", "syntheticFilePackages", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/annotations/NotNull;", "certainlyDoesNotExist", "", "fqName", "getPackageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "frontend"})
final class DelegatingPackageFragmentProvider
implements PackageFragmentProvider {
    private final Set<FqName> syntheticFilePackages;
    private final PackageOracle packageOracle;
    private final NotNullLazyValue<ResolverForModule> resolverForModule;

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        if (this.certainlyDoesNotExist(fqName2)) {
            return CollectionsKt.emptyList();
        }
        return ((ResolverForModule)this.resolverForModule.invoke()).getPackageFragmentProvider().getPackageFragments(fqName2);
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull(nameFilter2, (String)"nameFilter");
        if (this.certainlyDoesNotExist(fqName2)) {
            return CollectionsKt.emptyList();
        }
        return ((ResolverForModule)this.resolverForModule.invoke()).getPackageFragmentProvider().getSubPackagesOf(fqName2, nameFilter2);
    }

    private final boolean certainlyDoesNotExist(FqName fqName2) {
        if (this.resolverForModule.isComputed()) {
            return false;
        }
        return !this.packageOracle.packageExists(fqName2) && this.syntheticFilePackages.contains(fqName2) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public DelegatingPackageFragmentProvider(@NotNull ModuleContent moduleContent, @NotNull PackageOracle packageOracle, @NotNull NotNullLazyValue<ResolverForModule> resolverForModule) {
        Collection<FqName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)moduleContent, (String)"moduleContent");
        Intrinsics.checkParameterIsNotNull((Object)packageOracle, (String)"packageOracle");
        Intrinsics.checkParameterIsNotNull(resolverForModule, (String)"resolverForModule");
        this.packageOracle = packageOracle;
        this.resolverForModule = resolverForModule;
        Iterable iterable = moduleContent.getSyntheticFiles();
        DelegatingPackageFragmentProvider delegatingPackageFragmentProvider = this;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            FqName fqName2 = it.getPackageFqName();
            collection.add(fqName2);
        }
        collection = (List)destination$iv$iv;
        delegatingPackageFragmentProvider.syntheticFilePackages = CollectionsKt.toSet((Iterable)collection);
    }
}

