/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.android.ResourceReferenceAnnotatorUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/AndroidResourceReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getResourceReferenceTargetDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "idea-android"})
public final class AndroidResourceReferenceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement2 = element2;
        if (!(psiElement2 instanceof KtReferenceExpression)) {
            psiElement2 = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement2;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression reference2 = ktReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)element2);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        JavaPropertyDescriptor javaPropertyDescriptor = this.getResourceReferenceTargetDescriptor(reference2);
        if (javaPropertyDescriptor == null) {
            return;
        }
        JavaPropertyDescriptor referenceTarget = javaPropertyDescriptor;
        ResourceType resourceType = AndroidUtilKt.getAndroidResourceType(referenceTarget);
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        if (Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.COLOR) ^ true && Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.DRAWABLE) ^ true && Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.MIPMAP) ^ true) {
            return;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidUtilKt.getResourceReferenceType(referenceTarget);
        Configuration configuration2 = ResourceReferenceAnnotatorUtil.pickConfiguration(androidFacet2, androidFacet2.getModule(), ((KtReferenceExpression)element2).getContainingFile());
        if (configuration2 == null) {
            return;
        }
        Configuration configuration3 = configuration2;
        ResourceValue resourceValue = ResourceReferenceAnnotatorUtil.findResourceValue(resourceType2, reference2.getText(), Intrinsics.areEqual((Object)referenceType, (Object)AndroidPsiUtils.ResourceReferenceType.FRAMEWORK), androidFacet2.getModule(), configuration3);
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        ResourceResolver resourceResolver = configuration3.getResourceResolver();
        if (resourceResolver == null) {
            return;
        }
        ResourceResolver resourceResolver2 = resourceResolver;
        if (Intrinsics.areEqual((Object)resourceType2, (Object)ResourceType.COLOR)) {
            Color color = ResourceHelper.resolveColor((RenderResources)((RenderResources)resourceResolver2), (ResourceValue)resourceValue2, (Project)((KtReferenceExpression)element2).getProject());
            if (color != null) {
                Annotation annotation2 = holder.createInfoAnnotation(element2, null);
                annotation2.setGutterIconRenderer((GutterIconRenderer)new ResourceReferenceAnnotatorUtil.ColorRenderer(element2, color));
            }
        } else {
            File iconFile;
            File file2 = ResourceHelper.resolveDrawable((RenderResources)((RenderResources)resourceResolver2), (ResourceValue)resourceValue2, (Project)((KtReferenceExpression)element2).getProject());
            if (file2 != null && StringsKt.endsWith$default((String)file2.getPath(), (String)".xml", (boolean)false, (int)2, null)) {
                file2 = ResourceReferenceAnnotatorUtil.pickBitmapFromXml(file2, resourceResolver2, ((KtReferenceExpression)element2).getProject());
            }
            if ((iconFile = AndroidColorAnnotator.pickBestBitmap((File)file2)) != null) {
                Annotation annotation3 = holder.createInfoAnnotation(element2, null);
                annotation3.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, element2, iconFile));
            }
        }
    }

    private final JavaPropertyDescriptor getResourceReferenceTargetDescriptor(@NotNull KtReferenceExpression $receiver) {
        Object v = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL).get(BindingContext.REFERENCE_TARGET, $receiver);
        if (!(v instanceof JavaPropertyDescriptor)) {
            v = null;
        }
        return (JavaPropertyDescriptor)v;
    }
}

