/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u000bH\u0000\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000eH\u0000\u00a8\u0006\u0013"}, d2={"getReferredResourceOrManifestField", "Lorg/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "localOnly", "", "className", "", "getAndroidFacetForFile", "Lcom/intellij/psi/PsiElement;", "getAndroidResourceType", "Lcom/android/resources/ResourceType;", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "getPreviousInQualifiedChain", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getResourceReferenceType", "Lcom/android/tools/idea/AndroidPsiUtils$ResourceReferenceType;", "idea-android"})
public final class AndroidUtilKt {
    @Nullable
    public static final AndroidFacet getAndroidFacetForFile(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file2 = psiFile;
        return AndroidFacet.getInstance((PsiElement)((PsiElement)file2));
    }

    @Nullable
    public static final ResourceType getAndroidResourceType(@NotNull JavaPropertyDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Intrinsics.areEqual((Object)AndroidUtilKt.getResourceReferenceType($receiver), (Object)AndroidPsiUtils.ResourceReferenceType.NONE)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof JavaClassDescriptor)) {
            declarationDescriptor = null;
        }
        JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)declarationDescriptor;
        if (javaClassDescriptor == null) {
            return null;
        }
        JavaClassDescriptor containingClass = javaClassDescriptor;
        return ResourceType.getEnum((String)containingClass.getName().asString());
    }

    @NotNull
    public static final AndroidPsiUtils.ResourceReferenceType getResourceReferenceType(@NotNull JavaPropertyDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof JavaClassDescriptor)) {
            declarationDescriptor = null;
        }
        JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)declarationDescriptor;
        if (javaClassDescriptor == null) {
            return AndroidPsiUtils.ResourceReferenceType.NONE;
        }
        JavaClassDescriptor containingClass = javaClassDescriptor;
        DeclarationDescriptor declarationDescriptor2 = containingClass.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof JavaClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        JavaClassDescriptor javaClassDescriptor2 = (JavaClassDescriptor)declarationDescriptor2;
        if (javaClassDescriptor2 == null) {
            return AndroidPsiUtils.ResourceReferenceType.NONE;
        }
        JavaClassDescriptor rClass = javaClassDescriptor2;
        if (Intrinsics.areEqual((Object)"R", (Object)rClass.getName().asString())) {
            Object object;
            DeclarationDescriptor declarationDescriptor3 = rClass.getContainingDeclaration();
            if (!(declarationDescriptor3 instanceof PackageFragmentDescriptor)) {
                declarationDescriptor3 = null;
            }
            if (Intrinsics.areEqual((Object)((object = (PackageFragmentDescriptor)declarationDescriptor3) != null && (object = object.getFqName()) != null ? ((FqName)object).asString() : null), (Object)"android")) {
                return AndroidPsiUtils.ResourceReferenceType.FRAMEWORK;
            }
            return AndroidPsiUtils.ResourceReferenceType.APP;
        }
        return AndroidPsiUtils.ResourceReferenceType.NONE;
    }

    @Nullable
    public static final AndroidResourceUtil.MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull KtSimpleNameExpression expression2, boolean localOnly) {
        Intrinsics.checkParameterIsNotNull((Object)facet, (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return AndroidUtilKt.getReferredResourceOrManifestField(facet, expression2, null, localOnly);
    }

    @Nullable
    public static final AndroidResourceUtil.MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull KtSimpleNameExpression expression2, @Nullable String className2, boolean localOnly) {
        PsiSourceFile psiSourceFile;
        String qName;
        Intrinsics.checkParameterIsNotNull((Object)facet, (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        String resFieldName = expression2.getReferencedName();
        KtExpression ktExpression = AndroidUtilKt.getPreviousInQualifiedChain(expression2);
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return null;
        }
        KtSimpleNameExpression resClassReference = ktSimpleNameExpression;
        String resClassName = resClassReference.getReferencedName();
        CharSequence charSequence = resClassName;
        if (charSequence.length() == 0 || className2 != null && Intrinsics.areEqual((Object)className2, (Object)resClassName) ^ true) {
            return null;
        }
        KtExpression ktExpression2 = AndroidUtilKt.getPreviousInQualifiedChain(resClassReference);
        if (!(ktExpression2 instanceof KtSimpleNameExpression)) {
            ktExpression2 = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression2 = (KtSimpleNameExpression)ktExpression2;
        if (ktSimpleNameExpression2 == null) {
            return null;
        }
        KtSimpleNameExpression rClassReference = ktSimpleNameExpression2;
        Object v = ResolutionUtils.analyze(rClassReference, BodyResolveMode.PARTIAL).get(BindingContext.REFERENCE_TARGET, rClassReference);
        if (!(v instanceof ClassDescriptor)) {
            v = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)v;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor rClassDescriptor = classDescriptor;
        String rClassShortName = rClassDescriptor.getName().asString();
        boolean fromManifest = Intrinsics.areEqual((Object)"Manifest", (Object)rClassShortName);
        if (!fromManifest && Intrinsics.areEqual((Object)"R", (Object)rClassShortName) ^ true) {
            return null;
        }
        if (!localOnly && (Intrinsics.areEqual((Object)"android.R", (Object)(qName = DescriptorUtilsKt.getFqNameSafe(rClassDescriptor).asString())) || Intrinsics.areEqual((Object)"com.android.internal.R", (Object)qName))) {
            return new AndroidResourceUtil.MyReferredResourceFieldInfo(resClassName, resFieldName, facet.getModule(), true, false);
        }
        SourceFile sourceFile = rClassDescriptor.getSource().getContainingFile();
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((psiSourceFile = (PsiSourceFile)sourceFile) == null || (psiSourceFile = psiSourceFile.getPsiFile()) == null) {
            return null;
        }
        PsiSourceFile containingFile = psiSourceFile;
        boolean bl = fromManifest ? !AndroidResourceUtil.isManifestJavaFile((AndroidFacet)facet, (PsiFile)containingFile) : !AndroidResourceUtil.isRJavaFile((AndroidFacet)facet, (PsiFile)containingFile);
        if (bl) {
            return null;
        }
        return new AndroidResourceUtil.MyReferredResourceFieldInfo(resClassName, resFieldName, facet.getModule(), false, false);
    }

    private static final KtExpression getPreviousInQualifiedChain(@NotNull KtExpression $receiver) {
        KtExpression ktExpression;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector($receiver);
        KtExpression receiverExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        KtExpression ktExpression2 = receiverExpression;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        if ((ktExpression = (KtQualifiedExpression)ktExpression2) == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
            ktExpression = receiverExpression;
        }
        return ktExpression;
    }
}

