/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;

public class K2JSCompilerArguments
extends CommonCompilerArguments {
    public static final long serialVersionUID = 0L;
    @GradleOption(value=DefaultValues.StringNullDefault.class)
    @Argument(value="-output", valueDescription="<path>", description="Output file path")
    public String outputFile;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="-no-stdlib", description="Don't use bundled Kotlin stdlib")
    public boolean noStdlib;
    @Argument(value="-libraries", valueDescription="<path>", description="Paths to Kotlin libraries with .meta.js and .kjsm files, separated by system file separator")
    public String libraries;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-source-map", description="Generate source map")
    public boolean sourceMap;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="-meta-info", description="Generate .meta.js and .kjsm files with metadata. Use to create a library")
    public boolean metaInfo;
    @GradleOption(value=DefaultValues.JsEcmaVersions.class)
    @Argument(value="-target", valueDescription="{ v5 }", description="Generate JS files for specific ECMA version")
    public String target;
    @GradleOption(value=DefaultValues.JsModuleKinds.class)
    @Argument(value="-module-kind", valueDescription="{ plain, amd, commonjs, umd }", description="Kind of a module generated by compiler")
    public String moduleKind;
    @GradleOption(value=DefaultValues.JsMain.class)
    @Argument(value="-main", valueDescription="{call,noCall}", description="Whether a main function should be called")
    public String main;
    @Argument(value="-output-prefix", valueDescription="<path>", description="Path to file which will be added to the beginning of output file")
    public String outputPrefix;
    @Argument(value="-output-postfix", valueDescription="<path>", description="Path to file which will be added to the end of output file")
    public String outputPostfix;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-Xtyped-arrays", description="Translate primitive arrays to JS typed arrays")
    public boolean typedArrays;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="-Xfriend-modules-disabled", description="Disable internal declaration export")
    public boolean friendModulesDisabled;
    @Argument(value="-Xfriend-modules", valueDescription="<path>", description="Paths to friend modules")
    public String friendModules;

    @NotNull
    public static K2JSCompilerArguments createDefaultInstance() {
        K2JSCompilerArguments arguments2 = new K2JSCompilerArguments();
        arguments2.moduleKind = "plain";
        K2JSCompilerArguments k2JSCompilerArguments = arguments2;
        if (k2JSCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments", "createDefaultInstance"));
        }
        return k2JSCompilerArguments;
    }
}

