/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.FieldAccessorKind;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.TypeAndNullability;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegen;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.ResolvedCallWithRealDescriptor;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.forLoop.AbstractForLoopGenerator;
import org.jetbrains.kotlin.codegen.forLoop.ForLoopGeneratorsKt;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenForDefaultBody;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements LocalLookup {
    private final GenerationState state;
    final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    public final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor;
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator;
    private final Stack<BlockStackElement> blockStackElements;
    public final Map<KtElement, StackValue> tempVariables;
    private int myLastLineNumber;
    private boolean shouldMarkLineNumbers;
    private int finallyDepth;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType2, @NotNull MethodContext context, @NotNull GenerationState state, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "<init>"));
        }
        this.statementVisitor = new CodegenStatementVisitor(this);
        this.defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
        this.blockStackElements = new Stack();
        this.tempVariables = Maps.newHashMap();
        this.myLastLineNumber = -1;
        this.shouldMarkLineNumbers = true;
        this.finallyDepth = 0;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context;
        this.returnType = returnType2;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context, this, this.v, state);
    }

    @Nullable
    private static FunctionDescriptor getOriginalSuspendLambdaDescriptorFromContext(MethodContext context) {
        if (context.getParentContext() instanceof ClosureContext && context.getParentContext().closure != null && context.getParentContext().closure.isSuspend()) {
            return ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
        }
        return null;
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.state;
        if (generationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getState"));
        }
        return generationState;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        MemberCodegen<?> memberCodegen = this.parentCodegen;
        if (memberCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getParentCodegen"));
        }
        return memberCodegen;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateObjectLiteral"));
        }
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, (DeclarationDescriptor)classDescriptor), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        ObjectLiteralResult objectLiteralResult = new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor);
        if (objectLiteralResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateObjectLiteral"));
        }
        return objectLiteralResult;
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen member, @NotNull ClassDescriptor descriptor2) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addReifiedParametersFromSignature"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addReifiedParametersFromSignature"));
        }
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            for (TypeProjection supertypeArgument : type2.getArguments()) {
                TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
                if (parameterDescriptor == null || !parameterDescriptor.isReified()) continue;
                member.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
            }
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (provided == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provided", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        if (required == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "required", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            StackValue stackValue = StackValue.coercion(inner, this.asmType(required.getDefaultType()));
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
            }
            return stackValue;
        }
        StackValue stackValue = inner;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "castToRequiredTypeOfInterfaceIfNeeded"));
        }
        return stackValue;
    }

    public StackValue genQualified(StackValue receiver, KtElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, KtElement selector, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector);
        }
        try {
            StackValue samValue;
            if (selector instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector.accept(visitor2, receiver);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector instanceof KtExpression) {
                runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, (KtExpression)selector);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector, this.bindingContext)) {
                return stackValue;
            }
            return AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (ProcessCanceledException | CompilationException e) {
            throw e;
        }
        catch (Throwable error) {
            String message2 = error.getMessage();
            throw new CompilationException(message2 != null ? message2 : "null", error, (PsiElement)selector);
        }
    }

    public StackValue gen(KtElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(KtElement expr, Type type2) {
        StackValue value2 = Type.VOID_TYPE.equals((Object)type2) ? this.genStatement(expr) : this.gen(expr);
        this.putStackValue(expr, type2, value2);
    }

    private void putStackValue(@Nullable KtElement expr, @NotNull Type type2, @NotNull StackValue value2) {
        ScriptContext context;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putStackValue"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putStackValue"));
        }
        if (value2.type != Type.VOID_TYPE && this.state.getReplSpecific().getShouldGenerateScriptResultValue() && expr == (context = this.getScriptContext()).getLastStatement()) {
            StackValue.Field resultValue = StackValue.field(context.getResultFieldInfo(), (StackValue)StackValue.LOCAL_0);
            resultValue.store(value2, this.v);
            this.state.getReplSpecific().setHasResult(true);
            return;
        }
        value2.put(type2, this.v);
    }

    @NotNull
    private ScriptContext getScriptContext() {
        CodegenContext context = this.getContext();
        while (!(context instanceof ScriptContext)) {
            context = ((CodegenContext)context).getParentContext();
        }
        ScriptContext scriptContext = (ScriptContext)context;
        if (scriptContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getScriptContext"));
        }
        return scriptContext;
    }

    public StackValue genLazy(KtElement expr, Type type2) {
        StackValue value2 = this.gen(expr);
        return StackValue.coercion(value2, type2);
    }

    private StackValue genStatement(KtElement statement2) {
        return this.genQualified(StackValue.none(), statement2, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass2, StackValue data) {
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitClass"));
        }
        return this.visitClassOrObject(klass2);
    }

    @Override
    public StackValue visitTypeAlias(@NotNull KtTypeAlias typeAlias2, StackValue data) {
        if (typeAlias2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeAlias", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitTypeAlias"));
        }
        return StackValue.none();
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration2) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration2);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration2);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration2, (DeclarationDescriptor)descriptor2), asmType, declaration2.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration2, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        if (declaration2 instanceof KtClass && ((KtClass)declaration2).isInterface()) {
            Type traitImplType = this.state.getTypeMapper().mapDefaultImpls(descriptor2);
            ClassBuilder traitImplBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.DefaultImpls(declaration2, descriptor2), traitImplType, declaration2.getContainingFile());
            ClassContext traitImplContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.DEFAULT_IMPLS);
            new InterfaceImplBodyCodegen(declaration2, traitImplContext, traitImplBuilder, this.state, this.parentCodegen).generate();
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, StackValue data) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitObjectDeclaration"));
        }
        return this.visitClassOrObject(declaration2);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitExpression"));
        }
        throw new UnsupportedOperationException("Codegen for " + expression2 + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression2, StackValue data) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSuperExpression"));
        }
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression2), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context, @NotNull KtSuperExpression expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        KotlinType thisTypeForSuperCall = context.getState().getBindingContext().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
        assert (thisTypeForSuperCall != null) : "This type for superCall ''" + expression2.getText() + "'' should be not null!";
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "'This' reference target for ''" + expression2.getText() + "''should be class descriptor, but was " + descriptor2;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallLabelTarget"));
        }
        return classDescriptor;
    }

    @NotNull
    public Type asmType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "asmType"));
        }
        Type type3 = this.typeMapper.mapType(type2);
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "asmType"));
        }
        return type3;
    }

    @NotNull
    private Type expressionTypeForBranchingOperation(@Nullable KtExpression expression2) {
        if (this.context.getFunctionDescriptor().isSuspend() && !CoroutineCodegenUtilKt.isStateMachineNeeded(this.context.getFunctionDescriptor(), this.bindingContext) && Boolean.TRUE.equals(this.bindingContext.get(BindingContext.IS_TAIL_EXPRESSION_IN_SUSPEND_FUNCTION, expression2))) {
            Type type2 = AsmTypes.OBJECT_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "expressionTypeForBranchingOperation"));
            }
            return type2;
        }
        Type type3 = this.expressionType(expression2);
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "expressionTypeForBranchingOperation"));
        }
        return type3;
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression2) {
        Type type2 = CodegenUtilKt.asmType(expression2, this.typeMapper, this.bindingContext);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "expressionType"));
        }
        return type2;
    }

    @Nullable
    private KotlinType expressionJetType(@Nullable KtExpression expression2) {
        return CodegenUtilKt.kotlinType(expression2, this.bindingContext);
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitParenthesizedExpression"));
        }
        return this.genQualified(receiver, expression2.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitAnnotatedExpression"));
        }
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr) {
        KtBlockExpression blockExpression2;
        List<KtExpression> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof KtBlockExpression && ((statements = (blockExpression2 = (KtBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitIfExpression"));
        }
        return this.generateIfExpression(expression2, false);
    }

    StackValue generateIfExpression(@NotNull KtIfExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateIfExpression"));
        }
        Type asmType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression2);
        StackValue condition2 = this.gen(expression2.getCondition());
        KtExpression thenExpression = expression2.getThen();
        KtExpression elseExpression = expression2.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                return StackValue.coercion(condition2, asmType);
            }
            return this.generateSingleBranchIf(condition2, expression2, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition2, expression2, thenExpression, true, isStatement);
        }
        return StackValue.operation(asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateIfExpression$0"));
            }
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition2, elseLabel, true, (InstructionAdapter)v);
            Label end = new Label();
            this.gen(thenExpression, asmType);
            v.goTo(end);
            v.mark(elseLabel);
            this.gen(elseExpression, asmType);
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitWhileExpression(@NotNull KtWhileExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitWhileExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitWhileExpression$1"));
            }
            this.generateWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateWhile(@NotNull KtWhileExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateWhile"));
        }
        Label condition2 = new Label();
        this.v.mark(condition2);
        Label end = new Label();
        this.blockStackElements.push((Object)new LoopBlockStackElement(end, condition2, ExpressionCodegen.targetLabel(expression2)));
        StackValue conditionValue = this.gen(expression2.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression2.getBody());
        this.markStartLineNumber(expression2);
        this.v.goTo(condition2);
        this.v.mark(end);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDoWhileExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitDoWhileExpression$2"));
            }
            this.generateDoWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateDoWhile(@NotNull KtDoWhileExpression expression2) {
        StackValue conditionValue;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateDoWhile"));
        }
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push((Object)new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression2)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, breakLabel);
        KtExpression body2 = expression2.getBody();
        KtExpression condition2 = expression2.getCondition();
        StackValueWithLeaveTask leaveTask = null;
        if (body2 instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body2).getStatements();
            ArrayList<KtExpression> statements = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements.addAll(doWhileStatements);
            statements.add(condition2);
            leaveTask = this.generateBlock(statements, false, continueLabel, null);
            conditionValue = leaveTask.getStackValue();
        } else {
            if (body2 != null) {
                this.gen(body2, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition2);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        if (leaveTask != null) {
            leaveTask.getLeaveTasks().invoke((Object)conditionValue);
        }
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitForExpression(@NotNull KtForExpression forExpression, StackValue receiver) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitForExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            if (forExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitForExpression$3"));
            }
            this.generateFor(forExpression);
            return Unit.INSTANCE;
        }));
    }

    private void generateFor(@NotNull KtForExpression forExpression) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateFor"));
        }
        this.generateForLoop(ForLoopGeneratorsKt.getForLoopGenerator(this, forExpression));
    }

    @NotNull
    public static KotlinType getExpectedReceiverType(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getExpectedReceiverType"));
        }
        ReceiverParameterDescriptor extensionReceiver = resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter();
        assert (extensionReceiver != null) : "Extension receiver should be non-null";
        KotlinType kotlinType = extensionReceiver.getType();
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getExpectedReceiverType"));
        }
        return kotlinType;
    }

    @Nullable
    public static KtExpression getSingleArgumentExpression(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSingleArgumentExpression"));
        }
        List<ResolvedValueArgument> resolvedValueArguments = resolvedCall2.getValueArgumentsByIndex();
        if (resolvedValueArguments == null) {
            return null;
        }
        if (resolvedValueArguments.size() != 1) {
            return null;
        }
        List<ValueArgument> valueArguments2 = resolvedValueArguments.get(0).getArguments();
        if (valueArguments2.size() != 1) {
            return null;
        }
        return valueArguments2.get(0).getArgumentExpression();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(AbstractForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        generator.beforeBody();
        this.blockStackElements.push((Object)new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.getForExpression())));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    public void generateLoopBody(@Nullable KtExpression body2) {
        if (body2 != null) {
            this.gen(body2, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBreakExpression"));
        }
        return this.generateBreakOrContinueExpression(expression2, true, new Label());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitContinueExpression"));
        }
        return this.generateBreakOrContinueExpression(expression2, false, new Label());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression2, boolean isBreak, @NotNull Label afterBreakContinueLabel) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
        }
        if (afterBreakContinueLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterBreakContinueLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
        }
        assert (expression2 instanceof KtContinueExpression || expression2 instanceof KtBreakExpression);
        if (this.blockStackElements.isEmpty()) {
            throw new UnsupportedOperationException("Target label for break/continue not found");
        }
        BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.peek();
        if (stackElement instanceof FinallyBlockStackElement) {
            FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
            this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterBreakContinueLabel);
        } else if (stackElement instanceof LoopBlockStackElement) {
            LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                Label label2 = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                StackValue stackValue = StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    if (afterBreakContinueLabel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterBreakContinueLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateBreakOrContinueExpression$4"));
                    }
                    PseudoInsnsKt.fixStackAndJump(this.v, label2);
                    this.v.mark(afterBreakContinueLabel);
                    return Unit.INSTANCE;
                }));
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
                }
                return stackValue;
            }
        } else {
            throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
        }
        this.blockStackElements.pop();
        StackValue result2 = this.generateBreakOrContinueExpression(expression2, isBreak, afterBreakContinueLabel);
        this.blockStackElements.push((Object)stackElement);
        StackValue stackValue = result2;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBreakOrContinueExpression"));
        }
        return stackValue;
    }

    private StackValue generateSingleBranchIf(StackValue condition2, KtIfExpression ifExpression2, KtExpression expression2, boolean inverse, boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression2);
        return StackValue.operation(targetType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition2, elseLabel, inverse, (InstructionAdapter)v);
            if (isStatement) {
                this.gen(expression2, Type.VOID_TYPE);
                v.mark(elseLabel);
            } else {
                this.gen(expression2, targetType);
                Label end = new Label();
                v.goTo(end);
                v.mark(elseLabel);
                StackValue.putUnitInstance(v);
                this.markStartLineNumber(ifExpression2);
                v.mark(end);
            }
            return null;
        }));
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitConstantExpression"));
        }
        ConstantValue<?> compileTimeValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression2));
    }

    @Nullable
    public static ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getPrimitiveOrStringCompileTimeConstant"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getPrimitiveOrStringCompileTimeConstant"));
        }
        ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext2, false, shouldInlineConstVals);
        if (constant == null || ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constant)) {
            return null;
        }
        return constant;
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        return ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext2, false, shouldInlineConstVals);
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, final @NotNull BindingContext bindingContext2, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        KotlinType expectedType;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCompileTimeConstant"));
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, bindingContext2);
        if (compileTimeValue == null || compileTimeValue.getUsesNonConstValAsConstant()) {
            return null;
        }
        if (!shouldInlineConstVals && !takeUpConstValsAsConst && compileTimeValue.getUsesVariableAsConstant()) {
            final Ref containsNonInlinedVals = new Ref((Object)false);
            KtVisitor constantChecker = new KtVisitor(){

                public Object visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, Object data) {
                    CallableDescriptor callableDescriptor;
                    if (expression2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$1", "visitSimpleNameExpression"));
                    }
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext2);
                    if (resolvedCall2 != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof PropertyDescriptor && !JvmCodegenUtil.isInlinedJavaConstProperty((VariableDescriptor)callableDescriptor)) {
                        containsNonInlinedVals.set((Object)true);
                    }
                    return null;
                }

                public Object visitKtElement(@NotNull KtElement element2, Object data) {
                    if (element2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ExpressionCodegen$1", "visitKtElement"));
                    }
                    if (!((Boolean)containsNonInlinedVals.get()).booleanValue()) {
                        element2.acceptChildren(this);
                    }
                    return null;
                }
            };
            expression2.accept(constantChecker);
            if (((Boolean)containsNonInlinedVals.get()).booleanValue()) {
                return null;
            }
        }
        if ((expectedType = bindingContext2.getType(expression2)) == null) {
            return null;
        }
        return compileTimeValue.toConstantValue(expectedType);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitStringTemplateExpression"));
        }
        StringBuilder constantValue = new StringBuilder("");
        KtStringTemplateEntry[] entries2 = expression2.getEntries();
        if (entries2.length == 1 && entries2[0] instanceof KtStringTemplateEntryWithExpression) {
            KtExpression expr = entries2[0].getExpression();
            return AsmUtil.genToString(this.gen(expr), this.expressionType(expr));
        }
        for (KtStringTemplateEntry entry : entries2) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            constantValue = null;
            break;
        }
        if (constantValue != null) {
            Type type2 = this.expressionType(expression2);
            return StackValue.constant(constantValue.toString(), type2);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            AsmUtil.genStringBuilderConstructor(v);
            for (KtStringTemplateEntry entry : entries2) {
                if (entry instanceof KtStringTemplateEntryWithExpression) {
                    this.invokeAppend(entry.getExpression());
                    continue;
                }
                String text2 = entry instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)entry).getUnescapedValue() : entry.getText();
                v.aconst((Object)text2);
                AsmUtil.genInvokeAppendMethod(v, AsmTypes.JAVA_STRING_TYPE);
            }
            v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBlockExpression"));
        }
        return this.generateBlock(expression2, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitNamedFunction"));
        }
        return this.visitNamedFunction(function2, data, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data, boolean isStatement) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitNamedFunction"));
        }
        assert (data == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function2)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function2, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitLambdaExpression"));
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression2))) {
            return this.gen(expression2.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression2.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration2, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration2);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration2.getText();
        StackValue stackValue = this.genClosure(declaration2, descriptor2, new ClosureGenerationStrategy(this.state, declaration2), samType, null, null);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        return stackValue;
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration2, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable FunctionDescriptor functionReferenceTarget, @Nullable StackValue functionReferenceReceiver) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration2, (DeclarationDescriptor)descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration2.getContainingFile());
        ClosureCodegen coroutineCodegen = CoroutineCodegen.createByLambda(this, descriptor2, declaration2, cv);
        ClosureCodegen closureCodegen = coroutineCodegen != null ? coroutineCodegen : new ClosureCodegen(this.state, declaration2, samType, this.context.intoClosure(descriptor2, this, this.typeMapper), functionReferenceTarget, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        StackValue stackValue = this.putClosureInstanceOnStack(closureCodegen, functionReferenceReceiver);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genClosure"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue putClosureInstanceOnStack(@NotNull ClosureCodegen closureCodegen, @Nullable StackValue functionReferenceReceiver) {
        if (closureCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closureCodegen", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putClosureInstanceOnStack"));
        }
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker((MethodVisitor)this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        StackValue stackValue = closureCodegen.putInstanceOnStack(this, functionReferenceReceiver);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putClosureInstanceOnStack"));
        }
        return stackValue;
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitObjectLiteralExpression"));
        }
        ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression2);
        ClassDescriptor classDescriptor = objectLiteralResult.classDescriptor;
        Type type2 = this.typeMapper.mapType(classDescriptor);
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (objectLiteralResult.wereReifiedMarkers) {
                ReifiedTypeInliner.putNeedClassReificationMarker((MethodVisitor)v);
            }
            v.anew(type2);
            v.dup();
            this.pushClosureOnStack(classDescriptor, true, this.defaultCallGenerator, null);
            ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
            assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
            ResolvedCall<ConstructorDescriptor> superCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
            if (superCall != null) {
                ConstructorDescriptor superConstructor = superCall.getResultingDescriptor();
                ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                int params2 = superValueParameters.size();
                List<Type> superMappedTypes = this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                assert (superMappedTypes.size() >= params2) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params2, classDescriptor);
                ArrayList<ResolvedValueArgument> valueArguments2 = new ArrayList<ResolvedValueArgument>(params2);
                ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(params2);
                ArrayList<Type> mappedTypes = new ArrayList<Type>(params2);
                for (ValueParameterDescriptor parameter : superValueParameters) {
                    ResolvedValueArgument argument2 = superCall.getValueArguments().get(parameter);
                    if (argument2 instanceof DefaultValueArgument) continue;
                    valueArguments2.add(argument2);
                    valueParameters.add(parameter);
                    mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                }
                CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, this.defaultCallGenerator, valueParameters, mappedTypes);
                argumentGenerator.generate(valueArguments2, valueArguments2, null);
            }
            Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
            assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor + " " + constructors2;
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)CollectionsKt.single(constructors2);
            Method constructor2 = this.typeMapper.mapAsmMethod(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
            v.invokespecial(type2.getInternalName(), "<init>", constructor2.getDescriptor(), false);
            return Unit.INSTANCE;
        }));
    }

    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor, boolean putThis, @NotNull CallGenerator callGenerator, @Nullable StackValue functionReferenceReceiver) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "pushClosureOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "pushClosureOnStack"));
        }
        CalculatedClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        if (closure == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCaptureThis()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type)) : "This or outer should be non primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
            StackValue capturedReceiver = functionReferenceReceiver != null ? functionReferenceReceiver : this.generateExtensionReceiver(ExpressionCodegen.unwrapOriginalReceiverOwnerForSuspendFunction(this.context));
            callGenerator.putCapturedValueOnStack(capturedReceiver, capturedReceiver.type, paramIndex++);
        }
        for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
            Type sharedVarType = this.typeMapper.getSharedVarType((DeclarationDescriptor)entry.getKey());
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)entry.getKey());
            }
            StackValue capturedVar = this.lookupOuterValue((EnclosedValueDescriptor)entry.getValue());
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCaptureThis() == null, callGenerator, null);
        }
        if (closure.isSuspend()) {
            if (closure.isSuspendLambda()) {
                this.v.aconst(null);
            } else {
                assert (this.context.getFunctionDescriptor().isSuspend()) : "Coroutines closure must be created only inside suspend functions";
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.last(this.context.getFunctionDescriptor().getValueParameters());
                StackValue continuationValue = this.findLocalOrCapturedValue(valueParameterDescriptor);
                assert (continuationValue != null) : "Couldn't find a value for continuation parameter of " + this.context.getFunctionDescriptor();
                callGenerator.putCapturedValueOnStack(continuationValue, continuationValue.type, paramIndex++);
            }
        }
    }

    @NotNull
    private static CallableDescriptor unwrapOriginalReceiverOwnerForSuspendFunction(@NotNull MethodContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapOriginalReceiverOwnerForSuspendFunction"));
        }
        FunctionDescriptor originalForDoResume = context.getFunctionDescriptor().getUserData(CoroutineCodegenUtilKt.INITIAL_SUSPEND_DESCRIPTOR_FOR_DO_RESUME);
        if (originalForDoResume != null) {
            FunctionDescriptor functionDescriptor2 = originalForDoResume;
            if (functionDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapOriginalReceiverOwnerForSuspendFunction"));
            }
            return functionDescriptor2;
        }
        if (context.getFunctionDescriptor().isSuspend()) {
            FunctionDescriptor functionDescriptor3 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(context.getFunctionDescriptor());
            if (functionDescriptor3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapOriginalReceiverOwnerForSuspendFunction"));
            }
            return functionDescriptor3;
        }
        FunctionDescriptor functionDescriptor4 = context.getFunctionDescriptor();
        if (functionDescriptor4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapOriginalReceiverOwnerForSuspendFunction"));
        }
        return functionDescriptor4;
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBlock"));
        }
        if (expression2.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression2.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression2.getStatements(), isStatement, null, null);
    }

    @NotNull
    public StackValue lookupOuterValue(EnclosedValueDescriptor d) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue stackValue = aCase.outerValue(d, this);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupOuterValue"));
            }
            return stackValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValueWithLeaveTask generateBlock(@NotNull List<KtExpression> statements, boolean isStatement, @Nullable Label labelBeforeLastExpression, @Nullable Label labelBlockEnd) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateBlock"));
        }
        Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        ArrayList leaveTasks = Lists.newArrayList();
        StackValue blockResult = null;
        Iterator<KtExpression> iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            StackValue statementResult;
            boolean isExpression;
            KtNamedDeclaration declaration2;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement2 = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement2 instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration2 = (KtNamedDeclaration)statement2)) continue;
            this.putDescriptorIntoFrameMap(statement2);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = statementResult = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                blockResult = statementResult;
            } else {
                statementResult.put(Type.VOID_TYPE, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement2, blockEnd, leaveTasks);
        }
        if (statements.isEmpty()) {
            blockResult = StackValue.none();
        }
        assert (blockResult != null) : "Block result should be initialized in the loop or the condition above";
        return new StackValueWithLeaveTask(blockResult, (Function1<? super StackValue, Unit>)((Function1)value2 -> {
            if (labelBlockEnd == null) {
                this.v.mark(blockEnd);
            }
            for (Function task2 : Lists.reverse((List)leaveTasks)) {
                task2.fun(value2);
            }
            return Unit.INSTANCE;
        }));
    }

    @Nullable
    private StackValue getCoroutineInstanceValueForSuspensionPoint(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCoroutineInstanceValueForSuspensionPoint"));
        }
        FunctionDescriptor enclosingSuspendLambdaForSuspensionPoint = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        if (enclosingSuspendLambdaForSuspensionPoint == null) {
            return null;
        }
        return this.genCoroutineInstanceBySuspendFunction(enclosingSuspendLambdaForSuspensionPoint);
    }

    @Nullable
    private StackValue genCoroutineInstanceBySuspendFunction(@NotNull FunctionDescriptor suspendFunction) {
        if (suspendFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendFunction", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genCoroutineInstanceBySuspendFunction"));
        }
        if (!CoroutineCodegenUtilKt.isStateMachineNeeded(suspendFunction, this.bindingContext)) {
            return null;
        }
        ClassDescriptor suspendLambdaClassDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, suspendFunction);
        assert (suspendLambdaClassDescriptor != null) : "Coroutine class descriptor should not be null";
        return StackValue.thisOrOuter(this, suspendLambdaClassDescriptor, false, false);
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableType"));
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type type2 = sharedVarType != null ? sharedVarType : this.getVariableTypeNoSharing(variableDescriptor);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableType"));
        }
        return type2;
    }

    @NotNull
    private Type getVariableTypeNoSharing(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableTypeNoSharing"));
        }
        KotlinType varType = JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)variableDescriptor, this.bindingContext) : variableDescriptor.getType();
        Type type2 = this.asmType(varType);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableTypeNoSharing"));
        }
        return type2;
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putDescriptorIntoFrameMap"));
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement2);
        }
        if (statement2 instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement2.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putLocalVariableIntoFrameMap"));
        }
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(statement2);
        if (variableDescriptor.getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            this.myFrameMap.enter(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext), AsmTypes.K_PROPERTY0_TYPE);
        }
        if (AsmTypes.isSharedVarType(type2)) {
            this.markLineNumber(statement2, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement2, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveDescriptorFromFrameMap"));
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement2, blockEnd, leaveTasks);
        }
        if (statement2 instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement2, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveLocalVariableFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveLocalVariableFromFrameMap"));
        }
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(statement2);
        if (variableDescriptor.getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add((Function<StackValue, Void>)((Function)answer -> {
            if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                this.myFrameMap.leave(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
            }
            int index2 = this.myFrameMap.leave(variableDescriptor);
            if (AsmTypes.isSharedVarType(type2)) {
                this.v.aconst(null);
                this.v.store(index2, AsmTypes.OBJECT_TYPE);
            }
            this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        }));
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(@NotNull KtNamedFunction statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveNamedFunctionFromFrameMap"));
        }
        if (leaveTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leaveTasks", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addLeaveTaskToRemoveNamedFunctionFromFrameMap"));
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
        assert (functionDescriptor2 != null);
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor2);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add((Function<StackValue, Void>)((Function)answer -> {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$addLeaveTaskToRemoveNamedFunctionFromFrameMap$10"));
            }
            int index2 = this.myFrameMap.leave(functionDescriptor2);
            assert (!functionDescriptor2.getName().isSpecial()) : "Local variable should be generated only for function with name: " + statement2.getText();
            this.v.visitLocalVariable(functionDescriptor2.getName().asString() + "$", type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        }));
    }

    public boolean isShouldMarkLineNumbers() {
        return this.shouldMarkLineNumbers;
    }

    public void setShouldMarkLineNumbers(boolean shouldMarkLineNumbers) {
        this.shouldMarkLineNumbers = shouldMarkLineNumbers;
    }

    public void markStartLineNumber(@NotNull KtElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "markStartLineNumber"));
        }
        this.markLineNumber(element2, false);
    }

    public void markLineNumber(@NotNull KtElement statement2, boolean markEndOffset) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "markLineNumber"));
        }
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement((PsiElement)statement2, markEndOffset);
        if (lineNumber == null || lineNumber == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber;
        Label label2 = new Label();
        this.v.visitLabel(label2);
        this.v.visitLineNumber(lineNumber.intValue(), label2);
    }

    public void markLineNumberAfterInlineIfNeeded() {
        if (!this.shouldMarkLineNumbers) {
            if (this.myLastLineNumber > -1) {
                Label label2 = new Label();
                this.v.visitLabel(label2);
                this.v.visitLineNumber(this.myLastLineNumber, label2);
            }
        } else {
            this.myLastLineNumber = -1;
        }
    }

    public int getLastLineNumber() {
        return this.myLastLineNumber;
    }

    private void doFinallyOnReturn(@NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterReturnLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "doFinallyOnReturn"));
        }
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.peek();
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterReturnLabel);
            } else if (!(stackElement instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            this.doFinallyOnReturn(afterReturnLabel);
            this.blockStackElements.push((Object)stackElement);
        }
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element2 : this.blockStackElements) {
            if (!(element2 instanceof FinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable FinallyBlockStackElement finallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel) {
        if (finallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (finallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = (BlockStackElement)this.blockStackElements.pop();
            assert (topOfStack == finallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = finallyBlockStackElement.expression;
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            finallyBlockStackElement.addGapLabel(finallyStart);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            this.v.goTo(tryCatchBlockEnd);
        }
        if (finallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label2 = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            finallyBlockStackElement.addGapLabel(finallyEnd);
            this.blockStackElements.push((Object)finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(@NotNull KtReturnExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitReturnExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            boolean isNonLocalReturn;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitReturnExpression$11"));
            }
            KtExpression returnedExpression = expression2.getReturnedExpression();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)this.getContext().getContextDescriptor();
            NonLocalReturnInfo nonLocalReturn = this.getNonLocalReturnInfo(descriptor2, expression2);
            boolean bl = isNonLocalReturn = nonLocalReturn != null;
            if (isNonLocalReturn && this.state.isInlineDisabled()) {
                this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on((PsiElement)expression2));
                AsmUtil.genThrow(this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                return Unit.INSTANCE;
            }
            Type returnType2 = isNonLocalReturn ? nonLocalReturn.returnType : this.returnType;
            StackValue valueToReturn = returnedExpression != null ? this.gen(returnedExpression) : StackValue.none();
            this.putStackValue(returnedExpression, returnType2, valueToReturn);
            Label afterReturnLabel = new Label();
            this.generateFinallyBlocksIfNeeded(returnType2, afterReturnLabel);
            if (isNonLocalReturn) {
                InlineCodegenUtil.generateGlobalReturnFlag(this.v, nonLocalReturn.labelName);
                this.v.visitInsn(returnType2.getOpcode(172));
            } else {
                this.v.areturn(this.returnType);
            }
            this.v.mark(afterReturnLabel);
            return Unit.INSTANCE;
        }));
    }

    public void generateFinallyBlocksIfNeeded(Type returnType2, @NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterReturnLabel", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateFinallyBlocksIfNeeded"));
        }
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals((Object)returnType2)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType2);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType2);
                localForReturnValue.store(StackValue.onStack(returnType2), this.v);
                this.doFinallyOnReturn(afterReturnLabel);
                localForReturnValue.put(returnType2, this.v);
                this.myFrameMap.leaveTemp(returnType2);
            } else {
                this.doFinallyOnReturn(afterReturnLabel);
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNonLocalReturnInfo"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNonLocalReturnInfo"));
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression2.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = (FunctionDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(this.typeMapper.mapReturnType(containingFunction), "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element2 = this.bindingContext.get(BindingContext.LABEL_TARGET, expression2.getTargetLabel());
            if (element2 != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
                assert (element2 != null) : "Expression should be not null " + expression2.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element2.getText();
                return new NonLocalReturnInfo(this.typeMapper.mapReturnType((CallableDescriptor)elementDescriptor), expression2.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(KtExpression expr) {
        boolean isBlockedNamedFunction = expr instanceof KtBlockExpression && expr.getParent() instanceof KtNamedFunction;
        FunctionDescriptor originalSuspendLambdaDescriptor = ExpressionCodegen.getOriginalSuspendLambdaDescriptorFromContext(this.context);
        boolean isVoidCoroutineLambda = originalSuspendLambdaDescriptor != null && TypeSignatureMappingKt.hasVoidReturnType(originalSuspendLambdaDescriptor);
        Type typeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? Type.VOID_TYPE : this.returnType;
        this.gen(expr, typeForExpression);
        if (!ExpressionCodegen.endsWithReturn(expr)) {
            this.markLineNumber(expr, true);
            if (ExpressionCodegen.isLambdaVoidBody(expr, typeForExpression)) {
                this.markLineNumber((KtFunctionLiteral)expr.getParent(), true);
            }
            if (typeForExpression.getSort() == 0) {
                StackValue.none().put(this.returnType, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(KtElement bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements = ((KtBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(KtElement bodyExpression, Type returnType2) {
        PsiElement parent2;
        if (bodyExpression instanceof KtBlockExpression && (parent2 = bodyExpression.getParent()) instanceof KtFunctionLiteral) {
            return Type.VOID_TYPE.equals((Object)returnType2);
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver) {
        ClassDescriptor classDescriptor;
        StackValue intrinsicResult;
        DeclarationDescriptor descriptor2;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSimpleNameExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSimpleNameExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall2 == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        } else {
            StackValue intrinsicResult2;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call2 = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                resolvedCall2 = call2.getVariableCall();
            }
            if ((intrinsicResult2 = this.applyIntrinsic(descriptor2 = resolvedCall2.getResultingDescriptor(), KCallableNameProperty.class, resolvedCall2, receiver)) != null) {
                return intrinsicResult2;
            }
            receiver = StackValue.receiver(resolvedCall2, receiver, this, null);
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression2.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if ((intrinsicResult = this.applyIntrinsic(descriptor2, IntrinsicPropertyGetter.class, resolvedCall2, receiver)) != null) {
            return intrinsicResult;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall2 != null) {
                ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
                KotlinType returnType2 = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension : codegenExtensions) {
                    StackValue value2;
                    if (returnType2 == null || (value2 = extension.applyProperty(receiver, resolvedCall2, context)) == null) continue;
                    return value2;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor2 = superCallTarget = resolvedCall2 == null ? null : this.getSuperCallTarget(resolvedCall2.getCall());
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver, resolvedCall2);
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                throw new IllegalStateException("Type alias " + descriptor2 + " static member refernece should be rejected by type checker, since there is no class corresponding to this type alias.");
            }
            descriptor2 = classDescriptor;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)descriptor2;
            if (DescriptorUtils.isObject(classDescriptor)) {
                return StackValue.singleton(classDescriptor, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return StackValue.enumEntry(classDescriptor, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    @Nullable
    private StackValue applyIntrinsic(DeclarationDescriptor descriptor2, Class<? extends IntrinsicPropertyGetter> intrinsicType, ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "applyIntrinsic"));
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsicType.isInstance(intrinsic)) {
                Type returnType2 = this.typeMapper.mapType(memberDescriptor);
                return ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall2, this, returnType2, receiver);
            }
        }
        return null;
    }

    @Nullable
    private ClassDescriptor getSuperCallTarget(@NotNull Call call2) {
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getSuperCallTarget"));
        }
        KtSuperExpression superExpression = CallResolverUtilKt.getSuperCallExpression(call2);
        return superExpression == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "findLocalOrCapturedValue"));
        }
        int index2 = this.lookupLocalIndex(descriptor2);
        if (index2 >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "findCapturedValue"));
        }
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        return ExpressionCodegen.lookupValuaAndLocalVariableMetadata(descriptor2, StackValue.LOCAL_0, this.state, false, this.context, this);
    }

    @Nullable
    static StackValue lookupValuaAndLocalVariableMetadata(@NotNull DeclarationDescriptor descriptor2, @NotNull StackValue prefix, @NotNull GenerationState state, boolean ignoreNoOuter, @NotNull CodegenContext context, @Nullable ExpressionCodegen codegen) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupValuaAndLocalVariableMetadata"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupValuaAndLocalVariableMetadata"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupValuaAndLocalVariableMetadata"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupValuaAndLocalVariableMetadata"));
        }
        StackValue value2 = context.lookupInContext(descriptor2, prefix, state, ignoreNoOuter);
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) || value2 == null) {
            return value2;
        }
        VariableDescriptor metadata = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, state.getBindingContext());
        StackValue metadataValue = context.lookupInContext(metadata, prefix, state, ignoreNoOuter);
        assert (metadataValue != null) : "Metadata stack value should be non-null for local delegated property";
        if (codegen == null) {
            return null;
        }
        return codegen.delegatedVariableValue(value2, metadataValue, (VariableDescriptorWithAccessors)descriptor2, state.getTypeMapper());
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lookupCapturedValueInConstructorParameters"));
        }
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return this.adjustVariableValue(parentResult, descriptor2);
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return this.adjustVariableValue(StackValue.local(parameterOffsetInConstructor, parentResult.type), descriptor2);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            Type varType = this.getVariableTypeNoSharing(variableDescriptor);
            if (sharedVarType != null) {
                return StackValue.shared(index2, varType);
            }
            return this.adjustVariableValue(StackValue.local(index2, varType), variableDescriptor);
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean lookupLocal(DeclarationDescriptor descriptor2) {
        return this.lookupLocalIndex(descriptor2) != -1;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        int index2 = this.myFrameMap.getIndex(descriptor2);
        if (index2 != -1) {
            return index2;
        }
        if (!(descriptor2 instanceof ValueParameterDescriptor)) {
            return -1;
        }
        DeclarationDescriptor synonym = this.bindingContext.get(CodegenBinding.PARAMETER_SYNONYM, (ValueParameterDescriptor)descriptor2);
        if (synonym == null) {
            return -1;
        }
        return this.myFrameMap.getIndex(synonym);
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        StackValue.Property property2 = this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver, null);
        if (property2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        return property2;
    }

    private CodegenContext getBackingFieldContext(@NotNull FieldAccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration) {
        if (accessorKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorKind", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBackingFieldContext"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getBackingFieldContext"));
        }
        switch (accessorKind) {
            case NORMAL: {
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
        }
        throw new IllegalStateException();
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, @NotNull StackValue receiver, @Nullable ResolvedCall resolvedCall2) {
        String fieldName;
        boolean skipPropertyAccessors;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForProperty"));
        }
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver);
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        FieldAccessorKind fieldAccessorKind = FieldAccessorKind.NORMAL;
        boolean isBackingFieldInClassCompanion = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        if (isBackingFieldInClassCompanion && (forceField || propertyDescriptor.isConst() && Visibilities.isPrivate(propertyDescriptor.getVisibility()))) {
            fieldAccessorKind = FieldAccessorKind.IN_CLASS_COMPANION;
        } else if (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration) {
            fieldAccessorKind = FieldAccessorKind.FIELD_FROM_LOCAL;
        }
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration);
        DeclarationDescriptor ownerDescriptor = containingDeclaration;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        if (fieldAccessorKind != FieldAccessorKind.NORMAL) {
            int flags = AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty);
            boolean isInlinedConst = propertyDescriptor.isConst() && this.state.getShouldInlineConstVals();
            boolean bl = skipPropertyAccessors = isInlinedConst || (flags & 2) == 0 || skipAccessorsForPrivateFieldInOuterClass;
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            }
        } else {
            if (!isBackingFieldInClassCompanion) {
                ownerDescriptor = propertyDescriptor;
            }
            skipPropertyAccessors = forceField;
        }
        if (!skipPropertyAccessors) {
            PropertySetterDescriptor setter;
            if (!JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals())) {
                propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget, this.state);
                PropertyGetterDescriptor getter = (propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget)).getGetter();
                if (getter != null && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter, isSuper);
                }
            }
            if (propertyDescriptor.isVar() && (setter = propertyDescriptor.getSetter()) != null && !JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals()) && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                callableSetter = this.typeMapper.mapToCallableMethod(setter, isSuper);
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = KotlinTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStaticBackingField, fieldName, callableGetter, callableSetter, receiver, this, resolvedCall2);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForSyntheticExtensionProperty"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForSyntheticExtensionProperty"));
        }
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        StackValue.Property property2 = StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, receiver, this, null);
        if (property2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "intermediateValueForSyntheticExtensionProperty"));
        }
        return property2;
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitCallExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression2, resolvedCall2);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2);
            assert (argumentExpression != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression, this);
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    @Override
    public StackValue visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, StackValue data) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitCollectionLiteralExpression"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        assert (resolvedCall2 != null) : "No resolved call for " + PsiUtilsKt.getTextWithLocation((PsiElement)expression2);
        return this.invokeFunction(resolvedCall2, data);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        if (probablyParenthesizedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "probablyParenthesizedExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genSamInterfaceValue"));
        }
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genSamInterfaceValue"));
        }
        KtExpression expression2 = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression2).getFunctionLiteral(), samType);
        }
        if (expression2 instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression2, samType);
        }
        Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression2.getContainingKtFile(), this);
        return StackValue.operation(asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$genSamInterfaceValue$12"));
            }
            v.anew(asmType);
            v.dup();
            Type functionType2 = this.typeMapper.mapType(samType.getKotlinFunctionType());
            ((StackValue)expression2.accept(visitor2, StackValue.none())).put(functionType2, (InstructionAdapter)v);
            Label ifNonNull = new Label();
            Label afterAll = new Label();
            v.dup();
            v.ifnonnull(ifNonNull);
            v.pop();
            v.pop2();
            v.aconst(null);
            v.goTo(afterAll);
            v.mark(ifNonNull);
            v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{functionType2}), false);
            v.mark(afterAll);
            return null;
        }));
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor originalIfSamAdapter;
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "accessibleFunctionDescriptor"));
        }
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof TypeAliasConstructorDescriptor) {
            descriptor2 = ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor();
        }
        if ((originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2)) != null) {
            descriptor2 = originalIfSamAdapter;
        }
        descriptor2 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2);
        FunctionDescriptor functionDescriptor2 = CallUtilKt.usesDefaultArguments(resolvedCall2) ? descriptor2 : this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall2.getCall()));
        if (functionDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "accessibleFunctionDescriptor"));
        }
        return functionDescriptor2;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        StackValue stackValue = this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, receiver);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        ResolvedCallWithRealDescriptor callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state.getProject(), this.state.getBindingContext());
        if (callWithRealDescriptor != null) {
            StackValue coroutineInstanceValueForSuspensionPoint = this.getCoroutineInstanceValueForSuspensionPoint(resolvedCall2);
            StackValue coroutineInstanceValue = coroutineInstanceValueForSuspensionPoint != null ? coroutineInstanceValueForSuspensionPoint : this.getContinuationParameterFromEnclosingSuspendFunction(resolvedCall2);
            this.tempVariables.put(callWithRealDescriptor.getFakeContinuationExpression(), coroutineInstanceValue);
            StackValue stackValue = this.invokeFunction(callWithRealDescriptor.getResolvedCall(), receiver);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
            }
            return stackValue;
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall2);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call2);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget, this.state);
        List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension : codegenExtensions) {
                StackValue stackValue = extension.applyFunction(receiver, resolvedCall2, context);
                if (stackValue == null) continue;
                StackValue stackValue2 = stackValue;
                if (stackValue2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
                }
                return stackValue2;
            }
        }
        Callable callable2 = this.resolveToCallable(fd, superCallTarget != null, resolvedCall2);
        StackValue stackValue = callable2.invokeMethodWithArguments(resolvedCall2, receiver, this);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeFunction"));
        }
        return stackValue;
    }

    private StackValue getContinuationParameterFromEnclosingSuspendFunction(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getContinuationParameterFromEnclosingSuspendFunction"));
        }
        FunctionDescriptor enclosingSuspendFunction = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        assert (enclosingSuspendFunction != null) : "Suspend functions may be called either as suspension points or from another suspend function";
        FunctionDescriptor enclosingSuspendFunctionJvmView = this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, enclosingSuspendFunction);
        assert (enclosingSuspendFunctionJvmView != null) : "No JVM view function found for " + enclosingSuspendFunction;
        ValueParameterDescriptor continuationParameter = enclosingSuspendFunctionJvmView.getValueParameters().get(enclosingSuspendFunctionJvmView.getValueParameters().size() - 1);
        return this.findLocalOrCapturedValue(continuationParameter);
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context) {
        for (CodegenContext c = context; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull ResolvedCall resolvedCall2) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(fd);
        if (intrinsic != null) {
            Callable callable2 = intrinsic.toCallable(fd, superCall, resolvedCall2, this);
            if (callable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
            }
            return callable2;
        }
        CallableMethod callableMethod = this.resolveToCallableMethod(fd, superCall);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallable"));
        }
        return callableMethod;
    }

    @NotNull
    private CallableMethod resolveToCallableMethod(@NotNull FunctionDescriptor fd, boolean superCall) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallableMethod"));
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(fd), superCall);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "resolveToCallableMethod"));
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall2);
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall2, receiver, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        KotlinType returnType2;
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        if (argumentGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentGenerator", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "invokeMethodWithArguments"));
        }
        boolean isSuspensionPoint = CoroutineCodegenUtilKt.isSuspensionPointInStateMachine(resolvedCall2, this.bindingContext);
        boolean isConstructor = resolvedCall2.getResultingDescriptor() instanceof ConstructorDescriptor;
        this.putReceiverAndInlineMarkerIfNeeded(callableMethod, resolvedCall2, receiver, isSuspensionPoint, isConstructor);
        callGenerator.processAndPutHiddenParameters(false);
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate((List<? extends ResolvedValueArgument>)valueArguments2, (List<? extends ResolvedValueArgument>)new ArrayList<ResolvedValueArgument>(resolvedCall2.getValueArguments().values()), (CallableDescriptor)resolvedCall2.getResultingDescriptor());
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall2);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(parameter.getAsmType(), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        if (isSuspensionPoint) {
            this.v.invokestatic("kotlin/coroutines/Markers", "beforeSuspensionPoint", "()V", false);
        }
        callGenerator.genCall(callableMethod, resolvedCall2, defaultMaskWasGenerated, this);
        if (isSuspensionPoint) {
            this.v.invokestatic("kotlin/coroutines/Markers", "afterSuspensionPoint", "()V", false);
            InlineCodegenUtil.addInlineMarker(this.v, false);
        }
        if ((returnType2 = resolvedCall2.getResultingDescriptor().getReturnType()) != null && KotlinBuiltIns.isNothing(returnType2)) {
            this.v.aconst(null);
            this.v.athrow();
        }
    }

    private void putReceiverAndInlineMarkerIfNeeded(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, boolean isSuspensionPoint, boolean isConstructor) {
        boolean isSafeCallOrOnStack;
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReceiverAndInlineMarkerIfNeeded"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReceiverAndInlineMarkerIfNeeded"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReceiverAndInlineMarkerIfNeeded"));
        }
        boolean bl = isSafeCallOrOnStack = receiver instanceof StackValue.SafeCall || receiver instanceof StackValue.OnStack;
        if (isSuspensionPoint && !isSafeCallOrOnStack) {
            InlineCodegenUtil.addInlineMarker(this.v, true);
        }
        if (!isConstructor) {
            receiver = StackValue.receiver(resolvedCall2, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            if (isSuspensionPoint && isSafeCallOrOnStack) {
                boolean bothReceivers = receiver instanceof StackValue.CallReceiver && ((StackValue.CallReceiver)receiver).getDispatchReceiver().type.getSort() != 0 && ((StackValue.CallReceiver)receiver).getExtensionReceiver().type.getSort() != 0;
                Type firstReceiverType = bothReceivers ? ((StackValue.CallReceiver)receiver).getDispatchReceiver().type : receiver.type;
                Type secondReceiverType = bothReceivers ? receiver.type : null;
                int tmpVarForFirstReceiver = this.myFrameMap.enterTemp(firstReceiverType);
                int tmpVarForSecondReceiver = -1;
                if (secondReceiverType != null) {
                    tmpVarForSecondReceiver = this.myFrameMap.enterTemp(secondReceiverType);
                    this.v.store(tmpVarForSecondReceiver, secondReceiverType);
                }
                this.v.store(tmpVarForFirstReceiver, firstReceiverType);
                InlineCodegenUtil.addInlineMarker(this.v, true);
                this.v.load(tmpVarForFirstReceiver, firstReceiverType);
                if (secondReceiverType != null) {
                    this.v.load(tmpVarForSecondReceiver, secondReceiverType);
                    this.myFrameMap.leaveTemp(secondReceiverType);
                }
                this.myFrameMap.leaveTemp(firstReceiverType);
            }
            callableMethod.afterReceiverGeneration(this.v);
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement2, @Nullable TypeParameterMappings typeParameterMappings, boolean isDefaultCompilation) {
        boolean isInline;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        if (callElement2 == null) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
            }
            return callGenerator;
        }
        boolean bl = isInline = !(this.state.isInlineDisabled() && !InlineUtil.containsReifiedTypeParameters(descriptor2) || !InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2));
        if (!isInline) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
            }
            return callGenerator;
        }
        FunctionDescriptor original = ExpressionCodegen.unwrapInitialSignatureDescriptor(DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal()));
        if (isDefaultCompilation) {
            InlineCodegenForDefaultBody inlineCodegenForDefaultBody = new InlineCodegenForDefaultBody(original, this, this.state);
            if (inlineCodegenForDefaultBody == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
            }
            return inlineCodegenForDefaultBody;
        }
        InlineCodegen inlineCodegen = new InlineCodegen(this, this.state, original, callElement2, typeParameterMappings);
        if (inlineCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        return inlineCodegen;
    }

    @NotNull
    private static FunctionDescriptor unwrapInitialSignatureDescriptor(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapInitialSignatureDescriptor"));
        }
        if (function2.getInitialSignatureDescriptor() != null) {
            FunctionDescriptor functionDescriptor2 = function2.getInitialSignatureDescriptor();
            if (functionDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapInitialSignatureDescriptor"));
            }
            return functionDescriptor2;
        }
        FunctionDescriptor functionDescriptor3 = function2;
        if (functionDescriptor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "unwrapInitialSignatureDescriptor"));
        }
        return functionDescriptor3;
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGeneratorForDefaultImplBody"));
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(descriptor2, function2, null, true);
        if (callGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGeneratorForDefaultImplBody"));
        }
        return callGenerator;
    }

    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        return this.getOrCreateCallGenerator(resolvedCall2, (CallableDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments = ExpressionCodegen.getTypeArgumentsForResolvedCall(resolvedCall2, descriptor2);
        TypeParameterMappings mappings = new TypeParameterMappings();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = entry.getValue();
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall2.getResultingDescriptor());
            Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2);
            if (typeParameterAndReificationArgument == null) {
                KotlinType approximatedType = CapturedTypeApproximationKt.approximateCapturedTypes(entry.getValue()).getUpper();
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeParameter(approximatedType, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), approximatedType, asmType, ((JvmSignatureWriter)signatureWriter).toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, (ReificationArgument)typeParameterAndReificationArgument.getSecond(), isReified);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(descriptor2, resolvedCall2.getCall().getCallElement(), mappings, false);
        if (callGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getOrCreateCallGenerator"));
        }
        return callGenerator;
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> getTypeArgumentsForResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getTypeArgumentsForResolvedCall"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getTypeArgumentsForResolvedCall"));
        }
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getTypeArgumentsForResolvedCall"));
            }
            return map2;
        }
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)descriptor2;
        ClassConstructorDescriptor underlyingConstructorDescriptor = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor();
        KotlinType resultingType = typeAliasConstructorDescriptor.getReturnType();
        List<TypeProjection> typeArgumentsForReturnType = resultingType.getArguments();
        List<TypeParameterDescriptor> typeParameters = underlyingConstructorDescriptor.getTypeParameters();
        assert (typeParameters.size() == typeArgumentsForReturnType.size()) : "Type parameters of the underlying constructor " + underlyingConstructorDescriptor + "should correspond to type arguments for the resulting type " + resultingType;
        HashMap typeArgumentsMap = Maps.newHashMapWithExpectedSize((int)typeParameters.size());
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            KotlinType typeArgument = typeArgumentsForReturnType.get(typeParameter.getIndex()).getType();
            typeArgumentsMap.put(typeParameter, typeArgument);
        }
        HashMap hashMap = typeArgumentsMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getTypeArgumentsForResolvedCall"));
        }
        return hashMap;
    }

    @Nullable
    private static Pair<TypeParameterDescriptor, ReificationArgument> extractReificationArgument(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "extractReificationArgument"));
        }
        int arrayDepth = 0;
        boolean isNullable = type2.isMarkedNullable();
        while (KotlinBuiltIns.isArray(type2)) {
            ++arrayDepth;
            type2 = type2.getArguments().get(0).getType();
        }
        TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (parameterDescriptor == null) {
            return null;
        }
        return new Pair((Object)parameterDescriptor, (Object)new ReificationArgument(parameterDescriptor.getName().asString(), isNullable, arrayDepth));
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
                CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
                if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                    StackValue.Local local = StackValue.LOCAL_0;
                    if (local == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                    }
                    return local;
                }
                StackValue.Field field2 = StackValue.singleton(receiverDescriptor, this.typeMapper);
                if (field2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                }
                return field2;
            }
            if (receiverDescriptor instanceof ScriptDescriptor) {
                StackValue stackValue = this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
                }
                return stackValue;
            }
            StackValue stackValue = StackValue.thisOrOuter(this, receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        if (receiverValue instanceof ExtensionReceiver) {
            StackValue stackValue = this.generateExtensionReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            StackValue stackValue = this.gen(((ExpressionReceiver)receiverValue).getExpression());
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateReceiverValue"));
            }
            return stackValue;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    @NotNull
    private StackValue generateExtensionReceiver(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExtensionReceiver"));
        }
        if (this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()) != -1) {
            StackValue.Local local = StackValue.local(this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()), this.typeMapper.mapType(descriptor2.getExtensionReceiverParameter()));
            if (local == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExtensionReceiver"));
            }
            return local;
        }
        StackValue stackValue = this.context.generateReceiver(descriptor2, this.state, false);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExtensionReceiver"));
        }
        return stackValue;
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver) {
        CodegenContext cur;
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
        }
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver) {
                    StackValue stackValue = result2;
                    if (stackValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
                    }
                    return stackValue;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                Type classType = this.typeMapper.mapType(receiver);
                String fieldName = scriptContext.getScriptFieldName(receiver);
                StackValue.Field field2 = StackValue.field(classType, currentScriptType, fieldName, false, result2, receiver);
                if (field2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateScriptReceiver"));
                }
                return field2;
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        if (calleeContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeContainingClass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        StackValue stackValue = this.generateThisOrOuter(calleeContainingClass, isSuper, false);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper, boolean forceOuter) {
        CodegenContext cur;
        if (calleeContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeContainingClass", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
        }
        boolean isSingleton = calleeContainingClass.getKind().isSingleton();
        if (isSingleton) {
            if (calleeContainingClass.equals(this.context.getThisDescriptor()) && !CodegenUtilKt.isJvmStaticInObjectOrClass(this.context.getFunctionDescriptor())) {
                StackValue.Local local = StackValue.local(0, this.typeMapper.mapType(calleeContainingClass));
                if (local == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return local;
            }
            if (DescriptorUtils.isEnumEntry(calleeContainingClass)) {
                StackValue.Field field2 = StackValue.enumEntry(calleeContainingClass, this.typeMapper);
                if (field2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return field2;
            }
            StackValue.Field field3 = StackValue.singleton(calleeContainingClass, this.typeMapper);
            if (field3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
            }
            return field3;
        }
        Type type2 = this.asmType(calleeContainingClass.getDefaultType());
        StackValue result2 = StackValue.local(0, type2);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor == calleeContainingClass) {
                StackValue.Local local = result2;
                if (local == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return local;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, calleeContainingClass)) {
                StackValue stackValue = this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, calleeContainingClass);
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateThisOrOuter"));
                }
                return stackValue;
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                inStartConstructorContext = false;
                continue;
            }
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            result2 = cur.getOuterExpression(result2, false);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        CodegenContext codegenContext = cur;
        if (codegenContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getNotNullParentContextForMethod"));
        }
        return codegenContext;
    }

    @NotNull
    public StackValue genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
        }
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean hasSpread = false;
        for (int i = 0; i != size; ++i) {
            if (arguments2.get(i).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            String toArrayDescriptor;
            String addDescriptor;
            String owner;
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                Type arrayType = AsmUtil.getArrayType(arrayOfReferences ? AsmTypes.OBJECT_TYPE : elementType);
                StackValue stackValue = StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    this.gen(((ValueArgument)arguments2.get(0)).getArgumentExpression(), type2);
                    this.v.dup();
                    this.v.arraylength();
                    this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor((Type)arrayType, (Type[])new Type[]{arrayType, Type.INT_TYPE}), false);
                    if (arrayOfReferences) {
                        this.v.checkcast(type2);
                    }
                    return Unit.INSTANCE;
                }));
                if (stackValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
                }
                return stackValue;
            }
            if (arrayOfReferences) {
                owner = "kotlin/jvm/internal/SpreadBuilder";
                addDescriptor = "(Ljava/lang/Object;)V";
                toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
            } else {
                String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                addDescriptor = "(" + elementType.getDescriptor() + ")V";
                toArrayDescriptor = "()" + type2.getDescriptor();
            }
            StackValue stackValue = StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                if (outType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$genVarargs$14"));
                }
                this.v.anew(Type.getObjectType((String)owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i = 0; i != size; ++i) {
                    this.v.dup();
                    ValueArgument argument2 = (ValueArgument)arguments2.get(i);
                    if (argument2.getSpreadElement() != null) {
                        this.gen(argument2.getArgumentExpression(), AsmTypes.OBJECT_TYPE);
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argument2.getArgumentExpression(), elementType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
                return Unit.INSTANCE;
            }));
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            if (outType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$genVarargs$15"));
            }
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            for (int i = 0; i != size; ++i) {
                this.v.dup();
                StackValue rightSide = this.gen(((ValueArgument)arguments2.get(i)).getArgumentExpression());
                StackValue.arrayElement(elementType, StackValue.onStack(type2), StackValue.constant(i, Type.INT_TYPE)).store(rightSide, this.v);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genVarargs"));
        }
        return stackValue;
    }

    public int indexOfLocalNotDelegated(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isVarCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        if (declarationDescriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)declarationDescriptor).isDelegated()) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, StackValue data) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitClassLiteralExpression"));
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = this.bindingContext.get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        return this.generateClassLiteralReference(lhs, receiverExpression, true);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, StackValue data) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitCallableReferenceExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2.getCallableReference(), this.bindingContext);
        KotlinType receiverExpressionType = this.expressionJetType(expression2.getReceiverExpression());
        Type receiverAsmType = receiverExpressionType != null ? this.asmType(receiverExpressionType) : null;
        StackValue receiverValue = receiverExpressionType != null ? StackValue.coercion(this.gen(expression2.getReceiverExpression()), receiverAsmType) : null;
        FunctionDescriptor functionDescriptor2 = this.bindingContext.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor2 != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor2, resolvedCall2, receiverAsmType, null, false);
            return this.genClosure(expression2, functionDescriptor2, strategy, null, (FunctionDescriptor)resolvedCall2.getResultingDescriptor(), receiverValue);
        }
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(expression2);
        return this.generatePropertyReference(expression2, variableDescriptor, (VariableDescriptor)resolvedCall2.getResultingDescriptor(), receiverAsmType, receiverValue);
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element2, @NotNull VariableDescriptor variableDescriptor, @NotNull VariableDescriptor target, @Nullable Type receiverAsmType, @Nullable StackValue receiverValue) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForCallable(this.bindingContext, variableDescriptor);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(element2), this.typeMapper.mapClass(classDescriptor), element2.getContainingFile());
        PropertyReferenceCodegen codegen = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION), element2, classBuilder2, variableDescriptor, target, receiverAsmType);
        codegen.generate();
        StackValue stackValue = codegen.putInstanceOnStack(receiverValue == null ? null : () -> {
            assert (receiverAsmType != null) : "Receiver type should not be null when receiver value is not null: " + receiverValue;
            receiverValue.put(receiverAsmType, this.v);
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generatePropertyReference"));
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateClassLiteralReference(@NotNull DoubleColonLHS lhs, @Nullable KtExpression receiverExpression, boolean wrapIntoKClass) {
        if (lhs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lhs", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        StackValue stackValue = StackValue.operation(wrapIntoKClass ? AsmTypes.K_CLASS_TYPE : AsmTypes.JAVA_CLASS_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (lhs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lhs", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateClassLiteralReference$17"));
            }
            KotlinType type2 = lhs.getType();
            if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
                JavaClassProperty.INSTANCE.generateImpl((InstructionAdapter)v, this.gen(receiverExpression));
            } else {
                if (TypeUtils.isTypeParameter(type2)) {
                    assert (TypeUtils.isReifiedTypeParameter(type2)) : "Non-reified type parameter under ::class should be rejected by type checker: " + type2;
                    this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                }
                AsmUtil.putJavaLangClassInstance(v, this.typeMapper.mapType(type2));
            }
            if (wrapIntoKClass) {
                AsmUtil.wrapJavaClassIntoKClass(v);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateClassLiteralReference"));
        }
        return stackValue;
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDotQualifiedExpression"));
        }
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression2.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression2, @NotNull Label ifnull) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExpressionWithNullFallback"));
        }
        if (ifnull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifnull", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExpressionWithNullFallback"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression2 = deparenthesized;
        Type type2 = this.expressionType(expression2);
        if (expression2 instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression2, ifnull), type2);
        }
        return this.genLazy(expression2, type2);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull Label ifNull) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateSafeQualifiedExpression"));
        }
        if (ifNull == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifNull", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateSafeQualifiedExpression"));
        }
        KtExpression receiver = expression2.getReceiverExpression();
        KtExpression selector = expression2.getSelectorExpression();
        Type receiverType2 = this.expressionType(receiver);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver, ifNull);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType2, receiverValue, AsmUtil.isPrimitive(receiverType2) ? null : ifNull);
        return this.genQualified(newReceiver, selector);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, StackValue unused) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitSafeQualifiedExpression"));
        }
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression2));
        StackValue value2 = this.generateSafeQualifiedExpression(expression2, ifnull);
        StackValue newReceiver = StackValue.coercion(value2, type2);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression2.getReceiverExpression())) ? new StackValue.SafeFallback(type2, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryExpression"));
        }
        KtOperationReferenceExpression reference2 = expression2.getOperationReference();
        IElementType opToken = reference2.getReferencedNameElementType();
        if (opToken == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression2);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression2);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression2);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression2);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression2.getLeft(), expression2.getRight(), opToken);
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression2, receiver);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression2);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression2.getLeft()), expression2.getLeft(), this), expression2.getRight(), reference2);
        }
        ConstantValue<?> compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall2, this.expressionType(expression2));
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    private StackValue generateIn(StackValue leftValue, KtExpression rangeExpression, KtSimpleNameExpression operationReference) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        boolean isInverted = operationReference.getReferencedNameElementType() == KtTokens.NOT_IN;
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (RangeCodegenUtil.isPrimitiveRangeSpecializationOfType(leftValue.type, deparenthesized, this.bindingContext) || RangeCodegenUtil.isPrimitiveRangeToExtension(operationReference, this.bindingContext)) {
                this.generateInPrimitiveRange(leftValue, (KtBinaryExpression)deparenthesized, isInverted);
            } else {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(operationReference, this.bindingContext);
                StackValue result2 = this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, StackValue.none());
                result2.put(result2.type, (InstructionAdapter)v);
                if (isInverted) {
                    AsmUtil.genInvertBoolean(v);
                }
            }
            return null;
        }));
    }

    private void generateInPrimitiveRange(StackValue argument2, KtBinaryExpression rangeExpression, boolean isInverted) {
        Type rangeType = argument2.type;
        int localVarIndex = this.myFrameMap.enterTemp(rangeType);
        this.gen(rangeExpression.getLeft(), rangeType);
        argument2.put(rangeType, this.v);
        this.v.store(localVarIndex, rangeType);
        this.v.load(localVarIndex, rangeType);
        Label l1 = new Label();
        this.emitGreaterThan(rangeType, l1);
        this.v.load(localVarIndex, rangeType);
        this.gen(rangeExpression.getRight(), rangeType);
        this.emitGreaterThan(rangeType, l1);
        Label l2 = new Label();
        this.v.iconst(isInverted ? 0 : 1);
        this.v.goTo(l2);
        this.v.mark(l1);
        this.v.iconst(isInverted ? 1 : 0);
        this.v.mark(l2);
        this.myFrameMap.leaveTemp(rangeType);
    }

    private void emitGreaterThan(Type type2, Label label2) {
        if (AsmUtil.isIntPrimitive(type2)) {
            this.v.ificmpgt(label2);
        } else if (type2 == Type.LONG_TYPE) {
            this.v.lcmp();
            this.v.ifgt(label2);
        } else if (type2 == Type.FLOAT_TYPE || type2 == Type.DOUBLE_TYPE) {
            this.v.cmpg(type2);
            this.v.ifgt(label2);
        } else {
            throw new UnsupportedOperationException("Unexpected type: " + type2);
        }
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression2) {
        return StackValue.and(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression2) {
        return StackValue.or(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue generateEquals(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken) {
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateEquals"));
        }
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, opToken);
        }
        if (KtPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, opToken);
        }
        if (this.isIntZero(left, leftType) && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, opToken);
        }
        if (this.isIntZero(right, rightType) && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            rightType = AsmUtil.boxType(rightType);
        }
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, this.genLazy(left, leftType), this.genLazy(right, rightType));
        }
        return this.genEqualsForExpressionsPreferIEEE754Arithmetic(left, right, opToken, leftType, rightType, null);
    }

    private StackValue genEqualsForExpressionsPreferIEEE754Arithmetic(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken, @NotNull Type leftType, @NotNull Type rightType, @Nullable StackValue pregeneratedLeft) {
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genEqualsForExpressionsPreferIEEE754Arithmetic"));
        }
        if (leftType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genEqualsForExpressionsPreferIEEE754Arithmetic"));
        }
        if (rightType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "genEqualsForExpressionsPreferIEEE754Arithmetic"));
        }
        assert (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) : "Optoken should be '==' or '!=', but: " + opToken;
        TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        if (left754Type != null && right754Type != null && left754Type.type.equals((Object)right754Type.type)) {
            if (left754Type.isNullable || right754Type.isNullable) {
                if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0) {
                    return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                        if (opToken == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$genEqualsForExpressionsPreferIEEE754Arithmetic$19"));
                        }
                        this.generate754EqualsForNullableTypesViaIntrinsic((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                        return Unit.INSTANCE;
                    }));
                }
                return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                    if (opToken == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$genEqualsForExpressionsPreferIEEE754Arithmetic$20"));
                    }
                    this.generate754EqualsForNullableTypes((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                    return Unit.INSTANCE;
                }));
            }
            leftType = left754Type.type;
            rightType = right754Type.type;
        }
        return AsmUtil.genEqualsForExpressionsOnStack(opToken, pregeneratedLeft != null ? StackValue.coercion(pregeneratedLeft, leftType) : this.genLazy(left, leftType), this.genLazy(right, rightType));
    }

    private void generate754EqualsForNullableTypesViaIntrinsic(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        Type leftType;
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypesViaIntrinsic"));
        }
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypesViaIntrinsic"));
        }
        if (left754Type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left754Type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypesViaIntrinsic"));
        }
        if (right754Type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right754Type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypesViaIntrinsic"));
        }
        Type type2 = leftType = left754Type.isNullable ? AsmUtil.boxType(left754Type.type) : left754Type.type;
        if (pregeneratedLeft != null) {
            StackValue.coercion(pregeneratedLeft, leftType).put(leftType, v);
        } else {
            this.gen(left, leftType);
        }
        Type rightType = right754Type.isNullable ? AsmUtil.boxType(right754Type.type) : right754Type.type;
        this.gen(right, rightType);
        AsmUtil.genIEEE754EqualForNullableTypesCall(v, leftType, rightType);
        if (opToken == KtTokens.EXCLEQ) {
            AsmUtil.genInvertBoolean(v);
        }
    }

    private void generate754EqualsForNullableTypes(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypes"));
        }
        if (opToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opToken", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypes"));
        }
        if (left754Type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left754Type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypes"));
        }
        if (right754Type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right754Type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generate754EqualsForNullableTypes"));
        }
        int equals = opToken == KtTokens.EQEQ ? 1 : 0;
        int notEquals = opToken != KtTokens.EQEQ ? 1 : 0;
        Label end = new Label();
        StackValue leftValue = pregeneratedLeft != null ? pregeneratedLeft : this.gen(left);
        leftValue.put(leftValue.type, v);
        leftValue = StackValue.onStack(leftValue.type);
        Type leftType = left754Type.type;
        Type rightType = right754Type.type;
        if (left754Type.isNullable) {
            leftValue.dup(v, false);
            Label leftIsNull = new Label();
            v.ifnull(leftIsNull);
            StackValue.coercion(leftValue, leftType).put(leftType, v);
            StackValue nonNullLeftValue = StackValue.onStack(leftType);
            StackValue rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                rightValue.dup(v, false);
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                AsmUtil.pop((MethodVisitor)v, rightValue.type);
                AsmUtil.pop((MethodVisitor)v, nonNullLeftValue.type);
                v.iconst(notEquals);
                v.goTo(end);
                v.mark(rightIsNotNull);
            }
            StackValue.coercion(rightValue, rightType).put(rightType, v);
            StackValue nonNullRightValue = StackValue.onStack(rightType);
            StackValue.cmp(opToken, leftType, nonNullLeftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
            v.goTo(end);
            v.mark(leftIsNull);
            AsmUtil.pop((MethodVisitor)v, leftValue.type);
            rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                v.iconst(equals);
                v.goTo(end);
                v.mark(rightIsNotNull);
                v.iconst(notEquals);
            } else {
                AsmUtil.pop((MethodVisitor)v, rightValue.type);
                v.iconst(notEquals);
            }
            v.mark(end);
            return;
        }
        StackValue.coercion(leftValue, leftType).put(leftType, v);
        leftValue = StackValue.onStack(leftType);
        StackValue rightValue = this.gen(right);
        rightValue.put(rightValue.type, v);
        rightValue = StackValue.onStack(rightValue.type);
        rightValue.dup(v, false);
        Label rightIsNotNull = new Label();
        v.ifnonnull(rightIsNotNull);
        AsmUtil.pop((MethodVisitor)v, rightValue.type);
        AsmUtil.pop((MethodVisitor)v, leftValue.type);
        v.iconst(notEquals);
        v.goTo(end);
        v.mark(rightIsNotNull);
        StackValue.coercion(rightValue, rightType).put(rightType, v);
        StackValue nonNullRightValue = StackValue.onStack(rightType);
        StackValue.cmp(opToken, leftType, leftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
        v.mark(end);
    }

    private boolean isIntZero(KtExpression expr, Type exprType) {
        ConstantValue<?> exprValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expr, this.bindingContext, this.state.getShouldInlineConstVals());
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken) {
        return StackValue.compareIntWithZero(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken) {
        return StackValue.compareWithNull(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
    }

    private StackValue generateElvis(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateElvis"));
        }
        KtExpression left = expression2.getLeft();
        Type exprType = this.expressionType(expression2);
        Type leftType = this.expressionType(left);
        Label ifNull = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression2.getText();
        StackValue value2 = this.generateExpressionWithNullFallback(left, ifNull);
        if (AsmUtil.isPrimitive(leftType)) {
            return value2;
        }
        return StackValue.operation(exprType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateElvis$21"));
            }
            value2.put(value2.type, (InstructionAdapter)v);
            v.dup();
            v.ifnull(ifNull);
            StackValue.onStack(leftType).put(exprType, (InstructionAdapter)v);
            Label end = new Label();
            v.goTo(end);
            v.mark(ifNull);
            v.pop();
            this.gen(expression2.getRight(), exprType);
            v.mark(end);
            return null;
        }));
    }

    private StackValue generateComparison(KtBinaryExpression expression2, StackValue receiver) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        boolean is754Arithmetic;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        Callable callable2 = this.resolveToCallable((FunctionDescriptor)resolvedCall2.getResultingDescriptor(), false, resolvedCall2);
        boolean bl = is754Arithmetic = left754Type != null && right754Type != null && left754Type.type.equals((Object)right754Type.type);
        if (callable2 instanceof IntrinsicCallable && (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType) || is754Arithmetic)) {
            type2 = is754Arithmetic ? left754Type.type : AsmUtil.comparisonOperandType(leftType, rightType);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall2, receiver);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression2.getOperationToken(), type2, leftValue, rightValue);
    }

    private TypeAndNullability calcTypeForIEEE754ArithmeticIfNeeded(@Nullable KtExpression expression2) {
        return CodegenUtilKt.calcTypeForIEEE754ArithmeticIfNeeded(expression2, this.bindingContext, this.context.getFunctionDescriptor());
    }

    private StackValue generateAssignmentExpression(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            StackValue stackValue = this.gen(expression2.getLeft());
            KtExpression right = expression2.getRight();
            assert (right != null) : expression2.getText();
            stackValue.store(this.gen(right), this.v);
            return Unit.INSTANCE;
        }));
    }

    private StackValue generateAugmentedAssignment(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
            FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
            Callable callable2 = this.resolveToCallable(descriptor2, false, resolvedCall2);
            KtExpression lhs = expression2.getLeft();
            Type lhsType = this.expressionType(lhs);
            boolean keepReturnValue = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression2)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
            this.putCallAugAssignMethod(expression2, resolvedCall2, callable2, lhsType, keepReturnValue);
            return Unit.INSTANCE;
        }));
    }

    private void putCallAugAssignMethod(@NotNull KtBinaryExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Callable callable2, @NotNull Type lhsType, boolean keepReturnValue) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putCallAugAssignMethod"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putCallAugAssignMethod"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putCallAugAssignMethod"));
        }
        if (lhsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lhsType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putCallAugAssignMethod"));
        }
        StackValue value2 = this.gen(expression2.getLeft());
        if (keepReturnValue) {
            value2 = StackValue.complexWriteReadReceiver(value2);
        }
        value2.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        callable2.invokeMethodWithArguments(resolvedCall2, receiver, this).put(callable2.getReturnType(), this.v);
        if (keepReturnValue) {
            value2.store(StackValue.onStack(callable2.getReturnType()), this.v, true);
        }
    }

    public void invokeAppend(KtExpression expr) {
        KtBinaryExpression binaryExpression;
        ConstantValue<?> compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expr, this.bindingContext, this.state.getShouldInlineConstVals());
        if (compileTimeConstant == null && expr instanceof KtBinaryExpression && (binaryExpression = (KtBinaryExpression)expr).getOperationToken() == KtTokens.PLUS) {
            KtExpression left = binaryExpression.getLeft();
            KtExpression right = binaryExpression.getRight();
            Type leftType = this.expressionType(left);
            if (leftType.equals((Object)AsmTypes.JAVA_STRING_TYPE)) {
                this.invokeAppend(left);
                this.invokeAppend(right);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        if (compileTimeConstant != null) {
            StackValue.constant(compileTimeConstant.getValue(), exprType).put(exprType, this.v);
        } else {
            this.gen(expr, exprType);
        }
        AsmUtil.genInvokeAppendMethod(this.v, exprType.getSort() == 9 ? AsmTypes.OBJECT_TYPE : exprType);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression2) {
        if (expression2.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitLabeledExpression"));
        }
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull StackValue receiver) {
        String operationName;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPrefixExpression"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPrefixExpression"));
        }
        ConstantValue<?> compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall2, receiver);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression2.getBaseExpression());
        StackValue value2 = this.gen(expression2.getBaseExpression());
        return StackValue.preIncrement(type2, value2, increment, resolvedCall2, this);
    }

    @Override
    public StackValue visitPostfixExpression(@NotNull KtPostfixExpression expression2, StackValue receiver) {
        int index2;
        KtExpression operand;
        int increment;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitPostfixExpression"));
        }
        if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            StackValue base = this.genQualified(receiver, expression2.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            return StackValue.operation(base.type, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                base.put(base.type, (InstructionAdapter)v);
                v.dup();
                Label ok = new Label();
                v.ifnonnull(ok);
                v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                v.mark(ok);
                return null;
            }));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        Type asmResultType = this.expressionType(expression2);
        Type asmBaseType = this.expressionType(expression2.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        boolean isPrimitiveNumberClassDescriptor = AsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand = expression2.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand) == null && (index2 = this.indexOfLocalNotDelegated((KtReferenceExpression)operand)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Type storeType;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitPostfixExpression$25"));
            }
            StackValue value2 = StackValue.complexWriteReadReceiver(this.gen(expression2.getBaseExpression()));
            value2.put(asmBaseType, (InstructionAdapter)v);
            AsmUtil.dup(v, asmBaseType);
            StackValue.Local previousValue = StackValue.local(this.myFrameMap.enterTemp(asmBaseType), asmBaseType);
            previousValue.store(StackValue.onStack(asmBaseType), (InstructionAdapter)v);
            if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                AsmUtil.genIncrement(asmBaseType, increment, v);
                storeType = asmBaseType;
            } else {
                StackValue result2 = this.invokeFunction(resolvedCall2, StackValue.onStack(asmBaseType));
                result2.put(result2.type, (InstructionAdapter)v);
                storeType = result2.type;
            }
            value2.store(StackValue.onStack(storeType), (InstructionAdapter)v, true);
            previousValue.put(asmBaseType, (InstructionAdapter)v);
            this.myFrameMap.leaveTemp(asmBaseType);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property2, StackValue receiver) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitProperty"));
        }
        KtExpression initializer2 = property2.getInitializer();
        KtExpression delegateExpression = property2.getDelegateExpression();
        if (initializer2 != null) {
            assert (delegateExpression == null) : PsiUtilsKt.getElementTextWithContext(property2);
            this.initializeLocalVariable(property2, this.gen(initializer2));
        } else if (delegateExpression != null) {
            this.initializeLocalVariable(property2, this.gen(delegateExpression));
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitDestructuringDeclaration"));
        }
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType);
        this.initializeDestructuringDeclarationVariables(multiDeclaration, initializerAsReceiver, local);
        if (initializerAsmType.getSort() == 10 || initializerAsmType.getSort() == 9) {
            this.v.aconst(null);
            this.v.store(tempVarIndex, initializerAsmType);
        }
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    public void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue) {
        if (destructuringDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeDestructuringDeclarationVariables"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeDestructuringDeclarationVariables"));
        }
        if (receiverStackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverStackValue", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeDestructuringDeclarationVariables"));
        }
        for (KtDestructuringDeclarationEntry variableDeclaration : destructuringDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall2 != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call2 = this.makeFakeCall(receiver);
            VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(variableDeclaration);
            if (variableDescriptor.getName().isSpecial()) continue;
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call2, resolvedCall2, receiverStackValue));
        }
    }

    @NotNull
    private StackValue getVariableMetadataValue(VariableDescriptor variableDescriptor) {
        StackValue value2 = this.findLocalOrCapturedValue(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
        assert (value2 != null) : "Can't find stack value for local delegated variable metadata: " + variableDescriptor;
        StackValue stackValue = value2;
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableMetadataValue"));
        }
        return stackValue;
    }

    @NotNull
    private StackValue adjustVariableValue(@NotNull StackValue varValue, DeclarationDescriptor descriptor2) {
        if (varValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varValue", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "adjustVariableValue"));
        }
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
            StackValue stackValue = varValue;
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "adjustVariableValue"));
            }
            return stackValue;
        }
        VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
        StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
        StackValue.Delegate delegate2 = this.delegatedVariableValue(varValue, metadataValue, variableDescriptor, this.typeMapper);
        if (delegate2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "adjustVariableValue"));
        }
        return delegate2;
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @NotNull StackValue initializer2) {
        if (variableDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDeclaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeLocalVariable"));
        }
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializeLocalVariable"));
        }
        LocalVariableDescriptor variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type varType = this.getVariableTypeNoSharing(variableDescriptor);
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType) : StackValue.shared(index2, varType);
        storeTo.putReceiver(this.v, false);
        initializer2.put(initializer2.type, this.v);
        this.markLineNumber(variableDeclaration, false);
        Type resultType = initializer2.type;
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
            this.initializePropertyMetadata((KtProperty)variableDeclaration, variableDescriptor, metadataValue);
            ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
            if (provideDelegateResolvedCall != null) {
                resultType = this.generateProvideDelegateCallForLocalVariable(initializer2, metadataValue, provideDelegateResolvedCall);
            }
        }
        storeTo.storeSelector(resultType, this.v);
    }

    @NotNull
    private Type generateProvideDelegateCallForLocalVariable(@NotNull StackValue initializer2, final StackValue metadataValue, ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall) {
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateProvideDelegateCallForLocalVariable"));
        }
        StackValue provideDelegateReceiver = StackValue.onStack(initializer2.type);
        List<? extends ValueArgument> arguments2 = provideDelegateResolvedCall.getCall().getValueArguments();
        assert (arguments2.size() == 2) : "Resolved call for '" + OperatorNameConventions.PROVIDE_DELEGATE.asString() + "' should have exactly 2 value parameters";
        this.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
        this.tempVariables.put(arguments2.get(1).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen$2", "putSelector"));
                }
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ExpressionCodegen$2", "putSelector"));
                }
                metadataValue.put(type2, v);
            }
        });
        StackValue result2 = this.invokeFunction(provideDelegateResolvedCall, provideDelegateReceiver);
        result2.put(result2.type, this.v);
        this.tempVariables.remove(arguments2.get(0).asElement());
        this.tempVariables.remove(arguments2.get(1).asElement());
        Type type2 = result2.type;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateProvideDelegateCallForLocalVariable"));
        }
        return type2;
    }

    @NotNull
    public VariableDescriptor getVariableDescriptorNotNull(@NotNull KtElement declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableDescriptorNotNull"));
        }
        VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VARIABLE, declaration2);
        assert (descriptor2 != null) : "Couldn't find variable declaration in binding context " + declaration2.getText();
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getVariableDescriptorNotNull"));
        }
        return variableDescriptor;
    }

    private void initializePropertyMetadata(@NotNull KtProperty variable2, @NotNull LocalVariableDescriptor variableDescriptor, @NotNull StackValue metadataVar) {
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializePropertyMetadata"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializePropertyMetadata"));
        }
        if (metadataVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadataVar", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "initializePropertyMetadata"));
        }
        StackValue value2 = this.generatePropertyReference(variable2.getDelegate(), variableDescriptor, variableDescriptor, null, null);
        value2.put(AsmTypes.K_PROPERTY0_TYPE, this.v);
        metadataVar.storeSelector(AsmTypes.K_PROPERTY0_TYPE, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression2, @NotNull ResolvedCall<?> resolvedCall2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        Type type2 = this.expressionType(expression2);
        if (type2.getSort() == 9) {
            StackValue stackValue = this.generateNewArray(expression2, this.bindingContext.getType(expression2), resolvedCall2);
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
            }
            return stackValue;
        }
        StackValue stackValue = this.generateConstructorCall(resolvedCall2, type2);
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewCall"));
        }
        return stackValue;
    }

    @NotNull
    public ClassConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getConstructorDescriptor"));
        }
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall2);
        assert (accessibleDescriptor instanceof ClassConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)accessibleDescriptor;
        if (classConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getConstructorDescriptor"));
        }
        return classConstructorDescriptor;
    }

    @Nullable
    private static ReceiverValue getConstructorReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getConstructorReceiver"));
        }
        Object constructor2 = resolvedCall2.getResultingDescriptor();
        if (constructor2.getExtensionReceiverParameter() != null) {
            assert (constructor2 instanceof TypeAliasConstructorDescriptor) : "Only type alias constructor can have an extension receiver: " + constructor2;
            return resolvedCall2.getExtensionReceiver();
        }
        if (constructor2.getDispatchReceiverParameter() != null) {
            return resolvedCall2.getDispatchReceiver();
        }
        return null;
    }

    @NotNull
    public StackValue generateConstructorCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull Type objectType) {
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        if (objectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        StackValue stackValue = StackValue.functionCall(objectType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (objectType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateConstructorCall$26"));
            }
            if (resolvedCall2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateConstructorCall$26"));
            }
            v.anew(objectType);
            v.dup();
            ClassConstructorDescriptor constructor2 = this.getConstructorDescriptor(resolvedCall2);
            ReceiverParameterDescriptor dispatchReceiver = constructor2.getDispatchReceiverParameter();
            ClassDescriptor containingDeclaration = constructor2.getContainingDeclaration();
            if (dispatchReceiver != null) {
                Type receiverType2 = this.typeMapper.mapType(dispatchReceiver.getType());
                ReceiverValue receiver = ExpressionCodegen.getConstructorReceiver(resolvedCall2);
                boolean callSuper = containingDeclaration.isInner() && receiver instanceof ImplicitClassReceiver;
                this.generateReceiverValue(receiver, callSuper).put(receiverType2, (InstructionAdapter)v);
            }
            this.pushClosureOnStack(containingDeclaration, dispatchReceiver == null, this.defaultCallGenerator, null);
            constructor2 = SamCodegenUtil.resolveSamAdapter(constructor2);
            CallableMethod method = this.typeMapper.mapToCallableMethod(constructor2, false);
            this.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateConstructorCall"));
        }
        return stackValue;
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression2, @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateNewArray"));
        }
        List<KtValueArgument> args = expression2.getValueArguments();
        assert (args.size() == 1 || args.size() == 2) : "Unknown constructor called: " + args.size() + " arguments";
        if (args.size() == 1) {
            KtExpression sizeExpression = args.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                if (arrayType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$generateNewArray$27"));
                }
                this.gen(sizeExpression, Type.INT_TYPE);
                this.newArrayInstruction(arrayType);
                return Unit.INSTANCE;
            }));
        }
        return this.invokeFunction(resolvedCall2, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "newArrayInstruction"));
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            this.putReifiedOperationMarkerIfTypeIsReifiedParameter(elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.asmType(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitArrayAccessExpression"));
        }
        KtExpression array = expression2.getArrayExpression();
        KotlinType type2 = array != null ? this.bindingContext.getType(array) : null;
        Type arrayType = this.expressionType(array);
        List<KtExpression> indices = expression2.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType())) {
            Type elementType;
            assert (type2 != null);
            if (KotlinBuiltIns.isArray(type2)) {
                KotlinType jetElementType = type2.getArguments().get(0).getType();
                elementType = AsmUtil.boxType(this.asmType(jetElementType));
            } else {
                elementType = AsmUtil.correctElementType(arrayType);
            }
            StackValue arrayValue = this.genLazy(array, arrayType);
            StackValue index2 = this.genLazy(indices.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression2);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression2);
        boolean isGetter = OperatorNameConventions.GET.equals(operationDescriptor.getName());
        Callable callable2 = this.resolveToCallable(operationDescriptor, false, isGetter ? resolvedGetCall : resolvedSetCall);
        CallableMethod callableMethod = this.resolveToCallableMethod(operationDescriptor, false);
        Object[] argumentTypes = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression2, receiver, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable2);
        Type elementType = isGetter ? callableMethod.getReturnType() : (Type)ArrayUtil.getLastElement((Object[])argumentTypes);
        return StackValue.collectionElement(collectionElementReceiver, elementType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression2, @NotNull StackValue receiver, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable2) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "couldn't find resolved call: " + expression2.getText();
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments2.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments2.remove(valueArguments2.size() - 1);
        }
        StackValue.CollectionElementReceiver collectionElementReceiver = new StackValue.CollectionElementReceiver(callable2, receiver, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments2);
        if (collectionElementReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "createCollectionElementReceiver"));
        }
        return collectionElementReceiver;
    }

    @Override
    public StackValue visitThrowExpression(@NotNull KtThrowExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitThrowExpression"));
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "lambda$visitThrowExpression$28"));
            }
            this.gen(expression2.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
            this.v.athrow();
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitThisExpression"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
        if (descriptor2 instanceof ClassDescriptor) {
            return StackValue.thisOrOuter(this, (ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateExtensionReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2 + expression2.getParent().getContainingFile().getText());
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitTryExpression"));
        }
        return this.generateTryExpression(expression2, false);
    }

    public StackValue generateTryExpression(KtTryExpression expression2, boolean isStatement) {
        Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression2);
        return StackValue.operation(expectedAsmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockStackElement finallyBlockStackElement = null;
            if (finallyBlock != null) {
                finallyBlockStackElement = new FinallyBlockStackElement(expression2);
                this.blockStackElements.push((Object)finallyBlockStackElement);
            }
            Label tryStart = new Label();
            v.mark(tryStart);
            v.nop();
            this.gen(expression2.getTryBlock(), expectedAsmType);
            int savedValue = -1;
            if (!isStatement) {
                savedValue = this.myFrameMap.enterTemp(expectedAsmType);
                v.store(savedValue, expectedAsmType);
            }
            Label tryEnd = new Label();
            v.mark(tryEnd);
            List<Label> tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, tryEnd);
            Label end = new Label();
            this.genFinallyBlockOrGoto(finallyBlockStackElement, end, null);
            List<KtCatchClause> clauses = expression2.getCatchClauses();
            int size = clauses.size();
            for (int i = 0; i < size; ++i) {
                KtCatchClause clause = clauses.get(i);
                Label clauseStart = new Label();
                v.mark(clauseStart);
                KtExpression catchBody = clause.getCatchBody();
                if (catchBody != null) {
                    this.markLineNumber(catchBody, false);
                }
                VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                assert (descriptor2 != null);
                Type descriptorType = this.asmType(descriptor2.getType());
                this.myFrameMap.enter(descriptor2, descriptorType);
                int index2 = this.lookupLocalIndex(descriptor2);
                v.store(index2, descriptorType);
                Label catchVariableStart = new Label();
                v.mark(catchVariableStart);
                this.gen(catchBody, expectedAsmType);
                if (!isStatement) {
                    v.store(savedValue, expectedAsmType);
                }
                this.myFrameMap.leave(descriptor2);
                Label clauseEnd = new Label();
                v.mark(clauseEnd);
                v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, catchVariableStart, clauseEnd, index2);
                this.genFinallyBlockOrGoto(finallyBlockStackElement, (Label)(i != size - 1 || finallyBlock != null ? end : null), null);
                this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
            }
            if (finallyBlock != null) {
                Label defaultCatchStart = new Label();
                v.mark(defaultCatchStart);
                int savedException = this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                Label defaultCatchEnd = new Label();
                v.mark(defaultCatchEnd);
                List<Label> defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, defaultCatchEnd);
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, null);
                v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.athrow();
                this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            if (!isStatement) {
                v.load(savedValue, expectedAsmType);
                this.myFrameMap.leaveTemp(expectedAsmType);
            }
            if (finallyBlock != null) {
                this.blockStackElements.pop();
            }
            return Unit.INSTANCE;
        }));
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        if (catchStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchStart", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExceptionTable"));
        }
        if (catchedRegions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchedRegions", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "generateExceptionTable"));
        }
        for (int i = 0; i < catchedRegions.size(); i += 2) {
            Label startRegion = catchedRegions.get(i);
            Label endRegion = catchedRegions.get(i + 1);
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable FinallyBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        if (blockStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStart", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        ArrayList<Label> arrayList2 = blockRegions;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getCurrentCatchIntervals"));
        }
        return arrayList2;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitBinaryWithTypeRHSExpression"));
        }
        KtExpression left = expression2.getLeft();
        IElementType opToken = expression2.getOperationReference().getReferencedNameElementType();
        KotlinType rightType = this.bindingContext.get(BindingContext.TYPE, expression2.getRight());
        assert (rightType != null);
        StackValue value2 = this.genQualified(receiver, left);
        return StackValue.operation(AsmUtil.boxType(this.asmType(rightType)), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            value2.put(AsmUtil.boxType(value2.type), (InstructionAdapter)v);
            if (value2.type == Type.VOID_TYPE) {
                StackValue.putUnitInstance(v);
            }
            boolean safeAs = opToken == KtTokens.AS_SAFE;
            Type type2 = AsmUtil.boxType(this.asmType(rightType));
            if (TypeUtils.isReifiedTypeParameter(rightType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rightType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                v.checkcast(type2);
                return Unit.INSTANCE;
            }
            CodegenUtilKt.generateAsCast(v, rightType, type2, safeAs);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitIsExpression"));
        }
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression2.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression2.getTypeReference(), expression2.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression subjectExpression, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            Type condType;
            Type subjectType = expressionToMatch.type;
            this.markStartLineNumber(patternExpression);
            KotlinType condJetType = this.bindingContext.getType(patternExpression);
            if (AsmUtil.isNumberPrimitiveOrBoolean(subjectType)) {
                assert (condJetType != null);
                condType = this.asmType(condJetType);
                if (!AsmUtil.isNumberPrimitiveOrBoolean(condType)) {
                    subjectType = AsmUtil.boxType(subjectType);
                }
            } else {
                condType = AsmTypes.OBJECT_TYPE;
            }
            return this.genEqualsForExpressionsPreferIEEE754Arithmetic(subjectExpression, patternExpression, KtTokens.EQEQ, subjectType, condType, expressionToMatch);
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference, boolean negated) {
        KotlinType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        this.markStartLineNumber(typeReference);
        StackValue value2 = this.generateIsCheck(expressionToMatch, jetType, false);
        return negated ? StackValue.not(value2) : value2;
    }

    private StackValue generateIsCheck(StackValue expressionToGen, KotlinType kotlinType, boolean leaveExpressionOnStack) {
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            expressionToGen.put(AsmTypes.OBJECT_TYPE, (InstructionAdapter)v);
            if (leaveExpressionOnStack) {
                v.dup();
            }
            Type type2 = AsmUtil.boxType(this.asmType(kotlinType));
            if (TypeUtils.isReifiedTypeParameter(kotlinType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(kotlinType, ReifiedTypeInliner.OperationKind.IS);
                v.instanceOf(type2);
                return null;
            }
            CodegenUtilKt.generateIsCheck(v, kotlinType, type2);
            return null;
        }));
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        if (operationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationKind", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, operationKind, this.v);
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        if (operationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationKind", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putReifiedOperationMarkerIfTypeIsReifiedParameter"));
        }
        Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2);
        if (typeParameterAndReificationArgument != null && ((TypeParameterDescriptor)typeParameterAndReificationArgument.getFirst()).isReified()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameterAndReificationArgument.getFirst();
            if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
                this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
            }
            v.iconst(operationKind.getId());
            v.visitLdcInsn((Object)((ReificationArgument)typeParameterAndReificationArgument.getSecond()).asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "reifiedOperationMarker", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType(String.class)}), false);
        }
    }

    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages2) {
        if (usages2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "propagateChildReifiedTypeParametersUsages"));
        }
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages2, this.context);
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "visitWhenExpression"));
        }
        return this.generateWhenExpression(expression2, false);
    }

    public StackValue generateWhenExpression(KtWhenExpression expression2, boolean isStatement) {
        KtExpression expr = expression2.getSubjectExpression();
        Type subjectType = this.expressionType(expr);
        Type resultType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression2);
        return StackValue.operation(resultType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            int subjectLocal;
            SwitchCodegen switchCodegen = SwitchCodegenUtil.buildAppropriateSwitchCodegenIfPossible(expression2, isStatement, CodegenUtil.isExhaustive(this.bindingContext, expression2, isStatement), this);
            if (switchCodegen != null) {
                switchCodegen.generate();
                return Unit.INSTANCE;
            }
            int n = subjectLocal = expr != null ? this.myFrameMap.enterTemp(subjectType) : -1;
            if (subjectLocal != -1) {
                this.gen(expr, subjectType);
                this.tempVariables.put(expr, StackValue.local(subjectLocal, subjectType));
                v.store(subjectLocal, subjectType);
            }
            Label end = new Label();
            boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression2);
            Label nextCondition = null;
            for (KtWhenEntry whenEntry : expression2.getEntries()) {
                if (nextCondition != null) {
                    v.mark(nextCondition);
                }
                nextCondition = new Label();
                FrameMap.Mark mark = this.myFrameMap.mark();
                Label thisEntry = new Label();
                if (!whenEntry.isElse()) {
                    KtWhenCondition[] conditions2 = whenEntry.getConditions();
                    for (int i = 0; i < conditions2.length; ++i) {
                        StackValue conditionValue = this.generateWhenCondition(expr, subjectType, subjectLocal, conditions2[i]);
                        BranchedValue.Companion.condJump(conditionValue, nextCondition, true, (InstructionAdapter)v);
                        if (i >= conditions2.length - 1) continue;
                        v.goTo(thisEntry);
                        v.mark(nextCondition);
                        nextCondition = new Label();
                    }
                }
                v.visitLabel(thisEntry);
                this.gen(whenEntry.getExpression(), resultType);
                mark.dropTo();
                if (whenEntry.isElse()) continue;
                v.goTo(end);
            }
            if (!hasElse && nextCondition != null) {
                v.mark(nextCondition);
                this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression2, isStatement);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            this.myFrameMap.leaveTemp(subjectType);
            this.tempVariables.remove(expr);
            return null;
        }));
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression2, boolean isStatement) {
        if (whenExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "putUnitInstanceOntoStackForNonExhaustiveWhen"));
        }
        if (CodegenUtil.isExhaustive(this.bindingContext, whenExpression2, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(KtExpression subjectExpression, Type subjectType, int subjectLocal, KtWhenCondition condition2) {
        StackValue.Local match2;
        if (condition2 instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition2;
            return this.generateIn(StackValue.local(subjectLocal, subjectType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType);
        if (condition2 instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition2;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition2 instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition2).getExpression();
            return this.generateExpressionMatch(match2, subjectExpression, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    public Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @NotNull
    public FrameMap getFrameMap() {
        FrameMap frameMap = this.myFrameMap;
        if (frameMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getFrameMap"));
        }
        return frameMap;
    }

    @NotNull
    public MethodContext getContext() {
        MethodContext methodContext = this.context;
        if (methodContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getContext"));
        }
        return methodContext;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator2 = this.getParentCodegen().getInlineNameGenerator();
        Name name2 = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        String inlinedName = name2.isSpecial() ? "$special" : name2.asString();
        NameGenerator nameGenerator3 = nameGenerator2.subGenerator(inlinedName + "$$inlined");
        if (nameGenerator3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "getInlineNameGenerator"));
        }
        return nameGenerator3;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack(this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements2, int finallyDepth) {
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "addBlockStackElementsForNonLocalReturns"));
        }
        this.blockStackElements.addAll(elements2);
        this.finallyDepth = finallyDepth;
    }

    @NotNull
    private StackValue.Delegate delegatedVariableValue(@NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (delegateValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateValue", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "delegatedVariableValue"));
        }
        if (metadataValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadataValue", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "delegatedVariableValue"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "delegatedVariableValue"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "delegatedVariableValue"));
        }
        StackValue.Delegate delegate2 = StackValue.delegate(typeMapper.mapType(variableDescriptor.getType()), delegateValue, metadataValue, variableDescriptor, this);
        if (delegate2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ExpressionCodegen", "delegatedVariableValue"));
        }
        return delegate2;
    }

    private static class NonLocalReturnInfo {
        private final Type returnType;
        private final String labelName;

        private NonLocalReturnInfo(@NotNull Type type2, @NotNull String name2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/ExpressionCodegen$NonLocalReturnInfo", "<init>"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/ExpressionCodegen$NonLocalReturnInfo", "<init>"));
            }
            this.returnType = type2;
            this.labelName = name2;
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ObjectLiteralResult", "<init>"));
            }
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor;
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();
        final KtTryExpression expression;

        FinallyBlockStackElement(KtTryExpression expression2) {
            this.expression = expression2;
        }

        private void addGapLabel(Label label2) {
            this.gaps.add(label2);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

