/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.MultifileClassPartCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.SuspendFunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.inline.CallSiteMarker;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.DefaultProcessor;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.FictitiousArrayConstructor;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.InlineCacheKt;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineOnlySmapSkipper;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InliningContext;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.MethodId;
import org.jetbrains.kotlin.codegen.inline.MethodInliner;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.PropertyReferenceInfo;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicArrayConstructorsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class InlineCodegen
extends CallGenerator {
    private final GenerationState state;
    private final KotlinTypeMapper typeMapper;
    private final FunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final KtElement callElement;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    private final ParametersBuilder invocationParamBuilder;
    private final Map<Integer, LambdaInfo> expressionMap;
    private final ReifiedTypeInliner reifiedTypeInliner;
    @Nullable
    private final TypeParameterMappings typeParameterMappings;
    private LambdaInfo activeLambda;
    private final SourceMapper sourceMapper;
    private Runnable delayedHiddenWriting;
    private List<Integer> maskValues;
    private int maskStartIndex;
    private int methodHandleInDefaultMethodIndex;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state, @NotNull FunctionDescriptor function2, @NotNull KtElement callElement2, @Nullable TypeParameterMappings typeParameterMappings) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (callElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        this.invocationParamBuilder = ParametersBuilder.newBuilder();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        this.maskValues = new ArrayList<Integer>();
        this.maskStartIndex = -1;
        this.methodHandleInDefaultMethodIndex = -1;
        assert (InlineUtil.isInline(function2) || InlineUtil.isArrayConstructorWithLambda(function2)) : "InlineCodegen can inline only inline functions and array constructors: " + function2;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.codegen = codegen;
        this.callElement = callElement2;
        this.functionDescriptor = InlineUtil.isArrayConstructorWithLambda(function2) ? FictitiousArrayConstructor.create((ConstructorDescriptor)function2) : function2.getOriginal();
        this.typeParameterMappings = typeParameterMappings;
        this.reifiedTypeInliner = new ReifiedTypeInliner(typeParameterMappings);
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(this.functionDescriptor);
        this.context = (MethodContext)InlineCodegen.getContext(this.functionDescriptor, state, element2 != null ? (KtFile)element2.getContainingFile() : null);
        this.jvmSignature = this.typeMapper.mapSignatureWithGeneric(this.functionDescriptor, this.context.getContextKind());
        this.asFunctionInline = false;
        this.isSameModule = JvmCodegenUtil.isCallInsideSameModuleAsDeclared(this.functionDescriptor, codegen.getContext(), state.getOutDirectory());
        this.sourceMapper = codegen.getParentCodegen().getOrCreateSourceMapper();
        if (!(this.functionDescriptor instanceof FictitiousArrayConstructor)) {
            MemberScope scope2;
            InlineCodegen.reportIncrementalInfo(this.functionDescriptor, codegen.getContext().getFunctionDescriptor().getOriginal(), this.jvmSignature, state);
            String functionOrAccessorName = this.typeMapper.mapAsmMethod(function2).getName();
            if (!functionOrAccessorName.equals(this.functionDescriptor.getName().asString()) && (scope2 = InlineCodegen.getMemberScope(this.functionDescriptor)) != null) {
                scope2.getContributedFunctions(Name.identifier(functionOrAccessorName), new KotlinLookupLocation(callElement2));
            }
        }
    }

    @Nullable
    private static MemberScope getMemberScope(@NotNull FunctionDescriptor functionOrAccessor) {
        if (functionOrAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrAccessor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getMemberScope"));
        }
        CallableMemberDescriptor callableMemberDescriptor = JvmCodegenUtil.getDirectMember(functionOrAccessor);
        DeclarationDescriptor classOrPackageFragment = callableMemberDescriptor.getContainingDeclaration();
        if (classOrPackageFragment instanceof ClassDescriptor) {
            return ((ClassDescriptor)classOrPackageFragment).getUnsubstitutedMemberScope();
        }
        if (classOrPackageFragment instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)classOrPackageFragment).getMemberScope();
        }
        return null;
    }

    @Override
    public void genCallInner(@NotNull Callable callableMethod, @Nullable ResolvedCall<?> resolvedCall2, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        if (!this.state.getInlineCycleReporter().enterIntoInlining(resolvedCall2)) {
            this.generateStub(resolvedCall2, codegen);
            return;
        }
        SMAPAndMethodNode nodeAndSmap = null;
        try {
            nodeAndSmap = InlineCodegen.createMethodNode(this.functionDescriptor, this.jvmSignature, codegen, this.context, callDefault, resolvedCall2);
            this.endCall(this.inlineCall(nodeAndSmap, callDefault));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (InlineException e) {
            throw this.throwCompilationException(nodeAndSmap, e, false);
        }
        catch (Exception e) {
            throw this.throwCompilationException(nodeAndSmap, e, true);
        }
        finally {
            this.state.getInlineCycleReporter().exitFromInliningOf(resolvedCall2);
        }
    }

    @NotNull
    private CompilationException throwCompilationException(@Nullable SMAPAndMethodNode nodeAndSmap, @NotNull Exception e, boolean generateNodeText) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "throwCompilationException"));
        }
        CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.codegen.getContext().getContextDescriptor();
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(contextDescriptor);
        MethodNode node = nodeAndSmap != null ? nodeAndSmap.getNode() : null;
        throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into\n" + DescriptorRenderer.DEBUG_TEXT.render(contextDescriptor) + "\n" + (element2 != null ? element2.getText() : "<no source>") + (generateNodeText ? "\nCause: " + InlineCodegenUtil.getNodeText(node) : ""), e, (PsiElement)this.callElement);
    }

    private void generateStub(@Nullable ResolvedCall<?> resolvedCall2, @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateStub"));
        }
        this.leaveTemps();
        assert (resolvedCall2 != null);
        String message2 = "Call is part of inline cycle: " + resolvedCall2.getCall().getCallElement().getText();
        AsmUtil.genThrow(codegen.v, "java/lang/UnsupportedOperationException", message2);
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "endCall"));
        }
        this.leaveTemps();
        this.codegen.propagateChildReifiedTypeParametersUsages(result2.getReifiedTypeParametersUsages());
        this.state.getFactory().removeClasses(result2.calcClassesToRemove());
        this.codegen.markLineNumberAfterInlineIfNeeded();
    }

    @NotNull
    static SMAPAndMethodNode createMethodNode(@NotNull FunctionDescriptor functionDescriptor2, @NotNull JvmMethodSignature jvmSignature, @NotNull ExpressionCodegen codegen, @NotNull CodegenContext context, boolean callDefault, @Nullable ResolvedCall<?> resolvedCall2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        if (InlineCodegenUtil.isSpecialEnumMethod(functionDescriptor2)) {
            assert (resolvedCall2 != null) : "Resolved call for " + functionDescriptor2 + " should be not null";
            Map<TypeParameterDescriptor, KotlinType> arguments2 = resolvedCall2.getTypeArguments();
            assert (arguments2.size() == 1) : "Resolved call for " + functionDescriptor2 + " should have 1 type argument";
            MethodNode node = InlineCodegenUtil.createSpecialEnumMethodBody(codegen, functionDescriptor2.getName().asString(), arguments2.keySet().iterator().next().getDefaultType(), codegen.getState().getTypeMapper());
            SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(node, SMAPParser.parseOrCreateDefault(null, null, "fake", -1, -1));
            if (sMAPAndMethodNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
            }
            return sMAPAndMethodNode;
        }
        if (CoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturnInJvm(functionDescriptor2)) {
            SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(CoroutineCodegenUtilKt.createMethodNodeForSuspendCoroutineOrReturn(functionDescriptor2, codegen.getState().getTypeMapper()), SMAPParser.parseOrCreateDefault(null, null, "fake", -1, -1));
            if (sMAPAndMethodNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
            }
            return sMAPAndMethodNode;
        }
        GenerationState state = codegen.getState();
        Method asmMethod = callDefault ? state.getTypeMapper().mapDefaultMethod(functionDescriptor2, context.getContextKind()) : jvmSignature.getAsmMethod();
        MethodId methodId = new MethodId(DescriptorUtils.getFqNameSafe(functionDescriptor2.getContainingDeclaration()), asmMethod);
        CallableMemberDescriptor directMember = InlineCodegen.getDirectMemberAndCallableFromObject(functionDescriptor2);
        if (!InlineCodegen.isBuiltInArrayIntrinsic(functionDescriptor2) && !(directMember instanceof DeserializedCallableMemberDescriptor)) {
            SMAPAndMethodNode sMAPAndMethodNode = InlineCodegen.doCreateMethodNodeFromSource(functionDescriptor2, jvmSignature, codegen, context, callDefault, state, asmMethod);
            if (sMAPAndMethodNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
            }
            return sMAPAndMethodNode;
        }
        SMAPAndMethodNode resultInCache = InlineCacheKt.getOrPut(state.getInlineCache().getMethodNodeById(), methodId, () -> {
            if (functionDescriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "lambda$createMethodNode$0"));
            }
            SMAPAndMethodNode result2 = InlineCodegen.doCreateMethodNodeFromCompiled(directMember, state, asmMethod);
            if (result2 == null) {
                throw new IllegalStateException("Couldn't obtain compiled function body for " + functionDescriptor2);
            }
            return result2;
        });
        SMAPAndMethodNode sMAPAndMethodNode = resultInCache.copyWithNewNode(InlineCodegen.cloneMethodNode(resultInCache.getNode()));
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        return sMAPAndMethodNode;
    }

    @NotNull
    private static CallableMemberDescriptor getDirectMemberAndCallableFromObject(@NotNull FunctionDescriptor functionDescriptor2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDirectMemberAndCallableFromObject"));
        }
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(functionDescriptor2);
        if (directMember instanceof ImportedFromObjectCallableDescriptor) {
            Object TCallable = ((ImportedFromObjectCallableDescriptor)((Object)directMember)).getCallableFromObject();
            if (TCallable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDirectMemberAndCallableFromObject"));
            }
            return TCallable;
        }
        CallableMemberDescriptor callableMemberDescriptor = directMember;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDirectMemberAndCallableFromObject"));
        }
        return callableMemberDescriptor;
    }

    @NotNull
    private static MethodNode cloneMethodNode(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "cloneMethodNode"));
        }
        methodNode.instructions.resetLabels();
        MethodNode result2 = new MethodNode(327680, methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, ArrayUtil.toStringArray((Collection)methodNode.exceptions));
        methodNode.accept((MethodVisitor)result2);
        MethodNode methodNode2 = result2;
        if (methodNode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "cloneMethodNode"));
        }
        return methodNode2;
    }

    @Nullable
    private static SMAPAndMethodNode doCreateMethodNodeFromCompiled(@NotNull CallableMemberDescriptor callableDescriptor, @NotNull GenerationState state, @NotNull Method asmMethod) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromCompiled"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromCompiled"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromCompiled"));
        }
        if (InlineCodegen.isBuiltInArrayIntrinsic(callableDescriptor)) {
            ClassId classId = IntrinsicArrayConstructorsKt.getClassId();
            byte[] bytes2 = InlineCacheKt.getOrPut(state.getInlineCache().getClassBytes(), classId, IntrinsicArrayConstructorsKt::getBytecode);
            return InlineCodegenUtil.getMethodNode(bytes2, asmMethod.getName(), asmMethod.getDescriptor(), classId);
        }
        assert (callableDescriptor instanceof DeserializedCallableMemberDescriptor) : "Not a deserialized function or proper: " + callableDescriptor;
        KotlinTypeMapper.ContainingClassesInfo containingClasses = state.getTypeMapper().getContainingClassesForDeserializedCallable((DeserializedCallableMemberDescriptor)callableDescriptor);
        ClassId containerId = containingClasses.getImplClassId();
        byte[] bytes3 = InlineCacheKt.getOrPut(state.getInlineCache().getClassBytes(), containerId, () -> {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "lambda$doCreateMethodNodeFromCompiled$1"));
            }
            VirtualFile file2 = InlineCodegenUtil.findVirtualFile(state, containerId);
            if (file2 == null) {
                throw new IllegalStateException("Couldn't find declaration file for " + containerId);
            }
            try {
                return file2.contentsToByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return InlineCodegenUtil.getMethodNode(bytes3, asmMethod.getName(), asmMethod.getDescriptor(), containerId);
    }

    @NotNull
    private static SMAPAndMethodNode doCreateMethodNodeFromSource(@NotNull FunctionDescriptor callableDescriptor, @NotNull JvmMethodSignature jvmSignature, @NotNull ExpressionCodegen codegen, @NotNull CodegenContext context, boolean callDefault, @NotNull GenerationState state, @NotNull Method asmMethod) {
        SMAP smap;
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(callableDescriptor);
        if (!(element2 instanceof KtNamedFunction) && !(element2 instanceof KtPropertyAccessor)) {
            throw new IllegalStateException("Couldn't find declaration for function " + callableDescriptor);
        }
        KtDeclarationWithBody inliningFunction = (KtDeclarationWithBody)element2;
        MethodNode node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(callableDescriptor, context.getContextKind(), state) | (callDefault ? 8 : 0), asmMethod.getName(), asmMethod.getDescriptor(), null, null);
        MethodVisitor maxCalcAdapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
        CodegenContext parentContext = context.getParentContext();
        assert (parentContext != null) : "Context has no parent: " + context;
        MethodContext methodContext = parentContext.intoFunction(callableDescriptor);
        if (callDefault) {
            Type implementationOwner = state.getTypeMapper().mapImplementationOwner(callableDescriptor);
            FakeMemberCodegen parentCodegen = new FakeMemberCodegen(codegen.getParentCodegen(), inliningFunction, (FieldOwnerContext)methodContext.getParentContext(), implementationOwner.getInternalName());
            if (!(element2 instanceof KtNamedFunction)) {
                throw new IllegalStateException("Property accessors with default parameters not supported " + callableDescriptor);
            }
            FunctionCodegen.generateDefaultImplBody(methodContext, callableDescriptor, maxCalcAdapter, DefaultParameterValueLoader.DEFAULT, (KtNamedFunction)inliningFunction, parentCodegen, asmMethod);
            smap = InlineCodegen.createSMAPWithDefaultMapping(inliningFunction, parentCodegen.getOrCreateSourceMapper().getResultMappings());
        } else {
            smap = InlineCodegen.generateMethodBody(maxCalcAdapter, callableDescriptor, methodContext, inliningFunction, jvmSignature, codegen, null);
        }
        maxCalcAdapter.visitMaxs(-1, -1);
        maxCalcAdapter.visitEnd();
        SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(node, smap);
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "doCreateMethodNodeFromSource"));
        }
        return sMAPAndMethodNode;
    }

    private static boolean isBuiltInArrayIntrinsic(@NotNull CallableMemberDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "isBuiltInArrayIntrinsic"));
        }
        if (callableDescriptor instanceof FictitiousArrayConstructor) {
            return true;
        }
        String name2 = callableDescriptor.getName().asString();
        return (name2.equals("arrayOf") || name2.equals("emptyArray")) && callableDescriptor.getContainingDeclaration() instanceof BuiltInsPackageFragment;
    }

    @NotNull
    private InlineResult inlineCall(@NotNull SMAPAndMethodNode nodeAndSmap, boolean callDefault) {
        if (nodeAndSmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeAndSmap", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "inlineCall"));
        }
        assert (this.delayedHiddenWriting == null) : "'putHiddenParamsIntoLocals' should be called after 'processAndPutHiddenParameters(true)'";
        DefaultSourceMapper defaultSourceMapper = this.codegen.getParentCodegen().getOrCreateSourceMapper();
        defaultSourceMapper.setCallSiteMarker(new CallSiteMarker(this.codegen.getLastLineNumber()));
        MethodNode node = nodeAndSmap.getNode();
        if (callDefault) {
            MethodInlinerUtilKt.expandMaskConditionsAndUpdateVariableNodes(node, this.maskStartIndex, this.maskValues, this.methodHandleInDefaultMethodIndex);
        }
        ReifiedTypeParametersUsages reificationResult = this.reifiedTypeInliner.reifyInstructions(node);
        this.generateClosuresBodies();
        this.putClosureParametersOnStack();
        InlineCodegenUtil.addInlineMarker(this.codegen.v, true);
        Parameters parameters2 = this.invocationParamBuilder.buildParameters();
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.jvmSignature.getAsmMethod().getName()), this.callElement, this.getInlineCallSiteInfo(), this.reifiedTypeInliner, this.typeParameterMappings);
        MethodInliner inliner = new MethodInliner(node, parameters2, info, new FieldRemapper(null, null, parameters2), this.isSameModule, "Method inlining " + this.callElement.getText(), InlineCodegen.createNestedSourceMapper(nodeAndSmap, this.sourceMapper), ((InliningContext)info).getCallSiteInfo(), AnnotationUtilKt.isInlineOnly(this.functionDescriptor) ? new InlineOnlySmapSkipper(this.codegen) : null);
        LocalVarRemapper remapper = new LocalVarRemapper(parameters2, this.initialFrameSize);
        MethodNode adapter = InlineCodegenUtil.createEmptyMethodNode();
        adapter.visitInsn(0);
        InlineResult result2 = inliner.doInline((MethodVisitor)adapter, remapper, true, LabelOwner.SKIP_ALL);
        result2.getReifiedTypeParametersUsages().mergeAll(reificationResult);
        CallableMemberDescriptor descriptor2 = InlineCodegen.getLabelOwnerDescriptor(this.codegen.getContext());
        Set<String> labels = InlineCodegen.getDeclarationLabels(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2), descriptor2);
        List<MethodInliner.PointForExternalFinallyBlocks> infos = MethodInliner.processReturns(adapter, labels::contains, true, null);
        this.generateAndInsertFinallyBlocks(adapter, infos, ((StackValue.Local)remapper.remap((int)(parameters2.getArgsSizeOnStack() + 1)).value).index);
        InlineCodegen.removeStaticInitializationTrigger(adapter);
        if (!InlineCodegenUtil.isFinallyMarkerRequired(this.codegen.getContext())) {
            InlineCodegenUtil.removeFinallyMarkers(adapter);
        }
        adapter.accept((MethodVisitor)new MethodBodyVisitor((MethodVisitor)this.codegen.v));
        InlineCodegenUtil.addInlineMarker(this.codegen.v, false);
        defaultSourceMapper.setCallSiteMarker(null);
        InlineResult inlineResult = result2;
        if (inlineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "inlineCall"));
        }
        return inlineResult;
    }

    @NotNull
    private static CallableMemberDescriptor getLabelOwnerDescriptor(@NotNull MethodContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getLabelOwnerDescriptor"));
        }
        if (context.getParentContext() instanceof ClosureContext && ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor() != null) {
            FunctionDescriptor functionDescriptor2 = ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
            if (functionDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getLabelOwnerDescriptor"));
            }
            return functionDescriptor2;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)context.getContextDescriptor();
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getLabelOwnerDescriptor"));
        }
        return callableMemberDescriptor;
    }

    private static void removeStaticInitializationTrigger(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "removeStaticInitializationTrigger"));
        }
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode insn = insnList.getFirst();
        while (insn != null) {
            if (MultifileClassPartCodegen.isStaticInitTrigger(insn)) {
                AbstractInsnNode clinitTriggerCall = insn;
                insn = insn.getNext();
                insnList.remove(clinitTriggerCall);
                continue;
            }
            insn = insn.getNext();
        }
    }

    @NotNull
    private InlineCallSiteInfo getInlineCallSiteInfo() {
        MethodContext context = this.codegen.getContext();
        MemberCodegen parentCodegen = this.codegen.getParentCodegen();
        while (context instanceof InlineLambdaContext) {
            CodegenContext closureContext = context.getParentContext();
            assert (closureContext instanceof ClosureContext) : "Parent context of inline lambda should be closure context";
            assert (closureContext.getParentContext() instanceof MethodContext) : "Closure context should appear in method context";
            context = (MethodContext)closureContext.getParentContext();
            assert (parentCodegen instanceof FakeMemberCodegen) : "Parent codegen of inlined lambda should be FakeMemberCodegen";
            parentCodegen = ((FakeMemberCodegen)parentCodegen).delegate;
        }
        JvmMethodSignature signature = this.typeMapper.mapSignatureSkipGeneric(context.getFunctionDescriptor(), context.getContextKind());
        InlineCallSiteInfo inlineCallSiteInfo = new InlineCallSiteInfo(parentCodegen.getClassName(), signature.getAsmMethod().getName(), signature.getAsmMethod().getDescriptor());
        if (inlineCallSiteInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getInlineCallSiteInfo"));
        }
        return inlineCallSiteInfo;
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    @NotNull
    private SMAPAndMethodNode generateLambdaBody(@NotNull LambdaInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateLambdaBody"));
        }
        KtExpression declaration2 = info.getFunctionWithBodyOrCallableReference();
        FunctionDescriptor descriptor2 = info.getFunctionDescriptor();
        ClassContext closureContext = info.isPropertyReference() ? this.codegen.getContext().intoAnonymousClass(info.getClassDescriptor(), this.codegen, OwnerKind.IMPLEMENTATION) : this.codegen.getContext().intoClosure(descriptor2, this.codegen, this.typeMapper);
        MethodContext context = closureContext.intoInlinedLambda(descriptor2, info.isCrossInline, info.isPropertyReference());
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignatureSkipGeneric(descriptor2);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor2, context.getContextKind(), this.state), asmMethod.getName(), asmMethod.getDescriptor(), null, null);
        MethodVisitor adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        SMAP smap = InlineCodegen.generateMethodBody(adapter, descriptor2, context, declaration2, jvmMethodSignature, this.codegen, info);
        adapter.visitMaxs(-1, -1);
        SMAPAndMethodNode sMAPAndMethodNode = new SMAPAndMethodNode(methodNode, smap);
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateLambdaBody"));
        }
        return sMAPAndMethodNode;
    }

    @NotNull
    private static SMAP generateMethodBody(@NotNull MethodVisitor adapter, @NotNull FunctionDescriptor descriptor2, @NotNull MethodContext context, @NotNull KtExpression expression2, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull ExpressionCodegen codegen, @Nullable LambdaInfo lambdaInfo) {
        FunctionGenerationStrategy.CodegenBased strategy;
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        boolean isLambda = lambdaInfo != null;
        GenerationState state = codegen.getState();
        FakeMemberCodegen parentCodegen = new FakeMemberCodegen(codegen.getParentCodegen(), expression2, (FieldOwnerContext)context.getParentContext(), isLambda ? codegen.getParentCodegen().getClassName() : state.getTypeMapper().mapImplementationOwner(descriptor2).getInternalName());
        if (expression2 instanceof KtCallableReferenceExpression) {
            Type receiverType2;
            KtCallableReferenceExpression callableReferenceExpression = (KtCallableReferenceExpression)expression2;
            KtExpression receiverExpression = callableReferenceExpression.getReceiverExpression();
            Type type2 = receiverType2 = receiverExpression != null && codegen.getBindingContext().getType(receiverExpression) != null ? codegen.getState().getTypeMapper().mapType(codegen.getBindingContext().getType(receiverExpression)) : null;
            if (isLambda && lambdaInfo.isPropertyReference()) {
                Type asmType = state.getTypeMapper().mapClass(lambdaInfo.getClassDescriptor());
                PropertyReferenceInfo info = lambdaInfo.getPropertyReferenceInfo();
                strategy = new PropertyReferenceCodegen.PropertyReferenceGenerationStrategy(true, info.getGetFunction(), info.getTarget(), asmType, receiverType2, lambdaInfo.expression, state, true);
            } else {
                strategy = new FunctionReferenceGenerationStrategy(state, descriptor2, CallUtilKt.getResolvedCallWithAssert(callableReferenceExpression.getCallableReference(), codegen.getBindingContext()), receiverType2, null, true);
            }
        } else {
            strategy = expression2 instanceof KtFunctionLiteral ? new ClosureGenerationStrategy(state, (KtDeclarationWithBody)expression2) : (descriptor2.isSuspend() && expression2 instanceof KtFunction ? new SuspendFunctionGenerationStrategy(state, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2), (KtFunction)expression2) : new FunctionGenerationStrategy.FunctionDefault(state, (KtDeclarationWithBody)expression2));
        }
        FunctionCodegen.generateMethodBody(adapter, descriptor2, context, jvmMethodSignature, strategy, parentCodegen);
        if (isLambda) {
            codegen.propagateChildReifiedTypeParametersUsages(parentCodegen.getReifiedTypeParametersUsages());
        }
        SMAP sMAP = InlineCodegen.createSMAPWithDefaultMapping(expression2, parentCodegen.getOrCreateSourceMapper().getResultMappings());
        if (sMAP == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        return sMAP;
    }

    private static SMAP createSMAPWithDefaultMapping(@NotNull KtExpression declaration2, @NotNull List<FileMapping> mappings) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        PsiFile containingFile = declaration2.getContainingFile();
        Integer lineNumbers = CodegenUtil.getLineNumberForElement((PsiElement)containingFile, true);
        assert (lineNumbers != null) : "Couldn't extract line count in " + containingFile;
        return new SMAP(mappings);
    }

    private void putArgumentOrCapturedToLocalVal(@NotNull Type type2, @NotNull StackValue stackValue, int capturedParamIndex, int parameterIndex2, @NotNull ValueKind kind2) {
        boolean isDefaultParameter;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putArgumentOrCapturedToLocalVal"));
        }
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putArgumentOrCapturedToLocalVal"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putArgumentOrCapturedToLocalVal"));
        }
        boolean bl = isDefaultParameter = kind2 == ValueKind.DEFAULT_PARAMETER;
        if (!isDefaultParameter && InlineCodegen.shouldPutGeneralValue(type2, stackValue)) {
            stackValue.put(type2, this.codegen.v);
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type2) {
            ParameterInfo info;
            StackValue remappedValue;
            boolean couldBeRemapped = !InlineCodegen.shouldPutGeneralValue(type2, stackValue) && kind2 != ValueKind.DEFAULT_PARAMETER;
            StackValue stackValue2 = remappedValue = couldBeRemapped ? stackValue : null;
            if (capturedParamIndex >= 0) {
                CapturedParamDesc capturedParamInfoInLambda = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                info = this.invocationParamBuilder.addCapturedParam(capturedParamInfoInLambda, capturedParamInfoInLambda.getFieldName(), false);
                info.setRemapValue(remappedValue);
            } else {
                info = this.invocationParamBuilder.addNextValueParameter(type2, false, remappedValue, parameterIndex2);
            }
            this.recordParameterValueInLocalVal(false, isDefaultParameter, info);
        }
    }

    private static boolean shouldPutGeneralValue(@NotNull Type type2, @NotNull StackValue stackValue) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "shouldPutGeneralValue"));
        }
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "shouldPutGeneralValue"));
        }
        if (AsmUtil.isPrimitive(type2) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        StackValue field2 = stackValue;
        if (stackValue instanceof StackValue.FieldForSharedVar) {
            field2 = ((StackValue.FieldForSharedVar)stackValue).receiver;
        }
        if (field2 instanceof StackValue.Field) {
            DeclarationDescriptor varDescriptor = ((StackValue.Field)field2).descriptor;
            return !(varDescriptor instanceof ParameterDescriptor) || !InlineUtil.isInlineLambdaParameter((ParameterDescriptor)varDescriptor) || !InlineUtil.isInline(varDescriptor.getContainingDeclaration());
        }
        return true;
    }

    private Runnable recordParameterValueInLocalVal(boolean delayedWritingToLocals, boolean skipStore, ParameterInfo ... infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "recordParameterValueInLocalVal"));
        }
        int[] index2 = new int[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            ParameterInfo info = infos[i];
            index2[i] = !info.isSkippedOrRemapped() ? this.codegen.getFrameMap().enterTemp(info.getType()) : -1;
        }
        Runnable runnable = () -> {
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "lambda$recordParameterValueInLocalVal$2"));
            }
            for (int i = infos.length - 1; i >= 0; --i) {
                ParameterInfo info = infos[i];
                if (info.isSkippedOrRemapped()) continue;
                Type type2 = info.type;
                StackValue.Local local = StackValue.local(index2[i], type2);
                if (!skipStore) {
                    local.store(StackValue.onStack(type2), this.codegen.v);
                }
                if (!(info instanceof CapturedParamInfo)) continue;
                info.setRemapValue(local);
                ((CapturedParamInfo)info).setSynthetic(true);
            }
        };
        if (delayedWritingToLocals) {
            return runnable;
        }
        runnable.run();
        return null;
    }

    @Override
    public void processAndPutHiddenParameters(boolean justProcess) {
        if ((AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind(), this.state) & 8) == 0) {
            this.invocationParamBuilder.addNextParameter(AsmTypes.OBJECT_TYPE, false);
        }
        for (JvmMethodParameterSignature param : this.jvmSignature.getValueParameters()) {
            if (param.getKind() == JvmMethodParameterKind.VALUE) break;
            this.invocationParamBuilder.addNextParameter(param.getAsmType(), false);
        }
        this.invocationParamBuilder.markValueParametersStart();
        List<ParameterInfo> hiddenParameters = this.invocationParamBuilder.buildParameters().getParameters();
        this.delayedHiddenWriting = this.recordParameterValueInLocalVal(justProcess, false, hiddenParameters.toArray(new ParameterInfo[hiddenParameters.size()]));
    }

    private void leaveTemps() {
        List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
        ListIterator<ParameterInfo> iterator2 = infos.listIterator(infos.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped() && !CapturedParamInfo.isSynthetic(param)) continue;
            this.codegen.getFrameMap().leaveTemp(param.type);
        }
    }

    private static boolean isInliningParameter(@NotNull KtExpression expression2, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "isInliningParameter"));
        }
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "isInliningParameter"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        return InlineUtil.isInlineLambdaParameter(valueParameterDescriptor) && InlineCodegen.isInlinableParameterExpression(deparenthesized);
    }

    private static boolean isInlinableParameterExpression(@Nullable KtExpression deparenthesized) {
        return deparenthesized instanceof KtLambdaExpression || deparenthesized instanceof KtNamedFunction || deparenthesized instanceof KtCallableReferenceExpression;
    }

    private LambdaInfo rememberClosure(@NotNull KtExpression expression2, @NotNull Type type2, @NotNull ValueParameterDescriptor parameter) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "rememberClosure"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "rememberClosure"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "rememberClosure"));
        }
        KtExpression lambda2 = KtPsiUtil.deparenthesize(expression2);
        assert (InlineCodegen.isInlinableParameterExpression(lambda2)) : "Couldn't find inline expression in " + expression2.getText();
        LambdaInfo info = new LambdaInfo(lambda2, this.typeMapper, parameter.isCrossinline(), this.getBoundCallableReferenceReceiver(expression2) != null);
        ParameterInfo closureInfo = this.invocationParamBuilder.addNextValueParameter(type2, true, null, parameter.getIndex());
        closureInfo.setLambda(info);
        this.expressionMap.put(closureInfo.getIndex(), info);
        return info;
    }

    @NotNull
    public static Set<String> getDeclarationLabels(@Nullable PsiElement lambdaOrFun, @NotNull DeclarationDescriptor descriptor2) {
        Name label2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDeclarationLabels"));
        }
        HashSet<String> result2 = new HashSet<String>();
        if (lambdaOrFun != null && (label2 = LabelResolver.INSTANCE.getLabelNameIfAny(lambdaOrFun)) != null) {
            result2.add(label2.asString());
        }
        if (!ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            if (!descriptor2.getName().isSpecial()) {
                result2.add(descriptor2.getName().asString());
            }
            result2.add("$$$$$ROOT$$$$$");
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDeclarationLabels"));
        }
        return hashSet;
    }

    private void putClosureParametersOnStack() {
        for (LambdaInfo next2 : this.expressionMap.values()) {
            if (next2.isBoundCallableReference()) continue;
            this.putClosureParametersOnStack(next2, null);
        }
    }

    private void putClosureParametersOnStack(@NotNull LambdaInfo next2, @Nullable StackValue functionReferenceReceiver) {
        if (next2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putClosureParametersOnStack"));
        }
        this.activeLambda = next2;
        this.codegen.pushClosureOnStack(next2.getClassDescriptor(), true, this, functionReferenceReceiver);
        this.activeLambda = null;
    }

    @NotNull
    public static CodegenContext getContext(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state, @Nullable KtFile sourceFile) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            PackageContext packageContext = new PackageContext((PackageFragmentDescriptor)descriptor2, state.getRootContext(), null, sourceFile);
            if (packageContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
            }
            return packageContext;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        assert (container2 != null) : "No container for descriptor: " + descriptor2;
        CodegenContext parent2 = InlineCodegen.getContext(container2, state, sourceFile);
        if (descriptor2 instanceof ScriptDescriptor) {
            List<ScriptDescriptor> earlierScripts = state.getReplSpecific().getEarlierScriptsForReplInterpreter();
            ScriptContext scriptContext = parent2.intoScript((ScriptDescriptor)descriptor2, earlierScripts == null ? Collections.emptyList() : earlierScripts, (ClassDescriptor)descriptor2, state.getTypeMapper());
            if (scriptContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
            }
            return scriptContext;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            OwnerKind kind2 = DescriptorUtils.isInterface(descriptor2) ? OwnerKind.DEFAULT_IMPLS : OwnerKind.IMPLEMENTATION;
            ClassContext classContext = parent2.intoClass((ClassDescriptor)descriptor2, kind2, state);
            if (classContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
            }
            return classContext;
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            MethodContext methodContext = parent2.intoFunction((FunctionDescriptor)descriptor2);
            if (methodContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getContext"));
            }
            return methodContext;
        }
        throw new IllegalStateException("Couldn't build context for " + descriptor2);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull KtExpression argumentExpression, @NotNull Type parameterType, int parameterIndex2) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (InlineCodegen.isInliningParameter(argumentExpression, valueParameterDescriptor)) {
            LambdaInfo lambdaInfo = this.rememberClosure(argumentExpression, parameterType, valueParameterDescriptor);
            KtExpression receiver = this.getBoundCallableReferenceReceiver(argumentExpression);
            if (receiver != null) {
                this.putClosureParametersOnStack(lambdaInfo, this.codegen.gen(receiver));
            }
        } else {
            StackValue value2 = this.codegen.gen(argumentExpression);
            this.putValueIfNeeded(parameterType, value2, ValueKind.GENERAL, valueParameterDescriptor.getIndex());
        }
    }

    private KtExpression getBoundCallableReferenceReceiver(@NotNull KtExpression argumentExpression) {
        DoubleColonLHS lhs;
        KtExpression receiverExpression;
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getBoundCallableReferenceReceiver"));
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(argumentExpression);
        if (deparenthesized instanceof KtCallableReferenceExpression && (receiverExpression = ((KtCallableReferenceExpression)deparenthesized).getReceiverExpression()) != null && (lhs = this.state.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression)) instanceof DoubleColonLHS.Expression) {
            return receiverExpression;
        }
        return null;
    }

    @Override
    public void putValueIfNeeded(@NotNull Type parameterType, @NotNull StackValue value2, @NotNull ValueKind kind2, int parameterIndex2) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (this.processDefaultMaskOrMethodHandler(value2, kind2)) {
            return;
        }
        assert (this.maskValues.isEmpty()) : "Additional default call arguments should be last ones, but " + value2;
        this.putArgumentOrCapturedToLocalVal(parameterType, value2, -1, parameterIndex2, kind2);
    }

    private boolean processDefaultMaskOrMethodHandler(@NotNull StackValue value2, @NotNull ValueKind kind2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "processDefaultMaskOrMethodHandler"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "processDefaultMaskOrMethodHandler"));
        }
        if (kind2 != ValueKind.DEFAULT_MASK && kind2 != ValueKind.METHOD_HANDLE_IN_DEFAULT) {
            return false;
        }
        assert (value2 instanceof StackValue.Constant) : "Additional default method argument should be constant, but " + value2;
        Object constantValue = ((StackValue.Constant)value2).value;
        if (kind2 == ValueKind.DEFAULT_MASK) {
            assert (constantValue instanceof Integer) : "Mask should be of Integer type, but " + constantValue;
            this.maskValues.add((Integer)constantValue);
            if (this.maskStartIndex == -1) {
                this.maskStartIndex = 0;
                List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
                for (ParameterInfo info : infos) {
                    if (info instanceof CapturedParamInfo) continue;
                    this.maskStartIndex += info.getType().getSize();
                }
            }
        } else {
            assert (constantValue == null) : "Additional method handle for default argument should be null, but " + constantValue;
            this.methodHandleInDefaultMethodIndex = this.maskStartIndex + this.maskValues.size();
        }
        return true;
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        this.putArgumentOrCapturedToLocalVal(stackValue.type, stackValue, paramIndex, paramIndex, ValueKind.CAPTURED);
    }

    private void generateAndInsertFinallyBlocks(@NotNull MethodNode intoNode, @NotNull List<MethodInliner.PointForExternalFinallyBlocks> insertPoints, int offsetForFinallyLocalVar) {
        if (intoNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intoNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateAndInsertFinallyBlocks"));
        }
        if (insertPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertPoints", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateAndInsertFinallyBlocks"));
        }
        if (!this.codegen.hasFinallyBlocks()) {
            return;
        }
        HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks> extensionPoints = new HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks>();
        for (MethodInliner.PointForExternalFinallyBlocks insertPoint : insertPoints) {
            extensionPoints.put(insertPoint.beforeIns, insertPoint);
        }
        DefaultProcessor processor2 = new DefaultProcessor(intoNode, offsetForFinallyLocalVar);
        int curFinallyDepth = 0;
        for (AbstractInsnNode curInstr = intoNode.instructions.getFirst(); curInstr != null; curInstr = curInstr.getNext()) {
            MethodInliner.PointForExternalFinallyBlocks extension;
            processor2.processInstruction(curInstr, true);
            if (InlineCodegenUtil.isFinallyStart(curInstr)) {
                curFinallyDepth = InlineCodegenUtil.getConstant(curInstr.getPrevious());
            }
            if ((extension = (MethodInliner.PointForExternalFinallyBlocks)extensionPoints.get(curInstr)) == null) continue;
            Label start = new Label();
            MethodNode finallyNode = InlineCodegenUtil.createEmptyMethodNode();
            finallyNode.visitLabel(start);
            ExpressionCodegen finallyCodegen = new ExpressionCodegen((MethodVisitor)finallyNode, this.codegen.getFrameMap(), this.codegen.getReturnType(), this.codegen.getContext(), this.codegen.getState(), this.codegen.getParentCodegen());
            finallyCodegen.addBlockStackElementsForNonLocalReturns(this.codegen.getBlockStackElements(), curFinallyDepth);
            FrameMap frameMap = finallyCodegen.getFrameMap();
            FrameMap.Mark mark = frameMap.mark();
            int marker = -1;
            Set<LocalVarNodeWrapper> intervals = processor2.getLocalVarsMetaInfo().getCurrentIntervals();
            for (LocalVarNodeWrapper interval : intervals) {
                marker = Math.max(interval.getNode().index + 1, marker);
            }
            while (frameMap.getCurrentSize() < Math.max(processor2.getNextFreeLocalIndex(), offsetForFinallyLocalVar + marker)) {
                frameMap.enterTemp(Type.INT_TYPE);
            }
            finallyCodegen.generateFinallyBlocksIfNeeded(extension.returnType, extension.finallyIntervalEnd.getLabel());
            InlineCodegenUtil.insertNodeBefore(finallyNode, intoNode, curInstr);
            SimpleInterval splitBy = new SimpleInterval((LabelNode)start.info, extension.finallyIntervalEnd);
            processor2.getTryBlocksMetaInfo().splitCurrentIntervals(splitBy, true);
            mark.dropTo();
        }
        processor2.substituteTryBlockNodes(intoNode);
    }

    @NotNull
    public static SourceMapper createNestedSourceMapper(@NotNull SMAPAndMethodNode nodeAndSmap, @NotNull SourceMapper parent2) {
        if (nodeAndSmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeAndSmap", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createNestedSourceMapper"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createNestedSourceMapper"));
        }
        NestedSourceMapper nestedSourceMapper = new NestedSourceMapper(parent2, nodeAndSmap.getSortedRanges(), nodeAndSmap.getClassSMAP().getSourceInfo());
        if (nestedSourceMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createNestedSourceMapper"));
        }
        return nestedSourceMapper;
    }

    static void reportIncrementalInfo(@NotNull FunctionDescriptor sourceDescriptor, @NotNull FunctionDescriptor targetDescriptor, @NotNull JvmMethodSignature jvmSignature, @NotNull GenerationState state) {
        if (sourceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        IncrementalCache incrementalCache = state.getIncrementalCacheForThisTarget();
        if (incrementalCache == null) {
            return;
        }
        String classFilePath = InlineCodegenUtilsKt.getClassFilePath(sourceDescriptor, state.getTypeMapper(), incrementalCache);
        String sourceFilePath = InlineCodegenUtilsKt.getSourceFilePath(targetDescriptor);
        Method method = jvmSignature.getAsmMethod();
        incrementalCache.registerInline(classFilePath, method.getName() + method.getDescriptor(), sourceFilePath);
    }

    @Override
    public void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex, @NotNull List<? extends Type> valueParameterTypes) {
        if (actualArgsWithDeclIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualArgsWithDeclIndex", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reorderArgumentsIfNeeded"));
        }
        if (valueParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterTypes", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reorderArgumentsIfNeeded"));
        }
    }

    @Override
    public void putHiddenParamsIntoLocals() {
        assert (this.delayedHiddenWriting != null) : "processAndPutHiddenParameters(true) should be called before putHiddenParamsIntoLocals";
        this.delayedHiddenWriting.run();
        this.delayedHiddenWriting = null;
    }

    private static class FakeMemberCodegen
    extends MemberCodegen {
        private final MemberCodegen delegate;
        private final String className;

        public FakeMemberCodegen(@NotNull MemberCodegen wrapped, @NotNull KtElement declaration2, @NotNull FieldOwnerContext codegenContext, @NotNull String className2) {
            if (wrapped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (declaration2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (codegenContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (className2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            super(wrapped, declaration2, codegenContext);
            this.delegate = wrapped;
            this.className = className2;
        }

        @Override
        protected void generateDeclaration() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateBody() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateKotlinMetadataAnnotation() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public NameGenerator getInlineNameGenerator() {
            NameGenerator nameGenerator2 = this.delegate.getInlineNameGenerator();
            if (nameGenerator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getInlineNameGenerator"));
            }
            return nameGenerator2;
        }

        @Override
        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getClassName"));
            }
            return string;
        }
    }
}

