/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.TargetPlatformKind;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\b\u001a\u00020\t*\u00020\u000b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"deserializeFacetSettings", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "element", "Lorg/jdom/Element;", "readLatestConfig", "readV1Config", "readV2AndLaterConfig", "readV2Config", "convertPathsToSystemIndependent", "", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "getOption", "name", "", "getOptionBody", "getOptionValue", "serializeFacetSettings", "writeLatestConfig", "writeV2Config", "idea-jps-common"})
public final class FacetSerializationKt {
    @Nullable
    public static final Element getOption(@NotNull Element $receiver, @NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Iterable $receiver$iv = $receiver.getChildren("option");
            for (Object element$iv : $receiver$iv) {
                Element it = (Element)element$iv;
                if (!Intrinsics.areEqual((Object)it.getAttribute("name").getValue(), (Object)name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final String getOptionValue(@NotNull Element $receiver, String name2) {
        Element element2 = FacetSerializationKt.getOption($receiver, name2);
        return element2 != null && (element2 = element2.getAttribute("value")) != null ? element2.getValue() : null;
    }

    private static final Element getOptionBody(@NotNull Element $receiver, String name2) {
        Object object = FacetSerializationKt.getOption($receiver, name2);
        return object != null && (object = object.getChildren()) != null ? (Element)CollectionsKt.firstOrNull((List)object) : null;
    }

    private static final KotlinFacetSettings readV1Config(Element element2) {
        Element element3;
        Object object;
        TargetPlatformKind targetPlatformKind;
        Object v5;
        Object element$iv2;
        String apiLevel;
        String languageLevel;
        Boolean useProjectSettings;
        KotlinFacetSettings $receiver;
        KotlinFacetSettings kotlinFacetSettings;
        block16: {
            Element versionInfoElement;
            Boolean bl;
            $receiver = kotlinFacetSettings = new KotlinFacetSettings();
            String string = FacetSerializationKt.getOptionValue(element2, "useProjectSettings");
            if (string != null) {
                String string2 = string;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = null;
            }
            useProjectSettings = bl;
            Element element4 = versionInfoElement = FacetSerializationKt.getOptionBody(element2, "versionInfo");
            String targetPlatformName = element4 != null ? FacetSerializationKt.getOptionValue(element4, "targetPlatformName") : null;
            Element element5 = versionInfoElement;
            languageLevel = element5 != null ? FacetSerializationKt.getOptionValue(element5, "languageLevel") : null;
            Element element6 = versionInfoElement;
            apiLevel = element6 != null ? FacetSerializationKt.getOptionValue(element6, "apiLevel") : null;
            Iterable $receiver$iv = TargetPlatformKind.Companion.getALL_PLATFORMS();
            for (Object element$iv2 : $receiver$iv) {
                TargetPlatformKind it = (TargetPlatformKind)element$iv2;
                if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)targetPlatformName)) continue;
                v5 = element$iv2;
                break block16;
            }
            v5 = null;
        }
        if ((targetPlatformKind = (TargetPlatformKind)v5) == null) {
            targetPlatformKind = TargetPlatformKind.Jvm.Companion.get(JvmTarget.DEFAULT);
        }
        TargetPlatformKind targetPlatform = targetPlatformKind;
        Element compilerInfoElement = FacetSerializationKt.getOptionBody(element2, "compilerInfo");
        Object $receiver2 = element$iv2 = new CompilerSettings();
        Element element7 = compilerInfoElement;
        if (element7 != null && (element7 = FacetSerializationKt.getOptionBody(element7, "compilerSettings")) != null) {
            Element $i$a$1$firstOrNull;
            Element compilerSettingsElement = $i$a$1$firstOrNull = element7;
            XmlSerializer.deserializeInto($receiver2, (Element)compilerSettingsElement);
        }
        Object compilerSettings = element$iv2;
        Element element8 = compilerInfoElement;
        Element commonArgumentsElement = element8 != null ? FacetSerializationKt.getOptionBody(element8, "_commonCompilerArguments") : null;
        Element element9 = compilerInfoElement;
        Element jvmArgumentsElement = element9 != null ? FacetSerializationKt.getOptionBody(element9, "k2jvmCompilerArguments") : null;
        Element element10 = compilerInfoElement;
        Element jsArgumentsElement = element10 != null ? FacetSerializationKt.getOptionBody(element10, "k2jsCompilerArguments") : null;
        CommonCompilerArguments compilerArguments = KotlinFacetSettingsKt.createCompilerArguments$default(targetPlatform, null, 1, null);
        Element element11 = commonArgumentsElement;
        if (element11 != null) {
            Element it = object = element11;
            XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
        }
        object = compilerArguments;
        if (object instanceof K2JVMCompilerArguments) {
            Element element12 = jvmArgumentsElement;
            if (element12 != null) {
                Element it = element3 = element12;
                XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
            }
        } else if (object instanceof K2JSCompilerArguments) {
            Element element13 = jsArgumentsElement;
            if (element13 != null) {
                Element it = element3 = element13;
                XmlSerializer.deserializeInto((Object)compilerArguments, (Element)it);
            }
        }
        if (languageLevel != null) {
            compilerArguments.languageVersion = languageLevel;
        }
        if (apiLevel != null) {
            compilerArguments.apiVersion = apiLevel;
        }
        if (useProjectSettings != null) {
            $receiver.setUseProjectSettings(useProjectSettings);
        } else if (jvmArgumentsElement == null) {
            $receiver.setUseProjectSettings(false);
        }
        $receiver.setCompilerSettings((CompilerSettings)compilerSettings);
        $receiver.setCompilerArguments(compilerArguments);
        return kotlinFacetSettings;
    }

    private static final KotlinFacetSettings readV2AndLaterConfig(Element element2) {
        KotlinFacetSettings kotlinFacetSettings;
        block7: {
            String it;
            TargetPlatformKind<?> targetPlatformKind;
            Object v1;
            String string;
            KotlinFacetSettings $receiver;
            block6: {
                $receiver = kotlinFacetSettings = new KotlinFacetSettings();
                String string2 = element2.getAttributeValue("useProjectSettings");
                if (string2 != null) {
                    String string3;
                    String it2;
                    string = it2 = (string3 = string2);
                    KotlinFacetSettings kotlinFacetSettings2 = $receiver;
                    boolean bl = Boolean.parseBoolean(string);
                    kotlinFacetSettings2.setUseProjectSettings(bl);
                }
                String platformName = element2.getAttributeValue("platform");
                Iterable $receiver$iv = TargetPlatformKind.Companion.getALL_PLATFORMS();
                for (Object element$iv : $receiver$iv) {
                    TargetPlatformKind it3 = (TargetPlatformKind)element$iv;
                    if (!Intrinsics.areEqual((Object)it3.getDescription(), (Object)platformName)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((targetPlatformKind = (TargetPlatformKind<?>)v1) == null) {
                targetPlatformKind = TargetPlatformKind.Companion.getDEFAULT_PLATFORM();
            }
            TargetPlatformKind<?> platformKind = targetPlatformKind;
            Element element3 = element2.getChild("compilerSettings");
            if (element3 != null) {
                it = string = element3;
                $receiver.setCompilerSettings(new CompilerSettings());
                CompilerSettings compilerSettings = $receiver.getCompilerSettings();
                if (compilerSettings == null) {
                    Intrinsics.throwNpe();
                }
                XmlSerializer.deserializeInto((Object)compilerSettings, (Element)it);
            }
            Element element4 = element2.getChild("compilerArguments");
            if (element4 == null) break block7;
            it = string = element4;
            $receiver.setCompilerArguments(KotlinFacetSettingsKt.createCompilerArguments$default(platformKind, null, 1, null));
            CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerArguments();
            if (commonCompilerArguments == null) {
                Intrinsics.throwNpe();
            }
            XmlSerializer.deserializeInto((Object)commonCompilerArguments, (Element)it);
        }
        return kotlinFacetSettings;
    }

    private static final KotlinFacetSettings readV2Config(Element element2) {
        KotlinFacetSettings kotlinFacetSettings;
        block9: {
            boolean bl;
            KotlinFacetSettings $receiver;
            block8: {
                Element arg;
                Iterable $receiver$iv;
                Object args;
                block11: {
                    boolean bl2;
                    block7: {
                        block10: {
                            boolean bl3;
                            block6: {
                                Object object;
                                $receiver = kotlinFacetSettings = FacetSerializationKt.readV2AndLaterConfig(element2);
                                Object object2 = element2.getChild("compilerArguments");
                                if (object2 == null || (object2 = object2.getChildren()) == null) break block9;
                                args = object = object2;
                                $receiver$iv = (Iterable)args;
                                for (Object element$iv : $receiver$iv) {
                                    arg = (Element)element$iv;
                                    if (!(Intrinsics.areEqual((Object)((Attribute)arg.getAttributes().get(0)).getValue(), (Object)"coroutinesEnable") && ((Attribute)arg.getAttributes().get(1)).getBooleanValue())) continue;
                                    bl3 = true;
                                    break block6;
                                }
                                bl3 = false;
                            }
                            if (!bl3) break block10;
                            if ($receiver.getCompilerArguments() == null) {
                                Intrinsics.throwNpe();
                            }
                            $receiver.getCompilerArguments().coroutinesState = "enable";
                            break block9;
                        }
                        $receiver$iv = (Iterable)args;
                        for (Object element$iv : $receiver$iv) {
                            arg = (Element)element$iv;
                            if (!(Intrinsics.areEqual((Object)((Attribute)arg.getAttributes().get(0)).getValue(), (Object)"coroutinesWarn") && ((Attribute)arg.getAttributes().get(1)).getBooleanValue())) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                    if (!bl2) break block11;
                    if ($receiver.getCompilerArguments() == null) {
                        Intrinsics.throwNpe();
                    }
                    $receiver.getCompilerArguments().coroutinesState = "warn";
                    break block9;
                }
                $receiver$iv = (Iterable)args;
                for (Object element$iv : $receiver$iv) {
                    arg = (Element)element$iv;
                    if (!(Intrinsics.areEqual((Object)((Attribute)arg.getAttributes().get(0)).getValue(), (Object)"coroutinesError") && ((Attribute)arg.getAttributes().get(1)).getBooleanValue())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (!bl) break block9;
            if ($receiver.getCompilerArguments() == null) {
                Intrinsics.throwNpe();
            }
            $receiver.getCompilerArguments().coroutinesState = "error";
        }
        return kotlinFacetSettings;
    }

    private static final KotlinFacetSettings readLatestConfig(Element element2) {
        return FacetSerializationKt.readV2AndLaterConfig(element2);
    }

    @NotNull
    public static final KotlinFacetSettings deserializeFacetSettings(@NotNull Element element2) {
        KotlinFacetSettings kotlinFacetSettings;
        KotlinFacetSettings kotlinFacetSettings2;
        int version;
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        try {
            Attribute attribute = element2.getAttribute("version");
            n = attribute != null ? Integer.valueOf(attribute.getIntValue()) : null;
        }
        catch (DataConversionException e) {
            n = null;
        }
        Integer n2 = n;
        int n3 = version = n2 != null ? n2.intValue() : KotlinFacetSettings.Companion.getDEFAULT_VERSION();
        if (n3 == 1) {
            kotlinFacetSettings2 = FacetSerializationKt.readV1Config(element2);
        } else if (n3 == 2) {
            kotlinFacetSettings2 = FacetSerializationKt.readV2Config(element2);
        } else if (n3 == KotlinFacetSettings.Companion.getCURRENT_VERSION()) {
            kotlinFacetSettings2 = FacetSerializationKt.readLatestConfig(element2);
        } else {
            return new KotlinFacetSettings();
        }
        KotlinFacetSettings $receiver = kotlinFacetSettings = kotlinFacetSettings2;
        $receiver.setVersion(version);
        return kotlinFacetSettings;
    }

    /*
     * WARNING - void declaration
     */
    public static final void convertPathsToSystemIndependent(@NotNull CommonCompilerArguments $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.pluginClasspaths != null) {
            Object[] $receiver$iv = $receiver.pluginClasspaths;
            int index$iv = 0;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                void s;
                Object item$iv = $receiver$iv[i];
                int n = index$iv++;
                String string = (String)item$iv;
                int index2 = n;
                $receiver.pluginClasspaths[index2] = PathUtil.toSystemIndependentName((String)s);
            }
        } else {
            String[] cfr_ignored_0 = $receiver.pluginClasspaths;
        }
        CommonCompilerArguments commonCompilerArguments = $receiver;
        if (commonCompilerArguments instanceof K2JVMCompilerArguments) {
            ((K2JVMCompilerArguments)$receiver).destination = PathUtil.toSystemIndependentName((String)((K2JVMCompilerArguments)$receiver).destination);
            ((K2JVMCompilerArguments)$receiver).classpath = PathUtil.toSystemIndependentName((String)((K2JVMCompilerArguments)$receiver).classpath);
            ((K2JVMCompilerArguments)$receiver).jdkHome = PathUtil.toSystemIndependentName((String)((K2JVMCompilerArguments)$receiver).jdkHome);
            ((K2JVMCompilerArguments)$receiver).kotlinHome = PathUtil.toSystemIndependentName((String)((K2JVMCompilerArguments)$receiver).kotlinHome);
            if (((K2JVMCompilerArguments)$receiver).friendPaths != null) {
                Object[] $receiver$iv = ((K2JVMCompilerArguments)$receiver).friendPaths;
                int index$iv = 0;
                for (int i = 0; i < $receiver$iv.length; ++i) {
                    void s;
                    Object item$iv = $receiver$iv[i];
                    int n = index$iv++;
                    String index2 = (String)item$iv;
                    int index3 = n;
                    ((K2JVMCompilerArguments)$receiver).friendPaths[index3] = PathUtil.toSystemIndependentName((String)s);
                }
            } else {
                String[] cfr_ignored_1 = ((K2JVMCompilerArguments)$receiver).friendPaths;
            }
            ((K2JVMCompilerArguments)$receiver).declarationsOutputPath = PathUtil.toSystemIndependentName((String)((K2JVMCompilerArguments)$receiver).declarationsOutputPath);
        } else if (commonCompilerArguments instanceof K2JSCompilerArguments) {
            ((K2JSCompilerArguments)$receiver).outputFile = PathUtil.toSystemIndependentName((String)((K2JSCompilerArguments)$receiver).outputFile);
            ((K2JSCompilerArguments)$receiver).libraries = PathUtil.toSystemIndependentName((String)((K2JSCompilerArguments)$receiver).libraries);
        } else if (commonCompilerArguments instanceof K2MetadataCompilerArguments) {
            ((K2MetadataCompilerArguments)$receiver).destination = PathUtil.toSystemIndependentName((String)((K2MetadataCompilerArguments)$receiver).destination);
            ((K2MetadataCompilerArguments)$receiver).classpath = PathUtil.toSystemIndependentName((String)((K2MetadataCompilerArguments)$receiver).classpath);
        }
    }

    public static final void convertPathsToSystemIndependent(@NotNull CompilerSettings $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = PathUtil.toSystemIndependentName((String)$receiver.scriptTemplatesClasspath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.toSystemIndepen\u2026scriptTemplatesClasspath)");
        $receiver.scriptTemplatesClasspath = string;
        String string2 = PathUtil.toSystemIndependentName((String)$receiver.outputDirectoryForJsLibraryFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.toSystemIndepen\u2026rectoryForJsLibraryFiles)");
        $receiver.outputDirectoryForJsLibraryFiles = string2;
    }

    private static final void writeLatestConfig(@NotNull KotlinFacetSettings $receiver, Element element2) {
        block3: {
            Element element3;
            CommonCompilerArguments commonCompilerArguments;
            Element $receiver2;
            CompilerSettings compilerSettings;
            Object it;
            Object object;
            SkipDefaultsSerializationFilter filter2 = new SkipDefaultsSerializationFilter();
            TargetPlatformKind<?> targetPlatformKind = $receiver.getTargetPlatformKind();
            if (targetPlatformKind != null) {
                it = object = targetPlatformKind;
                element2.setAttribute("platform", ((TargetPlatformKind)it).getDescription());
            }
            if (!$receiver.getUseProjectSettings()) {
                element2.setAttribute("useProjectSettings", String.valueOf($receiver.getUseProjectSettings()));
            }
            if ((compilerSettings = $receiver.getCompilerSettings()) != null && (compilerSettings = (CompilerSettings)ArgumentUtilsKt.copyBean(it = (object = compilerSettings))) != null) {
                Element $i$a$2$let;
                it = object = compilerSettings;
                FacetSerializationKt.convertPathsToSystemIndependent((CompilerSettings)it);
                $receiver2 = $i$a$2$let = new Element("compilerSettings");
                XmlSerializer.serializeInto((Object)it, (Element)$receiver2, (SerializationFilter)((SerializationFilter)filter2));
                element2.addContent($receiver2);
            }
            if ((commonCompilerArguments = $receiver.getCompilerArguments()) == null || (commonCompilerArguments = (CommonCompilerArguments)ArgumentUtilsKt.copyBean(it = (object = commonCompilerArguments))) == null) break block3;
            it = object = commonCompilerArguments;
            FacetSerializationKt.convertPathsToSystemIndependent((CommonCompilerArguments)it);
            $receiver2 = element3 = new Element("compilerArguments");
            XmlSerializer.serializeInto((Object)it, (Element)$receiver2, (SerializationFilter)((SerializationFilter)filter2));
            element2.addContent($receiver2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void writeV2Config(@NotNull KotlinFacetSettings $receiver, Element element2) {
        String string;
        String string2;
        Element it;
        block8: {
            block7: {
                block6: {
                    Element element3;
                    FacetSerializationKt.writeLatestConfig($receiver, element2);
                    Element element4 = element2.getChild("compilerArguments");
                    if (element4 == null) return;
                    it = element3 = element4;
                    Element element5 = FacetSerializationKt.getOption(it, "coroutinesState");
                    if (element5 != null) {
                        element5.detach();
                    }
                    CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerArguments();
                    if (commonCompilerArguments == null) return;
                    String string3 = commonCompilerArguments.coroutinesState;
                    String string4 = string2 = string3;
                    if (string4 == null) return;
                    switch (string4.hashCode()) {
                        case 3641990: {
                            if (!string2.equals("warn")) return;
                            break block6;
                        }
                        case -1298848381: {
                            if (!string2.equals("enable")) return;
                            break;
                        }
                        case 96784904: {
                            if (!string2.equals("error")) return;
                            break block7;
                        }
                    }
                    string = "coroutinesEnable";
                    break block8;
                }
                string = "coroutinesWarn";
                break block8;
            }
            string = "coroutinesError";
            break block8;
            return;
        }
        String coroutineOption = string;
        if (coroutineOption == null) return;
        String $receiver2 = string2 = new Element("option");
        $receiver2.setAttribute("name", coroutineOption);
        $receiver2.setAttribute("value", "true");
        it.addContent((Element)$receiver2);
    }

    public static final void serializeFacetSettings(@NotNull KotlinFacetSettings $receiver, @NotNull Element element2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        int versionToWrite = $receiver.getVersion() == 2 ? $receiver.getVersion() : KotlinFacetSettings.Companion.getCURRENT_VERSION();
        element2.setAttribute("version", String.valueOf(versionToWrite));
        if (versionToWrite == 2) {
            FacetSerializationKt.writeV2Config($receiver, element2);
        } else {
            FacetSerializationKt.writeLatestConfig($receiver, element2);
        }
    }
}

