/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0007R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "functionResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lkotlin/jvm/functions/Function1;)V", "getFunctionDescriptor", "findMainFunction", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMainFunction", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "hasMain", "", "isMain", "function", "Companion", "frontend"})
public final class MainFunctionDetector {
    private final Function1<KtNamedFunction, FunctionDescriptor> getFunctionDescriptor;
    public static final Companion Companion = new Companion(null);

    public final boolean hasMain(@NotNull List<? extends KtDeclaration> declarations2) {
        Intrinsics.checkParameterIsNotNull(declarations2, (String)"declarations");
        return this.findMainFunction(declarations2) != null;
    }

    public final boolean isMain(@NotNull KtNamedFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        if (function2.isLocal()) {
            return false;
        }
        if (function2.getValueParameters().size() != 1 || !function2.getTypeParameters().isEmpty()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"main", (Object)function2.getName()) ^ true && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 1)) {
            return false;
        }
        if (!function2.isTopLevel() && !MainFunctionDetector.Companion.hasAnnotationWithExactNumberOfArguments(function2, 0)) {
            return false;
        }
        return Companion.isMain((DeclarationDescriptor)this.getFunctionDescriptor.invoke((Object)function2));
    }

    @Nullable
    public final FunctionDescriptor getMainFunction(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        return this.getMainFunction(module, module.getPackage(fqName2));
    }

    private final FunctionDescriptor getMainFunction(ModuleDescriptor module, PackageViewDescriptor packageView) {
        FunctionDescriptor it;
        FunctionDescriptor functionDescriptor2;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)packageView.getFragments();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            PackageFragmentDescriptor it2 = (PackageFragmentDescriptor)element$iv$iv;
            if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it2), (Object)module)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PackageFragmentDescriptor packageFragment : (List)destination$iv$iv) {
            Object v0;
            block5: {
                $receiver$iv = DescriptorUtils.getAllDescriptors(packageFragment.getMemberScope());
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    FunctionDescriptor it3 = (FunctionDescriptor)element$iv;
                    if (!Companion.isMain(it3)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            FunctionDescriptor functionDescriptor3 = v0;
            if (functionDescriptor3 == null) continue;
            it = functionDescriptor2 = functionDescriptor3;
            return it;
        }
        for (FqName subpackageName : module.getSubPackagesOf(packageView.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            FunctionDescriptor functionDescriptor4 = this.getMainFunction(module, module.getPackage(subpackageName));
            if (functionDescriptor4 == null) continue;
            it = functionDescriptor2 = functionDescriptor4;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtNamedFunction findMainFunction(List<? extends KtDeclaration> declarations2) {
        Iterator iterator2;
        block2: {
            Iterable iterable;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)declarations2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = iterable = (Iterable)((List)destination$iv$iv);
            for (Iterator iterator3 : iterable2) {
                KtNamedFunction it = (KtNamedFunction)((Object)iterator3);
                if (!this.isMain(it)) continue;
                iterator2 = iterator3;
                break block2;
            }
            iterator2 = null;
        }
        return (KtNamedFunction)((Object)iterator2);
    }

    public MainFunctionDetector(final @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        this.getFunctionDescriptor = (Function1)new Function1<KtNamedFunction, FunctionDescriptor>(){

            @NotNull
            public final FunctionDescriptor invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get(BindingContext.FUNCTION, function2);
                if (simpleFunctionDescriptor == null) {
                    throw (Throwable)new IllegalStateException("No descriptor resolved for " + function2 + " " + function2.getText());
                }
                return simpleFunctionDescriptor;
            }
        };
    }

    public MainFunctionDetector(@NotNull Function1<? super KtNamedFunction, ? extends FunctionDescriptor> functionResolver) {
        Intrinsics.checkParameterIsNotNull(functionResolver, (String)"functionResolver");
        this.getFunctionDescriptor = functionResolver;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/MainFunctionDetector$Companion;", "", "()V", "getJVMFunctionName", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasAnnotationWithExactNumberOfArguments", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "number", "", "isMain", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend"})
    public static final class Companion {
        public final boolean isMain(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!(descriptor2 instanceof FunctionDescriptor)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.getJVMFunctionName((FunctionDescriptor)descriptor2), (Object)"main") ^ true) {
                return false;
            }
            List<ValueParameterDescriptor> parameters2 = ((FunctionDescriptor)descriptor2).getValueParameters();
            if (parameters2.size() != 1 || !((FunctionDescriptor)descriptor2).getTypeParameters().isEmpty()) {
                return false;
            }
            ValueParameterDescriptor parameter = parameters2.get(0);
            KotlinType parameterType = parameter.getType();
            if (!KotlinBuiltIns.isArray(parameterType)) {
                return false;
            }
            List<TypeProjection> typeArguments = parameterType.getArguments();
            if (typeArguments.size() != 1) {
                return false;
            }
            KotlinType typeArgument = typeArguments.get(0).getType();
            if (!KotlinBuiltIns.isString(typeArgument)) {
                return false;
            }
            if (typeArguments.get(0).getProjectionKind() == Variance.IN_VARIANCE) {
                return false;
            }
            KotlinType returnType2 = ((FunctionDescriptor)descriptor2).getReturnType();
            if (returnType2 == null || !KotlinBuiltIns.isUnit(returnType2)) {
                return false;
            }
            if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
                return true;
            }
            DeclarationDescriptor containingDeclaration = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
            return containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind().isSingleton() && AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2);
        }

        private final String getJVMFunctionName(FunctionDescriptor functionDescriptor2) {
            String string = DescriptorUtils.getJvmName(functionDescriptor2);
            if (string == null) {
                String string2 = functionDescriptor2.getName().asString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"functionDescriptor.name.asString()");
            }
            return string;
        }

        private final boolean hasAnnotationWithExactNumberOfArguments(KtNamedFunction function2, int number) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = function2.getAnnotationEntries();
                for (Object element$iv : $receiver$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    if (!(it.getValueArguments().size() == number)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

