/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerAdapterKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/actions/DecompileKotlinToJavaAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getBinaryKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "update", "idea"})
public final class DecompileKotlinToJavaAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        KtFile ktFile = this.getBinaryKotlinFile(e);
        if (ktFile == null) {
            return;
        }
        KtFile binaryFile = ktFile;
        KotlinDecompilerAdapterKt.showDecompiledCode(binaryFile);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        e.getPresentation().setEnabled(this.getBinaryKotlinFile(e) != null);
    }

    private final KtFile getBinaryKotlinFile(AnActionEvent e) {
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = (KtFile)object;
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        if (!DecompileKotlinToJavaActionKt.canBeDecompiledToJava(file2)) {
            return null;
        }
        return file2;
    }
}

