/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.classes.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptDependenciesModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptDependenciesSourceModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.lightClasses.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptConfigurationManager;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a$\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002\u001a,\u0010\r\u001a\u0004\u0018\u00010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\t\u00a8\u0006\u0010"}, d2={"getModuleInfoByVirtualFile", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "treatAsLibrarySource", "", "getModuleInfo", "Lcom/intellij/psi/PsiElement;", "onFailure", "Lkotlin/Function1;", "", "getModuleInfoForLightElement", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "getNullableModuleInfo", "idea-analysis"})
public final class GetModuleInfoKt {
    @NotNull
    public static final IdeaModuleInfo getModuleInfo(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IdeaModuleInfo $receiver$iv = GetModuleInfoKt.getModuleInfo($receiver, (Function1<? super String, ? extends IdeaModuleInfo>)((Function1)getModuleInfo.1.INSTANCE));
        IdeaModuleInfo ideaModuleInfo = $receiver$iv;
        if (ideaModuleInfo == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "Defaulting to NotUnderContentRootModuleInfo so null is not possible";
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        return ideaModuleInfo;
    }

    @Nullable
    public static final IdeaModuleInfo getNullableModuleInfo(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return GetModuleInfoKt.getModuleInfo($receiver, (Function1<? super String, ? extends IdeaModuleInfo>)((Function1)getNullableModuleInfo.1.INSTANCE));
    }

    private static final IdeaModuleInfo getModuleInfo(@NotNull PsiElement $receiver, Function1<? super String, ? extends IdeaModuleInfo> onFailure) {
        Object explicitModuleInfo;
        String doNotAnalyze;
        PsiElement context;
        KtFile containingJetFile;
        PsiFile psiFile = $receiver.getContainingFile();
        ModuleInfo moduleInfo2 = psiFile != null ? KtPsiFactoryKt.getModuleInfo(psiFile) : null;
        if (!(moduleInfo2 instanceof IdeaModuleInfo)) {
            moduleInfo2 = null;
        }
        IdeaModuleInfo ideaModuleInfo = (IdeaModuleInfo)moduleInfo2;
        if (ideaModuleInfo != null) {
            IdeaModuleInfo ideaModuleInfo2;
            IdeaModuleInfo it = ideaModuleInfo2 = ideaModuleInfo;
            return it;
        }
        if ($receiver instanceof KtLightElement) {
            return GetModuleInfoKt.getModuleInfoForLightElement((KtLightElement)$receiver, onFailure);
        }
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        Object object = ktElement != null ? ktElement.getContainingFile() : null;
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = containingJetFile = (KtFile)object;
        Object object2 = context = ktFile != null ? KtPsiFactoryKt.getAnalysisContext(ktFile) : null;
        if (context != null) {
            return GetModuleInfoKt.getModuleInfo(context);
        }
        KtFile ktFile2 = containingJetFile;
        String string = doNotAnalyze = ktFile2 != null ? KtPsiFactoryKt.getDoNotAnalyze(ktFile2) : null;
        if (doNotAnalyze != null) {
            return (IdeaModuleInfo)onFailure.invoke((Object)("Should not analyze element: " + $receiver.getText() + " in file " + containingJetFile.getName() + "\n" + doNotAnalyze));
        }
        Object object3 = containingJetFile;
        if (object3 == null || (object3 = KtPsiFactoryKt.getModuleInfo((PsiFile)object3)) == null) {
            KtFile ktFile3 = containingJetFile;
            Object object4 = ktFile3 != null ? ktFile3.getOriginalFile() : null;
            if (!(object4 instanceof KtFile)) {
                object4 = null;
            }
            KtFile ktFile4 = (KtFile)object4;
            object3 = explicitModuleInfo = ktFile4 != null ? KtPsiFactoryKt.getModuleInfo((PsiFile)ktFile4) : null;
        }
        if (explicitModuleInfo instanceof IdeaModuleInfo) {
            return (IdeaModuleInfo)explicitModuleInfo;
        }
        if (containingJetFile instanceof KtCodeFragment) {
            Object object5 = containingJetFile.getContext();
            if (object5 == null || (object5 = GetModuleInfoKt.getModuleInfo(object5)) == null) {
                object5 = (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing code fragment of type " + containingJetFile.getClass() + " with no context element" + "\n" + "Text:" + "\n" + containingJetFile.getText()));
            }
            return object5;
        }
        PsiFile psiFile2 = $receiver.getContainingFile();
        if (psiFile2 == null) {
            return (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing element of type " + $receiver.getClass() + " with no containing file" + "\n" + "Text:" + "\n" + $receiver.getText()));
        }
        PsiFile containingFile = psiFile2;
        VirtualFile virtualFile2 = containingFile.getOriginalFile().getVirtualFile();
        if (virtualFile2 == null) {
            return (IdeaModuleInfo)onFailure.invoke((Object)("Analyzing element of type " + $receiver.getClass() + " in non-physical file " + containingFile + " of type " + containingFile.getClass() + "\n" + "Text:" + "\n" + $receiver.getText()));
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        PsiFile psiFile3 = containingFile;
        if (!(psiFile3 instanceof KtFile)) {
            psiFile3 = null;
        }
        KtFile ktFile5 = (KtFile)psiFile3;
        return GetModuleInfoKt.getModuleInfoByVirtualFile(project, virtualFile3, ktFile5 != null ? ktFile5.isCompiled() : false);
    }

    @NotNull
    public static final IdeaModuleInfo getModuleInfoByVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return GetModuleInfoKt.getModuleInfoByVirtualFile(project, virtualFile2, false);
    }

    private static final IdeaModuleInfo getModuleInfoByVirtualFile(Project project, VirtualFile virtualFile2, boolean treatAsLibrarySource) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(virtualFile2);
        if (module != null) {
            Function0<Unit> warnIfDecompiled$ = new Function0<Unit>(treatAsLibrarySource, virtualFile2, module){
                final /* synthetic */ boolean $treatAsLibrarySource;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Module $module;

                public final void invoke() {
                    if (this.$treatAsLibrarySource) {
                        KotlinCacheServiceImplKt.getLOG().warn("Decompiled file for " + this.$virtualFile.getCanonicalPath() + " is in content of " + this.$module);
                    }
                }
                {
                    this.$treatAsLibrarySource = bl;
                    this.$virtualFile = virtualFile2;
                    this.$module = module;
                    super(0);
                }
            };
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (moduleFileIndex.isInTestSourceContent(virtualFile2)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.testSourceInfo(module);
            }
            if (ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)moduleFileIndex, virtualFile2)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.productionSourceInfo(module);
            }
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(virtualFile2);
        for (OrderEntry orderEntry : orderEntries) {
            if (!orderEntry.isValid()) continue;
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 instanceof LibraryOrderEntry) {
                Library library2;
                if (((LibraryOrderEntry)orderEntry).getLibrary() == null) {
                    continue;
                }
                if (ProjectRootsUtil.isLibraryClassFile(project, virtualFile2) && !treatAsLibrarySource) {
                    Library library3 = library2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
                    return new LibraryInfo(project, library3);
                }
                if (!ProjectRootsUtil.isLibraryFile(project, virtualFile2) && !treatAsLibrarySource) continue;
                Library library4 = library2;
                Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
                return new LibrarySourceInfo(project, library4);
            }
            if (!(orderEntry2 instanceof JdkOrderEntry)) continue;
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                continue;
            }
            Sdk sdk2 = sdk;
            return new SdkInfo(project, sdk2);
        }
        KotlinScriptDefinition scriptDefinition2 = KotlinScriptDefinitionProviderKt.getScriptDefinition(virtualFile2, project);
        if (scriptDefinition2 != null) {
            return new ScriptModuleInfo(project, virtualFile2, scriptDefinition2);
        }
        boolean isBinary = ProjectRootsUtilKt.isKotlinBinary(virtualFile2);
        KotlinScriptConfigurationManager scriptConfigurationManager = KotlinScriptConfigurationManager.Companion.getInstance(project);
        if (isBinary && scriptConfigurationManager.getAllScriptsClasspathScope().contains(virtualFile2)) {
            if (treatAsLibrarySource) {
                return new ScriptDependenciesSourceModuleInfo(project);
            }
            return new ScriptDependenciesModuleInfo(project, null);
        }
        if (!isBinary && scriptConfigurationManager.getAllLibrarySourcesScope().contains(virtualFile2)) {
            return new ScriptDependenciesSourceModuleInfo(project);
        }
        return NotUnderContentRootModuleInfo.INSTANCE;
    }

    private static final IdeaModuleInfo getModuleInfoForLightElement(@NotNull KtLightElement<?, ?> $receiver, Function1<? super String, ? extends IdeaModuleInfo> onFailure) {
        NavigatablePsiElement navigatablePsiElement;
        VirtualFile $receiver$iv;
        PsiElement psiElement2 = $receiver;
        boolean strict$iv = false;
        KtLightClassForDecompiledDeclaration decompiledClass = (KtLightClassForDecompiledDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLightClassForDecompiledDeclaration.class, (boolean)strict$iv);
        if (decompiledClass != null) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            $receiver$iv = $receiver.getContainingFile().getVirtualFile();
            Project project2 = project;
            VirtualFile virtualFile2 = $receiver$iv;
            if (virtualFile2 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Decompiled class should be build from physical file";
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            VirtualFile virtualFile3 = virtualFile2;
            return GetModuleInfoKt.getModuleInfoByVirtualFile(project2, virtualFile3, false);
        }
        Object obj = $receiver.getKotlinOrigin();
        if (obj != null) {
            navigatablePsiElement = (NavigatablePsiElement)obj;
        } else {
            PsiFile psiFile;
            KtLightElement<?, ?> ktLightElement = $receiver;
            if (ktLightElement instanceof FakeLightClassForFileOfPackage) {
                psiFile = $receiver.getContainingFile();
                if (psiFile == null) {
                    Intrinsics.throwNpe();
                }
            } else if (ktLightElement instanceof KtLightClassForFacade) {
                psiFile = (PsiFile)CollectionsKt.first((Iterable)((KtLightClassForFacade)$receiver).getFiles());
            } else {
                return (IdeaModuleInfo)onFailure.invoke((Object)("Light element without origin is referenced by resolve:" + "\n" + $receiver + "\n" + $receiver.getClsDelegate().getText()));
            }
            navigatablePsiElement = (NavigatablePsiElement)psiFile;
        }
        NavigatablePsiElement element2 = navigatablePsiElement;
        return GetModuleInfoKt.getModuleInfo((PsiElement)element2);
    }
}

