/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.completion.KeywordCompletion;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000589:;<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010\u001bH\u0002J2\u0010&\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00192\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020!0\u0018J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0005J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001bH\u0002J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u00100\u001a\u00020!*\u00060#j\u0002`$2\u0006\u00101\u001a\u00020\u001bH\u0002J\u0014\u00102\u001a\u000203*\u00020\u001b2\u0006\u00104\u001a\u00020\u001bH\u0002J\u0014\u00105\u001a\u00020\u0019*\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion;", "", "()V", "ALL_KEYWORDS", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "COMPOUND_KEYWORDS", "", "GENERAL_FILTER", "Lcom/intellij/psi/filters/NotFilter;", "KEYWORDS_TO_IGNORE_PREFIX", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "KEYWORD_CONSTRUCTS", "", "NO_SPACE_AFTER", "buildFilesWithKeywordApplication", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "keywordTokenType", "prefixText", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "buildFilter", "Lkotlin/Function1;", "", "position", "Lcom/intellij/psi/PsiElement;", "buildFilterByText", "buildFilterWithContext", "contextElement", "buildFilterWithReducedContext", "buildReducedContextBefore", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scope", "complete", "prefix", "isJvmModule", "consumer", "Lcom/intellij/codeInsight/lookup/LookupElement;", "computeKeywordApplications", "keyword", "isErrorElementBefore", "token", "isSupportedAtLanguageLevel", "appendReducedText", "element", "getStartOffsetInAncestor", "", "ancestor", "matchesKeyword", "Lcom/intellij/psi/tree/IElementType;", "keywordType", "CommentFilter", "FileFilter", "ParentFilter", "SpaceAfterInsertHandler", "UseSiteAnnotationTargetInsertHandler", "idea-completion"})
public final class KeywordCompletion {
    private static final List<KtKeywordToken> ALL_KEYWORDS;
    private static final TokenSet KEYWORDS_TO_IGNORE_PREFIX;
    private static final Map<KtKeywordToken, KtKeywordToken> COMPOUND_KEYWORDS;
    private static final Map<KtKeywordToken, String> KEYWORD_CONSTRUCTS;
    private static final List<String> NO_SPACE_AFTER;
    private static final NotFilter GENERAL_FILTER;
    public static final KeywordCompletion INSTANCE;

    public final void complete(@NotNull PsiElement position2, @NotNull String prefix, boolean isJvmModule, @NotNull Function1<? super LookupElement, Unit> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        if (!GENERAL_FILTER.isAcceptable((Object)position2, position2)) {
            return;
        }
        Function1<KtKeywordToken, Boolean> parserFilter = this.buildFilter(position2);
        for (KtKeywordToken keywordToken : ALL_KEYWORDS) {
            LookupElementBuilder element2;
            String keyword = keywordToken.getValue();
            KtKeywordToken nextKeyword = COMPOUND_KEYWORDS.get((Object)keywordToken);
            boolean applicableAsCompound = false;
            if (nextKeyword != null) {
                String next2;
                complete.1 isSpace$ = complete.1.INSTANCE;
                PsiElement psiElement2 = PsiUtilsKt.nextLeaf(position2, (Function1<? super PsiElement, Boolean>)((Function1)complete.next.1.INSTANCE));
                String string = next2 = psiElement2 != null ? psiElement2.getText() : null;
                if (next2 != null && StringsKt.startsWith$default((String)next2, (String)"$", (boolean)false, (int)2, null)) {
                    String string2 = next2;
                    int n = 1;
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    next2 = string3;
                }
                if (Intrinsics.areEqual((Object)next2, (Object)nextKeyword.getValue()) ^ true) {
                    keyword = keyword + " " + nextKeyword.getValue();
                } else {
                    applicableAsCompound = true;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)keywordToken), (Object)((Object)KtTokens.DYNAMIC_KEYWORD)) && isJvmModule || !StringsKt.startsWith$default((String)keyword, (String)prefix, (boolean)false, (int)2, null) && KEYWORDS_TO_IGNORE_PREFIX.contains((IElementType)keywordToken) ^ true || !((Boolean)parserFilter.invoke((Object)keywordToken)).booleanValue()) continue;
            String constructText = KEYWORD_CONSTRUCTS.get((Object)keywordToken);
            if (constructText != null && !applicableAsCompound) {
                Project project = position2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
                String string = keyword;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyword");
                element2 = HandlerUtilsKt.createKeywordConstructLookupElement$default(project, string, constructText, false, 8, null);
                consumer2.invoke((Object)element2);
                continue;
            }
            element2 = LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold();
            PsiElement psiElement3 = PsiUtilsKt.prevLeaf$default(position2, false, 1, null);
            boolean isUseSiteAnnotationTarget = Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtTokens.AT));
            InsertHandler insertHandler = isUseSiteAnnotationTarget ? (InsertHandler)UseSiteAnnotationTargetInsertHandler.INSTANCE : (NO_SPACE_AFTER.contains(keyword) ? null : (InsertHandler)SpaceAfterInsertHandler.INSTANCE);
            element2 = element2.withInsertHandler(insertHandler);
            if (isUseSiteAnnotationTarget) {
                element2 = element2.withPresentableText(keyword + ":");
            }
            LookupElementBuilder lookupElementBuilder = element2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder, (String)"element");
            consumer2.invoke((Object)lookupElementBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<KtKeywordToken, Boolean> buildFilter(PsiElement position2) {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = position2;
        for (PsiElement parent2 = position2.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            void prevParent;
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBlockExpression) {
                Object v6;
                String prefixText;
                block26: {
                    Sequence<PsiElement> $receiver$iv;
                    prefixText = "fun foo() { ";
                    if ((PsiElement)prevParent.element instanceof KtExpression) {
                        KtIfExpression ktIfExpression;
                        Object blockParent;
                        PsiElement prevLeaf2 = PsiUtilsKt.prevLeaf((PsiElement)prevParent.element, (Function1<? super PsiElement, Boolean>)((Function1)buildFilter.prevLeaf.1.INSTANCE));
                        PsiElement psiElement3 = prevLeaf2;
                        if (Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtTokens.RBRACE))) {
                            PsiElement psiElement4 = prevLeaf2;
                            Object object = psiElement4 != null ? psiElement4.getParent() : null;
                            if (!(object instanceof KtBlockExpression)) {
                                object = null;
                            }
                            KtBlockExpression ktBlockExpression = (KtBlockExpression)object;
                            blockParent = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
                            Iterator iterator2 = blockParent;
                            if (iterator2 instanceof KtTryExpression) {
                                prefixText = prefixText + "try {}\n";
                            } else if (iterator2 instanceof KtCatchClause) {
                                prefixText = prefixText + "try {} catch (e: E) {}\n";
                            }
                        }
                        PsiElement psiElement5 = prevLeaf2;
                        if (psiElement5 != null) {
                            blockParent = psiElement5;
                            boolean strict$iv = false;
                            ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType($receiver$iv, KtIfExpression.class, (boolean)strict$iv);
                        } else {
                            ktIfExpression = null;
                        }
                        if (ktIfExpression != null) {
                            prefixText = prefixText + "if(true){}\n";
                        }
                        return this.buildFilterWithContext(prefixText, (PsiElement)prevParent.element, position2);
                    }
                    $receiver$iv = PsiUtilsKt.siblings((PsiElement)prevParent.element, false, false);
                    for (Object element$iv : $receiver$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v6 = element$iv;
                        break block26;
                    }
                    v6 = null;
                }
                KtExpression lastExpression = v6;
                if (lastExpression != null) {
                    String contextAfterExpression2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile(PsiUtilsKt.siblings((PsiElement)lastExpression, true, false), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef)prevParent){
                        final /* synthetic */ Ref.ObjectRef $prevParent;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)((PsiElement)this.$prevParent.element)) ^ true;
                        }
                        {
                            this.$prevParent = objectRef;
                            super(1);
                        }
                    })), null, null, null, (int)0, null, (Function1)buildFilter.contextAfterExpression.2.INSTANCE, (int)31, null);
                    return this.buildFilterWithContext(prefixText + "x" + contextAfterExpression2, (PsiElement)prevParent.element, position2);
                }
            } else if (psiElement2 instanceof KtDeclarationWithInitializer) {
                KtExpression initializer2 = ((KtDeclarationWithInitializer)parent2).getInitializer();
                if (Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)initializer2)) {
                    KtExpression ktExpression = initializer2;
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"initializer!!");
                    return this.buildFilterWithContext("val v = ", (PsiElement)ktExpression, position2);
                }
            } else if (psiElement2 instanceof KtParameter) {
                KtExpression ktExpression = ((KtParameter)parent2).getDefaultValue();
                if (Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)ktExpression)) {
                    KtExpression ktExpression2 = ktExpression;
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"default!!");
                    return this.buildFilterWithContext("val v = ", (PsiElement)ktExpression2, position2);
                }
            } else if (psiElement2 instanceof KtDeclaration) {
                PsiElement scope2 = ((KtDeclaration)parent2).getParent();
                PsiElement psiElement6 = scope2;
                if (psiElement6 instanceof KtClassOrObject) {
                    if (parent2 instanceof KtPrimaryConstructor) {
                        return this.buildFilterWithReducedContext("class X ", parent2, position2);
                    }
                    return this.buildFilterWithReducedContext("class X { ", parent2, position2);
                }
                if (psiElement6 instanceof KtFile) {
                    return this.buildFilterWithReducedContext("", parent2, position2);
                }
            }
            prevParent.element = parent2;
        }
        return this.buildFilterWithReducedContext("", null, position2);
    }

    @NotNull
    public final Sequence<String> computeKeywordApplications(@NotNull String prefixText, @NotNull KtKeywordToken keyword) {
        Intrinsics.checkParameterIsNotNull((Object)prefixText, (String)"prefixText");
        Intrinsics.checkParameterIsNotNull((Object)((Object)keyword), (String)"keyword");
        KtKeywordToken ktKeywordToken = keyword;
        return Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.SUSPEND_KEYWORD)) ? SequencesKt.sequenceOf((Object[])new String[]{"suspend () -> Unit>", "suspend X"}) : (StringsKt.endsWith$default((String)prefixText, (String)"@", (boolean)false, (int)2, null) ? SequencesKt.sequenceOf((Object[])new String[]{keyword.getValue() + ":X Y.Z"}) : SequencesKt.sequenceOf((Object[])new String[]{keyword.getValue() + " X"}));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithContext(String prefixText, PsiElement contextElement, PsiElement position2) {
        int offset2 = this.getStartOffsetInAncestor(position2, contextElement);
        String string = contextElement.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, offset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String truncatedContext = string4;
        return this.buildFilterByText(prefixText + truncatedContext, position2);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithReducedContext(String prefixText, PsiElement contextElement, PsiElement position2) {
        StringBuilder builder = new StringBuilder();
        this.buildReducedContextBefore(builder, position2, contextElement);
        return this.buildFilterByText(prefixText + builder.toString(), position2);
    }

    private final Sequence<KtFile> buildFilesWithKeywordApplication(KtKeywordToken keywordTokenType, String prefixText, KtPsiFactory psiFactory) {
        return SequencesKt.map(this.computeKeywordApplications(prefixText, keywordTokenType), (Function1)((Function1)new Function1<String, KtFile>(psiFactory, prefixText){
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ String $prefixText;

            @NotNull
            public final KtFile invoke(@NotNull String application) {
                Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
                return this.$psiFactory.createFile(this.$prefixText + application);
            }
            {
                this.$psiFactory = ktPsiFactory;
                this.$prefixText = string;
                super(1);
            }
        }));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterByText(String prefixText, PsiElement position2) {
        Project project = position2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        Function2<KtKeywordToken, KtFile, Boolean> isKeywordCorrectlyApplied$ = new Function2<KtKeywordToken, KtFile, Boolean>(prefixText, position2){
            final /* synthetic */ String $prefixText;
            final /* synthetic */ PsiElement $position;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull KtKeywordToken keywordTokenType, @NotNull KtFile file2) {
                KotlinTarget kotlinTarget;
                KtDeclaration ownerDeclaration;
                KtDeclaration ktDeclaration;
                Intrinsics.checkParameterIsNotNull((Object)((Object)keywordTokenType), (String)"keywordTokenType");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                PsiElement psiElement2 = file2.findElementAt(this.$prefixText.length());
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement elementAt = psiElement2;
                ASTNode aSTNode = elementAt.getNode();
                if (aSTNode == null) {
                    Intrinsics.throwNpe();
                }
                if (!KeywordCompletion.access$matchesKeyword(KeywordCompletion.INSTANCE, aSTNode.getElementType(), keywordTokenType)) {
                    return false;
                }
                PsiElement $receiver$iv = elementAt;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, PsiErrorElement.class, (boolean)false) != null) {
                    return false;
                }
                PsiElement psiElement3 = elementAt;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"elementAt");
                if (KeywordCompletion.access$isErrorElementBefore(KeywordCompletion.INSTANCE, psiElement3)) {
                    return false;
                }
                if (!KeywordCompletion.access$isSupportedAtLanguageLevel(KeywordCompletion.INSTANCE, keywordTokenType, this.$position)) {
                    return false;
                }
                if (!(keywordTokenType instanceof KtModifierKeywordToken)) {
                    return true;
                }
                if (!(elementAt.getParent() instanceof KtModifierList)) {
                    return true;
                }
                PsiElement container2 = elementAt.getParent().getParent();
                PsiElement psiElement4 = container2;
                List<E> possibleTargets = psiElement4 instanceof KtParameter ? (((KtParameter)container2).getOwnerFunction() instanceof KtPrimaryConstructor ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.MEMBER_PROPERTY}) : CollectionsKt.listOf((Object)((Object)KotlinTarget.VALUE_PARAMETER))) : (psiElement4 instanceof KtTypeParameter ? CollectionsKt.listOf((Object)((Object)KotlinTarget.TYPE_PARAMETER)) : (psiElement4 instanceof KtEnumEntry ? CollectionsKt.listOf((Object)((Object)KotlinTarget.ENUM_ENTRY)) : (psiElement4 instanceof KtClassBody ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : (psiElement4 instanceof KtFile ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : null))));
                Set<KotlinTarget> modifierTargets = ModifierCheckerCore.INSTANCE.getPossibleTargetMap().get((Object)((Object)keywordTokenType));
                if (modifierTargets != null && possibleTargets != null) {
                    boolean bl;
                    block20: {
                        Iterable $receiver$iv2 = possibleTargets;
                        for (E element$iv : $receiver$iv2) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            if (!modifierTargets.contains((Object)((Object)it))) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                    if (bl) {
                        return false;
                    }
                }
                PsiElement psiElement5 = container2;
                if (psiElement5 != null) {
                    void $receiver$iv3;
                    PsiElement psiElement6 = psiElement5;
                    boolean strict$iv = true;
                    ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtDeclaration.class, (boolean)strict$iv);
                } else {
                    ktDeclaration = null;
                }
                KtDeclaration strict$iv = ownerDeclaration = ktDeclaration;
                if (Intrinsics.areEqual((Object)strict$iv, null)) {
                    kotlinTarget = KotlinTarget.FILE;
                } else if (strict$iv instanceof KtClass) {
                    kotlinTarget = ((KtClass)ownerDeclaration).isInterface() ? KotlinTarget.INTERFACE : (((KtClass)ownerDeclaration).isEnum() ? KotlinTarget.ENUM_CLASS : (((KtClass)ownerDeclaration).isAnnotation() ? KotlinTarget.ANNOTATION_CLASS : KotlinTarget.CLASS_ONLY));
                } else if (strict$iv instanceof KtObjectDeclaration) {
                    kotlinTarget = ((KtObjectDeclaration)ownerDeclaration).isObjectLiteral() ? KotlinTarget.OBJECT_LITERAL : KotlinTarget.OBJECT;
                } else {
                    return true;
                }
                KotlinTarget parentTarget = kotlinTarget;
                Set<KotlinTarget> modifierParents = ModifierCheckerCore.INSTANCE.getPossibleParentTargetMap().get((Object)((Object)keywordTokenType));
                if (modifierParents != null && modifierParents.contains((Object)((Object)parentTarget)) ^ true) {
                    return false;
                }
                Set<KotlinTarget> deprecatedParents = ModifierCheckerCore.INSTANCE.getDeprecatedParentTargetMap().get((Object)((Object)keywordTokenType));
                return deprecatedParents == null || !deprecatedParents.contains((Object)((Object)parentTarget));
            }
            {
                this.$prefixText = string;
                this.$position = psiElement2;
                super(2);
            }
        };
        return (Function1)new Function1<KtKeywordToken, Boolean>(prefixText, psiFactory, isKeywordCorrectlyApplied$){
            final /* synthetic */ String $prefixText;
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ buildFilterByText.1 $isKeywordCorrectlyApplied;

            public final boolean invoke(@NotNull KtKeywordToken keywordTokenType) {
                boolean bl;
                block1: {
                    Sequence files2;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)keywordTokenType), (String)"keywordTokenType");
                    Sequence $receiver$iv = files2 = KeywordCompletion.access$buildFilesWithKeywordApplication(KeywordCompletion.INSTANCE, keywordTokenType, this.$prefixText, this.$psiFactory);
                    for (E element$iv : $receiver$iv) {
                        KtFile file2 = (KtFile)element$iv;
                        if (!this.$isKeywordCorrectlyApplied.invoke(keywordTokenType, file2)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$prefixText = string;
                this.$psiFactory = ktPsiFactory;
                this.$isKeywordCorrectlyApplied = var3_3;
                super(1);
            }
        };
    }

    private final boolean isErrorElementBefore(PsiElement token) {
        for (PsiElement leaf : PsiUtilsKt.getPrevLeafs(token)) {
            boolean bl;
            block3: {
                if (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) continue;
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParentsWithSelf(leaf);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PsiErrorElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (leaf.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private final boolean matchesKeyword(@NotNull IElementType $receiver, KtKeywordToken keywordType) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)keywordType)) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IN_KEYWORD)) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IS_KEYWORD)) : false));
    }

    private final boolean isSupportedAtLanguageLevel(KtKeywordToken keyword, PsiElement position2) {
        LanguageFeature languageFeature;
        Object object = ModuleUtilCore.findModuleForPsiElement((PsiElement)position2);
        if (object == null || (object = PlatformKt.getLanguageVersionSettings((Module)object)) == null) {
            object = LanguageVersionSettingsImpl.DEFAULT;
        }
        Object languageVersionSettings = object;
        KtKeywordToken ktKeywordToken = keyword;
        if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.TYPE_ALIAS_KEYWORD))) {
            languageFeature = LanguageFeature.TypeAliases;
        } else if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.HEADER_KEYWORD)) || Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.IMPL_KEYWORD))) {
            languageFeature = LanguageFeature.MultiPlatformProjects;
        } else if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.SUSPEND_KEYWORD))) {
            languageFeature = LanguageFeature.Coroutines;
        } else {
            return true;
        }
        LanguageFeature feature = languageFeature;
        return languageVersionSettings.supportsFeature(feature);
    }

    private final void buildReducedContextBefore(StringBuilder builder, PsiElement position2, PsiElement scope2) {
        Object v1;
        PsiElement parent2;
        block8: {
            if (Intrinsics.areEqual((Object)position2, (Object)scope2)) {
                return;
            }
            PsiElement psiElement2 = position2.getParent();
            if (psiElement2 == null) {
                return;
            }
            parent2 = psiElement2;
            this.buildReducedContextBefore(builder, parent2, scope2);
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(position2, false, false);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof KtDeclaration)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        PsiElement prevDeclaration = v1;
        PsiElement child = parent2.getFirstChild();
        while (Intrinsics.areEqual((Object)child, (Object)position2) ^ true) {
            if (child instanceof KtDeclaration) {
                if (Intrinsics.areEqual((Object)child, (Object)prevDeclaration)) {
                    this.appendReducedText(builder, child);
                }
            } else {
                PsiElement psiElement3 = child;
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                builder.append(psiElement3.getText());
            }
            child = child.getNextSibling();
        }
    }

    private final void appendReducedText(@NotNull StringBuilder $receiver, PsiElement element2) {
        PsiElement child = element2.getFirstChild();
        if (child == null) {
            String string = element2.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver.append(string);
        } else {
            while (child != null) {
                PsiElement psiElement2 = child;
                if (psiElement2 instanceof KtBlockExpression || psiElement2 instanceof KtClassBody) {
                    $receiver.append("{}");
                } else {
                    this.appendReducedText($receiver, child);
                }
                child = child.getNextSibling();
            }
        }
    }

    private final int getStartOffsetInAncestor(@NotNull PsiElement $receiver, PsiElement ancestor) {
        if (Intrinsics.areEqual((Object)ancestor, (Object)$receiver)) {
            return 0;
        }
        PsiElement psiElement2 = $receiver.getParent();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return this.getStartOffsetInAncestor(psiElement2, ancestor) + $receiver.getStartOffsetInParent();
    }

    /*
     * WARNING - void declaration
     */
    private KeywordCompletion() {
        void var3_3;
        Object object;
        KtKeywordToken it;
        Collection collection;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        INSTANCE = this;
        Object[] objectArray = KtTokens.KEYWORDS.getTypes();
        IElementType[] iElementTypeArray = KtTokens.SOFT_KEYWORDS.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"SOFT_KEYWORDS.types");
        Object $receiver$iv = ArraysKt.plus((Object[])objectArray, (Object[])iElementTypeArray);
        Object[] objectArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            item$iv$iv = $receiver$iv$iv[i];
            IElementType iElementType = (IElementType)item$iv$iv;
            collection = destination$iv$iv;
            void v2 = it;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtKeywordToken");
            }
            object = (KtKeywordToken)v2;
            collection.add(object);
        }
        ALL_KEYWORDS = (List)destination$iv$iv;
        KEYWORDS_TO_IGNORE_PREFIX = TokenSet.create((IElementType[])new IElementType[]{KtTokens.OVERRIDE_KEYWORD});
        COMPOUND_KEYWORDS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), (Object)((Object)KtTokens.OBJECT_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ENUM_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ANNOTATION_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.SEALED_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.LATEINIT_KEYWORD), (Object)((Object)KtTokens.VAR_KEYWORD))});
        KEYWORD_CONSTRUCTS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.IF_KEYWORD), (Object)"fun foo() { if (caret)"), TuplesKt.to((Object)((Object)KtTokens.WHILE_KEYWORD), (Object)"fun foo() { while(caret)"), TuplesKt.to((Object)((Object)KtTokens.FOR_KEYWORD), (Object)"fun foo() { for(caret)"), TuplesKt.to((Object)((Object)KtTokens.TRY_KEYWORD), (Object)"fun foo() { try {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CATCH_KEYWORD), (Object)"fun foo() { try {} catch (caret)"), TuplesKt.to((Object)((Object)KtTokens.FINALLY_KEYWORD), (Object)"fun foo() { try {\n}\nfinally{\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.DO_KEYWORD), (Object)"fun foo() { do {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.INIT_KEYWORD), (Object)"class C { init {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CONSTRUCTOR_KEYWORD), (Object)"class C { constructor(caret)"), TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), (Object)"class C { companion object {\ncaret\n}")});
        $receiver$iv = CollectionsKt.listOf((Object[])new KtKeywordToken[]{KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.DYNAMIC_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD});
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (KtKeywordToken)((Object)item$iv$iv);
            collection = destination$iv$iv;
            object = it.getValue();
            collection.add(object);
        }
        NO_SPACE_AFTER = CollectionsKt.plus((Collection)((List)var3_3), (Object)"companion object");
        GENERAL_FILTER = new NotFilter((ElementFilter)new OrFilter(new ElementFilter[]{new CommentFilter(), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtLiteralStringTemplateEntry.class)), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtConstantExpression.class)), (ElementFilter)new FileFilter((ElementFilter)new ClassFilter(KtTypeCodeFragment.class)), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter(".")), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter("?."))}));
    }

    static {
        new KeywordCompletion();
    }

    public static final /* synthetic */ boolean access$matchesKeyword(KeywordCompletion $this, @NotNull IElementType $receiver, @NotNull KtKeywordToken keywordType) {
        return $this.matchesKeyword($receiver, keywordType);
    }

    public static final /* synthetic */ boolean access$isErrorElementBefore(KeywordCompletion $this, @NotNull PsiElement token) {
        return $this.isErrorElementBefore(token);
    }

    public static final /* synthetic */ boolean access$isSupportedAtLanguageLevel(KeywordCompletion $this, @NotNull KtKeywordToken keyword, @NotNull PsiElement position2) {
        return $this.isSupportedAtLanguageLevel(keyword, position2);
    }

    @NotNull
    public static final /* synthetic */ Sequence access$buildFilesWithKeywordApplication(KeywordCompletion $this, @NotNull KtKeywordToken keywordTokenType, @NotNull String prefixText, @NotNull KtPsiFactory psiFactory) {
        return $this.buildFilesWithKeywordApplication(keywordTokenType, prefixText, psiFactory);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$UseSiteAnnotationTargetInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
    private static final class UseSiteAnnotationTargetInsertHandler
    implements InsertHandler<LookupElement> {
        public static final UseSiteAnnotationTargetInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            new WithTailInsertHandler(":", false, false, false, 8, null).postHandleInsert(context, item);
        }

        private UseSiteAnnotationTargetInsertHandler() {
            INSTANCE = this;
        }

        static {
            new UseSiteAnnotationTargetInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$SpaceAfterInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
    private static final class SpaceAfterInsertHandler
    implements InsertHandler<LookupElement> {
        public static final SpaceAfterInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            WithTailInsertHandler.Companion.getSPACE().postHandleInsert(context, item);
        }

        private SpaceAfterInsertHandler() {
            INSTANCE = this;
        }

        static {
            new SpaceAfterInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$CommentFilter;", "Lcom/intellij/psi/filters/ElementFilter;", "()V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "isClassAcceptable", "hintClass", "Ljava/lang/Class;", "idea-completion"})
    private static final class CommentFilter
    implements ElementFilter {
        public boolean isAcceptable(@Nullable Object element2, @Nullable PsiElement context) {
            return element2 instanceof PsiElement && KtPsiUtil.isInComment((PsiElement)element2);
        }

        public boolean isClassAcceptable(@NotNull Class<? extends Object> hintClass) {
            Intrinsics.checkParameterIsNotNull(hintClass, (String)"hintClass");
            return true;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$ParentFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "idea-completion"})
    private static final class ParentFilter
    extends PositionElementFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element2, @Nullable PsiElement context) {
            Object object = element2;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement2 = (PsiElement)object;
            if (psiElement2 == null) return false;
            PsiElement psiElement3 = psiElement2.getParent();
            PsiElement parent2 = psiElement3;
            if (parent2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)parent2, context);
            if (!bl) return false;
            return true;
        }

        public ParentFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$FileFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "idea-completion"})
    private static final class FileFilter
    extends PositionElementFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element2, @Nullable PsiElement context) {
            Object object = element2;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement2 = (PsiElement)object;
            if (psiElement2 == null) return false;
            PsiFile psiFile = psiElement2.getContainingFile();
            PsiFile file2 = psiFile;
            if (file2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)file2, context);
            if (!bl) return false;
            return true;
        }

        public FileFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }
    }
}

