/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.ui.CreateLibraryDialogWithModules;
import org.jetbrains.kotlin.idea.framework.ui.FileUIUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 E2\u00020\u0001:\u0002EFB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0017J\u0016\u0010\u001f\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!H\u0014J.\u0010\"\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J$\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u00100\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u00101\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J(\u00102\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\fH\u0004J\u0010\u00107\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u00107\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020(0!2\b\u00109\u001a\u0004\u0018\u00010:H&J\u001a\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010<\u001a\u000205H\u0004J*\u0010=\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010>\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010A\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010B\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010C\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010D\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0012\u0010\u0011\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryMatcher", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/libraries/Library;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function1;", "libraryName", "getLibraryName", "messageForOverrideDialog", "getMessageForOverrideDialog", "addLibraryToModuleIfNeeded", "", "module", "Lcom/intellij/openapi/module/Module;", "library", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configureKotlinSettings", "modules", "", "configureLibraryJar", "Lcom/intellij/openapi/roots/libraries/Library$ModifiableModel;", "jarState", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "dirToCopyJarTo", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "configureModuleWithLibrary", "defaultPath", "pathFromDialog", "copyFileToDir", "Ljava/io/File;", "file", "toDir", "createNewLibrary", "getDefaultPathToJarFile", "getJarState", "targetFile", "jarType", "Lcom/intellij/openapi/roots/OrderRootType;", "useBundled", "getKotlinLibrary", "getLibraryJarDescriptors", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getPathFromLibrary", "type", "getPathToCopyFileTo", "defaultDir", "getStatus", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "isConfigured", "isKotlinLibrary", "isProjectLibraryPresent", "needToChooseJarPath", "Companion", "FileState", "idea"})
public abstract class KotlinWithLibraryConfigurator
implements KotlinProjectConfigurator {
    @NotNull
    private static final String DEFAULT_LIBRARY_DIR = "lib";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract String getLibraryName();

    @NotNull
    protected abstract String getMessageForOverrideDialog();

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getLibraryCaption();

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (!Companion.isApplicable(module)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        if (this.isConfigured(module)) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    public abstract boolean isConfigured(@NotNull Module var1);

    @Override
    @JvmSuppressWildcards
    public void configure(@NotNull Project project, @NotNull Collection<Module> excludeModules) {
        List<Module> list2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        String defaultPathToJar = this.getDefaultPathToJarFile(project);
        boolean showPathToJarPanel = this.needToChooseJarPath(project);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            list2 = ConfigureKotlinInProjectUtilsKt.getNonConfiguredModules(project, this);
        } else {
            Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
            list2 = Arrays.asList(Arrays.copyOf(moduleArray, moduleArray.length));
        }
        List<Module> nonConfiguredModules = list2;
        List<Module> modulesToConfigure = nonConfiguredModules = CollectionsKt.minus((Iterable)nonConfiguredModules, (Iterable)excludeModules);
        String copyLibraryIntoPath = null;
        if (nonConfiguredModules.size() > 1 || showPathToJarPanel) {
            CreateLibraryDialogWithModules dialog2 = new CreateLibraryDialogWithModules(project, this, defaultPathToJar, showPathToJarPanel, this.getDialogTitle(), this.getLibraryCaption(), excludeModules);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dialog2.show();
                if (!dialog2.isOK()) {
                    return;
                }
            } else {
                dialog2.close(0);
            }
            modulesToConfigure = dialog2.getModulesToConfigure();
            copyLibraryIntoPath = dialog2.getCopyIntoPath();
        }
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        Iterator iterator2 = modulesToConfigure.iterator();
        while (iterator2.hasNext()) {
            Module module;
            Module module2 = module = (Module)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            this.configureModuleWithLibrary(module2, defaultPathToJar, copyLibraryIntoPath, collector2);
        }
        List<Module> list3 = modulesToConfigure;
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"modulesToConfigure");
        this.configureKotlinSettings((List<? extends Module>)list3);
        collector2.showNotification();
    }

    protected final void configureModuleWithLibrary(@NotNull Module module, @NotNull String defaultPath, @Nullable String pathFromDialog, @NotNull NotificationMessageCollector collector2) {
        Library library2;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)defaultPath, (String)"defaultPath");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Project project = module.getProject();
        Library library3 = this.getKotlinLibrary(module);
        if (library3 == null) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            library3 = library2 = this.getKotlinLibrary(project2);
        }
        if (library3 == null) {
            Project project3 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            library2 = this.createNewLibrary(project3, collector2);
        }
        Library library4 = library2;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Library.ModifiableModel model = library4.getModifiableModel();
        for (LibraryJarDescriptor descriptor2 : this.getLibraryJarDescriptors(sdk)) {
            Project project4 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            String dirToCopyJar = this.getPathToCopyFileTo(project4, descriptor2.getOrderRootType(), defaultPath, pathFromDialog);
            Project project5 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            FileState runtimeState = this.getJarState(project5, new File(dirToCopyJar, descriptor2.getJarName()), descriptor2.getOrderRootType(), pathFromDialog == null);
            Library.ModifiableModel modifiableModel = model;
            Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModel, (String)"model");
            this.configureLibraryJar(modifiableModel, runtimeState, dirToCopyJar, descriptor2, collector2);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(model){
            final /* synthetic */ Library.ModifiableModel $model;

            public final void run() {
                this.$model.commit();
            }
            {
                this.$model = modifiableModel;
            }
        });
        this.addLibraryToModuleIfNeeded(module, library4, collector2);
    }

    public final void configureLibraryJar(@NotNull Library.ModifiableModel library2, @NotNull FileState jarState, @NotNull String dirToCopyJarTo, @NotNull LibraryJarDescriptor libraryJarDescriptor, @NotNull NotificationMessageCollector collector2) {
        VirtualFile jarVFile;
        File jarFile;
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)((Object)jarState), (String)"jarState");
        Intrinsics.checkParameterIsNotNull((Object)dirToCopyJarTo, (String)"dirToCopyJarTo");
        Intrinsics.checkParameterIsNotNull((Object)((Object)libraryJarDescriptor), (String)"libraryJarDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        File file2 = jarFile = Intrinsics.areEqual((Object)((Object)jarState), (Object)((Object)FileState.DO_NOT_COPY)) ? libraryJarDescriptor.getPathInPlugin() : new File(dirToCopyJarTo, libraryJarDescriptor.getJarName());
        if (Intrinsics.areEqual((Object)((Object)jarState), (Object)((Object)FileState.COPY))) {
            this.copyFileToDir(libraryJarDescriptor.getPathInPlugin(), dirToCopyJarTo, collector2);
        }
        if ((jarVFile = LocalFileSystem.getInstance().findFileByIoFile(jarFile)) == null) {
            collector2.addMessage("Can't find library JAR file " + jarFile);
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jarVFile);
        if (jarRoot == null) {
            collector2.addMessage("Couldn't configure library; JAR file " + jarVFile + " may be corrupted");
            return;
        }
        if (ArraysKt.contains((Object[])library2.getFiles(libraryJarDescriptor.getOrderRootType()), (Object)jarRoot) ^ true) {
            library2.addRoot(jarRoot, libraryJarDescriptor.getOrderRootType());
            collector2.addMessage("Added " + jarFile + " to library configuration");
        }
    }

    @Nullable
    public final Library getKotlinLibrary(@NotNull Project project) {
        Library library2;
        Object v0;
        Library p1;
        Object element$iv;
        Object[] $receiver$iv;
        int n;
        KotlinWithLibraryConfigurator kotlinWithLibraryConfigurator;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object[] objectArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
            kotlinWithLibraryConfigurator = this;
            for (n = 0; n < $receiver$iv.length; ++n) {
                element$iv = $receiver$iv[n];
                p1 = (Library)element$iv;
                if (!kotlinWithLibraryConfigurator.isKotlinLibrary(p1)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((library2 = (Library)v0) == null) {
            Object object;
            block4: {
                $receiver$iv = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries();
                kotlinWithLibraryConfigurator = this;
                for (n = 0; n < $receiver$iv.length; ++n) {
                    element$iv = $receiver$iv[n];
                    p1 = (Library)element$iv;
                    if (!kotlinWithLibraryConfigurator.isKotlinLibrary(p1)) continue;
                    object = element$iv;
                    break block4;
                }
                object = null;
            }
            library2 = (Library)object;
        }
        return library2;
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public final File copyFileToDir(@Nullable File file2, @NotNull String toDir, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)toDir, (String)"toDir");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        if (file2 == null) {
            return null;
        }
        File copy = FileUIUtils.copyWithOverwriteDialog(this.getMessageForOverrideDialog(), toDir, file2);
        if (copy != null) {
            collector2.addMessage(file2.getName() + " was copied to " + toDir);
        }
        return copy;
    }

    @Nullable
    protected final String getPathFromLibrary(@NotNull Project project, @NotNull OrderRootType type2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return Companion.getPathFromLibrary(this.getKotlinLibrary(project), type2);
    }

    public final void addLibraryToModuleIfNeeded(@NotNull Module module, @NotNull Library library2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        DependencyScope expectedDependencyScope = KotlinWithLibraryConfigurator.Companion.getDependencyScope(module);
        Library kotlinLibrary = this.getKotlinLibrary(module);
        if (kotlinLibrary == null) {
            ModuleRootModificationUtil.addDependency((Module)module, (Library)library2, (DependencyScope)expectedDependencyScope, (boolean)false);
            collector2.addMessage(library2.getName() + " library was added to module " + module.getName());
        } else {
            DependencyScope libraryDependencyScope;
            OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(module).orderEntries");
            LibraryOrderEntry libraryEntry = KotlinWithLibraryConfigurator.Companion.findLibraryOrderEntry(orderEntryArray, kotlinLibrary);
            if (libraryEntry != null && Intrinsics.areEqual((Object)expectedDependencyScope, (Object)(libraryDependencyScope = libraryEntry.getScope())) ^ true) {
                libraryEntry.setScope(expectedDependencyScope);
                collector2.addMessage(kotlinLibrary.getName() + " library scope has changed from " + libraryDependencyScope + " to " + expectedDependencyScope + " for module " + module.getName());
            }
        }
    }

    @NotNull
    public final Library createNewLibrary(@NotNull Project project, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        Library library2 = (Library)ApplicationUtilsKt.runWriteAction((Function0)new Function0<Library>(this, table){
            final /* synthetic */ KotlinWithLibraryConfigurator this$0;
            final /* synthetic */ LibraryTable $table;

            public final Library invoke() {
                return this.$table.createLibrary(this.this$0.getLibraryName());
            }
            {
                this.this$0 = kotlinWithLibraryConfigurator;
                this.$table = libraryTable;
                super(0);
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        String string = library2.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        collector2.addMessage(stringBuilder.append(string).append(" library was created").toString());
        Library library3 = library2;
        if (library3 == null) {
            Intrinsics.throwNpe();
        }
        return library3;
    }

    private final boolean isProjectLibraryPresent(Project project) {
        Library library2 = this.getKotlinLibrary(project);
        return library2 != null && ((Object[])library2.getUrls(OrderRootType.CLASSES)).length > 0;
    }

    @NotNull
    protected abstract Function1<Library, Boolean> getLibraryMatcher();

    @Nullable
    public final Library getKotlinLibrary(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary(module, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(this){

            public final boolean invoke(@NotNull Library p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KotlinWithLibraryConfigurator.access$isKotlinLibrary((KotlinWithLibraryConfigurator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinWithLibraryConfigurator.class);
            }

            public final String getName() {
                return "isKotlinLibrary";
            }

            public final String getSignature() {
                return "isKotlinLibrary(Lcom/intellij/openapi/roots/libraries/Library;)Z";
            }
        }));
    }

    private final boolean isKotlinLibrary(Library library2) {
        return Intrinsics.areEqual((Object)library2.getName(), (Object)this.getLibraryName()) || (Boolean)this.getLibraryMatcher().invoke((Object)library2) != false;
    }

    protected final boolean needToChooseJarPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String defaultPath = this.getDefaultPathToJarFile(project);
        return !this.isProjectLibraryPresent(project) && !new File(defaultPath, ((LibraryJarDescriptor)((Object)CollectionsKt.first(this.getLibraryJarDescriptors(null)))).getJarName()).exists();
    }

    @NotNull
    protected String getDefaultPathToJarFile(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = FileUIUtils.createRelativePath(project, project.getBaseDir(), Companion.getDEFAULT_LIBRARY_DIR());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUIUtils.createRelati\u2026Dir, DEFAULT_LIBRARY_DIR)");
        return string;
    }

    @NotNull
    protected final FileState getJarState(@NotNull Project project, @NotNull File targetFile, @NotNull OrderRootType jarType, boolean useBundled) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetFile, (String)"targetFile");
        Intrinsics.checkParameterIsNotNull((Object)jarType, (String)"jarType");
        if (targetFile.exists()) {
            return FileState.EXISTS;
        }
        if (this.getPathFromLibrary(project, jarType) != null) {
            return FileState.COPY;
        }
        if (useBundled) {
            return FileState.DO_NOT_COPY;
        }
        return FileState.COPY;
    }

    private final String getPathToCopyFileTo(Project project, OrderRootType jarType, String defaultDir, String pathFromDialog) {
        if (pathFromDialog != null) {
            return pathFromDialog;
        }
        String pathFromLibrary = this.getPathFromLibrary(project, jarType);
        if (pathFromLibrary != null) {
            return pathFromLibrary;
        }
        return defaultDir;
    }

    @NotNull
    public abstract List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk var1);

    protected void configureKotlinSettings(@NotNull List<? extends Module> modules) {
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
    }

    static {
        DEFAULT_LIBRARY_DIR = DEFAULT_LIBRARY_DIR;
    }

    public static final /* synthetic */ boolean access$isKotlinLibrary(KotlinWithLibraryConfigurator $this, @NotNull Library library2) {
        return $this.isKotlinLibrary(library2);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "", "(Ljava/lang/String;I)V", "EXISTS", "COPY", "DO_NOT_COPY", "idea"})
    public static final class FileState
    extends Enum<FileState> {
        public static final /* enum */ FileState EXISTS;
        public static final /* enum */ FileState COPY;
        public static final /* enum */ FileState DO_NOT_COPY;
        private static final /* synthetic */ FileState[] $VALUES;

        static {
            FileState[] fileStateArray = new FileState[3];
            FileState[] fileStateArray2 = fileStateArray;
            fileStateArray[0] = EXISTS = new FileState();
            fileStateArray[1] = COPY = new FileState();
            fileStateArray[2] = DO_NOT_COPY = new FileState();
            $VALUES = fileStateArray;
        }

        public static FileState[] values() {
            return (FileState[])$VALUES.clone();
        }

        public static FileState valueOf(String string) {
            return Enum.valueOf(FileState.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$Companion;", "", "()V", "DEFAULT_LIBRARY_DIR", "", "getDEFAULT_LIBRARY_DIR", "()Ljava/lang/String;", "findLibraryOrderEntry", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "orderEntries", "", "Lcom/intellij/openapi/roots/OrderEntry;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "([Lcom/intellij/openapi/roots/OrderEntry;Lcom/intellij/openapi/roots/libraries/Library;)Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getDependencyScope", "Lcom/intellij/openapi/roots/DependencyScope;", "module", "Lcom/intellij/openapi/module/Module;", "getPathFromLibrary", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "getPathFromLibraryUrls", "libraryFiles", "([Ljava/lang/String;)Ljava/lang/String;", "isApplicable", "", "idea"})
    public static final class Companion {
        @NotNull
        public final String getDEFAULT_LIBRARY_DIR() {
            return DEFAULT_LIBRARY_DIR;
        }

        protected final boolean isApplicable(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            return !KotlinPluginUtil.isAndroidGradleModule(module) && !KotlinPluginUtil.isMavenModule(module) && !KotlinPluginUtil.isGradleModule(module);
        }

        @Nullable
        public final String getPathFromLibrary(@Nullable Library library2, @NotNull OrderRootType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (library2 == null) {
                return null;
            }
            String[] libraryFiles = library2.getUrls(type2);
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryFiles, (String)"libraryFiles");
            return this.getPathFromLibraryUrls(libraryFiles);
        }

        @Nullable
        public final String getPathFromLibraryUrls(@NotNull String[] libraryFiles) {
            Intrinsics.checkParameterIsNotNull((Object)libraryFiles, (String)"libraryFiles");
            if (((Object[])libraryFiles).length < 1) {
                return null;
            }
            String pathToJarInLib = VfsUtilCore.urlToPath((String)libraryFiles[0]);
            String string = VfsUtil.getParentDir((String)VfsUtil.getParentDir((String)pathToJarInLib));
            if (string == null) {
                return null;
            }
            String parentDir = string;
            File parentDirFile = new File(parentDir);
            if (!parentDirFile.exists() && !parentDirFile.mkdirs()) {
                return null;
            }
            return parentDir;
        }

        private final LibraryOrderEntry findLibraryOrderEntry(OrderEntry[] orderEntries, Library library2) {
            for (int i = 0; i < orderEntries.length; ++i) {
                OrderEntry orderEntry = orderEntries[i];
                if (!(orderEntry instanceof LibraryOrderEntry) || !Intrinsics.areEqual((Object)library2, (Object)((LibraryOrderEntry)orderEntry).getLibrary())) continue;
                return (LibraryOrderEntry)orderEntry;
            }
            return null;
        }

        private final DependencyScope getDependencyScope(Module module) {
            if (ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module)) {
                return DependencyScope.TEST;
            }
            return DependencyScope.COMPILE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

