/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.SMAPKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinStackFrame;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190\u00072\u0006\u0010/\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00072\u0006\u0010\u0011\u001a\u00020\u000eJ\f\u00101\u001a\u000202*\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "scopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "requestor", "position", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "expression", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineNumber", "", "getLambdaOrFunIfInside", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getPsiFileByLocation", "Lcom/intellij/psi/PsiFile;", "getSourcePosition", "locationsOfLine", "type", "originalClassNamesForPosition", "containsKotlinStrata", "", "idea"})
public final class KotlinPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private final List<GlobalSearchScope> scopes;
    private final DebugProcess myDebugProcess;

    @Nullable
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location2, @NotNull String expression2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return ThreeState.UNSURE;
    }

    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        if (this.containsKotlinStrata(location2.declaringType())) {
            return (XStackFrame)new KotlinStackFrame(frame);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) {
        int javaSourceFileName2;
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile = this.getPsiFileByLocation(location2);
        if (psiFile == null) {
            boolean isKotlinStrataAvailable = this.containsKotlinStrata(location2.declaringType());
            if (isKotlinStrataAvailable) {
                try {
                    Project project3;
                    String javaSourceFileName2 = location2.sourceName("Java");
                    JvmClassName javaClassName = JvmClassName.byInternalName(this.defaultInternalName(location2));
                    Project project2 = project3 = this.myDebugProcess.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    JvmClassName jvmClassName = javaClassName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"javaClassName");
                    String string = javaSourceFileName2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.scopes, jvmClassName, string);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName2) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            javaSourceFileName2 = location2.lineNumber() - 1;
        }
        catch (InternalError e) {
            javaSourceFileName2 = -1;
        }
        int sourceLineNumber = javaSourceFileName2;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location2, (KtFile)psiFile, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location2, (KtFile)psiFile, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        if (sourceLineNumber > KotlinRefactoringUtilKt.getLineCount((PsiElement)psiFile) && NoStrataPositionManagerHelperKt.isDexDebug(this.myDebugProcess)) {
            void line;
            void ktFile;
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            Pair<Integer, KtFile> pair2 = NoStrataPositionManagerHelperKt.ktLocationInfo(location2, true, project, false, (KtFile)psiFile);
            int project3 = ((Number)pair2.component1()).intValue();
            KtFile defaultPsiFile = (KtFile)pair2.component2();
            pair2 = null;
            void v8 = ktFile;
            return SourcePosition.createFromLine((PsiFile)(v8 != null ? (PsiFile)v8 : psiFile), (int)(line - true));
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)sourceLineNumber);
    }

    /*
     * Unable to fully structure code
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block13: {
            block10: {
                block12: {
                    block11: {
                        block9: {
                            v0 = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber);
                            if (v0 == null) {
                                return null;
                            }
                            lineStartOffset = v0;
                            elementAt = file.findElementAt(lineStartOffset);
                            contextElement = KotlinCodeFragmentFactory.Companion.getContextElement(elementAt);
                            if (!(contextElement instanceof KtClass)) {
                                return null;
                            }
                            methodName = location.method().name();
                            if (!JvmAbi.isGetterName(methodName)) break block10;
                            v1 = ((KtClass)contextElement).getPrimaryConstructor();
                            if (v1 == null || (v1 = v1.getValueParameters()) == null) break block11;
                            $receiver$iv = (Iterable)v1;
                            for (T element$iv : $receiver$iv) {
                                it = (KtParameter)element$iv;
                                if (!it.hasValOrVar() || it.getName() == null) ** GOTO lbl-1000
                                v2 = it.getName();
                                if (v2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (Intrinsics.areEqual((Object)JvmAbi.getterName(v2), (Object)methodName)) {
                                    v3 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v3 = false;
                                }
                                if (!v3) continue;
                                v4 = element$iv;
                                break block9;
                            }
                            v4 = null;
                        }
                        if ((v1 = (KtParameter)v4) != null) break block12;
                    }
                    return null;
                }
                parameterForGetter = v1;
                v5 = (KtElement)parameterForGetter;
                break block13;
            }
            v5 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v5;
    }

    private final KtFunction getLambdaOrFunIfInside(Location location2, KtFile file2, int lineNumber) {
        PsiElement elementAt;
        String string = location2.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        Integer start = CodeInsightUtils.getStartLineOffset((PsiFile)file2, lineNumber);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)file2, lineNumber);
        if (start == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file2, lineNumber);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        PsiElement psiElement2 = file2.findElementAt(start);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"elementAt");
        KotlinTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper(psiElement3);
        String currentLocationClassName = StringsKt.replace$default((String)JvmClassName.byFqNameWithoutInnerClasses(new FqName(currentLocationFqName)).getInternalName(), (char)'/', (char)'.', (boolean)false, (int)4, null);
        for (KtFunction literal : literalsOrFunctions) {
            boolean bl;
            block8: {
                if (InlineUtil.isInlinedArgument(literal, typeMapper.getBindingContext(), true)) {
                    DebugProcess debugProcess = this.myDebugProcess;
                    if (debugProcess == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    }
                    if (!DebuggerUtilKt.isInsideInlineArgument(literal, location2, (DebugProcessImpl)debugProcess)) continue;
                    return literal;
                }
                List<String> internalClassNames = new DebuggerClassNameProvider(this.myDebugProcess, this.scopes, false, false, 4, null).getOuterClassNamesForElement(literal.getFirstChild()).getClassNames();
                Iterable $receiver$iv = internalClassNames;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (!bl) continue;
            return literal;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location2) {
        Project project;
        String string;
        String sourceName;
        try {
            String string2 = location2.sourceName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"location.sourceName()");
            sourceName = string2;
        }
        catch (AbsentInformationException e) {
            return null;
        }
        catch (InternalError e) {
            return null;
        }
        try {
            string = this.containsKotlinStrata(location2.declaringType()) ? StringsKt.replace$default((String)location2.sourcePath(), (char)'\\', (char)'/', (boolean)false, (int)4, null) : this.defaultInternalName(location2);
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location2);
        }
        String referenceInternalName = string;
        JvmClassName className2 = JvmClassName.byInternalName(referenceInternalName);
        Project project2 = project = this.myDebugProcess.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        JvmClassName jvmClassName = className2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.scopes, jvmClassName, sourceName);
    }

    private final String defaultInternalName(Location location2) {
        String referenceFqName = location2.declaringType().name();
        return StringsKt.replace$default((String)referenceFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition) {
        PsiFile $receiver$iv;
        PsiFile decompiledPsiFile;
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition.getFile();
        if (psiFile instanceof KtFile) {
            PsiFile psiFile2 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"psiFile");
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile2)) {
                return CollectionsKt.emptyList();
            }
            return new DebuggerClassNameProvider(this.myDebugProcess, this.scopes, false, false, 12, null).getClassesForPosition(sourcePosition);
        }
        if (psiFile instanceof ClsFileImpl && (decompiledPsiFile = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiFile>((Object)($receiver$iv = psiFile)){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final PsiFile invoke() {
                ClsFileImpl it = (ClsFileImpl)this.receiver$0;
                return it.getDecompiledPsiFile();
            }
        })) instanceof KtClsFile && sourcePosition.getLine() == -1) {
            String className2 = FileClasses.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)decompiledPsiFile).getFileClassFqName());
            List list2 = this.myDebugProcess.getVirtualMachineProxy().classesByName(className2);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"myDebugProcess.virtualMa\u2026.classesByName(className)");
            return list2;
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
        throw (Throwable)noDataException;
    }

    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position2) {
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        return new DebuggerClassNameProvider(this.myDebugProcess, this.scopes, false, false, 8, null).getOuterClassNamesForPosition(position2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        if (!(position2.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            List locations;
            List list2;
            List inlineLocations2;
            if (NoStrataPositionManagerHelperKt.isDexDebug(this.myDebugProcess) && !(inlineLocations2 = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends Location>>(this, type2, position2){
                final /* synthetic */ KotlinPositionManager this$0;
                final /* synthetic */ ReferenceType $type;
                final /* synthetic */ SourcePosition $position;

                @NotNull
                public final List<Location> invoke() {
                    GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                    return NoStrataPositionManagerHelperKt.getLocationsOfInlinedLine(this.$type, this.$position, globalSearchScope);
                }
                {
                    this.this$0 = kotlinPositionManager;
                    this.$type = referenceType;
                    this.$position = sourcePosition;
                    super(0);
                }
            })).isEmpty()) {
                return inlineLocations2;
            }
            int line = position2.getLine() + 1;
            if (this.myDebugProcess.getVirtualMachineProxy().versionHigher("1.4")) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)type2.locationsOfLine(SMAPKt.getKOTLIN_STRATA_NAME(), null, line);
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    Location it = (Location)element$iv$iv;
                    if (!Intrinsics.areEqual((Object)it.sourceName(SMAPKt.getKOTLIN_STRATA_NAME()), (Object)position2.getFile().getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = locations = type2.locationsOfLine(line);
            }
            if (locations == null || locations.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
                throw (Throwable)noDataException;
            }
            return locations;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun")
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        if (!(position2.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)noDataException), (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        List<String> classNames2 = new DebuggerClassNameProvider(this.myDebugProcess, this.scopes, false, false, 12, null).getOuterClassNamesForPosition(position2);
        Iterable iterable = $receiver$iv = (Iterable)classNames2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassPrepareRequest classPrepareRequest;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            String name2 = (String)element$iv$iv;
            if (this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, name2 + "*") == null) continue;
            ClassPrepareRequest it$iv$iv = classPrepareRequest;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean containsKotlinStrata(@NotNull ReferenceType $receiver) {
        return $receiver.availableStrata().contains(SMAPKt.getKOTLIN_STRATA_NAME());
    }

    public KotlinPositionManager(@NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        Object[] objectArray = new GlobalSearchScope[2];
        objectArray[0] = this.myDebugProcess.getSearchScope();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myDebugProcess.project)");
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
        objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, project);
        this.scopes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final /* synthetic */ DebugProcess access$getMyDebugProcess$p(KotlinPositionManager $this) {
        return $this.myDebugProcess;
    }
}

