/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0001\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"createTemplateSequenceTokenString", "", "input", "deduceBlockSelectionWidth", "", "startOffsets", "", "endOffsets", "text", "findContainingTemplate", "Lcom/intellij/psi/PsiElement;", "getTemplateIfAtLiteral", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/psi/PsiFile;", "offset", "idea"})
public final class KotlinLiteralCopyPasteProcessorKt {
    private static final PsiElement findContainingTemplate(@NotNull PsiElement $receiver) {
        PsiElement psiElement2;
        PsiElement parent2 = $receiver.getParent();
        if (parent2 instanceof KtStringTemplateEntry) {
            PsiElement psiElement3 = ((KtStringTemplateEntry)parent2).getParent();
            psiElement2 = psiElement3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"parent.parent");
        } else {
            PsiElement psiElement4 = parent2;
            psiElement2 = psiElement4;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"parent");
        }
        return psiElement2;
    }

    private static final KtStringTemplateExpression getTemplateIfAtLiteral(@NotNull PsiFile $receiver, int offset2) {
        KtStringTemplateExpression ktStringTemplateExpression;
        IElementType iElementType;
        PsiElement psiElement2 = $receiver.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement at = psiElement2;
        ASTNode aSTNode = at.getNode();
        Object object = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.REGULAR_STRING_PART)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ESCAPE_SEQUENCE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START))) {
            PsiElement psiElement3 = at.getParent().getParent();
            if (!(psiElement3 instanceof KtStringTemplateExpression)) {
                psiElement3 = null;
            }
            ktStringTemplateExpression = (KtStringTemplateExpression)psiElement3;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.CLOSING_QUOTE))) {
            if (offset2 == PsiUtilsKt.getStartOffset(at)) {
                PsiElement psiElement4 = at.getParent();
                if (!(psiElement4 instanceof KtStringTemplateExpression)) {
                    psiElement4 = null;
                }
                ktStringTemplateExpression = (KtStringTemplateExpression)psiElement4;
            } else {
                ktStringTemplateExpression = null;
            }
        } else {
            ktStringTemplateExpression = null;
        }
        return ktStringTemplateExpression;
    }

    /*
     * WARNING - void declaration
     */
    private static final int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        boolean bl;
        int fragmentCount = startOffsets.length;
        boolean bl2 = bl = fragmentCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int totalLength = fragmentCount - 1;
        int n = 0;
        int n2 = fragmentCount - 1;
        if (n <= n2) {
            while (true) {
                void i;
                totalLength += endOffsets[i] - startOffsets[i];
                if (i == n2) break;
                ++i;
            }
        }
        if (totalLength < text2.length() && (text2.length() + 1) % fragmentCount == 0) {
            return (text2.length() + 1) / fragmentCount - 1;
        }
        return -1;
    }

    @NotNull
    public static final String createTemplateSequenceTokenString(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)new TemplateTokenSequence(input), (Function1)createTemplateSequenceTokenString.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ int access$deduceBlockSelectionWidth(@NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text2) {
        return KotlinLiteralCopyPasteProcessorKt.deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
    }

    @NotNull
    public static final /* synthetic */ PsiElement access$findContainingTemplate(@NotNull PsiElement $receiver) {
        return KotlinLiteralCopyPasteProcessorKt.findContainingTemplate($receiver);
    }

    @Nullable
    public static final /* synthetic */ KtStringTemplateExpression access$getTemplateIfAtLiteral(@NotNull PsiFile $receiver, int offset2) {
        return KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral($receiver, offset2);
    }
}

