/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.ui.SimpleColoredComponent;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;

class Utils {
    private Utils() {
    }

    public static void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent, @NotNull KtNamedDeclaration declaration2) {
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "configureLabelComponent"));
        }
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "configureLabelComponent"));
        }
        coloredComponent.append(DescriptorRenderer.COMPACT.render(UtilsKt.getDescriptor(declaration2)));
    }

    static boolean renameCheckbox(@NotNull JPanel panel, @NotNull String srcText, @NotNull String destText) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "renameCheckbox"));
        }
        if (srcText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcText", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "renameCheckbox"));
        }
        if (destText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destText", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "renameCheckbox"));
        }
        for (Component component : panel.getComponents()) {
            JCheckBox checkBox;
            if (!(component instanceof JCheckBox) || !(checkBox = (JCheckBox)component).getText().equals(srcText)) continue;
            checkBox.setText(destText);
            return true;
        }
        return false;
    }

    static boolean removeCheckbox(@NotNull JPanel panel, @NotNull String srcText) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "removeCheckbox"));
        }
        if (srcText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcText", "org/jetbrains/kotlin/idea/findUsages/dialogs/Utils", "removeCheckbox"));
        }
        for (Component component : panel.getComponents()) {
            JCheckBox checkBox;
            if (!(component instanceof JCheckBox) || !(checkBox = (JCheckBox)component).getText().equals(srcText)) continue;
            panel.remove(checkBox);
            return true;
        }
        return false;
    }
}

