/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.formatter.WrappingStrategy;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fJ \u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H$J<\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H$J\n\u0010\"\u001a\u0004\u0018\u00010\u0019H$J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0017H$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\tH$J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\fH$J\u0010\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020(H$J\b\u0010-\u001a\u00020\u0012H\u0002J\b\u0010.\u001a\u00020\u0017H$J\u0006\u0010/\u001a\u00020\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock;", "", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "alignmentStrategy", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;)V", "mySubBlocks", "", "Lcom/intellij/formatting/Block;", "buildChildren", "buildSubBlock", "child", "wrappingStrategy", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "buildSubBlocks", "Ljava/util/ArrayList;", "createAlignmentStrategy", "alignOption", "", "defaultAlignment", "Lcom/intellij/formatting/Alignment;", "createBlock", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "Lcom/intellij/formatting/Wrap;", "createChildIndent", "createSyntheticSpacingNodeBlock", "Lcom/intellij/formatting/ASTBlock;", "getAlignment", "getAlignmentForCaseBranch", "shouldAlignInColumns", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getChildrenAlignmentStrategy", "getNullAlignmentStrategy", "getSubBlocks", "getSuperChildAttributes", "getWrappingStrategy", "isIncompleteInSuper", "isLeaf", "formatter"})
public abstract class KotlinCommonBlock {
    private volatile List<? extends Block> mySubBlocks;
    private final ASTNode node;
    private final CodeStyleSettings settings;
    private final KotlinSpacingBuilder spacingBuilder;
    private final CommonAlignmentStrategy alignmentStrategy;

    @NotNull
    protected abstract Block createBlock(@NotNull ASTNode var1, @NotNull CommonAlignmentStrategy var2, @Nullable Indent var3, @Nullable Wrap var4, @NotNull CodeStyleSettings var5, @NotNull KotlinSpacingBuilder var6);

    @NotNull
    protected abstract ASTBlock createSyntheticSpacingNodeBlock(@NotNull ASTNode var1);

    @NotNull
    protected abstract List<Block> getSubBlocks();

    @NotNull
    protected abstract ChildAttributes getSuperChildAttributes(int var1);

    protected abstract boolean isIncompleteInSuper();

    @NotNull
    protected abstract CommonAlignmentStrategy getAlignmentForCaseBranch(boolean var1);

    @Nullable
    protected abstract Alignment getAlignment();

    @NotNull
    protected abstract CommonAlignmentStrategy createAlignmentStrategy(boolean var1, @Nullable Alignment var2);

    @NotNull
    protected abstract CommonAlignmentStrategy getNullAlignmentStrategy();

    public final boolean isLeaf() {
        return this.node.getFirstChildNode() == null;
    }

    @NotNull
    public final List<Block> buildChildren() {
        if (this.mySubBlocks != null) {
            List<Block> list2 = this.mySubBlocks;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            return list2;
        }
        ArrayList<Object> nodeSubBlocks = this.buildSubBlocks();
        if (this.node.getElementType() == KtNodeTypes.DOT_QUALIFIED_EXPRESSION || this.node.getElementType() == KtNodeTypes.SAFE_ACCESS_EXPRESSION) {
            List list3 = nodeSubBlocks;
            TokenSet tokenSet = KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"QUALIFIED_OPERATION");
            int operationBlockIndex = KotlinCommonBlockKt.access$findNodeBlockIndex(list3, tokenSet);
            if (operationBlockIndex != -1) {
                Block operationBlock;
                Block block = operationBlock = nodeSubBlocks.get(operationBlockIndex);
                if (block == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.formatting.ASTBlock");
                }
                ASTNode aSTNode = ((ASTBlock)block).getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"(operationBlock as ASTBlock).node");
                List<Block> list4 = nodeSubBlocks.subList(operationBlockIndex, nodeSubBlocks.size());
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"nodeSubBlocks.subList(op\u2026ndex, nodeSubBlocks.size)");
                SyntheticKotlinBlock operationSyntheticBlock2 = new SyntheticKotlinBlock(aSTNode, list4, null, operationBlock.getIndent(), null, this.spacingBuilder, (Function1<? super ASTNode, ? extends ASTBlock>)((Function1)new Function1<ASTNode, ASTBlock>(this){
                    final /* synthetic */ KotlinCommonBlock this$0;

                    @NotNull
                    public final ASTBlock invoke(@NotNull ASTNode it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.this$0.createSyntheticSpacingNodeBlock(it);
                    }
                    {
                        this.this$0 = kotlinCommonBlock;
                        super(1);
                    }
                }));
                nodeSubBlocks = new ArrayList(nodeSubBlocks.subList(0, operationBlockIndex));
                nodeSubBlocks.add((Block)operationSyntheticBlock2);
            }
        }
        this.mySubBlocks = nodeSubBlocks;
        return nodeSubBlocks;
    }

    @Nullable
    public final Indent createChildIndent(@NotNull ASTNode child) {
        ASTNode prev2;
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        ASTNode childParent = child.getTreeParent();
        IElementType childType = child.getElementType();
        if (childParent != null && childParent.getTreeParent() != null && childParent.getElementType() == KtNodeTypes.BLOCK && childParent.getTreeParent().getElementType() == KtNodeTypes.SCRIPT) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child)) != null && KtTokens.COMMENTS.contains(prev2.getElementType()) && KotlinCommonBlockKt.access$getPrevWithoutWhitespaceAndComments(prev2) == null) {
            return Indent.getNoneIndent();
        }
        NodeIndentStrategy[] nodeIndentStrategyArray = KotlinCommonBlockKt.access$getINDENT_RULES$p();
        for (int i = 0; i < nodeIndentStrategyArray.length; ++i) {
            NodeIndentStrategy strategy = nodeIndentStrategyArray[i];
            Indent indent = strategy.getIndent(child);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType parentType = childParent.getElementType();
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child);
                if (childType == KtTokens.RPAR && (prev3 == null || prev3.getElementType() != TokenType.ERROR_ELEMENT)) {
                    return Indent.getNoneIndent();
                }
                return Indent.getContinuationWithoutFirstIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @NotNull
    public final ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        IElementType type2 = this.node.getElementType();
        if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)((Object)KtNodeTypes.BLOCK)) && Intrinsics.areEqual((Object)this.node.getTreeParent().getElementType(), (Object)KtNodeTypes.SCRIPT)) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.IF))) {
            Block elseBlock;
            List<? extends Block> list2 = this.mySubBlocks;
            Block block = elseBlock = list2 != null ? (Block)CollectionsKt.getOrNull(list2, (int)newChildIndex) : null;
            if (elseBlock instanceof ASTBlock && Intrinsics.areEqual((Object)((ASTBlock)elseBlock).getNode().getElementType(), (Object)((Object)KtTokens.ELSE_KEYWORD))) {
                ChildAttributes childAttributes2 = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                Intrinsics.checkExpressionValueIsNotNull((Object)childAttributes2, (String)"ChildAttributes.DELEGATE_TO_NEXT_CHILD");
                return childAttributes2;
            }
        }
        IElementType iElementType = type2;
        if (KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.WHEN)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.IF)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.FOR)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.WHILE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.DO_WHILE))) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.TRY))) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.SAFE_ACCESS_EXPRESSION))) {
            childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.VALUE_ARGUMENT_LIST))) {
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < subBlocks.size()) {
                Block block = subBlocks.get(newChildIndex);
                childAttributes = new ChildAttributes(block.getIndent(), block.getAlignment());
            } else {
                childAttributes = new ChildAttributes(Indent.getContinuationIndent(), null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DOC_COMMENT)) {
            childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)KotlinCommonBlockKt.access$getKDOC_COMMENT_INDENT$p()), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.PARENTHESIZED))) {
            childAttributes = this.getSuperChildAttributes(newChildIndex);
        } else {
            List<Block> blocks = this.getSubBlocks();
            if (newChildIndex != 0) {
                boolean isIncomplete;
                boolean bl = isIncomplete = newChildIndex < blocks.size() ? blocks.get(newChildIndex - 1).isIncomplete() : this.isIncompleteInSuper();
                if (isIncomplete) {
                    return this.getSuperChildAttributes(newChildIndex);
                }
            }
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        }
        return childAttributes;
    }

    private final CommonAlignmentStrategy getChildrenAlignmentStrategy() {
        CommonAlignmentStrategy commonAlignmentStrategy;
        CommonCodeStyleSettings jetCommonSettings = this.settings.getCommonSettings((Language)KotlinLanguage.INSTANCE);
        KotlinCodeStyleSettings jetSettings = (KotlinCodeStyleSettings)this.settings.getCustomSettings(KotlinCodeStyleSettings.class);
        IElementType parentType = this.node.getElementType();
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            boolean bl = jetCommonSettings.ALIGN_MULTILINE_PARAMETERS;
            IElementType iElementType = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"KtNodeTypes.VALUE_PARAMETER");
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType2 = ktSingleValueToken;
            boolean bl2 = jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken2 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LPAR");
            IElementType iElementType3 = ktSingleValueToken2;
            KtSingleValueToken ktSingleValueToken3 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType, iElementType2, bl2, iElementType3, ktSingleValueToken3);
        } else if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            boolean bl = jetCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            KtNodeType ktNodeType = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.VALUE_ARGUMENT");
            IElementType iElementType = ktNodeType;
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType4 = ktSingleValueToken;
            boolean bl3 = jetCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken4 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LPAR");
            IElementType iElementType5 = ktSingleValueToken4;
            KtSingleValueToken ktSingleValueToken5 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType, iElementType4, bl3, iElementType5, ktSingleValueToken5);
        } else {
            commonAlignmentStrategy = parentType == KtNodeTypes.WHEN ? this.getAlignmentForCaseBranch(jetSettings.ALIGN_IN_COLUMNS_CASE_BRANCH) : (parentType == KtNodeTypes.WHEN_ENTRY ? this.alignmentStrategy : (KotlinCommonBlockKt.access$getBINARY_EXPRESSIONS$p().contains(parentType) && KotlinCommonBlockKt.access$getALIGN_FOR_BINARY_OPERATIONS$p().contains(KotlinCommonBlockKt.access$getOperationType(this.node)) ? this.createAlignmentStrategy(jetCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()) : (parentType == KtNodeTypes.SUPER_TYPE_LIST || parentType == KtNodeTypes.INITIALIZER_LIST ? this.createAlignmentStrategy(jetCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()) : (parentType == KtNodeTypes.PARENTHESIZED ? (CommonAlignmentStrategy)new CommonAlignmentStrategy(jetCommonSettings){
                private Alignment bracketsAlignment;
                final /* synthetic */ CommonCodeStyleSettings $jetCommonSettings;

                @Nullable
                public Alignment getAlignment(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    IElementType childNodeType = node.getElementType();
                    ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
                {
                    this.$jetCommonSettings = $captured_local_variable$0;
                    this.bracketsAlignment = $captured_local_variable$0.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }
            } : this.getNullAlignmentStrategy()))));
        }
        return commonAlignmentStrategy;
    }

    private final Block buildSubBlock(ASTNode child, CommonAlignmentStrategy alignmentStrategy, WrappingStrategy wrappingStrategy) {
        ASTNode operationNode;
        IElementType iElementType = child.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"child.elementType");
        Wrap childWrap = wrappingStrategy.getWrap(iElementType);
        if (child.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            return this.createBlock(operationNode, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder);
        }
        return this.createBlock(child, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder);
    }

    private final ArrayList<Block> buildSubBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        CommonAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        WrappingStrategy wrappingStrategy = this.getWrappingStrategy();
        ASTNode child = this.node.getFirstChildNode();
        while (child != null) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().getLength() == 0) {
                child = child.getTreeNext();
                continue;
            }
            if (childType == TokenType.WHITE_SPACE) {
                child = child.getTreeNext();
                continue;
            }
            blocks.add(this.buildSubBlock(child, childrenAlignmentStrategy, wrappingStrategy));
            child = child.getTreeNext();
        }
        return blocks;
    }

    private final WrappingStrategy getWrappingStrategy() {
        IElementType parentElementType;
        CommonCodeStyleSettings commonSettings = this.settings.getCommonSettings((Language)KotlinLanguage.INSTANCE);
        IElementType elementType = this.node.getElementType();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            int n = commonSettings.CALL_PARAMETERS_WRAP;
            KtNodeType ktNodeType = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.VALUE_ARGUMENT");
            return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, ktNodeType);
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST && ((parentElementType = this.node.getTreeParent().getElementType()) == KtNodeTypes.FUN || parentElementType == KtNodeTypes.PRIMARY_CONSTRUCTOR || parentElementType == KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
            int n = commonSettings.METHOD_PARAMETERS_WRAP;
            IElementType iElementType = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"KtNodeTypes.VALUE_PARAMETER");
            return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, iElementType);
        }
        return WrappingStrategy.NoWrapping.INSTANCE;
    }

    public KotlinCommonBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings2, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull CommonAlignmentStrategy alignmentStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkParameterIsNotNull((Object)alignmentStrategy, (String)"alignmentStrategy");
        this.node = node;
        this.settings = settings2;
        this.spacingBuilder = spacingBuilder;
        this.alignmentStrategy = alignmentStrategy;
    }
}

