/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.WrappingStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002\u001a\u0014\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0017H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u000b\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"ALIGN_FOR_BINARY_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "BINARY_EXPRESSIONS", "CODE_BLOCKS", "INDENT_RULES", "", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "[Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "KDOC_COMMENT_INDENT", "", "KDOC_CONTENT", "QUALIFIED_OPERATION", "findNodeBlockIndex", "blocks", "", "Lcom/intellij/formatting/Block;", "tokenSet", "getAlignmentForChildInParenthesis", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "shouldAlignChild", "", "parameter", "Lcom/intellij/psi/tree/IElementType;", "delimiter", "shouldAlignParenthesis", "openBracket", "closeBracket", "getOperationType", "node", "Lcom/intellij/lang/ASTNode;", "getPrevWithoutWhitespace", "pNode", "getPrevWithoutWhitespaceAndComments", "getWrappingStrategyForItemList", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "wrapType", "itemType", "formatter"})
public final class KotlinCommonBlockKt {
    private static final TokenSet QUALIFIED_OPERATION;
    private static final int KDOC_COMMENT_INDENT = 1;
    private static final TokenSet BINARY_EXPRESSIONS;
    private static final TokenSet KDOC_CONTENT;
    private static final TokenSet CODE_BLOCKS;
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS;
    private static final NodeIndentStrategy[] INDENT_RULES;

    private static final IElementType getOperationType(ASTNode node) {
        ASTNode aSTNode = node.findChildByType((IElementType)KtNodeTypes.OPERATION_REFERENCE);
        return aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null;
    }

    private static final CommonAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, IElementType parameter, IElementType delimiter, boolean shouldAlignParenthesis, IElementType openBracket, IElementType closeBracket) {
        Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new CommonAlignmentStrategy(parameterAlignment, openBracket, closeBracket, bracketsAlignment, parameter, delimiter){
            final /* synthetic */ Alignment $parameterAlignment;
            final /* synthetic */ IElementType $openBracket;
            final /* synthetic */ IElementType $closeBracket;
            final /* synthetic */ Alignment $bracketsAlignment;
            final /* synthetic */ IElementType $parameter;
            final /* synthetic */ IElementType $delimiter;

            @Nullable
            public Alignment getAlignment(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                IElementType childNodeType = node.getElementType();
                ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                    return this.$parameterAlignment;
                }
                if (childNodeType == this.$openBracket || childNodeType == this.$closeBracket) {
                    return this.$bracketsAlignment;
                }
                if (childNodeType == this.$parameter || childNodeType == this.$delimiter) {
                    return this.$parameterAlignment;
                }
                return null;
            }
            {
                this.$parameterAlignment = $captured_local_variable$0;
                this.$openBracket = $captured_local_variable$1;
                this.$closeBracket = $captured_local_variable$2;
                this.$bracketsAlignment = $captured_local_variable$3;
                this.$parameter = $captured_local_variable$4;
                this.$delimiter = $captured_local_variable$5;
            }
        };
    }

    private static final ASTNode getPrevWithoutWhitespace(ASTNode pNode) {
        ASTNode node = pNode;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        for (node = (v579813).getTreePrev(); node != null && node.getElementType() == TokenType.WHITE_SPACE; node = node.getTreePrev()) {
        }
        return node;
    }

    private static final ASTNode getPrevWithoutWhitespaceAndComments(ASTNode pNode) {
        ASTNode node = pNode;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        for (node = (v579828).getTreePrev(); node != null && (node.getElementType() == TokenType.WHITE_SPACE || KtTokens.COMMENTS.contains(node.getElementType())); node = node.getTreePrev()) {
        }
        return node;
    }

    private static final WrappingStrategy getWrappingStrategyForItemList(int wrapType, IElementType itemType) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)false);
        return new WrappingStrategy(itemType, itemWrap){
            final /* synthetic */ IElementType $itemType;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public Wrap getWrap(@NotNull IElementType childElementType) {
                Intrinsics.checkParameterIsNotNull((Object)childElementType, (String)"childElementType");
                return childElementType == this.$itemType ? this.$itemWrap : null;
            }
            {
                this.$itemType = $captured_local_variable$0;
                this.$itemWrap = $captured_local_variable$1;
            }
        };
    }

    private static final int findNodeBlockIndex(List<? extends Block> blocks, TokenSet tokenSet) {
        int n;
        block2: {
            List<? extends Block> $receiver$iv = blocks;
            int index$iv = 0;
            for (Block block : $receiver$iv) {
                ASTNode node;
                Block block2 = block;
                if (!(block2 instanceof ASTBlock) ? false : (node = ((ASTBlock)block2).getNode()) != null && tokenSet.contains(node.getElementType())) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        QUALIFIED_OPERATION = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
        KDOC_COMMENT_INDENT = 1;
        BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.IS_EXPRESSION});
        KDOC_CONTENT = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
        CODE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL});
        ALIGN_FOR_BINARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.PLUS, KtTokens.MINUS, KtTokens.ELVIS, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.ANDAND, KtTokens.OROR});
        NodeIndentStrategy[] nodeIndentStrategyArray = new NodeIndentStrategy[16];
        NodeIndentStrategy.PositionStrategy positionStrategy = NodeIndentStrategy.strategy("No indent for braces in blocks").in(KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL).forType(KtTokens.RBRACE, KtTokens.LBRACE).set(Indent.getNoneIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy, (String)"strategy(\"No indent for \u2026t(Indent.getNoneIndent())");
        nodeIndentStrategyArray[0] = positionStrategy;
        NodeIndentStrategy.PositionStrategy positionStrategy2 = NodeIndentStrategy.strategy("Indent for block content").in(KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL).notForType(KtTokens.RBRACE, KtTokens.LBRACE, KtNodeTypes.BLOCK).set(Indent.getNormalIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy2, (String)"strategy(\"Indent for blo\u2026t.getNormalIndent(false))");
        nodeIndentStrategyArray[1] = positionStrategy2;
        NodeIndentStrategy.PositionStrategy positionStrategy3 = NodeIndentStrategy.strategy("Indent for property accessors").in(KtNodeTypes.PROPERTY, new IElementType[0]).forType(KtNodeTypes.PROPERTY_ACCESSOR, new IElementType[0]).set(Indent.getNormalIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy3, (String)"strategy(\"Indent for pro\u2026Indent.getNormalIndent())");
        nodeIndentStrategyArray[2] = positionStrategy3;
        NodeIndentStrategy.PositionStrategy positionStrategy4 = NodeIndentStrategy.strategy("For a single statement in 'for'").in(KtNodeTypes.BODY, new IElementType[0]).notForType(KtNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy4, (String)"strategy(\"For a single s\u2026Indent.getNormalIndent())");
        nodeIndentStrategyArray[3] = positionStrategy4;
        NodeIndentStrategy.PositionStrategy positionStrategy5 = NodeIndentStrategy.strategy("For the entry in when").forType(KtNodeTypes.WHEN_ENTRY, new IElementType[0]).set(Indent.getNormalIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy5, (String)"strategy(\"For the entry \u2026Indent.getNormalIndent())");
        nodeIndentStrategyArray[4] = positionStrategy5;
        NodeIndentStrategy.PositionStrategy positionStrategy6 = NodeIndentStrategy.strategy("For single statement in THEN and ELSE").in(KtNodeTypes.THEN, KtNodeTypes.ELSE).notForType(KtNodeTypes.BLOCK, new IElementType[0]).set(Indent.getNormalIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy6, (String)"strategy(\"For single sta\u2026Indent.getNormalIndent())");
        nodeIndentStrategyArray[5] = positionStrategy6;
        NodeIndentStrategy.PositionStrategy positionStrategy7 = NodeIndentStrategy.strategy("Indent for parts").in(KtNodeTypes.PROPERTY, KtNodeTypes.FUN, KtNodeTypes.DESTRUCTURING_DECLARATION, KtNodeTypes.SECONDARY_CONSTRUCTOR).notForType(KtNodeTypes.BLOCK, KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.CONSTRUCTOR_KEYWORD).set(Indent.getContinuationWithoutFirstIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy7, (String)"strategy(\"Indent for par\u2026tionWithoutFirstIndent())");
        nodeIndentStrategyArray[6] = positionStrategy7;
        NodeIndentStrategy.PositionStrategy positionStrategy8 = NodeIndentStrategy.strategy("Chained calls").in(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION).set(Indent.getContinuationWithoutFirstIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy8, (String)"strategy(\"Chained calls\"\u2026ithoutFirstIndent(false))");
        nodeIndentStrategyArray[7] = positionStrategy8;
        NodeIndentStrategy.PositionStrategy positionStrategy9 = NodeIndentStrategy.strategy("Colon of delegation list").in(KtNodeTypes.CLASS, KtNodeTypes.OBJECT_DECLARATION).forType(KtTokens.COLON, new IElementType[0]).set(Indent.getNormalIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy9, (String)"strategy(\"Colon of deleg\u2026t.getNormalIndent(false))");
        nodeIndentStrategyArray[8] = positionStrategy9;
        NodeIndentStrategy.PositionStrategy positionStrategy10 = NodeIndentStrategy.strategy("Delegation list").in(KtNodeTypes.SUPER_TYPE_LIST, KtNodeTypes.INITIALIZER_LIST).set(Indent.getContinuationIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy10, (String)"strategy(\"Delegation lis\u2026ontinuationIndent(false))");
        nodeIndentStrategyArray[9] = positionStrategy10;
        NodeIndentStrategy.PositionStrategy positionStrategy11 = NodeIndentStrategy.strategy("Indices").in(KtNodeTypes.INDICES, new IElementType[0]).set(Indent.getContinuationIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy11, (String)"strategy(\"Indices\")\n    \u2026ontinuationIndent(false))");
        nodeIndentStrategyArray[10] = positionStrategy11;
        NodeIndentStrategy.PositionStrategy positionStrategy12 = NodeIndentStrategy.strategy("Binary expressions").in(BINARY_EXPRESSIONS).set(Indent.getContinuationWithoutFirstIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy12, (String)"strategy(\"Binary express\u2026ithoutFirstIndent(false))");
        nodeIndentStrategyArray[11] = positionStrategy12;
        NodeIndentStrategy.PositionStrategy positionStrategy13 = NodeIndentStrategy.strategy("Parenthesized expression").in(KtNodeTypes.PARENTHESIZED, new IElementType[0]).set(Indent.getContinuationWithoutFirstIndent((boolean)false));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy13, (String)"strategy(\"Parenthesized \u2026ithoutFirstIndent(false))");
        nodeIndentStrategyArray[12] = positionStrategy13;
        NodeIndentStrategy.PositionStrategy positionStrategy14 = NodeIndentStrategy.strategy("Round Brackets around conditions").forType(KtTokens.LPAR, KtTokens.RPAR).in(KtNodeTypes.IF, KtNodeTypes.WHEN_ENTRY, KtNodeTypes.WHILE, KtNodeTypes.DO_WHILE).set(Indent.getContinuationWithoutFirstIndent((boolean)true));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy14, (String)"strategy(\"Round Brackets\u2026WithoutFirstIndent(true))");
        nodeIndentStrategyArray[13] = positionStrategy14;
        NodeIndentStrategy.PositionStrategy positionStrategy15 = NodeIndentStrategy.strategy("KDoc comment indent").in(KDOC_CONTENT).forType(KDocTokens.LEADING_ASTERISK, KDocTokens.END).set(Indent.getSpaceIndent((int)KDOC_COMMENT_INDENT));
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy15, (String)"strategy(\"KDoc comment i\u2026ent(KDOC_COMMENT_INDENT))");
        nodeIndentStrategyArray[14] = positionStrategy15;
        NodeIndentStrategy.PositionStrategy positionStrategy16 = NodeIndentStrategy.strategy("Block in when entry").in(KtNodeTypes.WHEN_ENTRY, new IElementType[0]).notForType(KtNodeTypes.BLOCK, KtNodeTypes.WHEN_CONDITION_EXPRESSION, KtNodeTypes.WHEN_CONDITION_IN_RANGE, KtNodeTypes.WHEN_CONDITION_IS_PATTERN, KtTokens.ELSE_KEYWORD, KtTokens.ARROW).set(Indent.getNormalIndent());
        Intrinsics.checkExpressionValueIsNotNull((Object)positionStrategy16, (String)"strategy(\"Block in when \u2026Indent.getNormalIndent())");
        nodeIndentStrategyArray[15] = positionStrategy16;
        Object[] elements$iv = nodeIndentStrategyArray;
        INDENT_RULES = (NodeIndentStrategy[])var0;
    }

    public static final /* synthetic */ int access$findNodeBlockIndex(@NotNull List blocks, @NotNull TokenSet tokenSet) {
        return KotlinCommonBlockKt.findNodeBlockIndex(blocks, tokenSet);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getQUALIFIED_OPERATION$p() {
        return QUALIFIED_OPERATION;
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespace(@Nullable ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespace(pNode);
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespaceAndComments(@Nullable ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespaceAndComments(pNode);
    }

    @NotNull
    public static final /* synthetic */ NodeIndentStrategy[] access$getINDENT_RULES$p() {
        return INDENT_RULES;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getCODE_BLOCKS$p() {
        return CODE_BLOCKS;
    }

    public static final /* synthetic */ int access$getKDOC_COMMENT_INDENT$p() {
        return KDOC_COMMENT_INDENT;
    }

    @NotNull
    public static final /* synthetic */ CommonAlignmentStrategy access$getAlignmentForChildInParenthesis(boolean shouldAlignChild, @NotNull IElementType parameter, @NotNull IElementType delimiter, boolean shouldAlignParenthesis, @NotNull IElementType openBracket, @NotNull IElementType closeBracket) {
        return KotlinCommonBlockKt.getAlignmentForChildInParenthesis(shouldAlignChild, parameter, delimiter, shouldAlignParenthesis, openBracket, closeBracket);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getBINARY_EXPRESSIONS$p() {
        return BINARY_EXPRESSIONS;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getALIGN_FOR_BINARY_OPERATIONS$p() {
        return ALIGN_FOR_BINARY_OPERATIONS;
    }

    @Nullable
    public static final /* synthetic */ IElementType access$getOperationType(@NotNull ASTNode node) {
        return KotlinCommonBlockKt.getOperationType(node);
    }

    @NotNull
    public static final /* synthetic */ WrappingStrategy access$getWrappingStrategyForItemList(int wrapType, @NotNull IElementType itemType) {
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(wrapType, itemType);
    }
}

