/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a5\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0010\b\u0000\u0010\u0006*\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u001a.\u0010\u000e\u001a\u00020\u000f\"\u0010\b\u0000\u0010\u0006*\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"GRADLE_SYSTEM_ID", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getGRADLE_SYSTEM_ID", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "MAVEN_SYSTEM_ID", "getLibraryProperties", "LP", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "", "provider", "Lcom/intellij/openapi/roots/libraries/LibraryPresentationProvider;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/libraries/LibraryPresentationProvider;Lcom/intellij/openapi/roots/libraries/Library;)Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "isDetected", "", "isExternalLibrary", "idea"})
public final class KotlinLibraryUtilKt {
    private static final ProjectSystemId MAVEN_SYSTEM_ID = new ProjectSystemId("MAVEN");
    @NotNull
    private static final ProjectSystemId GRADLE_SYSTEM_ID = new ProjectSystemId("GRADLE");

    public static final <LP extends LibraryProperties<? extends Object>> boolean isDetected(@NotNull LibraryPresentationProvider<LP> provider2, @NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return KotlinLibraryUtilKt.getLibraryProperties(provider2, library2) != null;
    }

    @Nullable
    public static final <LP extends LibraryProperties<? extends Object>> LP getLibraryProperties(@NotNull LibraryPresentationProvider<LP> provider2, @NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        if (KotlinLibraryUtilKt.isExternalLibrary(library2)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        return (LP)provider2.detect(Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length)));
    }

    @NotNull
    public static final ProjectSystemId getGRADLE_SYSTEM_ID() {
        return GRADLE_SYSTEM_ID;
    }

    public static final boolean isExternalLibrary(@NotNull Library library2) {
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        return ExternalSystemApiUtil.isExternalSystemLibrary((Library)library2, (ProjectSystemId)ProjectSystemId.IDE) || ExternalSystemApiUtil.isExternalSystemLibrary((Library)library2, (ProjectSystemId)GRADLE_SYSTEM_ID) || ExternalSystemApiUtil.isExternalSystemLibrary((Library)library2, (ProjectSystemId)MAVEN_SYSTEM_ID);
    }
}

