/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinRainbowVisitor;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\n\u001a\u00020\u0000H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\u00020\f*\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "addRainbowHighlight", "", "target", "Lcom/intellij/psi/PsiElement;", "rainbowElement", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clone", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "element", "isRainbowDeclaration", "idea"})
public final class KotlinRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2 instanceof KtFile;
    }

    @NotNull
    public KotlinRainbowVisitor clone() {
        return new KotlinRainbowVisitor();
    }

    public void visit(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (this.isRainbowDeclaration(element2)) {
            PsiElement rainbowElement;
            PsiElement psiElement2 = ((KtNamedDeclaration)element2).getNameIdentifier();
            if (psiElement2 == null) {
                return;
            }
            PsiElement psiElement3 = rainbowElement = psiElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"rainbowElement");
            KotlinRainbowVisitor.addRainbowHighlight$default(this, element2, psiElement3, null, 4, null);
        } else if (element2 instanceof KtSimpleNameExpression) {
            Object v3;
            block15: {
                KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtQualifiedExpression.class, (boolean)true, (Class[])new Class[]{KtLambdaExpression.class, KtValueArgumentList.class});
                KtExpression ktExpression = qualifiedExpression;
                if (Intrinsics.areEqual(ktExpression != null && (ktExpression = ktExpression.getSelectorExpression()) != null ? Boolean.valueOf(PsiUtilsKt.isAncestor$default((PsiElement)ktExpression, element2, false, 2, null)) : null, (Object)true)) {
                    return;
                }
                BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element2, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
                Collection<DeclarationDescriptor> targets = BindingContextUtilsKt.getReferenceTargets((KtExpression)element2, bindingContext2);
                Iterable $receiver$iv = targets;
                for (Object element$iv : $receiver$iv) {
                    if (!(element$iv instanceof VariableDescriptor)) continue;
                    v3 = element$iv;
                    break block15;
                }
                v3 = null;
            }
            VariableDescriptor targetVariable = v3;
            if (targetVariable != null) {
                PsiElement targetElement = DescriptorToSourceUtils.getSourceFromDescriptor(targetVariable);
                if (this.isRainbowDeclaration(targetElement)) {
                    PsiElement psiElement4 = targetElement;
                    if (psiElement4 == null) {
                        Intrinsics.throwNpe();
                    }
                    KotlinRainbowVisitor.addRainbowHighlight$default(this, psiElement4, element2, null, 4, null);
                } else if (targetElement == null && Intrinsics.areEqual((Object)((KtSimpleNameExpression)element2).getReferencedName(), (Object)"it")) {
                    KotlinRainbowVisitor.addRainbowHighlight$default(this, element2, element2, null, 4, null);
                }
            }
        } else if (element2 instanceof KDocName) {
            PsiReference psiReference = ((KDocName)element2).getReference();
            if (psiReference == null || (psiReference = psiReference.resolve()) == null) {
                return;
            }
            PsiReference target = psiReference;
            if (this.isRainbowDeclaration((PsiElement)target)) {
                PsiReference psiReference2 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference2, (String)"target");
                this.addRainbowHighlight((PsiElement)psiReference2, element2, KotlinHighlightingColors.KDOC_LINK);
            }
        }
    }

    private final void addRainbowHighlight(PsiElement target, PsiElement rainbowElement, TextAttributesKey attributesKey) {
        TextAttributesKey attributesKeyToUse;
        Iterator lambdaSequenceIterator2 = SequencesKt.filter((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents(target), (Function1)addRainbowHighlight.lambdaSequenceIterator.1.INSTANCE), (Function1)addRainbowHighlight.lambdaSequenceIterator.2.INSTANCE).iterator();
        TextAttributesKey textAttributesKey = attributesKey;
        if (textAttributesKey == null) {
            textAttributesKey = attributesKeyToUse = target instanceof KtParameter ? KotlinHighlightingColors.PARAMETER : KotlinHighlightingColors.LOCAL_VARIABLE;
        }
        if (lambdaSequenceIterator2.hasNext()) {
            PsiElement lambda2 = (PsiElement)lambdaSequenceIterator2.next();
            int lambdaNestingLevel = 0;
            while (lambdaSequenceIterator2.hasNext()) {
                ++lambdaNestingLevel;
                lambda2 = (PsiElement)lambdaSequenceIterator2.next();
            }
            this.addInfo(this.getInfo(lambda2, rainbowElement, lambdaNestingLevel + rainbowElement.getText(), attributesKeyToUse));
            return;
        }
        PsiElement $receiver$iv = target;
        KtDeclarationWithBody ktDeclarationWithBody = (KtDeclarationWithBody)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, (boolean)true);
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody context = ktDeclarationWithBody;
        this.addInfo(this.getInfo(context, rainbowElement, rainbowElement.getText(), attributesKeyToUse));
    }

    static /* bridge */ /* synthetic */ void addRainbowHighlight$default(KotlinRainbowVisitor kotlinRainbowVisitor, PsiElement psiElement2, PsiElement psiElement3, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 4) != 0) {
            textAttributesKey = null;
        }
        kotlinRainbowVisitor.addRainbowHighlight(psiElement2, psiElement3, textAttributesKey);
    }

    private final boolean isRainbowDeclaration(@Nullable PsiElement $receiver) {
        PsiElement $receiver$iv;
        return $receiver instanceof KtProperty && ((KtProperty)$receiver).isLocal() || $receiver instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = $receiver), KtPrimaryConstructor.class, (boolean)true) == null || $receiver instanceof KtDestructuringDeclarationEntry;
    }
}

