/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinSuspendCallLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getLineMarkerInfo", "", "element", "isValidCandidateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "SuspendCallMarkerInfo", "idea"})
public final class KotlinSuspendCallLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public Void getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return null;
    }

    private final boolean isValidCandidateExpression(KtExpression expression2) {
        if (expression2 instanceof KtOperationReferenceExpression || expression2 instanceof KtForExpression) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        return parent2 instanceof KtCallExpression && Intrinsics.areEqual((Object)((KtCallExpression)parent2).getCalleeExpression(), (Object)expression2);
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashSet markedLineNumbers = new HashSet();
        for (PsiElement element2 : elements2) {
            FunctionDescriptor calleeDescriptor;
            ResolvedCall resolvedCall2;
            int lineNumber;
            ProgressManager.checkCanceled();
            if (!(element2 instanceof KtExpression) || !this.isValidCandidateExpression((KtExpression)element2) || markedLineNumbers.contains(lineNumber = KotlinRefactoringUtilKt.getLineNumber$default(element2, false, 1, null))) continue;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element2, BodyResolveMode.PARTIAL);
            if ((element2 instanceof KtForExpression ? (ResolvedCall)bindingContext2.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, ((KtForExpression)element2).getLoopRange()) : CallUtilKt.getResolvedCall((KtElement)element2, bindingContext2)) == null) {
                continue;
            }
            resolvedCall2 = resolvedCall2;
            Object d = resolvedCall2.getResultingDescriptor();
            if (!(d instanceof FunctionDescriptor)) {
                d = null;
            }
            if ((FunctionDescriptor)d == null) {
                continue;
            }
            if (!calleeDescriptor.isSuspend()) continue;
            Collection<LineMarkerInfo<?>> collection = markedLineNumbers;
            Object object = lineNumber;
            collection.add((LineMarkerInfo<?>)object);
            if (element2 instanceof KtForExpression) {
                collection = result2;
                KtExpression ktExpression = ((KtForExpression)element2).getLoopRange();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.loopRange!!");
                object = new SuspendCallMarkerInfo(ktExpression, "Suspending iteration");
                collection.add((LineMarkerInfo<?>)object);
                continue;
            }
            collection = result2;
            object = new SuspendCallMarkerInfo((KtElement)element2, "Suspend function call");
            collection.add((LineMarkerInfo<?>)object);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinSuspendCallLineMarkerProvider$SuspendCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/psi/KtElement;", "callElement", "message", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "idea"})
    private static final class SuspendCallMarkerInfo
    extends LineMarkerInfo<KtElement> {
        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<KtElement>(this, (LineMarkerInfo)this){
                final /* synthetic */ SuspendCallMarkerInfo this$0;

                @Nullable
                public Void getClickAction() {
                    return null;
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }

        public SuspendCallMarkerInfo(@NotNull KtElement callElement2, final @NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)callElement2, (String)"callElement");
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            super((PsiElement)callElement2, callElement2.getTextRange(), KotlinIcons.SUSPEND_CALL, 6, new Function<T, String>(){

                @NotNull
                public final String fun(KtElement it) {
                    return message2;
                }
            }, (GutterIconNavigationHandler)null, GutterIconRenderer.Alignment.RIGHT);
        }
    }
}

