/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "ReplaceWithFieldFix", "idea"})
public final class RecursivePropertyAccessorInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitSimpleNameExpression(expression2);
                if (RecursivePropertyAccessorInspection.Companion.isRecursivePropertyAccess(expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, "Recursive property accessor", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithFieldFix()});
                } else if (RecursivePropertyAccessorInspection.Companion.isRecursiveSyntheticPropertyAccess(expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, "Recursive synthetic property accessor", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection$ReplaceWithFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class ReplaceWithFieldFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Replace with 'field'";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression expression2 = (KtExpression)psiElement2;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            expression2.replace((PsiElement)factory2.createExpression("field"));
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0014\u0010\f\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u0004*\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection$Companion;", "", "()V", "isRecursivePropertyAccess", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRecursiveSyntheticPropertyAccess", "isSameAccessor", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isGetter", "hasObjectReceiver", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isAssignmentTo", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "idea"})
    public static final class Companion {
        private final boolean isAssignmentTo(@Nullable KtBinaryExpression $receiver, KtSimpleNameExpression expression2) {
            return $receiver != null && KtPsiUtil.isAssignment((PsiElement)$receiver) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)$receiver.getLeft()), (PsiElement)((PsiElement)expression2), (boolean)false);
        }

        private final boolean isSameAccessor(KtSimpleNameExpression expression2, boolean isGetter) {
            KtUnaryExpression unaryExpr;
            PsiElement $receiver$iv = (PsiElement)expression2;
            KtBinaryExpression binaryExpr = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtBinaryExpression.class, (boolean)true);
            if (isGetter) {
                if (this.isAssignmentTo(binaryExpr, expression2)) {
                    KtBinaryExpression ktBinaryExpression = binaryExpr;
                    return KtTokens.AUGMENTED_ASSIGNMENTS.contains((IElementType)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null));
                }
                return true;
            }
            if (this.isAssignmentTo(binaryExpr, expression2)) {
                return true;
            }
            PsiElement $receiver$iv2 = (PsiElement)expression2;
            KtUnaryExpression ktUnaryExpression = unaryExpr = (KtUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtUnaryExpression.class, (boolean)true);
            Object object = ktUnaryExpression != null ? ktUnaryExpression.getOperationToken() : null;
            IElementType it = object;
            return Intrinsics.areEqual((Object)it, (Object)((Object)KtTokens.PLUSPLUS)) || Intrinsics.areEqual((Object)it, (Object)((Object)KtTokens.MINUSMINUS));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isRecursivePropertyAccess(@NotNull KtElement element2) {
            KtQualifiedExpression ktQualifiedExpression;
            KtQualifiedExpression it;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!(element2 instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement2 = (PsiElement)element2;
            boolean strict$iv = true;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, (boolean)strict$iv);
            if (!(psiElement3 instanceof KtPropertyAccessor)) {
                psiElement3 = null;
            }
            KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)psiElement3;
            if (ktPropertyAccessor == null) {
                return false;
            }
            KtPropertyAccessor propertyAccessor = ktPropertyAccessor;
            if (Intrinsics.areEqual((Object)((KtSimpleNameExpression)element2).getText(), (Object)propertyAccessor.getProperty().getName()) ^ true) {
                return false;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze$default(element2, null, 1, null);
            DeclarationDescriptor target = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, element2);
            if (Intrinsics.areEqual((Object)target, (Object)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, propertyAccessor.getProperty())) ^ true) {
                return false;
            }
            PsiElement psiElement4 = ((KtSimpleNameExpression)element2).getParent();
            if (!(psiElement4 instanceof KtQualifiedExpression)) {
                psiElement4 = null;
            }
            KtQualifiedExpression ktQualifiedExpression2 = (KtQualifiedExpression)psiElement4;
            if (ktQualifiedExpression2 != null && Intrinsics.areEqual((Object)(it = (ktQualifiedExpression = ktQualifiedExpression2)).getReceiverExpression().getText(), (Object)KtTokens.THIS_KEYWORD.getValue()) ^ true && !Companion.hasObjectReceiver(it, bindingContext2)) {
                return false;
            }
            return this.isSameAccessor((KtSimpleNameExpression)element2, propertyAccessor.isGetter());
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isRecursiveSyntheticPropertyAccess(@NotNull KtElement element2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!(element2 instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement2 = (PsiElement)element2;
            boolean strict$iv = true;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, (boolean)strict$iv);
            if (!(psiElement3 instanceof KtNamedFunction)) {
                psiElement3 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
            if (ktNamedFunction == null) {
                return false;
            }
            KtNamedFunction namedFunction = ktNamedFunction;
            String string = namedFunction.getName();
            if (string == null) {
                return false;
            }
            String name2 = string;
            String referencedName = StringsKt.capitalize((String)((KtSimpleNameExpression)element2).getText());
            boolean isGetter = Intrinsics.areEqual((Object)name2, (Object)("get" + referencedName));
            boolean isSetter = Intrinsics.areEqual((Object)name2, (Object)("set" + referencedName));
            if (!isGetter && !isSetter) {
                return false;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze$default(element2, null, 1, null);
            Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, element2);
            if (!(v instanceof SyntheticJavaPropertyDescriptor)) {
                v = null;
            }
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = (SyntheticJavaPropertyDescriptor)v;
            if (syntheticJavaPropertyDescriptor == null) {
                return false;
            }
            SyntheticJavaPropertyDescriptor syntheticDescriptor = syntheticJavaPropertyDescriptor;
            DeclarationDescriptor namedFunctionDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, namedFunction);
            if (Intrinsics.areEqual((Object)namedFunctionDescriptor, (Object)syntheticDescriptor.getGetMethod()) ^ true && Intrinsics.areEqual((Object)namedFunctionDescriptor, (Object)syntheticDescriptor.getSetMethod()) ^ true) {
                return false;
            }
            return this.isSameAccessor((KtSimpleNameExpression)element2, isGetter);
        }

        private final boolean hasObjectReceiver(@NotNull KtQualifiedExpression $receiver, BindingContext context) {
            KtExpression ktExpression = $receiver.getReceiverExpression();
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
            if (ktReferenceExpression == null) {
                return false;
            }
            KtReferenceExpression receiver = ktReferenceExpression;
            Object v = context.get(BindingContext.REFERENCE_TARGET, receiver);
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)v;
            return Intrinsics.areEqual((Object)((Object)(classDescriptor != null ? classDescriptor.getKind() : null)), (Object)((Object)ClassKind.OBJECT));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

