/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantModalityModifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "modalityToken", "Lcom/intellij/psi/tree/IElementType;", "hasRefinedModalityInDescriptor", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "implicitModality", "idea"})
public final class RedundantModalityModifierInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ RedundantModalityModifierInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitDeclaration(@NotNull KtDeclaration declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                PsiElement psiElement2 = KtPsiUtilKt.modalityModifier(declaration2);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement modalityModifier = psiElement2;
                IElementType modalityModifierType = modalityModifier.getNode().getElementType();
                KtModifierKeywordToken implicitModality = PsiModificationUtilsKt.implicitModality(declaration2);
                if (Intrinsics.areEqual((Object)modalityModifierType, (Object)((Object)implicitModality)) ^ true) {
                    return;
                }
                Modality modalityFromPsi = RedundantModalityModifierInspection.access$getModality(this.this$0, implicitModality);
                if (modalityFromPsi != null && RedundantModalityModifierInspection.access$hasRefinedModalityInDescriptor(this.this$0, declaration2, modalityFromPsi)) {
                    return;
                }
                this.$holder.registerProblem(modalityModifier, "Redundant modality modifier", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new RemoveModifierFix(declaration2, implicitModality, true), declaration2.getContainingFile())});
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean hasRefinedModalityInDescriptor(KtDeclaration declaration2, Modality implicitModality) {
        boolean bl;
        block2: {
            BindingContext bindingContext2 = ResolutionUtils.analyze(declaration2, BodyResolveMode.PARTIAL);
            DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration2);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            Project project = declaration2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
            Iterable $receiver$iv = DeclarationAttributeAltererExtension.Companion.getInstances(project);
            for (Object element$iv : $receiver$iv) {
                DeclarationAttributeAltererExtension it = (DeclarationAttributeAltererExtension)element$iv;
                if (!(it.refineDeclarationModality(declaration2, descriptor2, descriptor2.getContainingDeclaration(), implicitModality, bindingContext2) != null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final Modality getModality(IElementType modalityToken) {
        IElementType iElementType = modalityToken;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.FINAL_KEYWORD)) ? Modality.FINAL : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.SEALED_KEYWORD)) ? Modality.SEALED : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OPEN_KEYWORD)) ? Modality.OPEN : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) ? Modality.ABSTRACT : null)));
    }

    @Nullable
    public static final /* synthetic */ Modality access$getModality(RedundantModalityModifierInspection $this, @NotNull IElementType modalityToken) {
        return $this.getModality(modalityToken);
    }

    public static final /* synthetic */ boolean access$hasRefinedModalityInDescriptor(RedundantModalityModifierInspection $this, @NotNull KtDeclaration declaration2, @NotNull Modality implicitModality) {
        return $this.hasRefinedModalityInDescriptor(declaration2, implicitModality);
    }
}

