/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgumentKt;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MoveLambdaOutsideParenthesesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class MoveLambdaOutsideParenthesesIntention
extends SelfTargetingIntention<KtCallExpression> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!Companion.canMove(element2)) {
            return false;
        }
        KtLambdaExpression ktLambdaExpression = MoveLambdaOutsideParenthesesIntention.Companion.getLambdaExpression(element2);
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression lambdaExpression2 = ktLambdaExpression;
        PsiElement $receiver$iv = (PsiElement)lambdaExpression2;
        KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtValueArgument.class, (boolean)true);
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument argument2 = ktValueArgument;
        if (caretOffset < PsiUtilsKt.getStartOffset((PsiElement)argument2)) {
            return false;
        }
        KtBlockExpression ktBlockExpression = lambdaExpression2.getBodyExpression();
        if (ktBlockExpression == null || (ktBlockExpression = ktBlockExpression.getTextRange()) == null) {
            return true;
        }
        KtBlockExpression bodyRange = ktBlockExpression;
        return !PsiUtilsKt.containsInside((TextRange)bodyRange, caretOffset);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(element2);
    }

    public MoveLambdaOutsideParenthesesIntention() {
        super(KtCallExpression.class, "Move lambda argument out of parentheses", null, 4, null);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MoveLambdaOutsideParenthesesIntention$Companion;", "", "()V", "canMove", "", "element", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "callExpression", "moveFunctionLiteralOutsideParenthesesIfPossible", "", "expression", "idea"})
    public static final class Companion {
        private final KtLambdaExpression getLambdaExpression(KtCallExpression callExpression2) {
            Collection collection = callExpression2.getLambdaArguments();
            if (!collection.isEmpty()) {
                return null;
            }
            KtElement ktElement = (KtValueArgument)CollectionsKt.lastOrNull(callExpression2.getValueArguments());
            return ktElement != null && (ktElement = ktElement.getArgumentExpression()) != null ? KtLambdaArgumentKt.unpackFunctionLiteral$default((KtExpression)ktElement, false, 1, null) : null;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean canMove(@NotNull KtCallExpression element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (this.getLambdaExpression(element2) == null) {
                return false;
            }
            KtExpression callee = element2.getCalleeExpression();
            if (callee instanceof KtNameReferenceExpression) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Collection collection;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor it;
                BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
                Object object = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, callee);
                if ((object != null && (object = CollectionsKt.listOf((Object)(it = (declarationDescriptor = object)))) != null ? (Collection)object : (collection = (Collection)bindingContext2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, callee))) == null) {
                    collection = CollectionsKt.emptyList();
                }
                Collection targets = collection;
                Iterable $i$a$1$let = $receiver$iv = (Iterable)targets;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List candidates2 = (List)destination$iv$iv;
                $receiver$iv = candidates2;
                if (!$receiver$iv.isEmpty()) {
                    boolean bl;
                    block7: {
                        $receiver$iv = candidates2;
                        for (Object element$iv : $receiver$iv) {
                            FunctionDescriptor it2 = (FunctionDescriptor)element$iv;
                            ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.lastOrNull(it2.getValueParameters());
                            if (!(lastParameter != null && FunctionTypesKt.isFunctionType(lastParameter.getType()))) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                    if (bl) {
                        return false;
                    }
                }
            }
            return true;
        }

        public final void moveFunctionLiteralOutsideParenthesesIfPossible(@NotNull KtLambdaExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            PsiElement psiElement2 = expression2.getParent();
            if (!(psiElement2 instanceof KtValueArgument)) {
                psiElement2 = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
            Object object = ktValueArgument != null ? ktValueArgument.getParent() : null;
            if (!(object instanceof KtValueArgumentList)) {
                object = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)object;
            Object object2 = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object2 instanceof KtCallExpression)) {
                object2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)object2;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call2 = ktCallExpression;
            if (this.canMove(call2)) {
                PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(call2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

