/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveRedundantCallsOfConversionMethodsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "()V", "targetClassMap", "", "", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableReceiverExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "qualifiedName", "idea"})
public final class RemoveRedundantCallsOfConversionMethodsIntention
extends SelfTargetingRangeIntention<KtQualifiedExpression> {
    private final Map<String, String> targetClassMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"toString()", (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()), TuplesKt.to((Object)"toDouble()", (Object)Reflection.getOrCreateKotlinClass(Double.TYPE).getQualifiedName()), TuplesKt.to((Object)"toFloat()", (Object)Reflection.getOrCreateKotlinClass(Float.TYPE).getQualifiedName()), TuplesKt.to((Object)"toLong()", (Object)Reflection.getOrCreateKotlinClass(Long.TYPE).getQualifiedName()), TuplesKt.to((Object)"toInt()", (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE).getQualifiedName()), TuplesKt.to((Object)"toChar()", (Object)Reflection.getOrCreateKotlinClass(Character.TYPE).getQualifiedName()), TuplesKt.to((Object)"toShort()", (Object)Reflection.getOrCreateKotlinClass(Short.TYPE).getQualifiedName()), TuplesKt.to((Object)"toByte()", (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE).getQualifiedName())});

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtQualifiedExpression element2, @Nullable Editor editor) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement2 = (PsiElement)element2;
        PsiElement newElement$iv = (PsiElement)element2.getReceiverExpression();
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            object = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtQualifiedExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selectorExpression = ktExpression;
        String selectorExpressionText = selectorExpression.getText();
        String string = this.targetClassMap.get(selectorExpressionText);
        if (string == null) {
            return null;
        }
        String qualifiedName2 = string;
        if (this.isApplicableReceiverExpression(element2.getReceiverExpression(), qualifiedName2)) {
            return selectorExpression.getTextRange();
        }
        return null;
    }

    private final boolean isApplicableReceiverExpression(@NotNull KtExpression $receiver, String qualifiedName2) {
        Object object;
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtStringTemplateExpression) {
            object = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
        } else if (ktExpression instanceof KtConstantExpression) {
            KotlinType kotlinType = CallUtilKt.getType($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
            object = kotlinType != null ? DescriptorUtilsKt.getJetTypeFqName(kotlinType, false) : null;
        } else {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            ResolvedCall<? extends CallableDescriptor> it;
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
            object = resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getCandidateDescriptor()) != null && (resolvedCall3 = resolvedCall3.getReturnType()) != null ? (FlexibleTypesKt.isFlexible((KotlinType)((Object)(it = (resolvedCall2 = resolvedCall3)))) ? null : (((KotlinType)((Object)it)).isMarkedNullable() && !($receiver.getParent() instanceof KtSafeQualifiedExpression) ? null : DescriptorUtilsKt.getJetTypeFqName((KotlinType)((Object)it), false))) : null;
        }
        return Intrinsics.areEqual((Object)object, (Object)qualifiedName2);
    }

    public RemoveRedundantCallsOfConversionMethodsIntention() {
        super(KtQualifiedExpression.class, "Remove redundant calls of the conversion method", null, 4, null);
    }
}

