/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/UnfoldReturnToIfIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class UnfoldReturnToIfIntention
extends SelfTargetingRangeIntention<KtReturnExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtReturnExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getReturnedExpression();
        if (!(ktExpression instanceof KtIfExpression)) {
            ktExpression = null;
        }
        KtIfExpression ktIfExpression = (KtIfExpression)ktExpression;
        if (ktIfExpression == null) {
            return null;
        }
        KtIfExpression ifExpression2 = ktIfExpression;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)element2), PsiUtilsKt.getEndOffset(ifExpression2.getIfKeyword()));
    }

    @Override
    public void applyTo(@NotNull KtReturnExpression element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = element2.getReturnedExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression ifExpression2 = (KtIfExpression)ktExpression;
        KtIfExpression newIfExpression = (KtIfExpression)PsiModificationUtilsKt.copied((PsiElement)ifExpression2);
        KtExpression ktExpression2 = newIfExpression.getThen();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression thenExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression2);
        KtExpression ktExpression3 = newIfExpression.getElse();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression elseExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression3);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element2, false, 2, null);
        thenExpr.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "return $0", new Object[]{thenExpr}, false, 4, null));
        elseExpr.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "return $0", new Object[]{elseExpr}, false, 4, null));
        element2.replace((PsiElement)newIfExpression);
    }

    public UnfoldReturnToIfIntention() {
        super(KtReturnExpression.class, "Replace return with 'if' expression", null, 4, null);
    }
}

