/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.makeBackup;

import com.intellij.compiler.server.BuildManager;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.internal.makeBackup.CreateIncrementalCompilationBackup;
import org.jetbrains.kotlin.idea.internal.makeBackup.MakeBackupKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "copyLogs", "backupDir", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "copyProjectSystemDir", "project", "Lcom/intellij/openapi/project/Project;", "createPatches", "zipProjectDir", "projectDir", "Companion", "idea"})
public final class CreateIncrementalCompilationBackup
extends AnAction {
    @NotNull
    private static final String BACKUP_DIR_NAME = ".backup";
    private static final int PATCHES_TO_CREATE = 5;
    private static final double PATCHES_FRACTION = 0.25;
    private static final double LOGS_FRACTION = 0.05;
    private static final double PROJECT_SYSTEM_FRACTION = 0.05;
    private static final double ZIP_FRACTION = 0.6499999999999999;
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Project project2 = project;
        VirtualFile virtualFile2 = project2.getBaseDir();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        File projectBaseDir = new File(virtualFile2.getPath());
        File backupDir = new File(FileUtil.createTempDirectory((String)"makeBackup", null), Companion.getBACKUP_DIR_NAME());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, backupDir, project2, projectBaseDir, project2, "Creating backup for debugging Kotlin incremental compilation", true){
            final /* synthetic */ CreateIncrementalCompilationBackup this$0;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ File $projectBaseDir;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                CreateIncrementalCompilationBackup.access$createPatches(this.this$0, this.$backupDir, project, indicator);
                CreateIncrementalCompilationBackup.access$copyLogs(this.this$0, this.$backupDir, indicator);
                Project project2 = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                CreateIncrementalCompilationBackup.access$copyProjectSystemDir(this.this$0, this.$backupDir, project2, indicator);
                Project project3 = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                CreateIncrementalCompilationBackup.access$zipProjectDir(this.this$0, this.$backupDir, project3, this.$projectBaseDir, indicator);
            }
            {
                this.this$0 = $outer;
                this.$backupDir = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$projectBaseDir = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    private final void createPatches(File backupDir, Project project, ProgressIndicator indicator) {
        ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(project, backupDir, indicator){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ ProgressIndicator $indicator;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.getInstanceImpl();
                if (localHistoryImpl == null) {
                    Intrinsics.throwNpe();
                }
                LocalHistoryImpl localHistoryImpl2 = localHistoryImpl;
                IdeaGateway ideaGateway = localHistoryImpl2.getGateway();
                if (ideaGateway == null) {
                    Intrinsics.throwNpe();
                }
                IdeaGateway gateway = ideaGateway;
                LocalHistoryFacade localHistoryFacade = localHistoryImpl2.getFacade();
                RootEntry rootEntry = gateway.createTransientRootEntry();
                VirtualFile virtualFile2 = this.$project.getBaseDir();
                if (virtualFile2 == null) {
                    Intrinsics.throwNpe();
                }
                RevisionsCollector revisionsCollector = new RevisionsCollector(localHistoryFacade, rootEntry, virtualFile2.getPath(), this.$project.getLocationHash(), null);
                int patchesCreated = 0;
                File patchesDir = new File(this.$backupDir, "patches");
                patchesDir.mkdirs();
                List list2 = revisionsCollector.getResult();
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                List revisions = list2;
                for (Revision rev : revisions) {
                    void $receiver$iv$iv;
                    List differences;
                    Iterable $receiver$iv;
                    String label2 = rev.getLabel();
                    if (label2 == null || !StringsKt.startsWith$default((String)label2, (String)MakeBackupKt.getHISTORY_LABEL_PREFIX(), (boolean)false, (int)2, null)) continue;
                    File patchFile = new File(patchesDir, StringsKt.removePrefix((String)label2, (CharSequence)MakeBackupKt.getHISTORY_LABEL_PREFIX()) + ".patch");
                    this.$indicator.setText("Creating patch " + patchFile);
                    this.$indicator.setFraction(CreateIncrementalCompilationBackup.Companion.getPATCHES_FRACTION() * (double)patchesCreated / (double)CreateIncrementalCompilationBackup.Companion.getPATCHES_TO_CREATE());
                    if (((Revision)revisions.get(0)).getDifferencesWith(rev) == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable iterable = $receiver$iv = (Iterable)differences;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void d;
                        Difference difference2 = (Difference)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Change change = new Change(d.getLeftContentRevision(gateway), d.getRightContentRevision(gateway));
                        collection.add(change);
                    }
                    List changes2 = (List)destination$iv$iv;
                    PatchCreator.create((Project)this.$project, (List)changes2, (String)patchFile.getPath(), (boolean)false, null);
                    if (++patchesCreated < CreateIncrementalCompilationBackup.Companion.getPATCHES_TO_CREATE()) continue;
                    break;
                }
            }
            {
                this.$project = project;
                this.$backupDir = file2;
                this.$indicator = progressIndicator;
                super(0);
            }
        });
    }

    private final void copyLogs(File backupDir, ProgressIndicator indicator) {
        indicator.setText("Copying logs");
        indicator.setFraction(Companion.getPATCHES_FRACTION());
        File logsDir = new File(backupDir, "logs");
        FileUtil.copyDir((File)new File(PathManager.getLogPath()), (File)logsDir);
        indicator.setFraction(Companion.getPATCHES_FRACTION() + Companion.getLOGS_FRACTION());
    }

    private final void copyProjectSystemDir(File backupDir, Project project, ProgressIndicator indicator) {
        indicator.setText("Copying project's system dir ");
        indicator.setFraction(Companion.getPATCHES_FRACTION());
        File projectSystemDir = new File(backupDir, "project-system");
        File file2 = BuildManager.getInstance().getProjectSystemDirectory(project);
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        FileUtil.copyDir((File)file2, (File)projectSystemDir);
        indicator.setFraction(Companion.getPATCHES_FRACTION() + Companion.getLOGS_FRACTION() + Companion.getPROJECT_SYSTEM_FRACTION());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipProjectDir(File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        Object totalBytes;
        ArrayList files2 = new ArrayList();
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        Object[] objectArray = new File[2];
        objectArray[0] = projectDir;
        File file2 = backupDir.getParentFile();
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        objectArray[1] = file2;
        for (File dir : CollectionsKt.listOf((Object[])objectArray)) {
            FileUtil.processFilesRecursively((File)dir, (Processor)((Processor)new Processor<File>(indicator, files2, dir, totalBytes){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ ArrayList $files;
                final /* synthetic */ File $dir;
                final /* synthetic */ Ref.LongRef $totalBytes;

                public final boolean process(File it) {
                    File file2 = it;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(!file2.isFile() || StringsKt.endsWith$default((String)it.getName(), (String)".hprof", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it.getName(), (String)"make_backup_", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it.getName(), (String)".zip", (boolean)false, (int)2, null))) {
                        this.$indicator.setText("Scanning project dir: " + it);
                        String string = FileUtil.getRelativePath((File)this.$dir, (File)it);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$files.add(new Pair((Object)it, (Object)string));
                        this.$totalBytes.element += it.length();
                    }
                    return true;
                }
                {
                    this.$indicator = progressIndicator;
                    this.$files = arrayList;
                    this.$dir = file2;
                    this.$totalBytes = longRef;
                }
            }), (Processor)zipProjectDir.2.INSTANCE);
        }
        File backupFile = new File(projectDir, "make_backup_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));
        long processedBytes = 0L;
        Closeable closeable = zos;
        boolean bl = false;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            for (Pair pair2 : files2) {
                File file3 = (File)pair2.component1();
                String relativePath = (String)pair2.component2();
                indicator.setText("Adding file to backup: " + relativePath);
                indicator.setFraction(Companion.getPATCHES_FRACTION() + Companion.getLOGS_FRACTION() + (double)processedBytes / (double)totalBytes.element * Companion.getZIP_FRACTION());
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)file3, (String)relativePath, null, null);
                processedBytes += file3.length();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
        FileUtil.delete((File)backupDir);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(project, backupFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupFile;

            public final void run() {
                ShowFilePathAction.showDialog((Project)this.$project, (String)("Successfully created backup " + this.$backupFile.getAbsolutePath()), (String)"Created backup", (File)this.$backupFile, null);
            }
            {
                this.$project = project;
                this.$backupFile = file2;
            }
        }, null, (Project)project);
        totalBytes = null;
    }

    public CreateIncrementalCompilationBackup() {
        super("Create backup for debugging Kotlin incremental compilation");
    }

    static {
        BACKUP_DIR_NAME = BACKUP_DIR_NAME;
        PATCHES_TO_CREATE = 5;
        PATCHES_FRACTION = 0.25;
        LOGS_FRACTION = 0.05;
        PROJECT_SYSTEM_FRACTION = 0.05;
        ZIP_FRACTION = 1.0 - Companion.getPATCHES_FRACTION() - Companion.getLOGS_FRACTION() - Companion.getPROJECT_SYSTEM_FRACTION();
    }

    public static final /* synthetic */ void access$createPatches(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        $this.createPatches(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$copyLogs(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull ProgressIndicator indicator) {
        $this.copyLogs(backupDir, indicator);
    }

    public static final /* synthetic */ void access$copyProjectSystemDir(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        $this.copyProjectSystemDir(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$zipProjectDir(CreateIncrementalCompilationBackup $this, @NotNull File backupDir, @NotNull Project project, @NotNull File projectDir, @NotNull ProgressIndicator indicator) {
        $this.zipProjectDir(backupDir, project, projectDir, indicator);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup$Companion;", "", "()V", "BACKUP_DIR_NAME", "", "getBACKUP_DIR_NAME", "()Ljava/lang/String;", "LOGS_FRACTION", "", "getLOGS_FRACTION", "()D", "PATCHES_FRACTION", "getPATCHES_FRACTION", "PATCHES_TO_CREATE", "", "getPATCHES_TO_CREATE", "()I", "PROJECT_SYSTEM_FRACTION", "getPROJECT_SYSTEM_FRACTION", "ZIP_FRACTION", "getZIP_FRACTION", "idea"})
    public static final class Companion {
        @NotNull
        public final String getBACKUP_DIR_NAME() {
            return BACKUP_DIR_NAME;
        }

        public final int getPATCHES_TO_CREATE() {
            return PATCHES_TO_CREATE;
        }

        public final double getPATCHES_FRACTION() {
            return PATCHES_FRACTION;
        }

        public final double getLOGS_FRACTION() {
            return LOGS_FRACTION;
        }

        public final double getPROJECT_SYSTEM_FRACTION() {
            return PROJECT_SYSTEM_FRACTION;
        }

        public final double getZIP_FRACTION() {
            return ZIP_FRACTION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

