/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtScriptInitializer;

public abstract class KotlinTemplateContextType
extends TemplateContextType {
    private KotlinTemplateContextType(@NotNull @NonNls String id, @NotNull String presentableName2, @Nullable java.lang.Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType", "<init>"));
        }
        if (presentableName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType", "<init>"));
        }
        super(id, presentableName2, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file2, int offset2) {
        PsiElement parent2;
        IElementType elementType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType", "isInContext"));
        }
        if (!PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset2).isKindOf((Language)KotlinLanguage.INSTANCE)) {
            return false;
        }
        PsiElement element2 = file2.findElementAt(offset2);
        if (element2 == null) {
            element2 = file2.findElementAt(offset2 - 1);
        }
        if (element2 instanceof PsiWhiteSpace) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, PsiComment.class, (boolean)false) != null) {
            return this.isCommentInContext();
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, KtPackageDirective.class) != null || PsiTreeUtil.getParentOfType((PsiElement)element2, KtImportDirective.class) != null) {
            return false;
        }
        if (element2 instanceof LeafPsiElement && (elementType = ((LeafPsiElement)element2).getElementType()) == KtTokens.IDENTIFIER && (parent2 = element2.getParent()) instanceof KtReferenceExpression) {
            PsiElement parentOfParent = parent2.getParent();
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtQualifiedExpression.class);
            if (qualifiedExpression != null && qualifiedExpression.getSelectorExpression() == parentOfParent) {
                return false;
            }
        }
        return element2 != null && this.isInContext(element2);
    }

    protected boolean isCommentInContext() {
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    private static <T extends PsiElement> T getParentClassOrObject(@NotNull PsiElement element2, @NotNull java.lang.Class<? extends T> klass2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType", "getParentClassOrObject"));
        }
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType", "getParentClassOrObject"));
        }
        PsiElement e = element2;
        while (e != null && !klass2.isInstance(e)) {
            if (e instanceof KtModifierList) {
                if ((e = e.getParent()) == null) continue;
                e = e.getParent();
                continue;
            }
            if (e instanceof KtProperty || e instanceof KtNamedFunction) {
                return null;
            }
            e = e.getParent();
        }
        return (T)e;
    }

    public static class Comment
    extends KotlinTemplateContextType {
        public Comment() {
            super("KOTLIN_COMMENT", "Comment", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$Comment", "isInContext"));
            }
            return false;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }

    public static class Expression
    extends KotlinTemplateContextType {
        public Expression() {
            super("KOTLIN_EXPRESSION", "Expression", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$Expression", "isInContext"));
            }
            return element2.getParent() instanceof KtExpression && !(element2.getParent() instanceof KtConstantExpression) && !(element2.getParent().getParent() instanceof KtDotQualifiedExpression) && !(element2.getParent() instanceof KtParameter);
        }
    }

    public static class Statement
    extends KotlinTemplateContextType {
        public Statement() {
            super("KOTLIN_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$Statement", "isInContext"));
            }
            PsiElement parentStatement = PsiTreeUtil.findFirstParent((PsiElement)element2, (Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element2) {
                    return element2 instanceof KtExpression && element2.getParent() instanceof KtBlockExpression;
                }
            });
            if (parentStatement == null) {
                return false;
            }
            return element2.getTextOffset() == parentStatement.getTextOffset();
        }
    }

    public static class Class
    extends KotlinTemplateContextType {
        public Class() {
            super("KOTLIN_CLASS", "Class", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$Class", "isInContext"));
            }
            return KotlinTemplateContextType.getParentClassOrObject(element2, KtClassOrObject.class) != null;
        }
    }

    public static class ObjectDeclaration
    extends KotlinTemplateContextType {
        public ObjectDeclaration() {
            super("KOTLIN_OBJECT_DECLARATION", "Object declaration", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$ObjectDeclaration", "isInContext"));
            }
            KtObjectDeclaration objectDeclaration = (KtObjectDeclaration)KotlinTemplateContextType.getParentClassOrObject(element2, KtObjectDeclaration.class);
            return objectDeclaration != null && !objectDeclaration.isObjectLiteral();
        }
    }

    public static class TopLevel
    extends KotlinTemplateContextType {
        public TopLevel() {
            super("KOTLIN_TOPLEVEL", "Top-level", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$TopLevel", "isInContext"));
            }
            PsiElement e = element2;
            while (e != null) {
                if (e instanceof KtModifierList) {
                    if ((e = e.getParent()) == null) continue;
                    e = e.getParent();
                    continue;
                }
                if (e instanceof KtProperty || e instanceof KtNamedFunction || e instanceof KtClassOrObject) {
                    return false;
                }
                if (e instanceof KtScriptInitializer) {
                    return false;
                }
                e = e.getParent();
            }
            return true;
        }
    }

    public static class Generic
    extends KotlinTemplateContextType {
        public Generic() {
            super("KOTLIN", "Kotlin", EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/liveTemplates/KotlinTemplateContextType$Generic", "isInContext"));
            }
            return true;
        }

        @Override
        protected boolean isCommentInContext() {
            return true;
        }
    }
}

