/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.maven.MavenModulesRelationshipKt;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 .2\u00020\u0001:\u0001.B)\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0016J(\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J8\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0005H\u0004J \u0010'\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010(\u001a\u00020\u0003H\u0014J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H$J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0003H$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "testArtifactId", "", "addJunit", "", "name", "presentableText", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPresentableText", "changePomFile", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "version", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "checkKotlinPlugin", "Lorg/jetbrains/kotlin/idea/configuration/ConfigureKotlinStatus;", "configure", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "configurePlugin", "pom", "Lorg/jetbrains/kotlin/idea/maven/PomFile;", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "createExecution", "pomFile", "kotlinPlugin", "executionId", "goalName", "isTest", "createExecutions", "getMinimumSupportedVersion", "getStatus", "getStdlibArtifactId", "hasKotlinPlugin", "isKotlinModule", "isRelevantGoal", "Companion", "idea-maven"})
public abstract class KotlinMavenConfigurator
implements KotlinProjectConfigurator {
    private final String testArtifactId;
    private final boolean addJunit;
    @NotNull
    private final String name;
    @NotNull
    private final String presentableText;
    @NotNull
    private static final String NAME = "maven";
    @NotNull
    private static final String GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String MAVEN_PLUGIN_ID = "kotlin-maven-plugin";
    private static final String KOTLIN_VERSION_PROPERTY = "kotlin.version";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ConfigureKotlinStatus getStatus(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (!KotlinPluginUtil.isMavenModule(module)) {
            return ConfigureKotlinStatus.NON_APPLICABLE;
        }
        PsiFile psi = Companion.findModulePomFile(module);
        if (psi == null || !psi.isValid() || !(psi instanceof XmlFile) || ((XmlFile)psi).getVirtualFile() == null) {
            return ConfigureKotlinStatus.BROKEN;
        }
        if (this.isKotlinModule(module)) {
            return this.checkKotlinPlugin(module);
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigureKotlinStatus checkKotlinPlugin(Module module) {
        boolean bl;
        block12: {
            Object v4;
            Object it;
            block10: {
                PsiFile psiFile = Companion.findModulePomFile(module);
                if (!(psiFile instanceof XmlFile)) {
                    psiFile = null;
                }
                XmlFile xmlFile = (XmlFile)psiFile;
                if (xmlFile == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                XmlFile psi = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(psi);
                if (pomFile == null) {
                    return ConfigureKotlinStatus.NON_APPLICABLE;
                }
                PomFile pom = pomFile;
                if (this.hasKotlinPlugin(pom)) {
                    return ConfigureKotlinStatus.CONFIGURED;
                }
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
                MavenProject mavenProject = mavenProjectsManager.findProject(module);
                if (mavenProject == null) {
                    return ConfigureKotlinStatus.BROKEN;
                }
                MavenProject mavenProject2 = mavenProject;
                MavenId kotlinPluginId = PomFileKt.kotlinPluginId(null);
                Iterable iterable = mavenProject2.getPlugins();
                Iterable iterable2 = iterable;
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it = (MavenPlugin)t;
                    if (!it.getMavenId().equals(kotlinPluginId.getGroupId(), kotlinPluginId.getArtifactId())) continue;
                    v4 = t;
                    break block10;
                }
                v4 = null;
            }
            MavenPlugin mavenPlugin = v4;
            if (mavenPlugin == null) {
                return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
            }
            MavenPlugin kotlinPlugin = mavenPlugin;
            Iterable $receiver$iv = kotlinPlugin.getExecutions();
            for (Object element$iv : $receiver$iv) {
                boolean bl2;
                block11: {
                    void $receiver$iv2;
                    MavenPlugin.Execution it2 = (MavenPlugin.Execution)element$iv;
                    it = it2.getGoals();
                    KotlinMavenConfigurator kotlinMavenConfigurator = this;
                    for (Object element$iv2 : $receiver$iv2) {
                        String p1 = (String)element$iv2;
                        if (!kotlinMavenConfigurator.isRelevantGoal(p1)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block12;
            }
            bl = false;
        }
        if (bl) {
            return ConfigureKotlinStatus.CONFIGURED;
        }
        return ConfigureKotlinStatus.CAN_BE_CONFIGURED;
    }

    private final boolean hasKotlinPlugin(PomFile pom) {
        boolean bl;
        block5: {
            MavenDomPlugin mavenDomPlugin = pom.findPlugin(PomFileKt.kotlinPluginId(null));
            if (mavenDomPlugin == null) {
                return false;
            }
            MavenDomPlugin plugin = mavenDomPlugin;
            Iterable $receiver$iv = plugin.getExecutions().getExecutions();
            for (Object element$iv : $receiver$iv) {
                boolean bl2;
                block4: {
                    MavenDomPluginExecution it = (MavenDomPluginExecution)element$iv;
                    Iterable $receiver$iv2 = it.getGoals().getGoals();
                    for (Object element$iv2 : $receiver$iv2) {
                        MavenDomGoal it2 = (MavenDomGoal)element$iv2;
                        String string = it2.getStringValue();
                        if (string == null) {
                            string = "";
                        }
                        if (!this.isRelevantGoal(string)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public void configure(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, this, excludeModules, this.getMinimumSupportedVersion());
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(this, project, dialog2){
            final /* synthetic */ KotlinMavenConfigurator this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureDialogWithModulesAndVersion $dialog;

            public final void run() {
                NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(this.$project);
                List<Module> list2 = this.$dialog.getModulesToConfigure();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"dialog.modulesToConfigure");
                for (Module module : MavenModulesRelationshipKt.excludeMavenChildrenModules(this.$project, list2)) {
                    PsiFile file2 = KotlinMavenConfigurator.Companion.findModulePomFile(module);
                    if (file2 != null && org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$canConfigureFile(KotlinMavenConfigurator.Companion, file2)) {
                        String string = this.$dialog.getKotlinVersion();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialog.kotlinVersion");
                        this.this$0.changePomFile(module, file2, string, collector2);
                        OpenFileAction.openFile((VirtualFile)file2.getVirtualFile(), (Project)this.$project);
                        continue;
                    }
                    org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator$Companion.access$showErrorMessage(KotlinMavenConfigurator.Companion, this.$project, "Cannot find pom.xml for module " + module.getName());
                }
                collector2.showNotification();
            }
            {
                this.this$0 = kotlinMavenConfigurator;
                this.$project = project;
                this.$dialog = configureDialogWithModulesAndVersion;
            }
        });
    }

    @NotNull
    protected String getMinimumSupportedVersion() {
        return "1.0.0";
    }

    protected abstract boolean isKotlinModule(@NotNull Module var1);

    protected abstract boolean isRelevantGoal(@NotNull String var1);

    protected abstract void createExecutions(@NotNull PomFile var1, @NotNull MavenDomPlugin var2, @NotNull Module var3);

    @NotNull
    protected abstract String getStdlibArtifactId(@NotNull Module var1, @NotNull String var2);

    public final void changePomFile(@NotNull Module module, @NotNull PsiFile file2, @NotNull String version, @NotNull NotificationMessageCollector collector2) {
        RepositoryDescription repositoryDescription;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            String string = "Virtual file should exists for psi file " + file2.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile3 = virtualFile2;
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)virtualFile3);
        if (domModel == null) {
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            KotlinMavenConfigurator.Companion.showErrorMessage(project, null);
            return;
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)file2);
        if (pomFile == null) {
            return;
        }
        PomFile pom = pomFile;
        pom.addProperty(KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY(), version);
        pom.addDependency(new MavenId(Companion.getGROUP_ID(), this.getStdlibArtifactId(module, version), "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"), MavenArtifactScope.COMPILE, null, false, null);
        if (this.testArtifactId != null) {
            pom.addDependency(new MavenId(Companion.getGROUP_ID(), this.testArtifactId, "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"), MavenArtifactScope.TEST, null, false, null);
        }
        if (this.addJunit) {
            pom.addDependency(new MavenId("junit", "junit", "4.12"), MavenArtifactScope.TEST, null, false, null);
        }
        if ((repositoryDescription = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version)) != null) {
            pom.addLibraryRepository(repositoryDescription);
            pom.addPluginRepository(repositoryDescription);
        }
        MavenDomPlugin plugin = pom.addPlugin(new MavenId(Companion.getGROUP_ID(), Companion.getMAVEN_PLUGIN_ID(), "$" + "{" + KotlinMavenConfigurator.Companion.getKOTLIN_VERSION_PROPERTY() + "}"));
        this.createExecutions(pom, plugin, module);
        this.configurePlugin(pom, plugin, module, version);
        CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)file2));
        collector2.addMessage(virtualFile3.getPath() + " was modified");
    }

    protected void configurePlugin(@NotNull PomFile pom, @NotNull MavenDomPlugin plugin, @NotNull Module module, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)pom, (String)"pom");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
    }

    protected final void createExecution(@NotNull PomFile pomFile, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String executionId, @NotNull String goalName, @NotNull Module module, boolean isTest) {
        Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
        Intrinsics.checkParameterIsNotNull((Object)executionId, (String)"executionId");
        Intrinsics.checkParameterIsNotNull((Object)goalName, (String)"goalName");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        pomFile.addKotlinExecution(module, kotlinPlugin, executionId, PomFile.Companion.getPhase(false, isTest), isTest, CollectionsKt.listOf((Object)goalName));
        if (KotlinMavenConfigurator.Companion.hasJavaFiles(module)) {
            pomFile.addJavacExecutions(module, kotlinPlugin);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.presentableText;
    }

    protected KotlinMavenConfigurator(@Nullable String testArtifactId, boolean addJunit, @NotNull String name2, @NotNull String presentableText) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)presentableText, (String)"presentableText");
        this.testArtifactId = testArtifactId;
        this.addJunit = addJunit;
        this.name = name2;
        this.presentableText = presentableText;
    }

    static {
        NAME = NAME;
        GROUP_ID = GROUP_ID;
        MAVEN_PLUGIN_ID = MAVEN_PLUGIN_ID;
        KOTLIN_VERSION_PROPERTY = KOTLIN_VERSION_PROPERTY;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/maven/configuration/KotlinMavenConfigurator$Companion;", "", "()V", "GROUP_ID", "", "getGROUP_ID", "()Ljava/lang/String;", "KOTLIN_VERSION_PROPERTY", "getKOTLIN_VERSION_PROPERTY", "MAVEN_PLUGIN_ID", "getMAVEN_PLUGIN_ID", "NAME", "getNAME", "canConfigureFile", "", "file", "Lcom/intellij/psi/PsiFile;", "findModulePomFile", "module", "Lcom/intellij/openapi/module/Module;", "hasJavaFiles", "showErrorMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "idea-maven"})
    public static final class Companion {
        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @NotNull
        public final String getGROUP_ID() {
            return GROUP_ID;
        }

        @NotNull
        public final String getMAVEN_PLUGIN_ID() {
            return MAVEN_PLUGIN_ID;
        }

        private final String getKOTLIN_VERSION_PROPERTY() {
            return KOTLIN_VERSION_PROPERTY;
        }

        private final boolean hasJavaFiles(Module module) {
            return !FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module)).isEmpty();
        }

        @Nullable
        public final PsiFile findModulePomFile(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            List files2 = MavenProjectsManager.getInstance((Project)module.getProject()).getProjectsFiles();
            for (VirtualFile file2 : files2) {
                PsiFile psiFile;
                Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)module.getProject());
                if (Intrinsics.areEqual((Object)module, (Object)fileModule) ^ true) continue;
                if (PsiManager.getInstance((Project)module.getProject()).findFile(file2) == null) {
                    continue;
                }
                if (!MavenDomUtil.isProjectFile((PsiFile)psiFile)) continue;
                return psiFile;
            }
            return null;
        }

        private final boolean canConfigureFile(PsiFile file2) {
            return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file2.getVirtualFile(), null);
        }

        private final void showErrorMessage(Project project, String message2) {
            Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-maven plugin automatically.<br/>" + (message2 != null ? message2 + "</br>" : "") + "See manual installation instructions <a href=\"http://confluence.jetbrains.com/display/Kotlin/Kotlin+Build+Tools#KotlinBuildTools-Maven\">here</a>.</html>"), (String)"Configure Kotlin-Maven Plugin");
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$canConfigureFile(Companion $this, @NotNull PsiFile file2) {
            return $this.canConfigureFile(file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

