/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"askUpdateRuntime", "", "module", "Lcom/intellij/openapi/module/Module;", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "project", "Lcom/intellij/openapi/project/Project;", "librariesToUpdate", "", "Lcom/intellij/openapi/roots/libraries/Library;", "checkUpdateRuntime", "idea"})
public final class EnableUnsupportedFeatureFixKt {
    public static final boolean checkUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)requiredVersion, (String)"requiredVersion");
        Iterable iterable = $receiver$iv = (Iterable)ProjectStructureUtilKt.allModules(project);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ApiVersion parsedModuleRuntimeVersion;
            ApiVersion apiVersion;
            Module module;
            Module module2 = module = (Module)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module2) != null) {
                String string;
                String version = string;
                apiVersion = ApiVersion.Companion.parse(StringsKt.substringBefore$default((String)version, (String)"-", null, (int)2, null));
            } else {
                apiVersion = null;
            }
            if (!((parsedModuleRuntimeVersion = apiVersion) != null && parsedModuleRuntimeVersion.compareTo(requiredVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithOutdatedRuntime = (List)destination$iv$iv;
        $receiver$iv = modulesWithOutdatedRuntime;
        if (!$receiver$iv.isEmpty()) {
            $receiver$iv = modulesWithOutdatedRuntime;
            ApiVersion apiVersion = requiredVersion;
            Project project2 = project;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Library library2;
                Module it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                Module module = it = (Module)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"it");
                if (OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module, null, 2, null) == null) continue;
                Library it$iv$iv = library2;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            if (!EnableUnsupportedFeatureFixKt.askUpdateRuntime(project2, apiVersion, list2)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Project project, @NotNull ApiVersion requiredVersion, @NotNull List<? extends Library> librariesToUpdate) {
        int rc;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)requiredVersion, (String)"requiredVersion");
        Intrinsics.checkParameterIsNotNull(librariesToUpdate, (String)"librariesToUpdate");
        if (!ApplicationManager.getApplication().isUnitTestMode() && (rc = Messages.showOkCancelDialog((Project)project, (String)("This language feature requires version " + requiredVersion + " or later of the Kotlin runtime library. " + "Would you like to update the runtime library in your project?"), (String)"Update Runtime Library", (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        KotlinRuntimeLibraryUtilKt.updateLibraries(project, (Collection<? extends Library>)librariesToUpdate);
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Module module, @NotNull ApiVersion requiredVersion) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)requiredVersion, (String)"requiredVersion");
        Library library2 = OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module, null, 2, null);
        if (library2 == null) {
            return true;
        }
        Library library3 = library2;
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        return EnableUnsupportedFeatureFixKt.askUpdateRuntime(project, requiredVersion, CollectionsKt.listOf((Object)library3));
    }
}

