/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInliner.CallableUsageReplacementStrategy;
import org.jetbrains.kotlin.idea.codeInliner.CodeToInline;
import org.jetbrains.kotlin.idea.codeInliner.CodeToInlineBuilder;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.InlineUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J\"\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "inlineElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isEnabledForLanguage", "l", "Lcom/intellij/lang/Language;", "reportAmbiguousAssignment", "name", "", "assignments", "", "showErrorHint", "message", "idea"})
public final class KotlinInlineValHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(@NotNull Language l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return Intrinsics.areEqual((Object)l, (Object)((Object)KotlinLanguage.INSTANCE));
    }

    public boolean canInlineElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(element2 instanceof KtProperty)) {
            return false;
        }
        return ((KtProperty)element2).getGetter() == null && ((KtProperty)element2).getReceiverTypeReference() == null;
    }

    public void inlineElement(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        KotlinType kotlinType;
        Collection $receiver$iv$iv;
        KtExpression ktExpression;
        Object parent2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtProperty declaration2 = (KtProperty)element2;
        KtFile file2 = declaration2.getContainingKtFile();
        String string = declaration2.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        if (file2.isCompiled()) {
            this.showErrorHint(project, editor, "Cannot inline '" + name2 + "' from a decompiled file");
            return;
        }
        Query references2 = ReferencesSearch.search((PsiElement)declaration2);
        List referenceExpressions = new ArrayList();
        List foreignUsages = new ArrayList();
        for (PsiReference ref : references2) {
            Object refElement;
            if (ref.getElement() == null) {
                continue;
            }
            if (!(refElement instanceof KtElement)) {
                foreignUsages.add(refElement);
                continue;
            }
            Collection collection = referenceExpressions;
            Object object = refElement;
            if (!(object instanceof KtExpression)) {
                object = null;
            }
            KtExpression ktExpression2 = (KtExpression)object;
            CollectionsKt.addIfNotNull(collection, ktExpression2 != null ? KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(ktExpression2) : null);
        }
        if (referenceExpressions.isEmpty()) {
            String kind2 = declaration2.isLocal() ? "Variable" : "Property";
            this.showErrorHint(project, editor, kind2 + " '" + name2 + "' is never used");
            return;
        }
        HashSet<PsiElement> assignments = new HashSet<PsiElement>();
        Iterable $receiver$iv = referenceExpressions;
        for (Object element$iv : $receiver$iv) {
            KtExpression expression2 = (KtExpression)element$iv;
            parent2 = expression2.getParent();
            KtBinaryExpression assignment = KtPsiUtilKt.getAssignmentByLHS(expression2);
            if (assignment != null) {
                assignments.add((PsiElement)parent2);
            }
            if (!(parent2 instanceof KtUnaryExpression) || !kotlin.collections.CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.INCREMENT_OPERATIONS), (Object)((KtUnaryExpression)parent2).getOperationToken())) continue;
            assignments.add((PsiElement)parent2);
        }
        KtExpression initializerInDeclaration = declaration2.getInitializer();
        if (initializerInDeclaration != null) {
            if (!assignments.isEmpty()) {
                String string2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                this.reportAmbiguousAssignment(project, editor, string2, (Set<? extends PsiElement>)assignments);
                return;
            }
            ktExpression = initializerInDeclaration;
        } else {
            Object object = kotlin.collections.CollectionsKt.singleOrNull((Iterable)assignments);
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((ktExpression = (KtBinaryExpression)object) == null || (ktExpression = ((KtBinaryExpression)ktExpression).getRight()) == null) {
                String string3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                this.reportAmbiguousAssignment(project, editor, string3, (Set<? extends PsiElement>)assignments);
                return;
            }
        }
        KtExpression initializer2 = ktExpression;
        Iterable $receiver$iv2 = referenceExpressions;
        parent2 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getContainingFile(), (Object)file2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List referencesInOriginalFile = (List)destination$iv$iv;
        $receiver$iv$iv = referencesInOriginalFile;
        boolean isHighlighting = !$receiver$iv$iv.isEmpty();
        InlineUtilsKt.highlightElements(project, editor, referencesInOriginalFile);
        if (referencesInOriginalFile.size() != referenceExpressions.size()) {
            KtExpression ktExpression3 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer");
            InlineUtilsKt.preProcessInternalUsages(ktExpression3, referenceExpressions);
        }
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default((KtDeclaration)element2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        VariableDescriptor descriptor2 = (VariableDescriptor)declarationDescriptor;
        if (((KtProperty)element2).getTypeReference() != null) {
            kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"TypeUtils.NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
        } else {
            SimpleType simpleType3 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"TypeUtils.NO_EXPECTED_TYPE");
            kotlinType = simpleType3;
        }
        KotlinType expectedType = kotlinType;
        KtExpression initializerCopy = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)initializer2);
        Function0<BindingContext> analyzeInitializerCopy$ = new Function0<BindingContext>(initializerCopy, initializer2, expectedType){
            final /* synthetic */ KtExpression $initializerCopy;
            final /* synthetic */ KtExpression $initializer;
            final /* synthetic */ KotlinType $expectedType;

            @NotNull
            public final BindingContext invoke() {
                LexicalScope lexicalScope = ScopeUtils.getResolutionScope(this.$initializer);
                KtExpression ktExpression = this.$initializer;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"initializer");
                return AnalyzerUtilKt.analyzeInContext$default(this.$initializerCopy, lexicalScope, ktExpression, null, null, this.$expectedType, false, null, null, 236, null);
            }
            {
                this.$initializerCopy = ktExpression;
                this.$initializer = ktExpression2;
                this.$expectedType = kotlinType;
                super(0);
            }
        };
        Function0<Unit> performRefactoring$ = new Function0<Unit>(editor, descriptor2, element2, initializerCopy, analyzeInitializerCopy$, declaration2, assignments, isHighlighting, project){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VariableDescriptor $descriptor;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ KtExpression $initializerCopy;
            final /* synthetic */ inlineElement.2 $analyzeInitializerCopy;
            final /* synthetic */ KtProperty $declaration;
            final /* synthetic */ HashSet $assignments;
            final /* synthetic */ boolean $isHighlighting;
            final /* synthetic */ Project $project;

            public final void invoke() {
                PsiReference psiReference;
                PsiReference psiReference2;
                Editor editor = this.$editor;
                if (editor != null) {
                    Editor editor2;
                    Editor it = editor2 = editor;
                    psiReference2 = TargetElementUtil.findReference((Editor)it, (int)it.getCaretModel().getOffset());
                } else {
                    psiReference2 = psiReference = null;
                }
                if (!(psiReference2 instanceof KtSimpleNameReference)) {
                    psiReference = null;
                }
                KtSimpleNameReference reference2 = (KtSimpleNameReference)psiReference;
                CodeToInlineBuilder replacementBuilder = new CodeToInlineBuilder(this.$descriptor, ResolutionUtils.getResolutionFacade((KtElement)this.$element));
                CodeToInline replacement2 = CodeToInlineBuilder.prepareCodeToInline$default(replacementBuilder, this.$initializerCopy, kotlin.collections.CollectionsKt.emptyList(), (Function0)new Function0<BindingContext>(this){
                    final /* synthetic */ inlineElement.3 this$0;

                    @NotNull
                    public final BindingContext invoke() {
                        return this.this$0.$analyzeInitializerCopy.invoke();
                    }

                    public final KDeclarationContainer getOwner() {
                        return null;
                    }

                    public final String getName() {
                        return "analyzeInitializerCopy";
                    }

                    public final String getSignature() {
                        return "invoke()Lorg/jetbrains/kotlin/resolve/BindingContext;";
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, null, 8, null);
                CallableUsageReplacementStrategy replacementStrategy = new CallableUsageReplacementStrategy(replacement2);
                KotlinInlineValDialog dialog2 = new KotlinInlineValDialog(this.$declaration, reference2, replacementStrategy, this.$assignments);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    dialog2.show();
                    if (!dialog2.isOK() && this.$isHighlighting) {
                        StatusBar statusBar;
                        StatusBar statusBar2 = statusBar = WindowManager.getInstance().getStatusBar(this.$project);
                        if (statusBar2 != null) {
                            statusBar2.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                        }
                    }
                } else {
                    dialog2.doAction();
                }
            }
            {
                this.$editor = editor;
                this.$descriptor = variableDescriptor;
                this.$element = psiElement2;
                this.$initializerCopy = ktExpression;
                this.$analyzeInitializerCopy = var5_5;
                this.$declaration = ktProperty;
                this.$assignments = hashSet;
                this.$isHighlighting = bl;
                this.$project = project;
                super(0);
            }
        };
        Collection $i$a$1$filter = foreignUsages;
        if (!$i$a$1$filter.isEmpty()) {
            MultiMap multiMap;
            MultiMap $receiver = multiMap = new MultiMap();
            $receiver.putValue(null, (Object)("Property '" + name2 + "' has non-Kotlin usages. They won't be processed by the Inline refactoring."));
            Iterable $receiver$iv3 = foreignUsages;
            for (Object element$iv : $receiver$iv3) {
                PsiElement it = (PsiElement)element$iv;
                $receiver.putValue((Object)it, (Object)it.getText());
            }
            MultiMap conflicts2 = multiMap;
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project, conflicts2, null, (Function0)new Function0<Unit>(performRefactoring$){
                final /* synthetic */ inlineElement.3 $performRefactoring;

                public final void invoke() {
                    this.$performRefactoring.invoke();
                }
                {
                    this.$performRefactoring = var1_1;
                    super(0);
                }
            }, 2, null);
        } else {
            performRefactoring$.invoke();
        }
    }

    private final void reportAmbiguousAssignment(Project project, Editor editor, String name2, Set<? extends PsiElement> assignments) {
        String message2;
        String key = assignments.isEmpty() ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
        String string = message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{name2}));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        this.showErrorHint(project, editor, string);
    }

    private final void showErrorHint(Project project, Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
    }
}

