/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFileProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiFileProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "allRenames", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "idea"})
public final class RenameKotlinFileProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtFile && ProjectRootsUtil.isInProjectSource(element2);
    }

    public void prepareRenaming(@Nullable PsiElement element2, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        PsiElement psiElement2 = element2;
        if (!(psiElement2 instanceof KtFile)) {
            psiElement2 = null;
        }
        KtFile ktFile = (KtFile)psiElement2;
        if (ktFile == null) {
            return;
        }
        KtFile jetFile = ktFile;
        if (Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(newName2), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module == null) {
            return;
        }
        Module module2 = module;
        JvmFileClassInfo fileInfo = JvmFileClassUtil.getFileClassInfoNoResolve(jetFile);
        if (!fileInfo.getWithJvmName()) {
            FqName facadeFqName = fileInfo.getFacadeClassFqName();
            Project project = jetFile.getProject();
            PsiClass facadeClass = JavaPsiFacade.getInstance((Project)project).findClass(facadeFqName.asString(), GlobalSearchScope.moduleScope((Module)module2));
            if (facadeClass != null) {
                Map<PsiElement, String> map2 = allRenames;
                String string = PackagePartClassUtils.getFilePartShortName(newName2);
                map2.put((PsiElement)facadeClass, string);
            }
        }
    }
}

