/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0014J\"\u0010\u001b\u001a\u00020\u00022\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00190\u001d\u00a2\u0006\u0002\b\u001eH\u0086\bJ\b\u0010\u001f\u001a\u00020\u0002H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "Lorg/jetbrains/kotlin/ir/builders/IrStatementsBuilder;", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "context", "Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "startOffset", "", "endOffset", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "resultType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/ir/builders/IrGeneratorContext;Lorg/jetbrains/kotlin/ir/builders/Scope;IILorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "getResultType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "setResultType", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "statements", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "addStatement", "", "irStatement", "block", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "doBuild", "ir.tree"})
public final class IrBlockBuilder
extends IrStatementsBuilder<IrBlock> {
    private final ArrayList<IrStatement> statements;
    @Nullable
    private final IrStatementOrigin origin;
    @Nullable
    private KotlinType resultType;

    @NotNull
    public final IrBlock block(@NotNull Function1<? super IrBlockBuilder, Unit> body2) {
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        body2.invoke((Object)this);
        return this.doBuild();
    }

    @Override
    protected void addStatement(@NotNull IrStatement irStatement) {
        Intrinsics.checkParameterIsNotNull((Object)irStatement, (String)"irStatement");
        this.statements.add(irStatement);
    }

    @Override
    @NotNull
    public IrBlock doBuild() {
        KotlinType kotlinType;
        KotlinType kotlinType2 = this.resultType;
        if (kotlinType2 == null) {
            Object object = CollectionsKt.lastOrNull((List)this.statements);
            if (!(object instanceof IrExpression)) {
                object = null;
            }
            IrExpression irExpression = (IrExpression)object;
            kotlinType2 = kotlinType = irExpression != null ? irExpression.getType() : null;
        }
        if (kotlinType2 == null) {
            SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
            kotlinType = simpleType2;
        }
        KotlinType resultType = kotlinType;
        IrBlockImpl irBlock = new IrBlockImpl(this.getStartOffset(), this.getEndOffset(), resultType, this.origin);
        irBlock.getStatements().addAll((Collection<IrStatement>)this.statements);
        return irBlock;
    }

    @Nullable
    public final IrStatementOrigin getOrigin() {
        return this.origin;
    }

    @Nullable
    public final KotlinType getResultType() {
        return this.resultType;
    }

    public final void setResultType(@Nullable KotlinType kotlinType) {
        this.resultType = kotlinType;
    }

    public IrBlockBuilder(@NotNull IrGeneratorContext context, @NotNull Scope scope2, int startOffset, int endOffset, @Nullable IrStatementOrigin origin, @Nullable KotlinType resultType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        super(context, scope2, startOffset, endOffset);
        this.origin = origin;
        this.resultType = resultType;
        this.statements = new ArrayList();
    }

    public /* synthetic */ IrBlockBuilder(IrGeneratorContext irGeneratorContext, Scope scope2, int n, int n2, IrStatementOrigin irStatementOrigin, KotlinType kotlinType, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            irStatementOrigin = null;
        }
        if ((n3 & 0x20) != 0) {
            kotlinType = null;
        }
        this(irGeneratorContext, scope2, n, n2, irStatementOrigin, kotlinType);
    }
}

