/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J.\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "checkForErrors", "", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class TopDownAnalyzerFacadeForJS {
    public static final TopDownAnalyzerFacadeForJS INSTANCE;

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull JsConfig config2) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        JsModuleDescriptor it;
        Collection<ModuleDescriptorImpl> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Project project = config2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"config.project");
        ProjectContext projectContext = ContextKt.ProjectContext(project);
        Name name2 = Name.special("<" + config2.getModuleId() + ">");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<${config.moduleId}>\")");
        MutableModuleContext context = ContextKt.ContextForNewModule(projectContext, name2, JsPlatform.INSTANCE.getBuiltIns(), null);
        Iterable iterable = config2.getModuleDescriptors();
        Collection collection2 = CollectionsKt.listOf((Object)context.getModule());
        ModuleDescriptorImpl moduleDescriptorImpl2 = context.getModule();
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsModuleDescriptor jsModuleDescriptor = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv = config2.getFriendModuleDescriptors();
        collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (Iterable)CollectionsKt.listOf((Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        moduleDescriptorImpl2.setDependencies((List<ModuleDescriptorImpl>)collection2, CollectionsKt.toSet((Iterable)collection));
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context.getModule(), config2.getModuleKind());
        return TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files2, trace, context, config2);
    }

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull JsConfig config2) {
        PackageFragmentProvider packageFragmentProvider2;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)moduleContext, (String)"moduleContext");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        PackagesWithHeaderMetadata packagesWithHeaderMetadata = config2.getConfiguration().get(JSConfigurationKeys.FALLBACK_METADATA);
        if (packagesWithHeaderMetadata != null) {
            PackagesWithHeaderMetadata packagesWithHeaderMetadata2;
            PackagesWithHeaderMetadata it;
            PackagesWithHeaderMetadata packagesWithHeaderMetadata3 = it = (packagesWithHeaderMetadata2 = packagesWithHeaderMetadata);
            Intrinsics.checkExpressionValueIsNotNull((Object)packagesWithHeaderMetadata3, (String)"it");
            packageFragmentProvider2 = KotlinJavascriptSerializationUtil.INSTANCE.readDescriptors(packagesWithHeaderMetadata3, moduleContext.getStorageManager(), moduleContext.getModule(), DeserializationConfiguration.Default.INSTANCE);
        } else {
            packageFragmentProvider2 = null;
        }
        PackageFragmentProvider packageFragment = packageFragmentProvider2;
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), CommonConfigurationKeysKt.getLanguageVersionSettings(config2.getConfiguration()), packageFragment);
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    @JvmStatic
    public static final void checkForErrors(@NotNull Collection<? extends KtFile> allFiles2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(allFiles2, (String)"allFiles");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2);
        for (KtFile ktFile : allFiles2) {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)ktFile);
        }
    }

    private TopDownAnalyzerFacadeForJS() {
        INSTANCE = this;
    }

    static {
        new TopDownAnalyzerFacadeForJS();
    }
}

