/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

public final class JsProgram
extends SourceInfoAwareJsNode {
    private final JsGlobalBlock globalBlock = new JsGlobalBlock();
    private final JsRootScope rootScope = new JsRootScope(this);
    private final JsObjectScope topScope = new JsObjectScope(this.rootScope, "Global");

    public JsGlobalBlock getGlobalBlock() {
        return this.globalBlock;
    }

    public JsNumberLiteral getNumberLiteral(double value2) {
        return new JsNumberLiteral.JsDoubleLiteral(value2);
    }

    public JsNumberLiteral getNumberLiteral(int value2) {
        return new JsNumberLiteral.JsIntLiteral(value2);
    }

    public JsRootScope getRootScope() {
        return this.rootScope;
    }

    public JsObjectScope getScope() {
        return this.topScope;
    }

    @NotNull
    public JsStringLiteral getStringLiteral(String value2) {
        JsStringLiteral jsStringLiteral = new JsStringLiteral(value2);
        if (jsStringLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgram", "getStringLiteral"));
        }
        return jsStringLiteral;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitProgram(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.globalBlock);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.accept(this.globalBlock);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsProgram deepCopy() {
        throw new UnsupportedOperationException();
    }
}

