/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;

public abstract class KtStubElementType<StubT extends StubElement, PsiT extends KtElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public KtStubElementType(@NotNull @NonNls String debugName2, @NotNull Class<PsiT> psiClass2, @NotNull Class<?> stubClass) {
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "<init>"));
        }
        if (psiClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "<init>"));
        }
        if (stubClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubClass", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "<init>"));
        }
        super(debugName2, (Language)KotlinLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass2.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass2.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass2.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (KtElementImplStub[])Array.newInstance(psiClass2, 0);
        this.arrayFactory = count -> {
            if (psiClass2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "lambda$new$0"));
            }
            if (count == 0) {
                return this.emptyArray;
            }
            return (KtElementImplStub[])Array.newInstance(psiClass2, count);
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "createPsiFromAst"));
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, (Object[])new Object[]{node});
        if (ktElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "createPsiFromAst"));
        }
        return (PsiT)ktElementImplStub;
    }

    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "createPsi"));
        }
        KtElementImplStub ktElementImplStub = (KtElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, (Object[])new Object[]{stub});
        if (ktElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "createPsi"));
        }
        return (PsiT)ktElementImplStub;
    }

    @NotNull
    public String getExternalId() {
        String string = "kotlin." + this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "getExternalId"));
        }
        return string;
    }

    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof KtClassOrObject || psi instanceof KtFunction) {
            return true;
        }
        if (psi instanceof KtProperty) {
            return !((KtProperty)psi).isLocal();
        }
        return KtStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent2 = node.getTreeParent();
        IElementType parentType = parent2.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent2);
        }
        return parentType instanceof IStubFileElementType;
    }

    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "indexStub"));
        }
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        ArrayFactory<PsiT> arrayFactory = this.arrayFactory;
        if (arrayFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType", "getArrayFactory"));
        }
        return arrayFactory;
    }
}

