/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.PublishedApiUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;

public class ModifiersChecker {
    private static final Set<KtModifierKeywordToken> MODIFIERS_ILLEGAL_ON_PARAMETERS = Sets.newHashSet();
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final Iterable<DeclarationChecker> declarationCheckers;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalInner"));
        }
        return ModifiersChecker.checkIllegalInner(descriptor2) != InnerModifierCheckResult.ALLOWED;
    }

    public static boolean isCompanionModifierAllowed(@NotNull KtDeclaration declaration2) {
        KtDeclaration containingDeclaration;
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isCompanionModifierAllowed"));
        }
        return declaration2 instanceof KtObjectDeclaration && (containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(declaration2)) instanceof KtClassOrObject;
    }

    @NotNull
    private static InnerModifierCheckResult checkIllegalInner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ILLEGAL_POSITION;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isInterface(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_INTERFACE;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        if (DescriptorUtils.isObject(containingDeclaration)) {
            InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.IN_OBJECT;
            if (innerModifierCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
            }
            return innerModifierCheckResult;
        }
        InnerModifierCheckResult innerModifierCheckResult = InnerModifierCheckResult.ALLOWED;
        if (innerModifierCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "checkIllegalInner"));
        }
        return innerModifierCheckResult;
    }

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker", "isIllegalNestedClass"));
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || DescriptorUtils.isLocal(containingClass);
    }

    @NotNull
    public static Modality resolveMemberModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext2, @Nullable DeclarationDescriptor containingDescriptor) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveMemberModalityFromModifiers"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveMemberModalityFromModifiers"));
        }
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierListOwner, defaultModality, bindingContext2, containingDescriptor, false);
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveMemberModalityFromModifiers"));
        }
        return modality;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext2, @Nullable DeclarationDescriptor containingDescriptor, boolean allowSealed) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        KtModifierList modifierList = modifierListOwner != null ? modifierListOwner.getModifierList() : null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality, allowSealed);
        if (modifierListOwner != null) {
            List extensions = DeclarationAttributeAltererExtension.Companion.getInstances(modifierListOwner.getProject());
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, modifierListOwner);
            for (DeclarationAttributeAltererExtension extension : extensions) {
                Modality newModality = extension.refineDeclarationModality(modifierListOwner, descriptor2, containingDescriptor, modality, bindingContext2);
                if (newModality == null) continue;
                modality = newModality;
                break;
            }
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality2;
    }

    @NotNull
    private static Modality resolveModalityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Modality defaultModality, boolean allowSealed) {
        if (defaultModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultModality", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        if (modifierList == null) {
            Modality modality = defaultModality;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (allowSealed && modifierList.hasModifier(KtTokens.SEALED_KEYWORD)) {
            Modality modality = Modality.SEALED;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (modifierList.hasModifier(KtTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                Modality modality = Modality.ABSTRACT;
                if (modality == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
                }
                return modality;
            }
            Modality modality = Modality.OPEN;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (hasAbstractModifier) {
            Modality modality = Modality.ABSTRACT;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        boolean hasFinalModifier = modifierList.hasModifier(KtTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        if (hasFinalModifier) {
            Modality modality = Modality.FINAL;
            if (modality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
            }
            return modality;
        }
        Modality modality = defaultModality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveModalityFromModifiers"));
        }
        return modality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull KtModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        return visibility;
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (defaultVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultVisibility", "org/jetbrains/kotlin/resolve/ModifiersChecker", "resolveVisibilityFromModifiers"));
        }
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(KtTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public static boolean isInnerClass(@Nullable KtModifierList modifierList) {
        return modifierList != null && modifierList.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        if (declarationCheckers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationCheckers", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/ModifiersChecker", "<init>"));
        }
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker", "withTrace"));
        }
        ModifiersCheckingProcedure modifiersCheckingProcedure = new ModifiersCheckingProcedure(trace, this.languageVersionSettings);
        if (modifiersCheckingProcedure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker", "withTrace"));
        }
        return modifiersCheckingProcedure;
    }

    static {
        MODIFIERS_ILLEGAL_ON_PARAMETERS.addAll(Arrays.asList(KtTokens.MODIFIER_KEYWORDS_ARRAY));
        MODIFIERS_ILLEGAL_ON_PARAMETERS.remove((Object)KtTokens.VARARG_KEYWORD);
    }

    public class ModifiersCheckingProcedure {
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;

        private ModifiersCheckingProcedure(BindingTrace trace, LanguageVersionSettings languageVersionSettings) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "<init>"));
            }
            this.trace = trace;
            this.languageVersionSettings = languageVersionSettings;
        }

        public void checkParameterHasNoValOrVar(@NotNull KtValVarKeywordOwner parameter, @NotNull DiagnosticFactory1<PsiElement, KtKeywordToken> diagnosticFactory) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkParameterHasNoValOrVar"));
            }
            if (diagnosticFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticFactory", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkParameterHasNoValOrVar"));
            }
            PsiElement valOrVar = parameter.getValOrVarKeyword();
            if (valOrVar != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (KtKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForDeclaration"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForDeclaration"));
            }
            this.checkNestedClassAllowed(modifierListOwner, descriptor2);
            this.checkObjectInsideInnerClass(modifierListOwner, descriptor2);
            this.checkTypeParametersModifiers(modifierListOwner);
            this.checkModifierListCommon(modifierListOwner, descriptor2);
        }

        private void checkObjectInsideInnerClass(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            KtObjectDeclaration ktObject;
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkObjectInsideInnerClass"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkObjectInsideInnerClass"));
            }
            if (modifierListOwner instanceof KtObjectDeclaration && !(ktObject = (KtObjectDeclaration)modifierListOwner).isLocal() && ModifiersChecker.isIllegalNestedClass(descriptor2)) {
                this.trace.report(Errors.NESTED_OBJECT_NOT_ALLOWED.on(ktObject));
            }
        }

        private void checkModifierListCommon(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifierListCommon"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifierListCommon"));
            }
            AnnotationUseSiteTargetChecker.INSTANCE.check(modifierListOwner, descriptor2, this.trace);
            this.runDeclarationCheckers(modifierListOwner, descriptor2);
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, descriptor2);
            ModifierCheckerCore.INSTANCE.check(modifierListOwner, this.trace, descriptor2, this.languageVersionSettings);
        }

        public void checkModifiersForLocalDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForLocalDeclaration"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForLocalDeclaration"));
            }
            this.checkModifierListCommon(modifierListOwner, descriptor2);
        }

        public void checkModifiersForDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration) {
            if (multiDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkModifiersForDestructuringDeclaration"));
            }
            ModifiersChecker.this.annotationChecker.check(multiDeclaration, this.trace, null);
            ModifierCheckerCore.INSTANCE.check(multiDeclaration, this.trace, null, this.languageVersionSettings);
            for (KtDestructuringDeclarationEntry multiEntry : multiDeclaration.getEntries()) {
                ModifiersChecker.this.annotationChecker.check(multiEntry, this.trace, null);
                ModifierCheckerCore.INSTANCE.check(multiEntry, this.trace, null, this.languageVersionSettings);
                UnderscoreChecker.INSTANCE.checkNamed(multiEntry, this.trace, this.languageVersionSettings, true);
            }
        }

        private void checkNestedClassAllowed(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkNestedClassAllowed"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkNestedClassAllowed"));
            }
            if (modifierListOwner.hasModifier(KtTokens.INNER_KEYWORD)) {
                return;
            }
            if (modifierListOwner instanceof KtClass && !(modifierListOwner instanceof KtEnumEntry)) {
                boolean localEnumError;
                KtClass aClass2 = (KtClass)modifierListOwner;
                boolean bl = localEnumError = aClass2.isLocal() && aClass2.isEnum();
                if (!localEnumError && ModifiersChecker.isIllegalNestedClass(descriptor2)) {
                    this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(aClass2));
                }
            }
        }

        @NotNull
        public Map<KtModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull KtModifierList modifierList, @NotNull Collection<KtModifierKeywordToken> possibleModifiers) {
            if (modifierList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            if (possibleModifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleModifiers", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            HashMap tokens2 = Maps.newHashMap();
            for (KtModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList.hasModifier(modifier)) continue;
                tokens2.put(modifier, modifierList.getModifier(modifier));
            }
            HashMap hashMap = tokens2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "getTokensCorrespondingToModifiers"));
            }
            return hashMap;
        }

        public void runDeclarationCheckers(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2) {
            if (declaration2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "runDeclarationCheckers"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "runDeclarationCheckers"));
            }
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                checker.check(declaration2, descriptor2, this.trace, this.trace.getBindingContext(), this.languageVersionSettings);
            }
            OperatorModifierChecker.INSTANCE.check(declaration2, descriptor2, this.trace, this.languageVersionSettings);
            PublishedApiUsageChecker.INSTANCE.check(declaration2, descriptor2, this.trace);
        }

        public void checkTypeParametersModifiers(@NotNull KtModifierListOwner modifierListOwner) {
            if (modifierListOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure", "checkTypeParametersModifiers"));
            }
            if (!(modifierListOwner instanceof KtTypeParameterListOwner)) {
                return;
            }
            List<KtTypeParameter> typeParameters = ((KtTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (KtTypeParameter typeParameter : typeParameters) {
                ModifierCheckerCore.INSTANCE.check(typeParameter, this.trace, null, this.languageVersionSettings);
            }
        }
    }

    private static enum InnerModifierCheckResult {
        ALLOWED,
        ILLEGAL_POSITION,
        IN_INTERFACE,
        IN_OBJECT;

    }
}

