/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;

public class OverloadResolutionResultsImpl<D extends CallableDescriptor>
implements OverloadResolutionResults<D> {
    private final Collection<MutableResolvedCall<D>> results;
    private final OverloadResolutionResults.Code resultCode;
    private DelegatingBindingTrace trace;
    private Collection<ResolvedCall<D>> allCandidates;

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> success(@NotNull MutableResolvedCall<D> candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "success"));
        }
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> nameNotFound() {
        OverloadResolutionResultsImpl<D> results2 = new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.NAME_NOT_FOUND, Collections.emptyList());
        results2.setAllCandidates(Collections.emptyList());
        return results2;
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> singleFailedCandidate(MutableResolvedCall<D> candidate) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> manyFailedCandidates(Collection<MutableResolvedCall<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> candidatesWithWrongReceiver(Collection<MutableResolvedCall<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> ambiguity(Collection<MutableResolvedCall<D>> candidates2) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.AMBIGUITY, candidates2);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(Collection<MutableResolvedCall<D>> candidates2) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE, candidates2);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(MutableResolvedCall<D> candidate) {
        return OverloadResolutionResultsImpl.incompleteTypeInference(Collections.singleton(candidate));
    }

    private OverloadResolutionResultsImpl(@NotNull OverloadResolutionResults.Code resultCode, @NotNull Collection<MutableResolvedCall<D>> results2) {
        if (resultCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultCode", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "<init>"));
        }
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "<init>"));
        }
        this.results = results2;
        this.resultCode = resultCode;
    }

    @Override
    @NotNull
    public Collection<MutableResolvedCall<D>> getResultingCalls() {
        Collection<MutableResolvedCall<D>> collection = this.results;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "getResultingCalls"));
        }
        return collection;
    }

    @Override
    @NotNull
    public MutableResolvedCall<D> getResultingCall() {
        assert (this.isSingleResult());
        MutableResolvedCall<D> mutableResolvedCall = this.results.iterator().next();
        if (mutableResolvedCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "getResultingCall"));
        }
        return mutableResolvedCall;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        Object d = this.getResultingCall().getResultingDescriptor();
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "getResultingDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public OverloadResolutionResults.Code getResultCode() {
        OverloadResolutionResults.Code code = this.resultCode;
        if (code == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "getResultCode"));
        }
        return code;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode.isSuccess();
    }

    @Override
    public boolean isSingleResult() {
        return this.results.size() == 1 && this.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
    }

    @Override
    public boolean isNothing() {
        return this.resultCode == OverloadResolutionResults.Code.NAME_NOT_FOUND;
    }

    @Override
    public boolean isAmbiguity() {
        return this.resultCode == OverloadResolutionResults.Code.AMBIGUITY;
    }

    @Override
    public boolean isIncomplete() {
        return this.resultCode == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE;
    }

    public DelegatingBindingTrace getTrace() {
        return this.trace;
    }

    public OverloadResolutionResultsImpl<D> setTrace(DelegatingBindingTrace trace) {
        this.trace = trace;
        return this;
    }

    public void setAllCandidates(@Nullable Collection<ResolvedCall<D>> allCandidates2) {
        this.allCandidates = allCandidates2;
    }

    @Override
    @Nullable
    public Collection<ResolvedCall<D>> getAllCandidates() {
        return this.allCandidates;
    }

    @NotNull
    public OverloadResolutionResultsImpl<D> changeStatusToSuccess() {
        if (this.getResultCode() == OverloadResolutionResults.Code.SUCCESS) {
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = this;
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "changeStatusToSuccess"));
            }
            return overloadResolutionResultsImpl;
        }
        assert (this.isSingleResult() && this.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) : "Only incomplete type inference status with one candidate can be changed to success: " + (Object)((Object)this.getResultCode()) + "\n" + this.getResultingCalls();
        OverloadResolutionResultsImpl<D> newResults = new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, this.getResultingCalls());
        newResults.setAllCandidates(this.getAllCandidates());
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = newResults;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl", "changeStatusToSuccess"));
        }
        return overloadResolutionResultsImpl;
    }
}

