/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SinceKotlinAnnotationValueChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "regex", "Lkotlin/text/Regex;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class SinceKotlinAnnotationValueChecker
implements DeclarationChecker {
    private static final Regex regex;
    public static final SinceKotlinAnnotationValueChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        AnnotationDescriptor annotationDescriptor = SinceKotlinUtilKt.getSinceKotlinAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String version = string;
        CharSequence charSequence = version;
        Regex regex = SinceKotlinAnnotationValueChecker.regex;
        if (!regex.matches(charSequence)) {
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(annotation2.getSource());
            if (psiElement2 == null) {
                psiElement2 = declaration2;
            }
            diagnosticHolder.report(Errors.ILLEGAL_SINCE_KOTLIN_VALUE.on(psiElement2));
            return;
        }
        ApiVersion apiVersion = ApiVersion.Companion.parse(version);
        ApiVersion specified = languageVersionSettings.getApiVersion();
        if (apiVersion != null && apiVersion.compareTo(specified) > 0) {
            PsiElement psiElement3 = KotlinSourceElementKt.getPsi(annotation2.getSource());
            if (psiElement3 == null) {
                psiElement3 = declaration2;
            }
            diagnosticHolder.report(Errors.NEWER_VERSION_IN_SINCE_KOTLIN.on(psiElement3, specified.getVersionString()));
        }
    }

    private SinceKotlinAnnotationValueChecker() {
        String string;
        INSTANCE = this;
        String number = string = "(0|[1-9][0-9]*)";
        regex = new Regex(number + "\\" + "." + number + "(" + "\\" + "." + number + ")?");
    }

    static {
        new SinceKotlinAnnotationValueChecker();
    }
}

