/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupportKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinEnum;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Function1<KotlinType, Boolean> VALID_SUPERTYPE = type2 -> {
        assert (!KotlinTypeKt.isError(type2)) : "Error types must be filtered out in DescriptorResolver";
        return TypeUtils.getClassDescriptor(type2) != null;
    };
    private final LazyClassContext c;
    @Nullable
    private final KtClassOrObject classOrObject;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final NotNullLazyValue<Modality> modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final boolean isData;
    private final boolean isHeader;
    private final boolean isImpl;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<ClassDescriptorWithResolutionScopes> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<KtObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final MemberScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;
    private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
    private final NotNullLazyValue<LexicalScope> scopeForInitializerResolution;
    private final NotNullLazyValue<Collection<ClassDescriptor>> sealedSubclasses;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name2, @NotNull KtClassLikeInfo classLikeInfo, boolean isExternal) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, name2, KotlinSourceElementKt.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()), isExternal);
        this.c = c;
        this.classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (this.classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, this.classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        StorageManager storageManager = c.getStorageManager();
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.kind = classLikeInfo.getClassKind();
        this.staticScope = this.kind == ClassKind.ENUM_CLASS ? new StaticScopeForKotlinEnum(storageManager, this) : MemberScope.Empty.INSTANCE;
        this.typeConstructor = new LazyClassTypeConstructor();
        this.isCompanionObject = classLikeInfo instanceof KtObjectInfo && ((KtObjectInfo)classLikeInfo).isCompanionObject();
        KtModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = storageManager.createLazyValue(() -> Modality.FINAL);
        } else {
            Modality defaultModality = this.kind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = storageManager.createLazyValue(() -> {
                if (c == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "lambda$new$2"));
                }
                return ModifiersChecker.resolveModalityFromModifiers(this.classOrObject, defaultModality, c.getTrace().getBindingContext(), null, true);
            });
        }
        boolean isLocal = this.classOrObject != null && KtPsiUtil.isLocal(this.classOrObject);
        Visibility defaultVisibility = this.kind == ClassKind.ENUM_ENTRY || this.kind == ClassKind.OBJECT && this.isCompanionObject ? Visibilities.PUBLIC : Visibilities.DEFAULT_VISIBILITY;
        this.visibility = isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
        this.isInner = ModifiersChecker.isInnerClass(modifierList) && !ModifiersChecker.isIllegalInner(this);
        this.isData = modifierList != null && modifierList.hasModifier(KtTokens.DATA_KEYWORD);
        this.isHeader = modifierList != null && modifierList.hasModifier(KtTokens.HEADER_KEYWORD);
        this.isImpl = modifierList != null && modifierList.hasModifier(KtTokens.IMPL_KEYWORD);
        ArrayList<KtAnnotationEntry> annotationEntries = new ArrayList<KtAnnotationEntry>();
        if (this.classOrObject != null && this.classOrObject.getParent() instanceof KtObjectLiteralExpression) {
            annotationEntries.addAll(KtPsiUtilKt.getAnnotationEntries((KtObjectLiteralExpression)this.classOrObject.getParent()));
        }
        if (modifierList != null) {
            annotationEntries.addAll(modifierList.getAnnotationEntries());
        }
        this.annotations = !annotationEntries.isEmpty() ? new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$1", "getScope"));
                }
                return lexicalScope;
            }
        }, annotationEntries) : Annotations.Companion.getEMPTY();
        List<KtAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.Companion.getEMPTY() : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
                }
                return lexicalScope;
            }
        }, jetDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(() -> this.computeCompanionObjectDescriptor(this.getCompanionObjectIfAllowed()));
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(this::computeCompanionObjectDescriptor);
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(() -> {
            this.doForceResolveAllContents();
            return null;
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, (Function0<? extends LexicalScope>)((Function0)this::getOuterScope));
        this.parameters = c.getStorageManager().createLazyValue(() -> {
            List<KtTypeParameter> typeParameters;
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "lambda$new$5"));
            }
            KtClassLikeInfo classInfo = this.declarationProvider.getOwnerInfo();
            KtTypeParameterList typeParameterList = classInfo.getTypeParameterList();
            if (typeParameterList == null) {
                return Collections.emptyList();
            }
            if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
            }
            if (classInfo.getClassKind() == ClassKind.OBJECT) {
                c.getTrace().report(Errors.TYPE_PARAMETERS_IN_OBJECT.on(typeParameterList));
            }
            if ((typeParameters = typeParameterList.getParameters()).isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<LazyTypeParameterDescriptor> parameters2 = new ArrayList<LazyTypeParameterDescriptor>(typeParameters.size());
            for (int i = 0; i < typeParameters.size(); ++i) {
                parameters2.add(new LazyTypeParameterDescriptor(c, this, typeParameters.get(i), i));
            }
            return parameters2;
        });
        this.scopeForInitializerResolution = storageManager.createLazyValue(() -> {
            if (classLikeInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "lambda$new$6"));
            }
            return ClassResolutionScopesSupportKt.scopeForInitializerResolution(this, this.createInitializerScopeParent(), classLikeInfo.getPrimaryConstructorParameters());
        });
        this.sealedSubclasses = storageManager.createLazyValue(() -> DescriptorUtilsKt.computeSealedSubclasses(this));
    }

    @NotNull
    private DeclarationDescriptor createInitializerScopeParent() {
        ClassConstructorDescriptor primaryConstructor2 = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            ClassConstructorDescriptor classConstructorDescriptor = primaryConstructor2;
            if (classConstructorDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createInitializerScopeParent"));
            }
            return classConstructorDescriptor;
        }
        FunctionDescriptorImpl functionDescriptorImpl = new FunctionDescriptorImpl(this, null, Annotations.Companion.getEMPTY(), Name.special("<init-blocks>"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE){
            {
                this.initialize(null, null, Collections.emptyList(), Collections.emptyList(), null, Modality.FINAL, Visibilities.PRIVATE);
            }

            @Override
            @NotNull
            protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind2, @Nullable Name newName2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
                if (newOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "createSubstitutedCopy"));
                }
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "createSubstitutedCopy"));
                }
                if (annotations2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "createSubstitutedCopy"));
                }
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$3", "createSubstitutedCopy"));
                }
                throw new UnsupportedOperationException();
            }
        };
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createInitializerScopeParent"));
        }
        return functionDescriptorImpl;
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getUnsubstitutedMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        LexicalScope lexicalScope = this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getOuterScope"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForConstructorHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForConstructorHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForConstructorHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForCompanionObjectHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForCompanionObjectHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForCompanionObjectHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForStaticMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.scopeForInitializerResolution.invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForInitializerResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List list2 = CollectionsKt.filter(DescriptorUtils.getAllDescriptors(this.unsubstitutedMemberScope), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredCallableMembers"));
        }
        return list2;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2 = this.staticScope;
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getStaticScope"));
        }
        return memberScope2;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        Collection<ClassConstructorDescriptor> collection = this.unsubstitutedMemberScope.getConstructors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getConstructors"));
        }
        return collection;
    }

    @Override
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getTypeConstructor"));
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public ClassDescriptorWithResolutionScopes getCompanionObjectDescriptor() {
        return (ClassDescriptorWithResolutionScopes)this.companionObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        KtObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        List list2 = CollectionsKt.map((Iterable)CollectionsKt.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), companionObject -> companionObject != allowedCompanionObject), this.extraCompanionObjectDescriptors);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDescriptorsForExtraCompanionObjects"));
        }
        return list2;
    }

    @Nullable
    private ClassDescriptorWithResolutionScopes computeCompanionObjectDescriptor(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject == null) {
            return this.createSyntheticCompanionObjectDescriptor();
        }
        KtClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject);
        if (!(companionObjectInfo instanceof KtClassOrObjectInfo)) {
            return null;
        }
        Name name2 = ((KtClassOrObjectInfo)companionObjectInfo).getName();
        assert (name2 != null);
        this.getUnsubstitutedMemberScope().getContributedClassifier(name2, NoLookupLocation.WHEN_GET_COMPANION_OBJECT);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject);
        if (companionObjectDescriptor2 instanceof ClassDescriptorWithResolutionScopes) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (ClassDescriptorWithResolutionScopes)companionObjectDescriptor2;
        }
        return null;
    }

    private ClassDescriptorWithResolutionScopes createSyntheticCompanionObjectDescriptor() {
        Name syntheticCompanionName = this.c.getSyntheticResolveExtension().getSyntheticCompanionObjectNameIfNeeded(this);
        if (syntheticCompanionName == null) {
            return null;
        }
        return new SyntheticClassOrObjectDescriptor(this.c, this.classOrObject, this, syntheticCompanionName, this.getSource(), this.getOuterScope(), Modality.FINAL, Visibilities.PUBLIC, ClassKind.OBJECT, true);
    }

    @Nullable
    private static KtClassLikeInfo getCompanionObjectInfo(@Nullable KtObjectDeclaration companionObject) {
        if (companionObject != null) {
            return KtClassInfoUtil.createClassLikeInfo(companionObject);
        }
        return null;
    }

    @Nullable
    private KtObjectDeclaration getCompanionObjectIfAllowed() {
        KtObjectDeclaration companionObject = (KtObjectDeclaration)CollectionsKt.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject != null && this.isCompanionObjectAllowed() ? companionObject : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = (Modality)((Object)this.modality.invoke());
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isData() {
        return this.isData;
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    public boolean isHeader() {
        return this.isHeader;
    }

    @Override
    public boolean isImpl() {
        return this.isImpl;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDanglingAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        Collection collection = (Collection)this.sealedSubclasses.invoke();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getSealedSubclasses"));
        }
        return collection;
    }

    public String toString() {
        return (this.isHeader ? "header " : (this.isImpl ? "impl " : "")) + "class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        ClassDescriptorWithResolutionScopes companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        DescriptorUtils.getAllDescriptors(this.getUnsubstitutedMemberScope());
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        List list2 = (List)this.parameters.invoke();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredTypeParameters"));
        }
        return list2;
    }

    @NotNull
    protected Collection<KotlinType> computeSupertypes() {
        if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(this)) {
            List<KotlinType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeSupertypes"));
            }
            return list2;
        }
        KtClassOrObject classOrObject = this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
        if (classOrObject == null) {
            Set<KotlinType> set = Collections.singleton(this.c.getModuleDescriptor().getBuiltIns().getAnyType());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeSupertypes"));
            }
            return set;
        }
        List<KotlinType> allSupertypes = this.c.getDescriptorResolver().resolveSupertypes(this.getScopeForClassHeaderResolution(), this, classOrObject, this.c.getTrace());
        ArrayList<KotlinType> arrayList = new ArrayList<KotlinType>(CollectionsKt.filter(allSupertypes, VALID_SUPERTYPE));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "computeSupertypes"));
        }
        return arrayList;
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor {
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;

        public LazyClassTypeConstructor() {
            super(LazyClassDescriptor.this.c.getStorageManager());
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(() -> TypeParameterUtilsKt.computeConstructorTypeParameters(LazyClassDescriptor.this));
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            Collection<KotlinType> collection = LazyClassDescriptor.this.computeSupertypes();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "computeSupertypes"));
            }
            return collection;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportSupertypeLoopError"));
            }
            ClassifierDescriptor supertypeDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (supertypeDescriptor instanceof ClassDescriptor) {
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (superclass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclass", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement2 instanceof KtClassOrObject) {
                KtClassOrObject classOrObject = (KtClassOrObject)psiElement2;
                for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
                    KotlinType supertype;
                    KtTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement2 instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement2).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            SupertypeLoopChecker supertypeLoopChecker = LazyClassDescriptor.this.c.getSupertypeLoopChecker();
            if (supertypeLoopChecker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getSupertypeLoopChecker"));
            }
            return supertypeLoopChecker;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list2 = (List)this.parameters.invoke();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getParameters"));
            }
            return list2;
        }

        @Override
        public boolean isFinal() {
            return LazyClassDescriptor.this.getModality() == Modality.FINAL;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            LazyClassDescriptor lazyClassDescriptor = LazyClassDescriptor.this;
            if (lazyClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getDeclarationDescriptor"));
            }
            return lazyClassDescriptor;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }
    }
}

