/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsLoaderBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;

public class JpsGlobalLoader
extends JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsGlobalLoader.class);
    public static final String SDK_TABLE_COMPONENT_NAME = "ProjectJdkTable";
    public static final JpsElementChildRole<JpsPathVariablesConfiguration> PATH_VARIABLES_ROLE = JpsElementChildRoleBase.create((String)"path variables");
    private static final JpsGlobalExtensionSerializer[] SERIALIZERS = new JpsGlobalExtensionSerializer[]{new GlobalLibrariesSerializer(), new SdkTableSerializer(), new FileTypesSerializer()};
    public static final String FILE_TYPES_COMPONENT_NAME_KEY = "jps.file.types.component.name";
    private final JpsGlobal myGlobal;

    private JpsGlobalLoader(JpsGlobal global, Map<String, String> pathVariables) {
        super(new JpsMacroExpander(pathVariables));
        this.myGlobal = global;
    }

    public static void loadGlobalSettings(JpsGlobal global, String optionsPath) throws IOException {
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        Map<String, String> pathVariables = JpsGlobalLoader.loadPathVariables(global, optionsDir);
        new JpsGlobalLoader(global, pathVariables).load(optionsDir);
    }

    private static Map<String, String> loadPathVariables(JpsGlobal global, Path optionsDir) {
        new JpsGlobalLoader(global, Collections.emptyMap()).loadGlobalComponents(optionsDir, optionsDir.resolve("other.xml"), new PathVariablesSerializer());
        return JpsModelSerializationDataService.computeAllPathVariables(global);
    }

    public static Map<String, String> computeAllPathVariables(@NotNull String optionsPath) {
        if (optionsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsPath", "org/jetbrains/jps/model/serialization/JpsGlobalLoader", "computeAllPathVariables"));
        }
        JpsModel model = JpsElementFactory.getInstance().createModel();
        Path optionsDir = Paths.get(FileUtil.toCanonicalPath((String)optionsPath), new String[0]);
        return JpsGlobalLoader.loadPathVariables(model.getGlobal(), optionsDir);
    }

    @Nullable
    public static String getPathVariable(JpsGlobal global, String name) {
        return JpsModelSerializationDataService.getPathVariableValue(global, name);
    }

    private void load(@NotNull Path optionsDir) {
        if (optionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsDir", "org/jetbrains/jps/model/serialization/JpsGlobalLoader", "load"));
        }
        Path defaultConfigFile = optionsDir.resolve("other.xml");
        LOG.debug("Loading config from " + optionsDir.toAbsolutePath());
        for (JpsGlobalExtensionSerializer jpsGlobalExtensionSerializer : SERIALIZERS) {
            this.loadGlobalComponents(optionsDir, defaultConfigFile, jpsGlobalExtensionSerializer);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsGlobalExtensionSerializer jpsGlobalExtensionSerializer : extension.getGlobalExtensionSerializers()) {
                this.loadGlobalComponents(optionsDir, defaultConfigFile, jpsGlobalExtensionSerializer);
            }
        }
    }

    private void loadGlobalComponents(@NotNull Path optionsDir, @NotNull Path defaultConfigFile, JpsGlobalExtensionSerializer serializer) {
        if (optionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsDir", "org/jetbrains/jps/model/serialization/JpsGlobalLoader", "loadGlobalComponents"));
        }
        if (defaultConfigFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultConfigFile", "org/jetbrains/jps/model/serialization/JpsGlobalLoader", "loadGlobalComponents"));
        }
        this.loadComponents(optionsDir, defaultConfigFile.getParent(), serializer, this.myGlobal);
    }

    private static class FileTypesSerializer
    extends JpsGlobalExtensionSerializer {
        private FileTypesSerializer() {
            super("filetypes.xml", System.getProperty(JpsGlobalLoader.FILE_TYPES_COMPONENT_NAME_KEY, "FileTypeManager"));
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$FileTypesSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$FileTypesSerializer", "loadExtension"));
            }
            Element ignoreFilesTag = componentTag.getChild("ignoreFiles");
            if (ignoreFilesTag != null) {
                global.getFileTypesConfiguration().setIgnoredPatternString(ignoreFilesTag.getAttributeValue("list"));
            }
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$FileTypesSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$FileTypesSerializer", "saveExtension"));
            }
        }
    }

    public static class SdkTableSerializer
    extends JpsGlobalExtensionSerializer {
        public SdkTableSerializer() {
            super("jdk.table.xml", JpsGlobalLoader.SDK_TABLE_COMPONENT_NAME);
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$SdkTableSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$SdkTableSerializer", "loadExtension"));
            }
            JpsSdkTableSerializer.loadSdks(componentTag, global.getLibraryCollection());
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$SdkTableSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$SdkTableSerializer", "saveExtension"));
            }
            JpsSdkTableSerializer.saveSdks(global.getLibraryCollection(), componentTag);
        }
    }

    public static class GlobalLibrariesSerializer
    extends JpsGlobalExtensionSerializer {
        public GlobalLibrariesSerializer() {
            super("applicationLibraries.xml", "libraryTable");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$GlobalLibrariesSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$GlobalLibrariesSerializer", "loadExtension"));
            }
            JpsLibraryTableSerializer.loadLibraries(componentTag, global.getLibraryCollection());
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$GlobalLibrariesSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$GlobalLibrariesSerializer", "saveExtension"));
            }
            JpsLibraryTableSerializer.saveLibraries(global.getLibraryCollection(), componentTag);
        }
    }

    public static class PathVariablesSerializer
    extends JpsGlobalExtensionSerializer {
        public static final String MACRO_TAG = "macro";
        public static final String NAME_ATTRIBUTE = "name";
        public static final String VALUE_ATTRIBUTE = "value";

        public PathVariablesSerializer() {
            super("path.macros.xml", "PathMacrosImpl");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$PathVariablesSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$PathVariablesSerializer", "loadExtension"));
            }
            JpsPathVariablesConfiguration configuration = (JpsPathVariablesConfiguration)global.getContainer().setChild(PATH_VARIABLES_ROLE, (JpsElement)new JpsPathVariablesConfigurationImpl());
            for (Element macroTag : JDOMUtil.getChildren((Element)componentTag, (String)MACRO_TAG)) {
                String name = macroTag.getAttributeValue(NAME_ATTRIBUTE);
                String value = macroTag.getAttributeValue(VALUE_ATTRIBUTE);
                if (name == null || value == null) continue;
                configuration.addPathVariable(name, StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)value), (String)"/"));
            }
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$PathVariablesSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/JpsGlobalLoader$PathVariablesSerializer", "saveExtension"));
            }
            JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
            if (configuration != null) {
                for (Map.Entry<String, String> entry : configuration.getAllUserVariables().entrySet()) {
                    Element tag = new Element(MACRO_TAG);
                    tag.setAttribute(NAME_ATTRIBUTE, entry.getKey());
                    tag.setAttribute(VALUE_ATTRIBUTE, entry.getValue());
                    componentTag.addContent(tag);
                }
            }
        }
    }
}

