/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, EnvironmentUtil.getValue((String)PATH), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, filter, pathVariableValue, fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, boolean logDetails) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInPath"));
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    private static File findInOriginalPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findInOriginalPath"));
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, System.getenv(PATH), fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseName", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        List<File> list = PathEnvironmentVariableUtil.findExeFilesInPath(false, filter, EnvironmentUtil.getValue((String)PATH), fileBaseName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAllExeFilesInPath"));
        }
        return list;
    }

    @NotNull
    private static List<File> findExeFilesInPath(boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue, String ... fileBaseNames) {
        if (fileBaseNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseNames", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        if (pathEnvVarValue == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
            }
            return list;
        }
        SmartList result = new SmartList();
        List<String> dirPaths = PathEnvironmentVariableUtil.getPathDirs(pathEnvVarValue);
        for (String dirPath : dirPaths) {
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory()) continue;
            for (String fileBaseName : fileBaseNames) {
                File exeFile = new File(dir, fileBaseName);
                if (!exeFile.isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
                result.add(exeFile);
                if (!stopAfterFirstMatch) continue;
                SmartList smartList = result;
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
                }
                return smartList;
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExeFilesInPath"));
        }
        return smartList;
    }

    @NotNull
    public static List<String> getPathDirs(@NotNull String pathEnvVarValue) {
        if (pathEnvVarValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathEnvVarValue", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "getPathDirs"));
        }
        List list = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "getPathDirs"));
        }
        return list;
    }

    @NotNull
    public static String toLocatableExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "toLocatableExePath"));
        }
        String string = PathEnvironmentVariableUtil.findAbsolutePathOnMac(exePath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "toLocatableExePath"));
        }
        return string;
    }

    public static String findAbsolutePathOnMac(@NotNull String exePath) {
        File resolvedExeFile;
        File originalResolvedExeFile;
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findAbsolutePathOnMac"));
        }
        if (SystemInfo.isMac && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\') && (originalResolvedExeFile = PathEnvironmentVariableUtil.findInOriginalPath(exePath)) == null && (resolvedExeFile = PathEnvironmentVariableUtil.findInPath(exePath)) != null) {
            exePath = resolvedExeFile.getAbsolutePath();
        }
        return exePath;
    }

    @NotNull
    public static List<String> getWindowsExecutableFileExtensions() {
        String allExtensions;
        if (SystemInfo.isWindows && (allExtensions = System.getenv("PATHEXT")) != null) {
            List extensions = StringUtil.split((String)allExtensions, (String)";", (boolean)true, (boolean)true);
            extensions = ContainerUtil.filter((Collection)extensions, s -> !StringUtil.isEmpty((String)s) && s.startsWith("."));
            List list = ContainerUtil.map2List((Collection)extensions, s -> StringUtil.toLowerCase((String)s));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "getWindowsExecutableFileExtensions"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "getWindowsExecutableFileExtensions"));
        }
        return list;
    }

    public static String findExecutableInWindowsPath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "findExecutableInWindowsPath"));
        }
        if (SystemInfo.isWindows && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\')) {
            List<String> executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            String[] baseNames = (String[])ContainerUtil.map2Array(executableFileExtensions, String.class, s -> {
                if (exePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/execution/configurations/PathEnvironmentVariableUtil", "lambda$findExecutableInWindowsPath$2"));
                }
                return exePath + s;
            });
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, EnvironmentUtil.getValue((String)PATH), baseNames);
            File foundFile = (File)ContainerUtil.getFirstItem(exeFiles);
            if (foundFile != null) {
                return foundFile.getAbsolutePath();
            }
        }
        return exePath;
    }
}

