/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunConfiguration
extends RunProfile,
Cloneable {
    public static final DataKey<RunConfiguration> DATA_KEY = DataKey.create("runtimeConfiguration");

    @NotNull
    default public ConfigurationType getType() {
        ConfigurationType configurationType = this.getFactory().getType();
        if (configurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/RunConfiguration", "getType"));
        }
        return configurationType;
    }

    public ConfigurationFactory getFactory();

    public void setName(String var1);

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor();

    public Project getProject();

    @Nullable
    default public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Nullable
    default public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunConfiguration clone();

    @Deprecated
    default public int getUniqueID() {
        return System.identityHashCode(this);
    }

    default public void checkConfiguration() throws RuntimeConfigurationException {
    }

    default public void readExternal(Element element) {
    }

    default public void writeExternal(Element element) {
    }

    @NotNull
    default public List<BeforeRunTask> getBeforeRunTasks() {
        List<BeforeRunTask> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/RunConfiguration", "getBeforeRunTasks"));
        }
        return list;
    }

    default public void setBeforeRunTasks(@NotNull List<BeforeRunTask> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/execution/configurations/RunConfiguration", "setBeforeRunTasks"));
        }
    }
}

