/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationStatus;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class RunDashboardContributor {
    public static final ExtensionPointName<RunDashboardContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardContributor");
    @NotNull
    private final ConfigurationType myType;

    protected RunDashboardContributor(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/dashboard/RunDashboardContributor", "<init>"));
        }
        this.myType = type;
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.myType;
        if (configurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getType"));
        }
        return configurationType;
    }

    public void updatePresentation(@NotNull PresentationData presentation, @NotNull DashboardNode node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/execution/dashboard/RunDashboardContributor", "updatePresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RunDashboardContributor", "updatePresentation"));
        }
    }

    @NotNull
    public DashboardRunConfigurationStatus getStatus(@NotNull DashboardRunConfigurationNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
        }
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor == null) {
            DashboardRunConfigurationStatus dashboardRunConfigurationStatus = DashboardRunConfigurationStatus.STOPPED;
            if (dashboardRunConfigurationStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
            }
            return dashboardRunConfigurationStatus;
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler == null) {
            DashboardRunConfigurationStatus dashboardRunConfigurationStatus = DashboardRunConfigurationStatus.STOPPED;
            if (dashboardRunConfigurationStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
            }
            return dashboardRunConfigurationStatus;
        }
        Integer exitCode = processHandler.getExitCode();
        if (exitCode == null) {
            DashboardRunConfigurationStatus dashboardRunConfigurationStatus = DashboardRunConfigurationStatus.STARTED;
            if (dashboardRunConfigurationStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
            }
            return dashboardRunConfigurationStatus;
        }
        Boolean terminationRequested = (Boolean)processHandler.getUserData(ProcessHandler.TERMINATION_REQUESTED);
        if (exitCode == 0 || terminationRequested != null && terminationRequested.booleanValue()) {
            DashboardRunConfigurationStatus dashboardRunConfigurationStatus = DashboardRunConfigurationStatus.STOPPED;
            if (dashboardRunConfigurationStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
            }
            return dashboardRunConfigurationStatus;
        }
        DashboardRunConfigurationStatus dashboardRunConfigurationStatus = DashboardRunConfigurationStatus.FAILED;
        if (dashboardRunConfigurationStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContributor", "getStatus"));
        }
        return dashboardRunConfigurationStatus;
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/dashboard/RunDashboardContributor", "isShowInDashboard"));
        }
        return true;
    }

    public boolean handleDoubleClick(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/execution/dashboard/RunDashboardContributor", "handleDoubleClick"));
        }
        return false;
    }

    @Nullable
    public static RunDashboardContributor getContributor(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/dashboard/RunDashboardContributor", "getContributor"));
        }
        if (!Registry.is((String)"ide.run.dashboard")) {
            return null;
        }
        for (RunDashboardContributor contributor : (RunDashboardContributor[])EP_NAME.getExtensions()) {
            if (!type.equals(contributor.getType())) continue;
            return contributor;
        }
        return null;
    }
}

