/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "doGetService"));
        }
        PicoContainer picoContainer = componentManager.getPicoContainer();
        Object instance = picoContainer.getComponentInstance((Object)serviceClass.getName());
        if (instance == null && (instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }

    @NotNull
    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "createLazyKey"));
        }
        NotNullLazyKey notNullLazyKey = NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), project -> {
            if (serviceClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "lambda$createLazyKey$0"));
            }
            return ServiceManager.getService(project, serviceClass);
        });
        if (notNullLazyKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/ServiceManager", "createLazyKey"));
        }
        return notNullLazyKey;
    }
}

