/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileEditorManager {
    public static final Key<Boolean> USE_CURRENT_WINDOW = Key.create((String)"OpenFile.searchForOpen");
    public static final Key<Boolean> SEPARATOR_DISABLED = Key.create((String)"FileEditorSeparatorDisabled");

    public static FileEditorManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/FileEditorManager", "getInstance"));
        }
        return project.getComponent(FileEditorManager.class);
    }

    @NotNull
    public abstract FileEditor[] openFile(@NotNull VirtualFile var1, boolean var2);

    @NotNull
    public FileEditor[] openFile(@NotNull VirtualFile file, boolean focusEditor, boolean searchForOpen) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/FileEditorManager", "openFile"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract void closeFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract Editor openTextEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @Nullable
    public abstract Editor getSelectedTextEditor();

    public abstract boolean isFileOpen(@NotNull VirtualFile var1);

    @NotNull
    public abstract VirtualFile[] getOpenFiles();

    @NotNull
    public abstract VirtualFile[] getSelectedFiles();

    @NotNull
    public abstract FileEditor[] getSelectedEditors();

    @Nullable
    public abstract FileEditor getSelectedEditor(@NotNull VirtualFile var1);

    @NotNull
    public abstract FileEditor[] getEditors(@NotNull VirtualFile var1);

    @NotNull
    public abstract FileEditor[] getAllEditors(@NotNull VirtualFile var1);

    @NotNull
    public abstract FileEditor[] getAllEditors();

    public abstract void showEditorAnnotation(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeEditorAnnotation(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void addTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void addBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void removeBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    public abstract void addFileEditorManagerListener(@NotNull FileEditorManagerListener var1);

    public abstract void addFileEditorManagerListener(@NotNull FileEditorManagerListener var1, @NotNull Disposable var2);

    public abstract void removeFileEditorManagerListener(@NotNull FileEditorManagerListener var1);

    @NotNull
    public abstract List<FileEditor> openEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @NotNull
    public abstract Project getProject();

    public abstract void registerExtraEditorDataProvider(@NotNull EditorDataProvider var1, Disposable var2);

    @Nullable
    public abstract Object getData(@NotNull String var1, @NotNull Editor var2, @NotNull Caret var3);

    public abstract void setSelectedEditor(@NotNull VirtualFile var1, @NotNull String var2);

    public abstract void runWhenLoaded(@NotNull Editor var1, @NotNull Runnable var2);
}

