/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        ProductionScopeFilter productionScopeFilter = new ProductionScopeFilter(project);
        if (productionScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectProductionScope"));
        }
        return productionScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        TestScopeFilter testScopeFilter = new TestScopeFilter(project);
        if (testScopeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "projectTestScope"));
        }
        return testScopeFilter;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        DirectoryScope directoryScope = new DirectoryScope(project, directory, withSubdirectories);
        if (directoryScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoryScope"));
        }
        return directoryScope;
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        if (directories.length == 1) {
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope(project, directories[0], withSubdirectories);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
            }
            return globalSearchScope;
        }
        DirectoriesScope directoriesScope = new DirectoriesScope(project, withSubdirectories ? Collections.emptySet() : ContainerUtil.newHashSet((Object[])directories), withSubdirectories ? ContainerUtil.newHashSet((Object[])directories) : Collections.emptySet());
        if (directoriesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore", "directoriesScope"));
        }
        return directoriesScope;
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/search/GlobalSearchScopesCore", "filterScope"));
        }
        return new FilterScopeAdapter(project, set);
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myDirectories;
        private final Set<VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull Set<VirtualFile> directories, @NotNull Set<VirtualFile> directoriesWithSubdirectories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            if (directories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            if (directoriesWithSubdirectories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoriesWithSubdirectories", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "<init>"));
            }
            super(project);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + directories + ", directories with subdirectories " + directoriesWithSubdirectories);
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "contains"));
            }
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "in"));
            }
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            return VfsUtilCore.isUnder(parent, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "Directories scope: directories " + this.myDirectories + ", directories with subdirectories " + this.myDirectoriesWithSubdirectories;
        }

        @Override
        public int hashCode() {
            int result = this.myDirectories.hashCode();
            result = result * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && this.myDirectories.equals(((DirectoriesScope)obj).myDirectories) && this.myDirectoriesWithSubdirectories.equals(((DirectoriesScope)obj).myDirectoriesWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                    }
                    return directoriesScope;
                }
                HashSet directories = this.myDirectories;
                HashSet directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    directoriesWithSubdirectories = new HashSet(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.add(other.myDirectory);
                } else {
                    directories = new HashSet(directories);
                    directories.add(other.myDirectory);
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), (Set<VirtualFile>)directories, (Set<VirtualFile>)directoriesWithSubdirectories);
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoriesScope) {
                DirectoriesScope other = (DirectoriesScope)scope;
                HashSet directories = this.myDirectories;
                HashSet directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    directories = new HashSet(directories);
                    directories.addAll(other.myDirectories);
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    directoriesWithSubdirectories = new HashSet(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.addAll(other.myDirectoriesWithSubdirectories);
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), (Set<VirtualFile>)directories, (Set<VirtualFile>)directoriesWithSubdirectories);
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getProject"));
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                String string = "Directory '" + root.getName() + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getDisplayName"));
                }
                return string;
            }
            Iterable allDirs = ContainerUtil.concat((Iterable[])new Iterable[]{this.myDirectories, this.myDirectoriesWithSubdirectories});
            String string = "Directories " + StringUtil.join((Iterable)allDirs, file -> "'" + file.getName() + "'", (String)", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope", "getDisplayName"));
            }
            return string;
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        private DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "<init>"));
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "contains"));
            }
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "in"));
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, parent, false) : this.myDirectory.equals(parent);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int hashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                    }
                    return directoryScope;
                }
                if (other.in(this.myDirectory)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                    }
                    return directoryScope;
                }
                DirectoriesScope directoriesScope = new DirectoriesScope(this.getProject(), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
                if (directoriesScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
                }
                return directoriesScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        private static Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (dir1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "union"));
            }
            if (dir2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "union"));
            }
            if (addDir1 && addDir2) {
                return ContainerUtil.newHashSet((Object[])new VirtualFile[]{dir1, dir2});
            }
            if (addDir1) {
                return Collections.singleton(dir1);
            }
            if (addDir2) {
                return Collections.singleton(dir2);
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "getProject"));
            }
            return project;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = "Directory '" + this.myDirectory.getName() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope", "getDisplayName"));
            }
            return string;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "<init>"));
            }
            super(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "contains"));
            }
            return TestSourcesFilter.isTestSources(file, (Project)ObjectUtils.assertNotNull((Object)this.getProject()));
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "isSearchInModuleContent"));
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.test.files", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter", "getDisplayName"));
            }
            return string;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "<init>"));
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "contains"));
            }
            return this.myFileIndex.isInSourceContent(file) && !TestSourcesFilter.isTestSources(file, (Project)ObjectUtils.assertNotNull((Object)this.getProject()));
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "isSearchInModuleContent"));
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ModuleManager.getInstance((Project)ObjectUtils.assertNotNull((Object)this.getProject())).getUnloadedModuleDescriptions();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.production.files", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter", "getDisplayName"));
            }
            return string;
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "<init>"));
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "contains"));
            }
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.mySet.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "getDisplayName"));
            }
            return string;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = super.getProject();
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "getProject"));
            }
            return project;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

