/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.ScrollColorProducer;
import com.intellij.ui.components.ScrollPainter;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ScrollSource;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBScrollPane
extends JScrollPane {
    public static final Key<Boolean> BRIGHTNESS_FROM_VIEW = Key.create((String)"JB_SCROLL_PANE_BRIGHTNESS_FROM_VIEW");
    @Deprecated
    public static final RegionPainter<Float> THUMB_PAINTER = ScrollPainter.EditorThumb.DEFAULT;
    @Deprecated
    public static final RegionPainter<Float> THUMB_DARK_PAINTER = ScrollPainter.EditorThumb.DARCULA;
    @Deprecated
    public static final RegionPainter<Float> MAC_THUMB_PAINTER = ScrollPainter.EditorThumb.Mac.DEFAULT;
    @Deprecated
    public static final RegionPainter<Float> MAC_THUMB_DARK_PAINTER = ScrollPainter.EditorThumb.Mac.DARCULA;
    private static final Logger LOG = Logger.getInstance(JBScrollPane.class);
    private ScrollSource myScrollSource = ScrollSource.UNKNOWN;
    private double myWheelRotation;
    private int myViewportBorderWidth = -1;
    private volatile boolean myBackgroundRequested;
    private static final int SCROLL_MODIFIERS = -1106;

    public JBScrollPane(int viewportWidth) {
        this.init(false);
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.init();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        JViewport child;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && ScrollSettings.isBackgroundFromView() && (!this.isBackgroundSet() || color instanceof UIResource) && (child = this.getViewport()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    static Color getViewBackground(JScrollPane pane) {
        if (pane == null) {
            return null;
        }
        JViewport viewport = pane.getViewport();
        if (viewport == null) {
            return null;
        }
        Component view = viewport.getView();
        if (view == null) {
            return null;
        }
        return view.getBackground();
    }

    public static JScrollPane findScrollPane(Component c) {
        Container vp;
        if (c == null) {
            return null;
        }
        if (!(c instanceof JViewport) && (vp = c.getParent()) instanceof JViewport) {
            c = vp;
        }
        if (!((c = c.getParent()) instanceof JScrollPane)) {
            return null;
        }
        return (JScrollPane)c;
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean setupCorners) {
        this.setLayout(new Layout());
        if (setupCorners) {
            this.setupCorners();
        }
    }

    protected void setupCorners() {
        this.setBorder(IdeBorderFactory.createBorder());
        this.setCorner("UPPER_RIGHT_CORNER", new Corner("UPPER_RIGHT_CORNER"));
        this.setCorner("UPPER_LEFT_CORNER", new Corner("UPPER_LEFT_CORNER"));
        this.setCorner("LOWER_RIGHT_CORNER", new Corner("LOWER_RIGHT_CORNER"));
        this.setCorner("LOWER_LEFT_CORNER", new Corner("LOWER_LEFT_CORNER"));
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
        if (ui instanceof BasicScrollPaneUI) {
            try {
                Field field = BasicScrollPaneUI.class.getDeclaredField("mouseScrollListener");
                field.setAccessible(true);
                Object value = field.get(ui);
                if (value instanceof MouseWheelListener) {
                    MouseWheelListener oldListener = (MouseWheelListener)value;
                    MouseWheelListener newListener = event -> {
                        JScrollPane pane;
                        Object source;
                        if (JBScrollPane.isScrollEvent(event) && (source = event.getSource()) instanceof JScrollPane && (pane = (JScrollPane)source).isWheelScrollingEnabled()) {
                            JScrollBar bar;
                            JScrollBar jScrollBar = bar = event.isShiftDown() ? pane.getHorizontalScrollBar() : pane.getVerticalScrollBar();
                            if (!(bar == null || !bar.isVisible() || bar instanceof JBScrollBar && ((JBScrollBar)bar).handleMouseWheelEvent(event))) {
                                oldListener.mouseWheelMoved(event);
                            }
                        }
                    };
                    field.set(ui, newListener);
                    this.removeMouseWheelListener(oldListener);
                    this.addMouseWheelListener(newListener);
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return JBScrollPane.isOptimizedDrawingEnabledFor(this.getVerticalScrollBar()) && JBScrollPane.isOptimizedDrawingEnabledFor(this.getHorizontalScrollBar());
    }

    private static boolean isOptimizedDrawingEnabledFor(JScrollBar bar) {
        return bar == null || !bar.isVisible() || bar.isOpaque() && bar.isOptimizedDrawingEnabled();
    }

    private void updateViewportBorder() {
        if (this.getViewportBorder() instanceof ViewportBorder) {
            this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
        }
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new JBScrollBar(1);
    }

    @Override
    @NotNull
    public JScrollBar createHorizontalScrollBar() {
        JBScrollBar jBScrollBar = new JBScrollBar(0);
        if (jBScrollBar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBScrollPane", "createHorizontalScrollBar"));
        }
        return jBScrollBar;
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    @Deprecated
    protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
        ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
        return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
    }

    public static boolean canBePreprocessed(MouseEvent e, JScrollBar bar) {
        if (e.getID() == 503 || e.getID() == 501) {
            ScrollBarUI ui = bar.getUI();
            if (ui instanceof BasicScrollBarUI) {
                BasicScrollBarUI bui = (BasicScrollBarUI)ui;
                try {
                    Rectangle rect = (Rectangle)ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.class, (String)"getThumbBounds", (Class[])ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)bui, new Object[0]);
                    Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                    return !rect.contains(point);
                }
                catch (Exception e1) {
                    return true;
                }
            }
            if (ui instanceof DefaultScrollBarUI) {
                DefaultScrollBarUI dui = (DefaultScrollBarUI)ui;
                Point point = e.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, bar);
                return !dui.isThumbContains(point.x, point.y);
            }
        }
        return true;
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        boolean hasAbsoluteDelta = ScrollSettings.isPixelPerfectEnabled();
        this.myScrollSource = hasAbsoluteDelta ? ScrollSource.TOUCHPAD : ScrollSource.MOUSE_WHEEL;
        this.myWheelRotation = e.getPreciseWheelRotation();
        super.processMouseWheelEvent(e);
        this.myScrollSource = ScrollSource.UNKNOWN;
    }

    int getInitialDelay(boolean valueIsAdjusting) {
        ScrollSource source = valueIsAdjusting ? ScrollSource.SCROLLBAR : this.myScrollSource;
        return source.getInterpolationDelay(this.myWheelRotation);
    }

    public static boolean isScrollEvent(@NotNull MouseWheelEvent event) {
        boolean ignore;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/components/JBScrollPane", "isScrollEvent"));
        }
        if (event.isConsumed()) {
            return false;
        }
        boolean bl = ignore = event.getWheelRotation() == 0;
        if (ignore && (ScrollSettings.isPixelPerfectEnabled() || ScrollSettings.isHighPrecisionEnabled())) {
            double rotation = event.getPreciseWheelRotation();
            ignore = rotation == 0.0 || !Double.isFinite(rotation);
        }
        return !ignore && 0 == (0xFFFFFBAE & event.getModifiers());
    }

    private static class Layout
    extends ScrollPaneLayout {
        private static final Insets EMPTY_INSETS = JBUI.emptyInsets();

        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle lower;
            Dimension viewPreferredSize;
            Border border;
            boolean hsbOnTop;
            JScrollPane pane = (JScrollPane)parent;
            Rectangle bounds = new Rectangle(pane.getWidth(), pane.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)pane.getInsets());
            Object property = pane.getClientProperty(Flip.class);
            Flip flip = property instanceof Flip ? (Flip)((Object)property) : Flip.NONE;
            boolean bl = hsbOnTop = flip == Flip.BOTH || flip == Flip.VERTICAL;
            boolean vsbOnLeft = pane.getComponentOrientation().isLeftToRight() ? flip == Flip.BOTH || flip == Flip.HORIZONTAL : flip == Flip.NONE || flip == Flip.VERTICAL;
            Rectangle rowHeadBounds = new Rectangle(bounds.x, 0, 0, 0);
            if (this.rowHead != null && this.rowHead.isVisible()) {
                rowHeadBounds.width = Layout.min(bounds.width, this.rowHead.getPreferredSize().width);
                bounds.width -= rowHeadBounds.width;
                if (vsbOnLeft) {
                    rowHeadBounds.x += bounds.width;
                } else {
                    bounds.x += rowHeadBounds.width;
                }
            }
            Rectangle colHeadBounds = new Rectangle(0, bounds.y, 0, 0);
            if (this.colHead != null && this.colHead.isVisible()) {
                colHeadBounds.height = Layout.min(bounds.height, this.colHead.getPreferredSize().height);
                bounds.height -= colHeadBounds.height;
                if (hsbOnTop) {
                    colHeadBounds.y += bounds.height;
                } else {
                    bounds.y += colHeadBounds.height;
                }
            }
            Insets insets = (border = pane.getViewportBorder()) == null ? null : border.getBorderInsets(parent);
            JBInsets.removeFrom((Rectangle)bounds, (Insets)insets);
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            boolean isEmpty = bounds.width < 0 || bounds.height < 0;
            Component view = this.viewport == null ? null : this.viewport.getView();
            Dimension dimension = viewPreferredSize = view == null ? new Dimension() : view.getPreferredSize();
            if (view instanceof JComponent && !view.isPreferredSizeSet()) {
                JBInsets.removeFrom((Dimension)viewPreferredSize, (Insets)JBViewport.getViewInsets((JComponent)view));
            }
            Dimension viewportExtentSize = this.viewport == null ? new Dimension() : this.viewport.toViewCoordinates(bounds.getSize());
            Scrollable scrollable = null;
            boolean viewTracksViewportWidth = false;
            boolean viewTracksViewportHeight = false;
            if (!isEmpty && view instanceof Scrollable) {
                scrollable = (Scrollable)((Object)view);
                viewTracksViewportWidth = scrollable.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = scrollable.getScrollableTracksViewportHeight();
            }
            Point viewLocation = new Point();
            if (view != null) {
                viewLocation = view.getLocation(viewLocation);
            }
            boolean vsbOpaque = false;
            boolean vsbNeeded = false;
            int vsbPolicy = pane.getVerticalScrollBarPolicy();
            if (!isEmpty && vsbPolicy != 21) {
                vsbNeeded = vsbPolicy == 22 || !viewTracksViewportHeight && (viewPreferredSize.height > viewportExtentSize.height || viewLocation.y != 0);
            }
            Rectangle vsbBounds = new Rectangle(0, bounds.y - insets.top, 0, 0);
            if (this.vsb != null) {
                if (!SystemInfo.isMac && ScrollSettings.isNotSupportedYet(view)) {
                    this.vsb.setOpaque(true);
                }
                vsbOpaque = this.vsb.isOpaque();
                if (vsbNeeded) {
                    this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                    if (vsbOpaque && this.viewport != null) {
                        viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                    }
                }
            }
            boolean hsbOpaque = false;
            boolean hsbNeeded = false;
            int hsbPolicy = pane.getHorizontalScrollBarPolicy();
            if (!isEmpty && hsbPolicy != 31) {
                hsbNeeded = hsbPolicy == 32 || !viewTracksViewportWidth && (viewPreferredSize.width > viewportExtentSize.width || viewLocation.x != 0);
            }
            Rectangle hsbBounds = new Rectangle(bounds.x - insets.left, 0, 0, 0);
            if (this.hsb != null) {
                if (!SystemInfo.isMac && ScrollSettings.isNotSupportedYet(view)) {
                    this.hsb.setOpaque(true);
                }
                hsbOpaque = this.hsb.isOpaque();
                if (hsbNeeded) {
                    this.adjustForHSB(bounds, insets, hsbBounds, hsbOpaque, hsbOnTop);
                    if (hsbOpaque && this.viewport != null && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                        viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                        boolean bl2 = vsbNeeded = viewPreferredSize.height > viewportExtentSize.height || viewLocation.y != 0;
                        if (vsbNeeded) {
                            this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                        }
                    }
                }
            }
            if (this.viewport != null) {
                this.viewport.setBounds(bounds);
                if (scrollable != null && hsbOpaque && vsbOpaque) {
                    viewTracksViewportWidth = scrollable.getScrollableTracksViewportWidth();
                    viewTracksViewportHeight = scrollable.getScrollableTracksViewportHeight();
                    viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                    boolean vsbNeededOld = vsbNeeded;
                    if (this.vsb != null && vsbPolicy == 20) {
                        boolean vsbNeededNew;
                        boolean bl3 = vsbNeededNew = !viewTracksViewportHeight && viewPreferredSize.height > viewportExtentSize.height || viewLocation.y != 0;
                        if (vsbNeeded != vsbNeededNew) {
                            vsbNeeded = vsbNeededNew;
                            if (vsbNeeded) {
                                this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                            } else if (vsbOpaque) {
                                bounds.width += vsbBounds.width;
                            }
                            if (vsbOpaque) {
                                viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                            }
                        }
                    }
                    boolean hsbNeededOld = hsbNeeded;
                    if (this.hsb != null && hsbPolicy == 30) {
                        boolean hsbNeededNew;
                        boolean bl4 = hsbNeededNew = !viewTracksViewportWidth && viewPreferredSize.width > viewportExtentSize.width || viewLocation.x != 0;
                        if (hsbNeeded != hsbNeededNew) {
                            hsbNeeded = hsbNeededNew;
                            if (hsbNeeded) {
                                this.adjustForHSB(bounds, insets, hsbBounds, hsbOpaque, hsbOnTop);
                            } else if (hsbOpaque) {
                                bounds.height += hsbBounds.height;
                            }
                            if (hsbOpaque && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                                viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                                boolean bl5 = vsbNeeded = viewPreferredSize.height > viewportExtentSize.height || viewLocation.y != 0;
                                if (vsbNeeded) {
                                    this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                                }
                            }
                        }
                    }
                    if (hsbNeededOld != hsbNeeded || vsbNeededOld != vsbNeeded) {
                        this.viewport.setBounds(bounds);
                    }
                }
            }
            rowHeadBounds.y = bounds.y - insets.top;
            rowHeadBounds.height = bounds.height + insets.top + insets.bottom;
            boolean fillLowerCorner = false;
            if (this.rowHead != null) {
                if (hsbOpaque) {
                    Component corner = hsbOnTop ? (vsbOnLeft ? this.upperRight : this.upperLeft) : (vsbOnLeft ? this.lowerRight : this.lowerLeft);
                    boolean bl6 = fillLowerCorner = corner == null && UIManager.getBoolean("ScrollPane.fillLowerCorner");
                    if (!fillLowerCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (hsbOnTop) {
                            rowHeadBounds.y -= hsbBounds.height;
                        }
                        rowHeadBounds.height += hsbBounds.height;
                    }
                }
                this.rowHead.setBounds(rowHeadBounds);
                this.rowHead.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.RIGHT : Alignment.LEFT));
            }
            colHeadBounds.x = bounds.x - insets.left;
            colHeadBounds.width = bounds.width + insets.left + insets.right;
            boolean fillUpperCorner = false;
            if (this.colHead != null) {
                if (vsbOpaque) {
                    Component corner = vsbOnLeft ? (hsbOnTop ? this.lowerLeft : this.upperLeft) : (hsbOnTop ? this.lowerRight : this.upperRight);
                    boolean bl7 = fillUpperCorner = corner == null && UIManager.getBoolean("ScrollPane.fillUpperCorner");
                    if (!fillUpperCorner && ScrollSettings.isHeaderOverCorner(this.viewport)) {
                        if (vsbOnLeft) {
                            colHeadBounds.x -= vsbBounds.width;
                        }
                        colHeadBounds.width += vsbBounds.width;
                    }
                }
                this.colHead.setBounds(colHeadBounds);
                this.colHead.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.BOTTOM : Alignment.TOP));
            }
            int overlapWidth = 0;
            int overlapHeight = 0;
            if (vsbNeeded && !vsbOpaque && hsbNeeded && !hsbOpaque) {
                overlapWidth = vsbBounds.width;
            }
            vsbBounds.y = bounds.y - insets.top;
            vsbBounds.height = bounds.height + insets.top + insets.bottom;
            if (this.vsb != null) {
                this.vsb.setVisible(vsbNeeded);
                if (vsbNeeded) {
                    if (fillUpperCorner) {
                        if (!hsbOnTop) {
                            vsbBounds.y -= colHeadBounds.height;
                        }
                        vsbBounds.height += colHeadBounds.height;
                    }
                    int overlapY = !hsbOnTop ? 0 : overlapHeight;
                    this.vsb.setBounds(vsbBounds.x, vsbBounds.y + overlapY, vsbBounds.width, vsbBounds.height - overlapHeight);
                    this.vsb.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.LEFT : Alignment.RIGHT));
                }
                if (!vsbOpaque) {
                    if (!vsbOnLeft) {
                        vsbBounds.x += vsbBounds.width;
                    }
                    vsbBounds.width = 0;
                }
            }
            hsbBounds.x = bounds.x - insets.left;
            hsbBounds.width = bounds.width + insets.left + insets.right;
            if (this.hsb != null) {
                this.hsb.setVisible(hsbNeeded);
                if (hsbNeeded) {
                    if (fillLowerCorner) {
                        if (!vsbOnLeft) {
                            hsbBounds.x -= rowHeadBounds.width;
                        }
                        hsbBounds.width += rowHeadBounds.width;
                    }
                    int overlapX = !vsbOnLeft ? 0 : overlapWidth;
                    this.hsb.setBounds(hsbBounds.x + overlapX, hsbBounds.y, hsbBounds.width - overlapWidth, hsbBounds.height);
                    this.hsb.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.TOP : Alignment.BOTTOM));
                }
                if (!hsbOpaque) {
                    if (!hsbOnTop) {
                        hsbBounds.y += hsbBounds.height;
                    }
                    hsbBounds.height = 0;
                }
            }
            Rectangle left = vsbOnLeft ? vsbBounds : rowHeadBounds;
            Rectangle right = vsbOnLeft ? rowHeadBounds : vsbBounds;
            Rectangle upper = hsbOnTop ? hsbBounds : colHeadBounds;
            Rectangle rectangle = lower = hsbOnTop ? colHeadBounds : hsbBounds;
            if (this.lowerLeft != null) {
                Rectangle lowerLeftBounds = new Rectangle(left.x, left.y + left.height, 0, 0);
                if (left.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerLeftBounds, lower.x, lower.y + lower.height);
                }
                this.lowerLeft.setBounds(lowerLeftBounds);
            }
            if (this.lowerRight != null) {
                Rectangle lowerRightBounds = new Rectangle(lower.x + lower.width, right.y + right.height, 0, 0);
                if (right.width > 0 && lower.height > 0) {
                    Layout.updateCornerBounds(lowerRightBounds, right.x + right.width, lower.y + lower.height);
                }
                this.lowerRight.setBounds(lowerRightBounds);
            }
            if (this.upperLeft != null) {
                Rectangle upperLeftBounds = new Rectangle(left.x, upper.y, 0, 0);
                if (left.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperLeftBounds, upper.x, left.y);
                }
                this.upperLeft.setBounds(upperLeftBounds);
            }
            if (this.upperRight != null) {
                Rectangle upperRightBounds = new Rectangle(upper.x + upper.width, upper.y, 0, 0);
                if (right.width > 0 && upper.height > 0) {
                    Layout.updateCornerBounds(upperRightBounds, right.x + right.width, right.y);
                }
                this.upperRight.setBounds(upperRightBounds);
            }
            if (!vsbOpaque && vsbNeeded || !hsbOpaque && hsbNeeded) {
                Layout.fixComponentZOrder(this.vsb, 0);
                Layout.fixComponentZOrder(this.viewport, -1);
            }
        }

        private static void updateCornerBounds(Rectangle bounds, int x, int y) {
            bounds.width = Math.abs(bounds.x - x);
            bounds.height = Math.abs(bounds.y - y);
            bounds.x = Math.min(bounds.x, x);
            bounds.y = Math.min(bounds.y, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void fixComponentZOrder(Component component, int index) {
            if (component != null) {
                Container parent = component.getParent();
                Object object = parent.getTreeLock();
                synchronized (object) {
                    if (index < 0) {
                        index += parent.getComponentCount();
                    }
                    parent.setComponentZOrder(component, index);
                }
            }
        }

        private void adjustForVSB(Rectangle bounds, Insets insets, Rectangle vsbBounds, boolean vsbOpaque, boolean vsbOnLeft) {
            int n = vsbBounds.width = !this.vsb.isEnabled() ? 0 : Layout.min(bounds.width, this.vsb.getPreferredSize().width);
            if (vsbOnLeft) {
                vsbBounds.x = bounds.x - insets.left;
                if (vsbOpaque) {
                    bounds.x += vsbBounds.width;
                }
            } else {
                vsbBounds.x = bounds.x + bounds.width + insets.right - vsbBounds.width;
            }
            if (vsbOpaque) {
                bounds.width -= vsbBounds.width;
            }
        }

        private void adjustForHSB(Rectangle bounds, Insets insets, Rectangle hsbBounds, boolean hsbOpaque, boolean hsbOnTop) {
            int n = hsbBounds.height = !this.hsb.isEnabled() ? 0 : Layout.min(bounds.height, this.hsb.getPreferredSize().height);
            if (hsbOnTop) {
                hsbBounds.y = bounds.y - insets.top;
                if (hsbOpaque) {
                    bounds.y += hsbBounds.height;
                }
            } else {
                hsbBounds.y = bounds.y + bounds.height + insets.bottom - hsbBounds.height;
            }
            if (hsbOpaque) {
                bounds.height -= hsbBounds.height;
            }
        }

        private static int min(int one, int two) {
            return Math.max(0, Math.min(one, two));
        }
    }

    public static enum Alignment {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        public static Alignment get(JComponent component) {
            if (component != null) {
                Object property = component.getClientProperty(Alignment.class);
                if (property instanceof Alignment) {
                    return (Alignment)((Object)property);
                }
                Container parent = component.getParent();
                if (parent instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)parent;
                    if (component == pane.getColumnHeader()) {
                        return TOP;
                    }
                    if (component == pane.getHorizontalScrollBar()) {
                        return BOTTOM;
                    }
                    boolean ltr = pane.getComponentOrientation().isLeftToRight();
                    if (component == pane.getVerticalScrollBar()) {
                        return ltr ? RIGHT : LEFT;
                    }
                    if (component == pane.getRowHeader()) {
                        return ltr ? LEFT : RIGHT;
                    }
                }
                if (component instanceof JScrollBar) {
                    JScrollBar bar = (JScrollBar)component;
                    switch (bar.getOrientation()) {
                        case 0: {
                            return BOTTOM;
                        }
                        case 1: {
                            return bar.getComponentOrientation().isLeftToRight() ? RIGHT : LEFT;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static enum Flip {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }

    private static class ViewportBorder
    extends LineBorder {
        public ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            this.lineColor = JBScrollPane.getViewBackground((JScrollPane)c);
        }
    }

    private static class Corner
    extends JPanel {
        private final String myPos;

        public Corner(String pos) {
            this.myPos = pos;
            ScrollColorProducer.setBackground(this);
            ScrollColorProducer.setForeground(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

