/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    public static final String DEFAULT_EMPTY_TEXT = UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]);
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    private final MouseMotionListener myMouseMotionListener;
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    protected final SimpleColoredComponent myComponent = new SimpleColoredComponent();
    private final List<ActionListener> myClickListeners = new ArrayList<ActionListener>();
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/StatusText$1", "onClick"));
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    return true;
                }
                return false;
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myComponent.setFont(UIUtil.getLabelFont());
        this.setText(DEFAULT_EMPTY_TEXT, DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        int index;
        if (!this.myHasActiveClickListeners || !this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle b = this.getTextComponentBound();
        if (b.contains(point) && (index = this.myComponent.findFragmentAt(point.x - b.x)) >= 0 && index < this.myClickListeners.size()) {
            return this.myClickListeners.get(index);
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.myComponent.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.isShowAboveCenter() ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/StatusText", "getText"));
        }
        return string;
    }

    public StatusText setText(String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myComponent.clear();
        this.myClickListeners.clear();
        this.myHasActiveClickListeners = false;
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
        return this;
    }

    public StatusText appendText(String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        this.myComponent.append(text, attrs);
        this.myClickListeners.add(listener);
        if (listener != null) {
            this.myHasActiveClickListeners = true;
        }
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
        return this;
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible()) {
            return;
        }
        if (owner == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component, Graphics g) {
        JBViewport viewport = (JBViewport)ObjectUtils.tryCast((Object)this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component.getX();
        int yInOwner = textBoundsInViewport.y - component.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private void doPaintStatusText(Graphics g, Rectangle textComponentBounds) {
        this.myComponent.setBounds(0, 0, textComponentBounds.width, textComponentBounds.height);
        Graphics2D g2 = (Graphics2D)g.create(textComponentBounds.x, textComponentBounds.y, textComponentBounds.width, textComponentBounds.height);
        this.myComponent.paint(g2);
        g2.dispose();
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.myComponent;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/StatusText", "getComponent"));
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        return this.myComponent.getPreferredSize();
    }
}

