/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import git4idea.GitUtil;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogStatusInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCommit
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails,
VcsIndexableDetails {
    private static final Logger LOG = Logger.getInstance(GitCommit.class);
    @NotNull
    private final AtomicReference<Changes> myChanges;

    /*
     * WARNING - void declaration
     */
    public GitCommit(Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<GitLogStatusInfo>> list) {
        void reportedChanges;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/GitCommit", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "git4idea/GitCommit", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitCommit", "<init>"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "git4idea/GitCommit", "<init>"));
        }
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "git4idea/GitCommit", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/GitCommit", "<init>"));
        }
        if (committer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committer", "git4idea/GitCommit", "<init>"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportedChanges", "git4idea/GitCommit", "<init>"));
        }
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myChanges = new AtomicReference();
        this.myChanges.set(new UnparsedChanges(project, (List)reportedChanges));
    }

    @NotNull
    public Collection<String> getModifiedPaths(int parent) {
        Collection<String> collection = this.myChanges.get().getModifiedPaths(parent);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getModifiedPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<Couple<String>> getRenamedPaths(int parent) {
        Collection<Couple<String>> collection = this.myChanges.get().getRenamedPaths(parent);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getRenamedPaths"));
        }
        return collection;
    }

    @NotNull
    public Collection<Change> getChanges() {
        Collection<Change> collection;
        try {
            collection = this.myChanges.get().getMergedChanges();
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            List<Change> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getChanges"));
            }
            return list;
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getChanges"));
        }
        return collection;
    }

    @NotNull
    public Collection<Change> getChanges(int parent) {
        Collection<Change> collection;
        try {
            collection = this.myChanges.get().getChanges(parent);
        }
        catch (VcsException e) {
            LOG.error("Error happened when parsing changes", (Throwable)e);
            List<Change> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getChanges"));
            }
            return list;
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "getChanges"));
        }
        return collection;
    }

    @NotNull
    private String absolutePath(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitCommit", "absolutePath"));
        }
        try {
            string = this.getRoot().getPath() + "/" + GitUtil.unescapePath(path);
        }
        catch (VcsException e) {
            String string2 = this.getRoot().getPath() + "/" + path;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "absolutePath"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit", "absolutePath"));
        }
        return string;
    }

    private class UnparsedChanges
    implements Changes {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<List<GitLogStatusInfo>> myChangesOutput;

        private UnparsedChanges(@NotNull Project project, List<List<GitLogStatusInfo>> changesOutput) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitCommit$UnparsedChanges", "<init>"));
            }
            if (changesOutput == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesOutput", "git4idea/GitCommit$UnparsedChanges", "<init>"));
            }
            this.myProject = project;
            this.myChangesOutput = changesOutput;
        }

        @NotNull
        private ParsedChanges parseChanges() throws VcsException {
            List<Change> mergedChanges = this.parseStatusInfo(this.getMergedStatusInfo(), ContainerUtil.map((Collection)GitCommit.this.getParents(), Hash::asString));
            List<Collection<Change>> changes = this.computeChanges(mergedChanges);
            ParsedChanges parsedChanges = new ParsedChanges(mergedChanges, changes);
            GitCommit.this.myChanges.compareAndSet(this, parsedChanges);
            ParsedChanges parsedChanges2 = parsedChanges;
            if (parsedChanges2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "parseChanges"));
            }
            return parsedChanges2;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException {
            Collection<Change> collection = this.parseChanges().getMergedChanges();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedChanges"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) throws VcsException {
            Collection<Change> collection = this.parseChanges().getChanges(parent);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getChanges"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<String> getModifiedPaths(int parent) {
            HashSet changes = ContainerUtil.newHashSet();
            for (GitLogStatusInfo status : this.myChangesOutput.get(parent)) {
                if (status.getSecondPath() != null) continue;
                changes.add(GitCommit.this.absolutePath(status.getFirstPath()));
            }
            HashSet hashSet = changes;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getModifiedPaths"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (GitLogStatusInfo status : this.myChangesOutput.get(parent)) {
                if (status.getSecondPath() == null) continue;
                renames.add(Couple.of((Object)GitCommit.this.absolutePath(status.getFirstPath()), (Object)GitCommit.this.absolutePath(status.getSecondPath())));
            }
            HashSet hashSet = renames;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getRenamedPaths"));
            }
            return hashSet;
        }

        @NotNull
        private List<Collection<Change>> computeChanges(@NotNull Collection<Change> mergedChanges) throws VcsException {
            if (mergedChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedChanges", "git4idea/GitCommit$UnparsedChanges", "computeChanges"));
            }
            if (this.myChangesOutput.size() == 1) {
                List<Collection<Change>> list = Collections.singletonList(mergedChanges);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "computeChanges"));
                }
                return list;
            }
            ArrayList changes = ContainerUtil.newArrayListWithCapacity((int)this.myChangesOutput.size());
            for (int i = 0; i < this.myChangesOutput.size(); ++i) {
                List<GitLogStatusInfo> statusInfos = this.myChangesOutput.get(i);
                changes.add(this.parseStatusInfo(statusInfos, Collections.singletonList(((Hash)GitCommit.this.getParents().get(i)).asString())));
            }
            ArrayList arrayList = changes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "computeChanges"));
            }
            return arrayList;
        }

        @NotNull
        private List<Change> parseStatusInfo(@NotNull List<GitLogStatusInfo> changes, @NotNull List<String> parentHashes) throws VcsException {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/GitCommit$UnparsedChanges", "parseStatusInfo"));
            }
            if (parentHashes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHashes", "git4idea/GitCommit$UnparsedChanges", "parseStatusInfo"));
            }
            List<Change> list = GitChangesParser.parse(this.myProject, GitCommit.this.getRoot(), changes, GitCommit.this.getId().asString(), new Date(GitCommit.this.getCommitTime()), parentHashes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "parseStatusInfo"));
            }
            return list;
        }

        @NotNull
        private List<GitLogStatusInfo> getMergedStatusInfo() {
            List<GitLogStatusInfo> firstParent = this.myChangesOutput.get(0);
            if (this.myChangesOutput.size() == 1) {
                List<GitLogStatusInfo> list = firstParent;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
                }
                return list;
            }
            List affectedMap = ContainerUtil.map(this.myChangesOutput, infos -> {
                LinkedHashMap map = ContainerUtil.newLinkedHashMap();
                for (GitLogStatusInfo info : infos) {
                    String path = this.getPath(info);
                    if (path == null) continue;
                    map.put(path, info);
                }
                return map;
            });
            ArrayList result2 = ContainerUtil.newArrayList();
            block0: for (String path : ((Map)affectedMap.get(0)).keySet()) {
                ArrayList statuses = ContainerUtil.newArrayList();
                for (Map infoMap : affectedMap) {
                    GitLogStatusInfo status = (GitLogStatusInfo)infoMap.get(path);
                    if (status == null) continue block0;
                    statuses.add(status);
                }
                result2.add(this.getMergedStatusInfo(path, statuses));
            }
            ArrayList arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
            }
            return arrayList;
        }

        @NotNull
        private GitLogStatusInfo getMergedStatusInfo(@NotNull String path, @NotNull List<GitLogStatusInfo> statuses) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
            }
            if (statuses == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
            }
            Set types = ContainerUtil.map2Set(statuses, GitLogStatusInfo::getType);
            if (types.size() == 1) {
                GitChangeType type = (GitChangeType)((Object)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)types)));
                if (type.equals((Object)GitChangeType.COPIED) || type.equals((Object)GitChangeType.RENAMED)) {
                    String renamedFrom = null;
                    for (GitLogStatusInfo status : statuses) {
                        if (renamedFrom == null) {
                            renamedFrom = status.getFirstPath();
                            continue;
                        }
                        if (renamedFrom.equals(status.getFirstPath())) continue;
                        GitLogStatusInfo gitLogStatusInfo = new GitLogStatusInfo(GitChangeType.MODIFIED, path, null);
                        if (gitLogStatusInfo == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
                        }
                        return gitLogStatusInfo;
                    }
                }
                GitLogStatusInfo gitLogStatusInfo = statuses.get(0);
                if (gitLogStatusInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
                }
                return gitLogStatusInfo;
            }
            if (types.contains((Object)GitChangeType.DELETED)) {
                GitLogStatusInfo gitLogStatusInfo = new GitLogStatusInfo(GitChangeType.DELETED, path, null);
                if (gitLogStatusInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
                }
                return gitLogStatusInfo;
            }
            GitLogStatusInfo gitLogStatusInfo = new GitLogStatusInfo(GitChangeType.MODIFIED, path, null);
            if (gitLogStatusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$UnparsedChanges", "getMergedStatusInfo"));
            }
            return gitLogStatusInfo;
        }

        @Nullable
        private String getPath(@NotNull GitLogStatusInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "git4idea/GitCommit$UnparsedChanges", "getPath"));
            }
            switch (info.getType()) {
                case MODIFIED: 
                case ADDED: 
                case TYPE_CHANGED: 
                case DELETED: {
                    return info.getFirstPath();
                }
                case COPIED: 
                case RENAMED: {
                    return info.getSecondPath();
                }
                case UNRESOLVED: {
                    LOG.error("Unsupported status info " + info);
                }
            }
            return null;
        }
    }

    private static class ParsedChanges
    implements Changes {
        @NotNull
        private final Collection<Change> myMergedChanges;
        @NotNull
        private final List<Collection<Change>> myChanges;

        private ParsedChanges(@NotNull Collection<Change> mergedChanges, @NotNull List<Collection<Change>> changes) {
            if (mergedChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedChanges", "git4idea/GitCommit$ParsedChanges", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/GitCommit$ParsedChanges", "<init>"));
            }
            this.myMergedChanges = mergedChanges;
            this.myChanges = changes;
        }

        @Override
        @NotNull
        public Collection<Change> getMergedChanges() {
            Collection<Change> collection = this.myMergedChanges;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$ParsedChanges", "getMergedChanges"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<Change> getChanges(int parent) {
            Collection<Change> collection = this.myChanges.get(parent);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$ParsedChanges", "getChanges"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<String> getModifiedPaths(int parent) {
            HashSet changes = ContainerUtil.newHashSet();
            for (Change change : this.getChanges(parent)) {
                if (change.getType().equals((Object)Change.Type.MOVED)) continue;
                if (change.getAfterRevision() != null) {
                    changes.add(change.getAfterRevision().getFile().getPath());
                }
                if (change.getBeforeRevision() == null) continue;
                changes.add(change.getBeforeRevision().getFile().getPath());
            }
            HashSet hashSet = changes;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$ParsedChanges", "getModifiedPaths"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int parent) {
            HashSet renames = ContainerUtil.newHashSet();
            for (Change change : this.getChanges(parent)) {
                if (!change.getType().equals((Object)Change.Type.MOVED) || change.getAfterRevision() == null || change.getBeforeRevision() == null) continue;
                renames.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
            }
            HashSet hashSet = renames;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitCommit$ParsedChanges", "getRenamedPaths"));
            }
            return hashSet;
        }
    }

    private static interface Changes {
        @NotNull
        public Collection<Change> getMergedChanges() throws VcsException;

        @NotNull
        public Collection<Change> getChanges(int var1) throws VcsException;

        @NotNull
        public Collection<String> getModifiedPaths(int var1);

        @NotNull
        public Collection<Couple<String>> getRenamedPaths(int var1);
    }
}

