/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFilePathUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBinaryContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ByteBackedContentRevision {
    @NotNull
    protected final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Charset myCharset;

    protected GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, @Nullable Charset charset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/GitContentRevision", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/GitContentRevision", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.getAsString((byte[])bytes, (FilePath)this.myFile, (Charset)this.myCharset);
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, this::loadContent);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myFile);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        GitRevisionNumber gitRevisionNumber = this.myRevision;
        if (gitRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "getRevisionNumber"));
        }
        return gitRevisionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, Project project, boolean canBeDeleted, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/GitContentRevision", "createRevision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitContentRevision", "createRevision"));
        }
        FilePath file = GitContentRevision.createPath(vcsRoot, path, canBeDeleted, unescapePath);
        ContentRevision contentRevision = GitContentRevision.createRevision(file, revisionNumber, project);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
        }
        return contentRevision;
    }

    @NotNull
    private static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/GitContentRevision", "createRevision"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "createRevision"));
        }
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            GitContentRevision gitContentRevision = GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, null);
            if (gitContentRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
            }
            return gitContentRevision;
        }
        ContentRevision contentRevision = CurrentContentRevision.create((FilePath)filePath);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
        }
        return contentRevision;
    }

    @NotNull
    public static ContentRevision createRevisionForTypeChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, boolean unescapePath) throws VcsException {
        FilePath filePath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "createRevisionForTypeChange"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/GitContentRevision", "createRevisionForTypeChange"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitContentRevision", "createRevisionForTypeChange"));
        }
        if (revisionNumber == null) {
            File file = new File(GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath));
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            filePath = virtualFile == null ? VcsUtil.getFilePath((File)file, (boolean)false) : VcsUtil.getFilePath((VirtualFile)virtualFile);
        } else {
            filePath = GitContentRevision.createPath(vcsRoot, path, false, unescapePath);
        }
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, revisionNumber, project);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevisionForTypeChange"));
        }
        return contentRevision;
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean canBeDeleted, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/GitContentRevision", "createPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitContentRevision", "createPath"));
        }
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath);
        FilePath file = VcsUtil.getFilePath((String)absolutePath, (boolean)false);
        if (canBeDeleted && !SystemInfo.isFileSystemCaseSensitive && VcsFilePathUtil.caseDiffers((String)file.getPath(), (String)absolutePath)) {
            file = VcsUtil.getFilePath((String)absolutePath, (boolean)false);
        }
        FilePath filePath = file;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createPath"));
        }
        return filePath;
    }

    @NotNull
    private static String makeAbsolutePath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/GitContentRevision", "makeAbsolutePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitContentRevision", "makeAbsolutePath"));
        }
        String unescapedPath = unescapePath ? GitUtil.unescapePath(path) : path;
        String string = vcsRoot.getPath() + "/" + unescapedPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "makeAbsolutePath"));
        }
        return string;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/GitContentRevision", "createRevision"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "createRevision"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, revisionNumber, project, null);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
        }
        return contentRevision;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/GitContentRevision", "createRevision"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "createRevision"));
        }
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            GitContentRevision gitContentRevision = GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, charset);
            if (gitContentRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
            }
            return gitContentRevision;
        }
        ContentRevision contentRevision = CurrentContentRevision.create((FilePath)filePath);
        if (contentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevision"));
        }
        return contentRevision;
    }

    @NotNull
    private static GitContentRevision createRevisionImpl(@NotNull FilePath path, @NotNull GitRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitContentRevision", "createRevisionImpl"));
        }
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "git4idea/GitContentRevision", "createRevisionImpl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitContentRevision", "createRevisionImpl"));
        }
        if (path.getFileType().isBinary()) {
            GitBinaryContentRevision gitBinaryContentRevision = new GitBinaryContentRevision(path, revisionNumber, project);
            if (gitBinaryContentRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevisionImpl"));
            }
            return gitBinaryContentRevision;
        }
        GitContentRevision gitContentRevision = new GitContentRevision(path, revisionNumber, project, charset);
        if (gitContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitContentRevision", "createRevisionImpl"));
        }
        return gitContentRevision;
    }

    public String toString() {
        return this.myFile.getPath();
    }
}

